/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.tokenmarker;

import com.jidesoft.editor.SyntaxUtils;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import javax.swing.text.Segment;

public class ShellScriptTokenMarker
extends TokenMarker {
    public static final byte LVARIABLE = 100;

    @Override
    public void insertLines(int n2, int n3) {
        super.insertLines(n2, n3);
        if (n3 <= 0) {
            return;
        }
        int n4 = n2 + n3;
        System.arraycopy(this._lineInfoExtended, n2, this._lineInfoExtended, n4, this._lineInfoExtended.length - n4);
        for (int i2 = n2 + n3 - 1; i2 >= n2; --i2) {
            this._lineInfoExtended[i2] = null;
        }
    }

    @Override
    public void deleteLines(int n2, int n3) {
        super.deleteLines(n2, n3);
        if (n3 <= 0 || n2 >= this.length) {
            return;
        }
        if (n2 + n3 > this.length) {
            n3 = this.length - n2;
        }
        int n4 = n2 + n3;
        System.arraycopy(this._lineInfoExtended, n4, this._lineInfoExtended, n2, this._lineInfoExtended.length - n4);
    }

    @Override
    protected void ensureCapacity(int n2) {
        super.ensureCapacity(n2);
        if (this._lineInfoExtended == null) {
            this._lineInfoExtended = new Object[n2 + 1];
        } else if (this._lineInfoExtended.length <= n2) {
            int n3 = Math.min(n2 + 1, 4096);
            Object[] objectArray = new Object[n2 + 1 + n3];
            System.arraycopy(this._lineInfoExtended, 0, objectArray, 0, this._lineInfoExtended.length);
            this._lineInfoExtended = objectArray;
        }
    }

    @Override
    public byte markTokensImpl(byte by, Segment segment, int n2) {
        int n3;
        char[] cArray = segment.array;
        int n4 = 0;
        int n5 = n3 = segment.offset;
        int n6 = segment.count + n3;
        if (by == 3 && n2 != 0 && this._lineInfoExtended[n2 - 1] != null) {
            String string = (String)this._lineInfoExtended[n2 - 1];
            if (string != null && string.length() == segment.count && SyntaxUtils.regionMatches(false, segment, n3, string)) {
                this.addToken(segment.count, (byte)3);
                return 0;
            }
            this.addToken(segment.count, (byte)3);
            this._lineInfoExtended[n2] = string;
            return 3;
        }
        boolean bl = false;
        block27: for (int i2 = n3; i2 < n6; ++i2) {
            int n7 = i2 + 1;
            char c2 = cArray[i2];
            if (c2 == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    block7 : switch (c2) {
                        case '\t': 
                        case ' ': 
                        case '(': 
                        case ')': {
                            bl = false;
                            if (n4 != true) continue block27;
                            this.addToken(i2 - n5, (byte)6);
                            n5 = i2;
                            n4 = 2;
                            break;
                        }
                        case '=': {
                            bl = false;
                            if (n4 != true) continue block27;
                            this.addToken(i2 - n5, by);
                            n5 = i2;
                            n4 = 2;
                            break;
                        }
                        case '&': 
                        case ';': 
                        case '|': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            n4 = 0;
                            break;
                        }
                        case '#': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i2 - n5, by);
                            this.addToken(n6 - i2, (byte)1);
                            n5 = n6;
                            break block27;
                        }
                        case '$': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i2 - n5, by);
                            n4 = 2;
                            n5 = i2;
                            if (n6 - i2 >= 2) {
                                switch (cArray[n7]) {
                                    case '(': {
                                        break block7;
                                    }
                                    case '{': {
                                        by = (byte)100;
                                        break block7;
                                    }
                                }
                                by = (byte)7;
                                break;
                            }
                            by = (byte)7;
                            break;
                        }
                        case '\"': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i2 - n5, by);
                            by = (byte)3;
                            this._lineInfoExtended[n2] = null;
                            n4 = 2;
                            n5 = i2;
                            break;
                        }
                        case '\'': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i2 - n5, by);
                            by = (byte)4;
                            n4 = 2;
                            n5 = i2;
                            break;
                        }
                        case '<': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            if (n6 - i2 <= 1 || cArray[n7] != '<') continue block27;
                            this.addToken(i2 - n5, by);
                            by = (byte)3;
                            n5 = i2;
                            this._lineInfoExtended[n2] = new String(cArray, i2 + 2, n6 - (i2 + 2));
                            break;
                        }
                        default: {
                            bl = false;
                            if (!Character.isLetter(c2) || n4 != 0) continue block27;
                            this.addToken(i2 - n5, by);
                            n5 = i2;
                            n4 = (byte)(n4 + 1);
                            break;
                        }
                    }
                    continue block27;
                }
                case 7: {
                    bl = false;
                    if (Character.isLetterOrDigit(c2) || c2 == '_') continue block27;
                    if (i2 != n3 && cArray[i2 - 1] == '$') {
                        this.addToken(n7 - n5, by);
                        n5 = n7;
                        by = 0;
                        continue block27;
                    }
                    this.addToken(i2 - n5, by);
                    n5 = i2;
                    by = 0;
                    continue block27;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block27;
                    }
                    if (c2 == '\"') {
                        this.addToken(n7 - n5, by);
                        n4 = 2;
                        n5 = n7;
                        by = 0;
                        continue block27;
                    }
                    bl = false;
                    continue block27;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block27;
                    }
                    if (c2 == '\'') {
                        this.addToken(n7 - n5, (byte)3);
                        n4 = 2;
                        n5 = n7;
                        by = 0;
                        continue block27;
                    }
                    bl = false;
                    continue block27;
                }
                case 100: {
                    bl = false;
                    if (c2 != '}') continue block27;
                    this.addToken(n7 - n5, (byte)7);
                    n5 = n7;
                    by = 0;
                    continue block27;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        switch (by) {
            case 0: {
                if (n4 == 1) {
                    this.addToken(n6 - n5, (byte)6);
                    break;
                }
                this.addToken(n6 - n5, by);
                break;
            }
            case 4: {
                this.addToken(n6 - n5, (byte)3);
                break;
            }
            case 7: {
                this.addToken(n6 - n5, by);
                by = 0;
                break;
            }
            case 100: {
                this.addToken(n6 - n5, (byte)10);
                by = 0;
                break;
            }
            default: {
                this.addToken(n6 - n5, by);
            }
        }
        return by;
    }
}

