/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.highlight;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.highlight.LayeredHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class DefaultHighlighter
extends LayeredHighlighter {
    private static final Highlighter.Highlight[] \u0101 = new Highlighter.Highlight[0];
    private Vector<C> \u0104 = new Vector();
    private CodeEditor \u0102;
    private boolean \u0105 = true;
    private B \u0103 = new B();
    public static final LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);

    @Override
    public void paint(Graphics graphics) {
        int n2 = this.\u0104.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            C c2 = this.\u0104.elementAt(i2);
            if (c2 instanceof A) continue;
            Rectangle rectangle = this.\u0102.getBounds();
            Insets insets = this.\u0102.getInsets();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            while (i2 < n2) {
                c2 = this.\u0104.elementAt(i2);
                if (!(c2 instanceof A)) {
                    Highlighter.HighlightPainter highlightPainter = c2.getPainter();
                    highlightPainter.paint(graphics, c2.getStartOffset(), c2.getEndOffset(), rectangle, this.\u0102);
                }
                ++i2;
            }
        }
    }

    public Object getHighlightInfo(int n2) {
        return this.\u0104 != null && this.\u0104.size() > n2 ? this.\u0104.elementAt(n2) : null;
    }

    @Override
    public void install(CodeEditor codeEditor) {
        this.\u0102 = codeEditor;
        this.removeAllHighlights();
    }

    @Override
    public void deinstall(CodeEditor codeEditor) {
        this.\u0102 = null;
    }

    @Override
    public Object addHighlight(int n2, int n3, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        SyntaxDocument syntaxDocument = this.\u0102.getDocument();
        C c2 = this.getDrawsLayeredHighlights() && highlightPainter instanceof LayeredHighlighter.LayerPainter ? new A() : new C();
        c2.\u0102 = highlightPainter;
        c2.\u0104 = syntaxDocument.createPosition(n2);
        c2.\u0103 = syntaxDocument.createPosition(n3);
        this.\u0104.addElement(c2);
        this.\u0101(n2, n3);
        return c2;
    }

    @Override
    public void removeHighlight(Object object) {
        if (object instanceof A) {
            A a2 = (A)object;
            if (a2.\u0107 > 0 && a2.\u0105 > 0) {
                this.\u0102.repaint(a2.\u0106, a2.\u0108, a2.\u0107, a2.\u0105);
            }
        } else {
            C c2 = (C)object;
            this.\u0101(c2.\u0104, c2.\u0103);
        }
        this.\u0104.removeElement(object);
    }

    @Override
    public void removeAllHighlights() {
        if (this.getDrawsLayeredHighlights()) {
            int n2 = this.\u0104.size();
            if (n2 != 0) {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = -1;
                int n8 = -1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    C c2 = this.\u0104.elementAt(i2);
                    if (c2 instanceof A) {
                        A a2 = (A)c2;
                        n3 = Math.min(n3, a2.\u0106);
                        n4 = Math.min(n4, a2.\u0108);
                        n5 = Math.max(n5, a2.\u0106 + a2.\u0107);
                        n6 = Math.max(n6, a2.\u0108 + a2.\u0105);
                        continue;
                    }
                    if (n7 == -1) {
                        n7 = c2.\u0104.getOffset();
                        n8 = c2.\u0103.getOffset();
                        continue;
                    }
                    n7 = Math.min(n7, c2.\u0104.getOffset());
                    n8 = Math.max(n8, c2.\u0103.getOffset());
                }
                if (n3 != n5 && n4 != n6) {
                    this.\u0102.repaint(n3, n4, n5 - n3, n6 - n4);
                }
                if (n7 != -1) {
                    try {
                        this.\u0101(n7, n8);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                this.\u0104.removeAllElements();
            }
        } else {
            int n9 = this.\u0104.size();
            if (n9 != 0) {
                int n10 = Integer.MAX_VALUE;
                int n11 = 0;
                for (int i3 = 0; i3 < n9; ++i3) {
                    C c3 = this.\u0104.elementAt(i3);
                    n10 = Math.min(n10, c3.\u0104.getOffset());
                    n11 = Math.max(n11, c3.\u0103.getOffset());
                }
                try {
                    this.\u0101(n10, n11);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.\u0104.removeAllElements();
            }
        }
    }

    @Override
    public void changeHighlight(Object object, int n2, int n3) throws BadLocationException {
        SyntaxDocument syntaxDocument = this.\u0102.getDocument();
        if (object instanceof A) {
            A a2 = (A)object;
            if (a2.\u0107 > 0 && a2.\u0105 > 0) {
                this.\u0102.repaint(a2.\u0106, a2.\u0108, a2.\u0107, a2.\u0105);
            }
            a2.\u0105 = 0;
            a2.\u0107 = 0;
            a2.\u0104 = syntaxDocument.createPosition(n2);
            a2.\u0103 = syntaxDocument.createPosition(n3);
            this.\u0101(Math.min(n2, n3), Math.max(n2, n3));
        } else {
            C c2 = (C)object;
            int n4 = c2.\u0104.getOffset();
            int n5 = c2.\u0103.getOffset();
            if (n2 == n4) {
                this.\u0101(Math.min(n5, n3), Math.max(n5, n3));
            } else if (n3 == n5) {
                this.\u0101(Math.min(n2, n4), Math.max(n2, n4));
            } else {
                this.\u0101(n4, n5);
                this.\u0101(n2, n3);
            }
            c2.\u0104 = syntaxDocument.createPosition(n2);
            c2.\u0103 = syntaxDocument.createPosition(n3);
        }
    }

    @Override
    public Highlighter.Highlight[] getHighlights() {
        int n2 = this.\u0104.size();
        if (n2 == 0) {
            return \u0101;
        }
        Object[] objectArray = new Highlighter.Highlight[n2];
        this.\u0104.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public void paintLayeredHighlights(Graphics graphics, int n2, int n3, Shape shape, CodeEditor codeEditor) {
        for (int i2 = this.\u0104.size() - 1; i2 >= 0; --i2) {
            C c2 = this.\u0104.elementAt(i2);
            if (!(c2 instanceof A)) continue;
            A a2 = (A)c2;
            int n4 = a2.getStartOffset();
            int n5 = a2.getEndOffset();
            if (!(n2 < n4 && n3 > n4 || n2 >= n4 && n2 < n5) && (!(a2.getPainter() instanceof LayeredHighlighter.LayerPainter) || !((LayeredHighlighter.LayerPainter)a2.getPainter()).isOccupyNextLine() || n2 < n4 || n2 > n5)) continue;
            a2.\u0101(graphics, n2, n3, shape, codeEditor);
        }
    }

    private void \u0101(Position position, Position position2) {
        this.\u0103.\u0101(position, position2);
    }

    private void \u0101(int n2, int n3) throws BadLocationException {
        SyntaxDocument syntaxDocument = this.\u0102.getDocument();
        this.\u0101(syntaxDocument.createPosition(n2), syntaxDocument.createPosition(n3));
    }

    public void setDrawsLayeredHighlights(boolean bl) {
        this.\u0105 = bl;
    }

    public boolean getDrawsLayeredHighlights() {
        return this.\u0105;
    }

    class B
    implements Runnable {
        private Vector<Position> \u0104 = new Vector(10);
        private Vector<Position> \u0103 = new Vector(10);
        private Document \u0102 = null;

        B() {
        }

        @Override
        public synchronized void run() {
            if (DefaultHighlighter.this.\u0102 != null && this.\u0102 == DefaultHighlighter.this.\u0102.getDocument()) {
                int n2 = this.\u0104.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    DefaultHighlighter.this.\u0102.getPainter().invalidateRange(this.\u0104.get(i2).getOffset(), this.\u0103.get(i2).getOffset());
                }
            }
            this.\u0104.clear();
            this.\u0103.clear();
            this.\u0102 = null;
        }

        public synchronized void \u0101(Position position, Position position2) {
            if (DefaultHighlighter.this.\u0102 == null) {
                this.\u0104.clear();
                this.\u0102 = null;
                return;
            }
            boolean bl = this.\u0104.isEmpty();
            SyntaxDocument syntaxDocument = DefaultHighlighter.this.\u0102.getDocument();
            if (syntaxDocument != this.\u0102) {
                if (!this.\u0104.isEmpty()) {
                    this.\u0104.clear();
                    this.\u0103.clear();
                }
                this.\u0102 = syntaxDocument;
            }
            this.\u0104.add(position);
            this.\u0103.add(position2);
            if (bl) {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    class A
    extends C {
        int \u0106;
        int \u0108;
        int \u0107;
        int \u0105;

        A() {
        }

        void \u0101(Shape shape) {
            if (shape == null) {
                return;
            }
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.\u0107 == 0 || this.\u0105 == 0) {
                this.\u0106 = rectangle.x;
                this.\u0108 = rectangle.y;
                this.\u0107 = rectangle.width;
                this.\u0105 = rectangle.height;
            } else {
                this.\u0107 = Math.max(this.\u0106 + this.\u0107, rectangle.x + rectangle.width);
                this.\u0105 = Math.max(this.\u0108 + this.\u0105, rectangle.y + rectangle.height);
                this.\u0106 = Math.min(this.\u0106, rectangle.x);
                this.\u0107 -= this.\u0106;
                this.\u0108 = Math.min(this.\u0108, rectangle.y);
                this.\u0105 -= this.\u0108;
            }
        }

        void \u0101(Graphics graphics, int n2, int n3, Shape shape, CodeEditor codeEditor) {
            int n4 = this.getStartOffset();
            int n5 = this.getEndOffset();
            if (n4 <= n2 && n5 > n3) {
                ++n3;
            }
            n2 = Math.max(n4, n2);
            n3 = Math.min(n5, n3);
            this.\u0101(((LayeredHighlighter.LayerPainter)this.\u0102).paintLayer(graphics, n2, n3, shape, codeEditor));
        }
    }

    class C
    implements Highlighter.Highlight {
        Position \u0104;
        Position \u0103;
        Highlighter.HighlightPainter \u0102;

        C() {
        }

        @Override
        public int getStartOffset() {
            return this.\u0104.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.\u0103.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.\u0102;
        }
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color \u0107;

        public DefaultHighlightPainter(Color color) {
            this.\u0107 = color;
        }

        public Color getColor() {
            return this.\u0107;
        }

        @Override
        public boolean isOccupyNextLine() {
            return false;
        }

        @Override
        public void paint(Graphics graphics, int n2, int n3, Shape shape, CodeEditor codeEditor) {
            Rectangle rectangle = shape.getBounds();
            try {
                Rectangle rectangle2 = codeEditor.modelToView(n2);
                Rectangle rectangle3 = codeEditor.modelToView(n3);
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(codeEditor.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                } else {
                    int n4 = rectangle.x + rectangle.width - rectangle2.x;
                    graphics.fillRect(rectangle2.x, rectangle2.y, n4, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                    }
                    graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n2, int n3, Shape shape, CodeEditor codeEditor) {
            Color color = this.getColor();
            if (color == null) {
                graphics.setColor(codeEditor.getSelectionColor());
            } else {
                graphics.setColor(color);
            }
            try {
                Rectangle rectangle = codeEditor.modelToView(n2, n3);
                Rectangle rectangle2 = rectangle instanceof Rectangle ? rectangle : rectangle.getBounds();
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                return rectangle2;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }
}

