/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.hints.IntelliHints;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.DelegateAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;

public abstract class AbstractCodeEditorIntelliHints
implements IntelliHints {
    private JidePopup \u0117;
    private CodeEditor \u0116;
    private JComponent \u011d;
    private KeyListener \u0121;
    private FocusListener \u011f;
    private MouseListener \u0118;
    private boolean \u0120 = false;
    private boolean \u0122 = false;
    private List<KeyStroke> \u0115;
    private DelegateAction \u011a;
    private String \u011e = " \t";
    private int \u0114 = 200;
    private final DelegateAction \u011c = new DelegateAction(){
        private static final long \u0105 = 818798975216716710L;

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            AbstractCodeEditorIntelliHints abstractCodeEditorIntelliHints = AbstractCodeEditorIntelliHints.getIntelliHints(jComponent);
            if (abstractCodeEditorIntelliHints != null) {
                abstractCodeEditorIntelliHints.hideHintsPopup();
                if (abstractCodeEditorIntelliHints.getSelectedHint() != null) {
                    abstractCodeEditorIntelliHints.setHintsEnabled(false);
                    abstractCodeEditorIntelliHints.acceptHint(abstractCodeEditorIntelliHints.getSelectedHint());
                    abstractCodeEditorIntelliHints.setHintsEnabled(true);
                    return true;
                }
            }
            return false;
        }
    };
    private final DelegateAction \u0119 = new DelegateAction(){
        private static final long \u0139 = -2356564033432685097L;

        @Override
        public boolean isDelegateEnabled() {
            return AbstractCodeEditorIntelliHints.this.\u0116.isEnabled() && AbstractCodeEditorIntelliHints.this.isHintsPopupVisible();
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled()) {
                AbstractCodeEditorIntelliHints.this.hideHintsPopup();
                return true;
            }
            return false;
        }
    };
    private final DocumentListener \u011b = new DocumentListener(){
        Timer \u0102 = null;

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.\u0101();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.\u0101();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        void \u0101() {
            if (this.\u0102 == null || this.\u0102.getInitialDelay() != AbstractCodeEditorIntelliHints.this.getPopupDelay()) {
                if (this.\u0102 != null) {
                    this.\u0102.stop();
                }
                this.\u0102 = new Timer(AbstractCodeEditorIntelliHints.this.getPopupDelay(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (AbstractCodeEditorIntelliHints.this.\u0103()) {
                            if (AbstractCodeEditorIntelliHints.this.isHintsPopupVisible() || AbstractCodeEditorIntelliHints.this.isAutoPopup()) {
                                AbstractCodeEditorIntelliHints.this.showHintsPopup(true);
                            }
                            AbstractCodeEditorIntelliHints.this.\u0102(false);
                        }
                    }
                });
            }
            if (this.\u0102.isRunning()) {
                this.\u0102.restart();
            } else {
                this.\u0102.setRepeats(false);
                this.\u0102.start();
            }
        }
    };

    public AbstractCodeEditorIntelliHints(CodeEditor codeEditor) {
        this.\u0117 = this.createPopup();
        this.install(codeEditor);
    }

    public void install(CodeEditor codeEditor) {
        KeyStroke[] keyStrokeArray;
        this.uninstall();
        this.\u0116 = codeEditor;
        if (this.\u0116 == null) {
            throw new IllegalArgumentException("The installer could not accept a null CodeEditor as its parameter.");
        }
        codeEditor.putClientProperty("INTELLI_HINTS", this);
        codeEditor.getDocument().addDocumentListener(this.\u011b);
        this.\u0121 = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (27 != keyEvent.getKeyCode() && 10 != keyEvent.getKeyCode()) {
                    AbstractCodeEditorIntelliHints.this.\u0102(true);
                }
            }
        };
        codeEditor.addKeyListener(this.\u0121);
        this.\u011f = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Container container = AbstractCodeEditorIntelliHints.this.\u0117.getTopLevelAncestor();
                if (container == null) {
                    return;
                }
                Component component = focusEvent.getOppositeComponent();
                if (container == component || container.isAncestorOf(component)) {
                    return;
                }
                AbstractCodeEditorIntelliHints.this.hideHintsPopup();
            }
        };
        codeEditor.addFocusListener(this.\u011f);
        this.\u0118 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AbstractCodeEditorIntelliHints.this.hideHintsPopup();
            }
        };
        codeEditor.getPainter().addMouseListener(this.\u0118);
        this.\u011a = new DelegateAction(){
            private static final long \u0107 = -6405015607399407217L;

            @Override
            public boolean isDelegateEnabled() {
                return (AbstractCodeEditorIntelliHints.this.getDelegateComponent() == null || AbstractCodeEditorIntelliHints.this.getDelegateComponent().isEnabled()) && !AbstractCodeEditorIntelliHints.this.isHintsPopupVisible();
            }

            @Override
            public boolean delegateActionPerformed(ActionEvent actionEvent) {
                JComponent jComponent = (JComponent)actionEvent.getSource();
                AbstractCodeEditorIntelliHints abstractCodeEditorIntelliHints = AbstractCodeEditorIntelliHints.getIntelliHints(jComponent);
                if (abstractCodeEditorIntelliHints != null && jComponent.isEnabled() && !abstractCodeEditorIntelliHints.isHintsPopupVisible()) {
                    abstractCodeEditorIntelliHints.showHintsPopup(false);
                    return true;
                }
                return false;
            }
        };
        this.addShowHintsKeyStroke(this.getShowHintsKeyStroke());
        for (KeyStroke keyStroke : keyStrokeArray = this.getDelegateKeyStrokes()) {
            DelegateAction.replaceAction(codeEditor, 0, keyStroke, new A(keyStroke));
        }
    }

    public void uninstall() {
        CodeEditor codeEditor = this.getCodeEditor();
        if (codeEditor == null) {
            return;
        }
        codeEditor.putClientProperty("INTELLI_HINTS", null);
        codeEditor.getDocument().removeDocumentListener(this.\u011b);
        codeEditor.removeKeyListener(this.\u0121);
        codeEditor.removeFocusListener(this.\u011f);
        codeEditor.getPainter().removeMouseListener(this.\u0118);
        DelegateAction.restoreAction((JComponent)this.getCodeEditor(), 0, KeyStroke.getKeyStroke(27, 0), this.\u0119);
        DelegateAction.restoreAction((JComponent)this.getCodeEditor(), 0, KeyStroke.getKeyStroke(10, 0), this.\u011c);
        for (KeyStroke keyStroke : this.\u0115) {
            DelegateAction.restoreAction(this.getCodeEditor(), 0, keyStroke);
        }
        for (KeyStroke keyStroke : this.getDelegateKeyStrokes()) {
            DelegateAction.restoreAction(codeEditor, 0, keyStroke);
        }
        this.\u0116 = null;
    }

    protected JidePopup createPopup() {
        JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
        jidePopup.setKeepPreviousSize(false);
        jidePopup.setLayout(new BorderLayout());
        jidePopup.setResizable(true);
        jidePopup.setPopupBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlDkShadow"), 1));
        jidePopup.setMovable(false);
        jidePopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                DelegateAction.restoreAction((JComponent)AbstractCodeEditorIntelliHints.this.getCodeEditor(), 0, KeyStroke.getKeyStroke(27, 0), AbstractCodeEditorIntelliHints.this.\u0119);
                DelegateAction.restoreAction((JComponent)AbstractCodeEditorIntelliHints.this.getCodeEditor(), 0, KeyStroke.getKeyStroke(10, 0), AbstractCodeEditorIntelliHints.this.\u011c);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jidePopup.setTransient(true);
        return jidePopup;
    }

    public CodeEditor getCodeEditor() {
        return this.\u0116;
    }

    @Override
    public void acceptHint(Object object) {
        int n2;
        String string;
        if (object == null) {
            return;
        }
        CaretPosition caretPosition = this.getCodeEditor().getCaretModel().getModelPosition();
        String string2 = this.getCodeEditor().getLineText(caretPosition.line);
        String string3 = string = this.getContext() instanceof String ? (String)this.getContext() : "";
        if (string.length() > 0 && (n2 = string2.lastIndexOf(string, caretPosition.column - 1)) >= 0 && caretPosition.column <= string2.length()) {
            this.getCodeEditor().select(this.getCodeEditor().modelPositionToOffset(new CaretPosition(caretPosition.line, n2)), this.getCodeEditor().modelPositionToOffset(new CaretPosition(caretPosition.line, caretPosition.column)));
        }
        this.getCodeEditor().insertChar(object.toString());
    }

    protected void showHintsPopup(boolean bl) {
        if (this.\u0117 == null) {
            return;
        }
        if (this.\u011d == null) {
            this.\u011d = this.createHintsComponent();
            this.\u0117.add(this.\u011d);
            this.getDelegateComponent().setRequestFocusEnabled(false);
            this.getDelegateComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AbstractCodeEditorIntelliHints.this.hideHintsPopup();
                    AbstractCodeEditorIntelliHints.this.setHintsEnabled(false);
                    AbstractCodeEditorIntelliHints.this.acceptHint(AbstractCodeEditorIntelliHints.this.getSelectedHint());
                    AbstractCodeEditorIntelliHints.this.setHintsEnabled(true);
                }
            });
        }
        if (this.getCodeEditor().isEnabled() && this.getCodeEditor().hasFocus() && this.updateHints(this.getContext(), bl)) {
            DelegateAction.replaceAction(this.getCodeEditor(), 0, KeyStroke.getKeyStroke(27, 0), this.\u0119);
            DelegateAction.replaceAction((JComponent)this.getCodeEditor(), 0, KeyStroke.getKeyStroke(10, 0), this.\u011c, true);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                Rectangle rectangle = this.getCaretRectangleForPopup();
                n3 = rectangle.y;
                n2 = rectangle.x;
                n4 = rectangle.height;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            this.\u0117.setOwner(this.getCodeEditor());
            this.\u0117.showPopup(new Insets(n3 + 4 + this.getCodeEditor().getPainter().getY(), n2 + this.getCodeEditor().getPainter().getX(), this.getCodeEditor().getHeight() - n4 - n3 - 6, 0));
        } else {
            this.\u0117.hidePopup();
        }
    }

    protected Rectangle getCaretRectangleForPopup() throws BadLocationException {
        return new Rectangle(this.getCodeEditor().getCaretLocation(), new Dimension(4, 8));
    }

    protected Object getContext() {
        CaretPosition caretPosition = this.getCodeEditor().getCaretModel().getModelPosition();
        String string = this.getCodeEditor().getLineText(caretPosition.line);
        if (caretPosition.column == 0) {
            return "";
        }
        if (caretPosition.column > string.length()) {
            return "";
        }
        String string2 = this.getDelimiters();
        string = string.substring(0, caretPosition.column);
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            int n2 = string.lastIndexOf(c2);
            string = string.substring(n2 + 1);
        }
        return string;
    }

    protected void hideHintsPopup() {
        if (this.\u0117 != null) {
            this.\u0117.hidePopup();
        }
        this.\u0102(false);
    }

    public void setHintsEnabled(boolean bl) {
        if (!bl) {
            this.getCodeEditor().getDocument().removeDocumentListener(this.\u011b);
        } else {
            this.getCodeEditor().getDocument().addDocumentListener(this.\u011b);
        }
    }

    public boolean isHintsPopupVisible() {
        return this.\u0117 != null && this.\u0117.isPopupVisible();
    }

    public boolean isAutoPopup() {
        return this.\u0122;
    }

    public void setAutoPopup(boolean bl) {
        this.\u0122 = bl;
    }

    public abstract KeyStroke[] getDelegateKeyStrokes();

    public abstract JComponent getDelegateComponent();

    protected KeyStroke getShowHintsKeyStroke() {
        return KeyStroke.getKeyStroke(32, 2);
    }

    public void addShowHintsKeyStroke(KeyStroke keyStroke) {
        if (this.\u0115 == null) {
            this.\u0115 = new ArrayList<KeyStroke>();
        }
        this.\u0115.add(keyStroke);
        DelegateAction.replaceAction(this.getCodeEditor(), 0, keyStroke, this.\u011a);
    }

    public void removeShowHintsKeyStroke(KeyStroke keyStroke) {
        if (this.\u0115 != null) {
            this.\u0115.remove(keyStroke);
            DelegateAction.restoreAction((JComponent)this.getCodeEditor(), 0, keyStroke, this.\u011a);
        }
    }

    public KeyStroke[] getAllShowHintsKeyStrokes() {
        if (this.\u0115 == null) {
            return new KeyStroke[0];
        }
        return this.\u0115.toArray(new KeyStroke[this.\u0115.size()]);
    }

    private boolean \u0103() {
        return this.\u0120;
    }

    private void \u0102(boolean bl) {
        this.\u0120 = bl;
    }

    public String getDelimiters() {
        return this.\u011e;
    }

    public void setDelimiters(String string) {
        this.\u011e = string;
    }

    public static AbstractCodeEditorIntelliHints getIntelliHints(JComponent jComponent) {
        Object object = jComponent.getClientProperty("INTELLI_HINTS");
        if (object instanceof AbstractCodeEditorIntelliHints) {
            return (AbstractCodeEditorIntelliHints)object;
        }
        return null;
    }

    public int getPopupDelay() {
        return this.\u0114;
    }

    public void setPopupDelay(int n2) {
        if (n2 >= 0) {
            this.\u0114 = n2;
        }
    }

    private class A
    extends DelegateAction {
        private final KeyStroke \u0109;
        private static final long \u010a = 2258648528763679043L;

        public A(KeyStroke keyStroke) {
            this.\u0109 = keyStroke;
        }

        @Override
        public boolean isDelegateEnabled() {
            Action action = this.\u0101();
            return action != null && action.isEnabled();
        }

        private Action \u0101() {
            if (AbstractCodeEditorIntelliHints.this.isHintsPopupVisible() && AbstractCodeEditorIntelliHints.this.getDelegateComponent() != null) {
                Object object = AbstractCodeEditorIntelliHints.this.getDelegateComponent().getInputMap().get(this.\u0109);
                Object object2 = object = object == null ? AbstractCodeEditorIntelliHints.this.getCodeEditor().getInputMap(1).get(this.\u0109) : object;
                if (object != null) {
                    return AbstractCodeEditorIntelliHints.this.getDelegateComponent().getActionMap().get(object);
                }
            }
            return null;
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            Action action = this.\u0101();
            if (action != null) {
                action.actionPerformed(new ActionEvent(AbstractCodeEditorIntelliHints.this.getDelegateComponent(), 0, String.valueOf(action.getValue("ActionCommandKey"))));
                return true;
            }
            return false;
        }
    }
}

