/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.DateChooserPanel;
import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DateModelEvent;
import com.jidesoft.combobox.DateModelListener;
import com.jidesoft.combobox.DateSelectionEvent;
import com.jidesoft.combobox.DateSelectionListener;
import com.jidesoft.combobox.DefaultDateModel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;

public class DateComboBox
extends AbstractComboBox
implements DateModelListener {
    private DateModel \u0198;
    private boolean \u019c = true;
    private boolean \u019b = true;
    private boolean \u019f = false;
    private boolean \u019d = false;
    private boolean \u019e = true;
    private boolean \u0199 = false;
    public static final String PROPERTY_SHOW_NONE_BUTTON = "showNoneButton";
    public static final String PROPERTY_SHOW_OK_BUTTON = "showOKButton";
    public static final String PROPERTY_SHOW_TODAY_BUTTON = "showTodayButton";
    public static final String PROPERTY_SHOW_WEEK_NUMBERS = "showWeekNumbers";
    private boolean \u019a = false;

    public DateComboBox() {
        this(new DefaultDateModel());
    }

    public DateComboBox(DateModel dateModel) {
        super(0);
        this.setDateModel(dateModel);
        this.initComponent();
    }

    public DateModel getDateModel() {
        return this.\u0198;
    }

    public void setDateModel(DateModel dateModel) {
        DateModel dateModel2 = this.\u0198;
        if (dateModel2 != dateModel) {
            if (this.\u0198 != null) {
                this.\u0198.removeDateModelListener(this);
            }
            this.\u0198 = dateModel;
            if (this.\u0198 != null) {
                this.\u0198.addDateModelListener(this);
            }
        }
    }

    @Override
    public void dateModelChanged(DateModelEvent dateModelEvent) {
        if (!this.getDateModel().isValidDate(this.getCalendar())) {
            this.setCalendar(null);
        }
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            return new DateEditorComponent(Calendar.class);
        }
        return new DateRendererComponent(Calendar.class);
    }

    @Override
    public PopupPanel createPopupComponent() {
        final DateChooserPanel dateChooserPanel = this.createDateChooserPanel();
        dateChooserPanel.setTimeDisplayed(this.isTimeDisplayed());
        dateChooserPanel.setShowOKButton(this.isShowOKButton());
        dateChooserPanel.getSelectionModel().addDateSelectionListener(new DateSelectionListener(){

            @Override
            public void valueChanged(DateSelectionEvent dateSelectionEvent) {
                Date date = dateChooserPanel.getSelectedDate();
                Object object = DateComboBox.this.getEditor().getItem();
                if (!(object instanceof Date && object.equals(date) || object instanceof Calendar && ((Calendar)object).getTime().equals(date))) {
                    if (!JideSwingUtilities.equals(date, dateChooserPanel.\u013e())) {
                        DateComboBox.this.getEditor().setItem(date);
                        DateComboBox.this.setSelectedItem(date, false);
                    } else {
                        DateComboBox.this.setSelectedItem(date);
                    }
                    DateComboBox.this.getEditor().selectAll();
                }
            }
        });
        return dateChooserPanel;
    }

    protected DateChooserPanel createDateChooserPanel() {
        return new DateChooserPanel(this.getDateModel(), this.isShowTodayButton(), this.isShowNoneButton(), this.isShowWeekNumbers(), this.getLocale());
    }

    @Override
    public boolean isPopupVolatile() {
        return true;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        if (this.getPopupCancelBehavior() == 2) {
            if (this.getPopupPanel() != null && !JideSwingUtilities.equals(this.getSelectedItem(), this.getPopupPanel().getPreviousSelectedObject())) {
                this.getPopupPanel().setSelectedObject(this.getPopupPanel().getPreviousSelectedObject());
            }
            this.firePopupMenuCanceled();
        } else {
            super.popupMenuCanceled(popupMenuEvent);
        }
    }

    public Date getDate() {
        Calendar calendar = this.getCalendar();
        if (calendar != null) {
            return calendar.getTime();
        }
        return null;
    }

    public void setSelectedItemWithoutValidation(Object object, boolean bl) {
        super.setSelectedItem(object, bl);
    }

    @Override
    protected boolean equals(Object object, Object object2) {
        return JideSwingUtilities.equals(object, object2);
    }

    @Override
    public void setSelectedItem(Object object, boolean bl) {
        if (object instanceof Calendar && this.getDateModel().isValidDate((Calendar)object)) {
            super.setSelectedItem(object, bl);
        } else if (object instanceof Date) {
            Calendar calendar = this.createCalendarInstance();
            calendar.setTime((Date)object);
            if (this.getDateModel().isValidDate(calendar)) {
                super.setSelectedItem(calendar, bl);
            }
        } else if (object == null) {
            super.setSelectedItem(null, bl);
        } else if (this.isInvalidValueAllowed()) {
            super.setSelectedItem(object, bl);
        } else {
            super.setSelectedItem(null, false);
        }
    }

    public Calendar createCalendarInstance() {
        return this.getDateModel().createCalendarInstance();
    }

    protected void updateDateFromEditorComponent() {
        Object object = this.getEditor().getItem();
        if (object instanceof Calendar && this.getDateModel().isValidDate((Calendar)object) && !object.equals(this.getSelectedItem())) {
            this.setSelectedItem(object, false);
        } else if (object == null && this.getSelectedItem() != null) {
            this.setSelectedItem(null, false);
        }
    }

    public Calendar getCalendar() {
        this.updateDateFromEditorComponent();
        Object object = this.getSelectedItem();
        if (object instanceof Calendar) {
            return (Calendar)this.getSelectedItem();
        }
        if (object instanceof Date) {
            Calendar calendar = this.createCalendarInstance();
            calendar.setTime((Date)object);
            return calendar;
        }
        return null;
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setCalendar(null);
        } else {
            Calendar calendar = this.createCalendarInstance();
            calendar.setTime(date);
            this.setCalendar(calendar);
        }
    }

    public void setCalendar(Calendar calendar) {
        if (calendar == null) {
            this.setSelectedItem(null);
        } else {
            Calendar calendar2;
            Calendar calendar3 = calendar2 = this.isTimeDisplayed() ? calendar : DateChooserPanel.convertToMidnight(calendar);
            if (this.getDateModel().isValidDate(calendar2)) {
                this.setSelectedItem(calendar2);
            }
        }
    }

    protected String convertElementToString(Object object, Class clazz) {
        if (this.getFormat() == null) {
            if (object instanceof Calendar) {
                return ObjectConverterManager.toString(object, Calendar.class, this.getConverterContext());
            }
            if (object instanceof Date) {
                return ObjectConverterManager.toString(object, Date.class, this.getConverterContext());
            }
            return ObjectConverterManager.toString(object, clazz, this.getConverterContext());
        }
        try {
            if (object instanceof Calendar) {
                return this.getFormat().format(((Calendar)object).getTime());
            }
            if (object instanceof Date) {
                return this.getFormat().format(object);
            }
            return ObjectConverterManager.toString(object, clazz, this.getConverterContext());
        }
        catch (Exception exception) {
            return ObjectConverterManager.toString(object, clazz, this.getConverterContext());
        }
    }

    public DateFormat getFormat() {
        return this.getDateModel().getDateFormat();
    }

    public void setFormat(DateFormat dateFormat) {
        Object object = null;
        if (this.getEditor().getItem() != null) {
            object = this.getEditor().getItem();
        }
        this.getDateModel().setDateFormat(dateFormat);
        if (object instanceof Date || object instanceof Calendar) {
            this.getEditor().setItem(object);
        }
    }

    public boolean isShowTodayButton() {
        return this.\u019c;
    }

    public void setShowTodayButton(boolean bl) {
        boolean bl2 = this.\u019c;
        if (bl2 != bl) {
            this.\u019c = bl;
            this.firePropertyChange(PROPERTY_SHOW_TODAY_BUTTON, bl2, this.\u019c);
        }
    }

    public boolean isShowNoneButton() {
        return this.\u019b;
    }

    public void setShowNoneButton(boolean bl) {
        boolean bl2 = this.\u019b;
        if (bl2 != bl) {
            this.\u019b = bl;
            this.firePropertyChange(PROPERTY_SHOW_NONE_BUTTON, bl2, this.\u019b);
        }
    }

    public boolean isShowOKButton() {
        return this.isTimeDisplayed() && !this.\u019d || this.\u019f;
    }

    public void setShowOKButton(boolean bl) {
        boolean bl2 = this.\u019f;
        if (bl2 != bl) {
            this.\u019f = bl;
            this.\u019d = true;
            this.firePropertyChange(PROPERTY_SHOW_OK_BUTTON, bl2, this.\u019f);
        }
    }

    public boolean isShowWeekNumbers() {
        return this.\u019e;
    }

    public void setShowWeekNumbers(boolean bl) {
        boolean bl2 = this.\u019e;
        if (bl2 != bl) {
            this.\u019e = bl;
            this.firePropertyChange(PROPERTY_SHOW_WEEK_NUMBERS, bl2, this.\u019e);
        }
    }

    @Override
    protected List<KeyStroke> getDelegateKeyStrokes() {
        List<KeyStroke> list = super.getDelegateKeyStrokes();
        list.add(KeyStroke.getKeyStroke(34, 128));
        list.add(KeyStroke.getKeyStroke(33, 128));
        return list;
    }

    public boolean isTimeDisplayed() {
        return this.\u0199;
    }

    public void setTimeDisplayed(boolean bl) {
        this.\u0199 = bl;
        this.getDateModel().setCompareTime(this.\u0199);
    }

    public String getTimeFormat() {
        return this.getDateModel().getTimeFormat();
    }

    public void setTimeFormat(String string) {
        this.getDateModel().setTimeFormat(string);
    }

    @Override
    public void setLocale(Locale locale) {
        Object object = this.getEditor().getItem();
        super.setLocale(locale);
        if (object != null) {
            this.getEditor().setItem(object);
        }
    }

    @Override
    public void resetPopup() {
        if (this.getPopupPanel() != null && this.isPopupVolatile() && this.getPopupPanel() instanceof DateChooserPanel) {
            ((DateChooserPanel)this.getPopupPanel()).setDateModel(null);
        }
        super.resetPopup();
    }

    public boolean isInvalidValueAllowed() {
        return this.\u019a;
    }

    public void setInvalidValueAllowed(boolean bl) {
        this.\u019a = bl;
    }

    @Override
    Object \u010d() {
        Object object = this.getSelectedItem();
        if (object instanceof Calendar) {
            object = ((Calendar)object).clone();
        } else if (object instanceof Date) {
            object = ((Date)object).clone();
        }
        return object;
    }

    @Override
    protected void customizePopup(JidePopup jidePopup) {
        super.customizePopup(jidePopup);
        if (this.getPopupPanel() instanceof DateChooserPanel) {
            jidePopup.putClientProperty("popupMenuToCancel", ((DateChooserPanel)this.getPopupPanel()).\u013c());
        }
        if (this.isEditable() && this.isEnabled() && this.isButtonOnly()) {
            jidePopup.setOwner(this);
        }
    }

    public class DateEditorComponent
    extends AbstractComboBox.DefaultTextFieldEditorComponent {
        public DateEditorComponent(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Object getItem() {
            if (DateComboBox.this.getFormat() == null) {
                return ObjectConverterManager.fromString(this.getText(), this._class, DateComboBox.this.getConverterContext());
            }
            try {
                if (this.getText().trim().length() == 0) {
                    return null;
                }
                Date date = DateComboBox.this.getFormat().parse(this.getText());
                Calendar calendar = DateComboBox.this.createCalendarInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException parseException) {
                return super.getItem();
            }
        }

        @Override
        public void setItem(Object object) {
            this.setText(this.convertElementToString(object));
        }

        @Override
        protected String convertElementToString(Object object) {
            return DateComboBox.this.convertElementToString(object, this._class);
        }

        @Override
        public Dimension getPreferredSize() {
            Object object = DateComboBox.this.getPrototypeDisplayValue();
            if (object == null) {
                object = Calendar.getInstance();
            }
            String string = "";
            if (DateComboBox.this.getFormat() == null) {
                string = ObjectConverterManager.toString(object, this._class, DateComboBox.this.getConverterContext());
            } else if (object instanceof Calendar) {
                string = DateComboBox.this.getFormat().format(((Calendar)object).getTime());
            } else if (object instanceof Date) {
                string = DateComboBox.this.getFormat().format(object);
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
            return new Dimension(n2 + 10, fontMetrics.getHeight());
        }
    }

    public class DateRendererComponent
    extends AbstractComboBox.DefaultRendererComponent {
        public DateRendererComponent(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected String convertElementToString(Object object) {
            return DateComboBox.this.convertElementToString(object, this._class);
        }

        @Override
        public Dimension getPreferredSize() {
            Object object = DateComboBox.this.getPrototypeDisplayValue();
            if (object == null) {
                object = Calendar.getInstance();
            }
            String string = "";
            if (DateComboBox.this.getFormat() == null) {
                string = ObjectConverterManager.toString(object, this._class, DateComboBox.this.getConverterContext());
            } else if (object instanceof Calendar) {
                string = DateComboBox.this.getFormat().format(((Calendar)object).getTime());
            } else if (object instanceof Date) {
                string = DateComboBox.this.getFormat().format(object);
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
            return new Dimension(n2 + 10, fontMetrics.getHeight());
        }
    }
}

