/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ColorChooserPanel;
import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.PopupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ColorExComboBox
extends ExComboBox
implements PropertyChangeListener {
    private int \u03ce = 1;
    private boolean \u03c9 = true;
    private boolean \u03cd = true;
    private PopupPanel \u03d0;
    public static final String PROPERTY_COLOR_MODE = "colorMode";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_COLOR_VALUE_VISIBLE = "colorValueVisible";
    public static final String PROPERTY_COLOR_ICON_VISIBLE = "colorIconVisible";
    private boolean \u03d1 = false;
    private boolean \u03cc = true;
    private boolean \u03ca = true;
    private boolean \u03cb = false;
    protected ColorIcon _colorIcon;

    public ColorExComboBox() {
        super(0);
        this.setType(Color.class);
    }

    public ColorExComboBox(int n2) {
        super(0);
        this.setType(Color.class);
        this.\u03ce = n2;
    }

    @Override
    public PopupPanel createPopupComponent() {
        ColorChooserPanel colorChooserPanel = new ColorChooserPanel(this.getColorMode(), this.isAllowMoreColors(), this.isAllowDefaultColor(), this.getLocale());
        colorChooserPanel.addPropertyChangeListener(PROPERTY_SELECTED_COLOR, this);
        if (this.getSelectedItem() instanceof Color) {
            Color color = (Color)this.getSelectedItem();
            int n2 = 255;
            if (color != null) {
                n2 = color.getAlpha();
            }
            colorChooserPanel.\u0104(n2);
        }
        this.\u03d0 = colorChooserPanel;
        return colorChooserPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (PROPERTY_SELECTED_COLOR.equals(propertyChangeEvent.getPropertyName())) {
            Object object = this.getSelectedItem();
            this.setSelectedItem(propertyChangeEvent.getNewValue(), false);
            this.fireItemStateChanged(new ItemEvent(this, 701, object, 2));
            this.fireItemStateChanged(new ItemEvent(this, 701, propertyChangeEvent.getNewValue(), 1));
            this.repaint();
        }
        super.propertyChange(propertyChangeEvent);
    }

    public int getColorMode() {
        return this.\u03ce;
    }

    public void setColorMode(int n2) {
        int n3 = this.\u03ce;
        if (n3 != n2) {
            this.\u03ce = n2;
            this.firePropertyChange(PROPERTY_COLOR_MODE, n3, this.\u03ce);
        }
    }

    public boolean isAllowDefaultColor() {
        return this.\u03cc;
    }

    public void setAllowDefaultColor(boolean bl) {
        this.\u03cc = bl;
    }

    public boolean isAllowMoreColors() {
        return this.\u03ca;
    }

    public void setAllowMoreColors(boolean bl) {
        this.\u03ca = bl;
    }

    public Color getSelectedColor() {
        this.updateColorFromEditorComponent();
        if (this.getSelectedItem() instanceof Color) {
            return (Color)this.getSelectedItem();
        }
        return null;
    }

    protected void updateColorFromEditorComponent() {
        Object object = this.getEditor().getItem();
        Object object2 = this.getSelectedItem();
        if (object instanceof Color && !object.equals(object2)) {
            this.setSelectedItem(object, false);
        } else if (object == null && object2 != null) {
            this.setSelectedItem(null, false);
        }
    }

    public void setSelectedColor(Color color) {
        this.setSelectedItem(color);
    }

    @Override
    public void setSelectedItem(Object object, boolean bl) throws IllegalArgumentException {
        if (!(object instanceof Color) && !this.isInvalidValueAllowed() && object != null) {
            object = null;
            bl = false;
        }
        if (!this.isInvalidValueAllowed() && object == null && !this.isAllowDefaultColor()) {
            throw new IllegalArgumentException("Null color not accepted.");
        }
        super.setSelectedItem(object, bl);
        if (object instanceof Color) {
            if (this.\u03d0 != null && this.\u03d0 instanceof ColorChooserPanel) {
                int n2 = 255;
                n2 = ((Color)object).getAlpha();
                ((ColorChooserPanel)this.\u03d0).\u0104(n2);
            }
        } else if (object == null) {
            if (this.\u03d0 != null && this.\u03d0 instanceof ColorChooserPanel) {
                ((ColorChooserPanel)this.\u03d0).\u0104(255);
            }
        } else if (this.isInvalidValueAllowed() && this.\u03d0 != null && this.\u03d0 instanceof ColorChooserPanel) {
            ((ColorChooserPanel)this.\u03d0).\u0104(255);
        }
    }

    public boolean isCrossBackGroundStyle() {
        return this.\u03d1;
    }

    public void setCrossBackGroundStyle(boolean bl) {
        if (this.\u03d1 != bl) {
            this.\u03d1 = bl;
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.isColorIconVisible()) {
            dimension.width += 20;
        }
        return dimension;
    }

    public boolean isColorValueVisible() {
        return this.\u03c9;
    }

    public void setColorValueVisible(boolean bl) {
        boolean bl2 = this.\u03c9;
        if (bl2 != bl) {
            this.\u03c9 = bl;
            this.firePropertyChange(PROPERTY_COLOR_VALUE_VISIBLE, bl2, bl);
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isColorIconVisible() {
        return this.\u03cd;
    }

    public void setColorIconVisible(boolean bl) {
        boolean bl2 = this.\u03cd;
        if (bl2 != bl) {
            this.\u03cd = bl;
            this.firePropertyChange(PROPERTY_COLOR_ICON_VISIBLE, bl2, bl);
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isInvalidValueAllowed() {
        return this.\u03cb;
    }

    public void setInvalidValueAllowed(boolean bl) {
        this.\u03cb = bl;
    }

    @Override
    public void customizeRendererComponent(Component component, Object object, int n2, boolean bl, boolean bl2) {
        super.customizeRendererComponent(component, object, n2, bl, bl2);
        if (component instanceof JLabel) {
            if (this._colorIcon == null) {
                this._colorIcon = new ColorIcon();
            }
            if (object instanceof Color) {
                this._colorIcon.setColor((Color)object);
            } else {
                this._colorIcon.setColor(null);
            }
            if (this.isColorIconVisible()) {
                ((JLabel)component).setIcon(this._colorIcon);
            } else {
                ((JLabel)component).setIcon(null);
            }
            ((JLabel)component).setIconTextGap(10);
            if (!this.isColorValueVisible()) {
                ((JLabel)component).setText("");
            }
        }
    }

    public class ColorIcon
    implements Icon {
        private int \u0102 = 1;
        private static final double \u0103 = 1.618;
        private Color \u0104;

        public ColorIcon() {
            ColorExComboBox.this.setOpaque(false);
        }

        public Color getColor() {
            return this.\u0104;
        }

        public void setColor(Color color) {
            this.\u0104 = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            int n4 = component.getHeight();
            if (n4 > 18) {
                this.\u0102 = 2;
            }
            if (!ColorExComboBox.this.isColorIconVisible()) {
                return;
            }
            int n5 = ColorExComboBox.this.isColorValueVisible() ? (int)((double)n4 * 1.618) : component.getWidth();
            Rectangle rectangle = new Rectangle(this.\u0102, this.\u0102, n5 - 2 * this.\u0102, n4 - 2 * this.\u0102 - (ColorExComboBox.this.getHeight() - n4 + 1) % 2);
            if (ColorExComboBox.this.isCrossBackGroundStyle()) {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
            } else {
                graphics.setColor(new Color(204, 204, 204));
                int n6 = rectangle.x + rectangle.width;
                int n7 = rectangle.y + rectangle.height;
                int n8 = 4;
                int n9 = 4;
                boolean bl = false;
                for (int i2 = rectangle.y + 1; i2 <= n7; i2 += n9) {
                    int n10 = bl ? rectangle.x + 1 : rectangle.x + 1 + n8;
                    boolean bl2 = bl = !bl;
                    while (n10 <= n6) {
                        graphics.fillRect(n10, i2, Math.min(n8, n6 - n10 + 1), Math.min(n9, n7 - i2 + 1));
                        n10 += 2 * n8;
                    }
                }
            }
            if (this.getColor() != null) {
                graphics.setColor(this.getColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics.setColor(Color.gray);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        @Override
        public int getIconWidth() {
            return 26;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }
}

