/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.AbstractTimeTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.range.Range;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;

public class DefaultTimeTickCalculator
extends AbstractTimeTickCalculator {
    private static double \u0109 = 4.0;
    private static double \u010b = 10.0;
    private static final Logger \u010a = Logger.getLogger(DefaultTimeTickCalculator.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tick[] calculateTicks(Range<Date> range) {
        double d2;
        TimeZone timeZone = this.getDateFormat() != null ? this.getDateFormat().getTimeZone() : this.getTimeZone();
        DateFormat dateFormat = DateFormat.getTimeInstance();
        double d3 = range.maximum();
        double d4 = range.minimum();
        double d5 = range.minimum();
        double d6 = range.maximum();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeZone(timeZone);
        calendar.setTimeInMillis((long)range.minimum());
        calendar2.setTimeInMillis((long)range.maximum());
        Calendar calendar3 = DefaultTimeTickCalculator.min(calendar, calendar2);
        d5 = calendar3.getTimeInMillis();
        double d7 = DefaultTimeTickCalculator.secondsDiff(calendar, calendar2);
        List<Double> list = null;
        if (d7 < 1.0) {
            double d8;
            if (d4 > d3) {
                d4 = d3;
            }
            if ((d7 = d3 - d4) < 1.0E-8) {
                d7 = 1.0E-8;
            }
            double d9 = Math.log10(d7);
            double d10 = Math.ceil(d9 - 1.0);
            d2 = Math.pow(10.0, d10);
            assert (\u010b / \u0109 >= 2.0);
            do {
                if ((d8 = d7 / d2) > \u010b) {
                    d2 *= 2.0;
                    continue;
                }
                if (!(d8 < \u0109)) continue;
                d2 /= 2.0;
            } while (d8 < \u0109 || d8 > \u010b);
        } else if (d7 > 1.0 && d7 <= 180.0) {
            dateFormat = new SimpleDateFormat("HH:mm:ss");
            if (d7 < 10.0) {
                d2 = 1000.0;
            } else if (d7 < 20.0) {
                d2 = 5000.0;
            } else if (d7 < 40.0) {
                d2 = 5000.0;
            } else if (d7 <= 120.0) {
                d2 = 15000.0;
            } else {
                if (!(d7 <= 180.0)) throw new RuntimeException("Unexpected argument");
                d2 = 30000.0;
            }
        } else if (d7 > 180.0 && d7 <= 3600.0) {
            dateFormat = new SimpleDateFormat("HH:mm");
            if ((d7 /= 60.0) < 10.0) {
                d2 = 60000.0;
            } else if (d7 < 20.0) {
                d2 = 300000.0;
            } else if (d7 < 40.0) {
                d2 = 300000.0;
            } else {
                if (!(d7 <= 60.0)) throw new RuntimeException("Unexpected argument; range = " + d7);
                d2 = 900000.0;
            }
        } else if (d7 > 3600.0 && d7 <= 14400.0) {
            d2 = (d7 /= 3600.0) < 2.0 ? 900000.0 : 1800000.0;
        } else if (d7 > 14400.0 && d7 <= 86400.0) {
            dateFormat = new SimpleDateFormat("HH:mm");
            if ((d7 /= 3600.0) < 10.0) {
                d2 = 3600000.0;
            } else if (d7 <= 24.0) {
                d2 = 7200000.0;
            } else {
                if (!(d7 > 24.0)) throw new RuntimeException("Unexpected argument; range = " + d7);
                d2 = 4.32E7;
            }
        } else if (d7 > 86400.0 && d7 <= 259200.0) {
            dateFormat = new SimpleDateFormat("dd-MMM HH:mm");
            d2 = 4.32E7;
        } else {
            dateFormat = new SimpleDateFormat("dd-MMM");
            if ((d7 /= 86400.0) < 10.0) {
                list = this.\u0101(d5, d6, d4, 1, 6);
                d2 = 8.64E7;
            } else if (d7 <= 20.0) {
                list = this.\u0101(d5, d6, d4, 2, 6);
                d2 = 1.728E8;
            } else if (d7 <= 100.0) {
                list = this.\u0101(d5, d6, d4, 7, 6);
                d2 = 6.048E8;
            } else if (d7 <= 365.25) {
                dateFormat = new SimpleDateFormat("MMM-yy");
                list = this.\u0101(d5, d6, d4, 1, 2);
                d2 = 2.628288E9;
            } else if (d7 <= 1095.75) {
                dateFormat = new SimpleDateFormat("MMM-yy");
                list = this.\u0101(d5, d6, d4, 3, 2);
                d2 = 7.884E9;
            } else if (d7 <= 7305.0) {
                dateFormat = new SimpleDateFormat("yy");
                list = this.\u0101(d5, d6, d4, 1, 1);
                d2 = 3.15576E10;
            } else if (d7 <= 36525.0) {
                dateFormat = new SimpleDateFormat("yyyy");
                list = this.\u0101(d5, d6, d4, 10, 1);
                d2 = 3.15576E11;
            } else {
                Tick[] tickArray = new Tick[]{new Tick((d5 + d6) / 2.0, "Out of Range")};
                return tickArray;
            }
        }
        if (list == null) {
            list = this.\u0101(d5, d6, d4, d2);
        }
        if (this.getDateFormat() != null) {
            dateFormat = this.getDateFormat();
            return this.\u0101(list, dateFormat);
        } else {
            dateFormat.setTimeZone(timeZone);
        }
        return this.\u0101(list, dateFormat);
    }

    private List<Double> \u0101(double d2, double d3, double d4, int n2, int n3) {
        assert (n2 != 0) : "If amount were zero, it would lead to an infinite loop";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis((long)d2);
        double d5 = d2;
        do {
            if (d5 >= d4) {
                arrayList.add(d5);
            }
            calendar.add(n3, n2);
        } while ((d5 = (double)calendar.getTimeInMillis()) <= d3);
        return arrayList;
    }

    private List<Double> \u0101(double d2, double d3, double d4, double d5) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Double d6 = null;
        for (double d7 = d2; d7 <= d3 && d2 != d3 && d5 > 0.0; d7 += d5) {
            if (d7 >= d4) {
                arrayList.add(d7);
            }
            if (d6 != null && d7 <= d6) break;
            d6 = d7;
        }
        return arrayList;
    }

    private Tick[] \u0101(List<Double> list, DateFormat dateFormat) {
        Tick[] tickArray = new Tick[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Double d2 = list.get(i2);
            Date date = new Date(d2.longValue());
            tickArray[i2] = new Tick((double)d2, dateFormat.format(date));
        }
        return tickArray;
    }

    public static Calendar min(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = Calendar.getInstance();
        Calendar calendar4 = calendar.before(calendar2) ? calendar : calendar2;
        calendar3.setTimeZone(calendar4.getTimeZone());
        calendar3.setTimeInMillis(calendar4.getTimeInMillis());
        if (DefaultTimeTickCalculator.yearsDiff(calendar, calendar2) > 10.0) {
            int n2 = calendar.get(1);
            int n3 = (int)(10.0 * Math.floor((double)n2 / 10.0));
            calendar3.set(1, n3);
            calendar3.set(5, 3);
            calendar3.set(2, 0);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (DefaultTimeTickCalculator.yearsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(5, 1);
            calendar3.set(2, 0);
            calendar3.set(11, 12);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (DefaultTimeTickCalculator.weeksDiff(calendar, calendar2) > 10.0) {
            int n4 = calendar.get(5);
            calendar3.set(5, 15);
            if (n4 < 15) {
                calendar3.add(2, -1);
            }
            int n5 = calendar.get(2);
            calendar3.set(2, 5);
            if (n5 < 5) {
                calendar3.add(1, -1);
            }
            calendar3.set(11, 12);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (DefaultTimeTickCalculator.weeksDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 12);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            int n6 = calendar3.get(7);
            if (n6 != 1) {
                int n7 = n6 - 1;
                calendar3.add(5, -n7);
            }
        } else {
            if (DefaultTimeTickCalculator.daysDiff(calendar, calendar2) > 1.0) {
                calendar3.set(11, 0);
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
                return calendar3;
            }
            if (DefaultTimeTickCalculator.hoursDiff(calendar, calendar2) > 1.0) {
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
                if (calendar3.get(11) % 2 != 0) {
                    calendar3.add(11, -1);
                }
            } else if (DefaultTimeTickCalculator.minutesDiff(calendar, calendar2) > 1.0) {
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
            } else if (DefaultTimeTickCalculator.secondsDiff(calendar, calendar2) > 1.0) {
                calendar3.set(14, 0);
                calendar3.set(13, 0);
            }
        }
        return calendar3;
    }

    static Calendar \u0101(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = Calendar.getInstance();
        Calendar calendar4 = calendar2.after(calendar) ? calendar2 : calendar;
        calendar3.setTimeZone(calendar4.getTimeZone());
        calendar3.setTimeInMillis(calendar4.getTimeInMillis());
        if (DefaultTimeTickCalculator.yearsDiff(calendar, calendar2) > 10.0) {
            int n2 = calendar.get(1);
            int n3 = (int)(10.0 * Math.ceil((double)n2 / 10.0));
            calendar3.set(1, n3);
            calendar3.set(2, 5);
            calendar3.set(5, 1);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (DefaultTimeTickCalculator.yearsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(2, 5);
            calendar3.set(5, 1);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(1, 1);
        } else if (DefaultTimeTickCalculator.weeksDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(5, 1);
        } else if (DefaultTimeTickCalculator.daysDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(5, 1);
        } else if (DefaultTimeTickCalculator.hoursDiff(calendar, calendar2) > 1.0) {
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(11, 1);
        } else if (DefaultTimeTickCalculator.minutesDiff(calendar, calendar2) > 1.0) {
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(11, 1);
        } else if (DefaultTimeTickCalculator.secondsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(14, 0);
            calendar3.add(13, 1);
        }
        return calendar3;
    }

    public static double yearsDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.weeksDiff(calendar, calendar2) / 52.0;
    }

    public static double weeksDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.daysDiff(calendar, calendar2) / 7.0;
    }

    public static double daysDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.hoursDiff(calendar, calendar2) / 24.0;
    }

    public static double hoursDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.minutesDiff(calendar, calendar2) / 60.0;
    }

    public static double minutesDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.secondsDiff(calendar, calendar2) / 60.0;
    }

    public static double secondsDiff(Calendar calendar, Calendar calendar2) {
        return (double)DefaultTimeTickCalculator.millisDiff(calendar, calendar2) / 1000.0;
    }

    public static long millisDiff(Calendar calendar, Calendar calendar2) {
        long l2 = calendar.getTimeInMillis();
        long l3 = calendar2.getTimeInMillis();
        return Math.abs(l2 - l3);
    }
}

