/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.Shadowable;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.LineSmoother;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class DifferenceMarker
implements Drawable,
Frontable,
Shadowable {
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_MODEL1 = "Model1";
    public static final String PROPERTY_MODEL2 = "Model2";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_MODEL1_DOMINANT_FILL = "Model1 Dominant Fill";
    public static final String PROPERTY_MODEL2_DOMINANT_FILL = "Model2 Dominant Fill";
    private static final Color \u0157 = new Color(0, 0, 0, 50);
    private Chart \u0153;
    private ChartModel \u014c;
    private ChartModel \u014b;
    private Polygon \u014f;
    private Polygon \u014d;
    private Polygon \u0158;
    private boolean \u0154 = false;
    private double \u0148 = 0.5;
    private Shape \u015b;
    private Shape \u0149;
    private Shape \u0152;
    private ComponentListener \u0151;
    private ChartModelListener \u0155;
    private boolean \u0150 = false;
    private boolean \u015a = false;
    private Paint \u014a = \u0157;
    private Paint \u0159 = \u0157;
    private PropertyChangeSupport \u014e = new PropertyChangeSupport(this);

    public DifferenceMarker() {
        this.\u014f = new Polygon();
        this.\u014d = new Polygon();
        this.\u0158 = new Polygon();
        this.\u0155 = new ChartModelListener(){

            @Override
            public void chartModelChanged() {
                DifferenceMarker.this.update();
            }
        };
    }

    public DifferenceMarker(Chart chart) {
        this();
        this.setChart(chart);
    }

    public DifferenceMarker(Chart chart, ChartModel chartModel, ChartModel chartModel2) {
        this();
        this.setChart(chart);
        this.setModel1(chartModel);
        this.setModel2(chartModel2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u014e.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u014e.removePropertyChangeListener(propertyChangeListener);
    }

    public Chart getChart() {
        return this.\u0153;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.\u0153;
        if (chart2 != null) {
            chart2.removeComponentListener(this.\u0151);
        }
        this.\u0153 = chart;
        chart.addComponentListener(this.\u0151);
        this.\u014e.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public ChartModel getModel1() {
        return this.\u014c;
    }

    public void setModel1(ChartModel chartModel) {
        ChartModel chartModel2 = this.\u014c;
        if (chartModel2 != null) {
            chartModel2.removeChartModelListener(this.\u0155);
        }
        this.\u014c = chartModel;
        chartModel.addChartModelListener(this.\u0155);
        this.\u014e.firePropertyChange(PROPERTY_MODEL1, chartModel2, chartModel);
    }

    public ChartModel getModel2() {
        return this.\u014b;
    }

    public void setModel2(ChartModel chartModel) {
        ChartModel chartModel2 = this.\u014b;
        if (chartModel2 != null) {
            chartModel2.removeChartModelListener(this.\u0155);
        }
        this.\u014b = chartModel;
        chartModel.addChartModelListener(this.\u0155);
        this.\u014e.firePropertyChange(PROPERTY_MODEL2, chartModel2, chartModel);
    }

    public boolean isSmooth() {
        return this.\u0154;
    }

    public void setSmooth(boolean bl) {
        this.\u0154 = bl;
    }

    public double getSmoothness() {
        return this.\u0148;
    }

    public void setSmoothness(double d2) {
        this.\u0148 = d2;
    }

    public Shape getDifferenceShape() {
        return this.\u0152;
    }

    public Paint getModel1DominantFill() {
        return this.\u014a;
    }

    public void setModel1DominantFill(Paint paint) {
        Paint paint2 = this.\u014a;
        this.\u014a = paint;
        this.\u014e.firePropertyChange(PROPERTY_MODEL1_DOMINANT_FILL, paint2, paint);
    }

    public Paint getModel2DominantFill() {
        return this.\u0159;
    }

    public void setModel2DominantFill(Paint paint) {
        Paint paint2 = this.\u0159;
        this.\u0159 = paint;
        this.\u014e.firePropertyChange(PROPERTY_MODEL2_DOMINANT_FILL, paint2, paint);
    }

    public void setFill(Paint paint) {
        this.setModel1DominantFill(paint);
        this.setModel2DominantFill(paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        this.\u014f.reset();
        this.\u014d.reset();
        this.\u0158.reset();
        if (this.\u0153 != null) {
            if (this.\u0154) {
                GeneralPath generalPath = new GeneralPath();
                GeneralPath generalPath2 = new GeneralPath();
                generalPath.moveTo(this.\u0153.getXStart(), this.\u0153.getYStart());
                generalPath2.moveTo(this.\u0153.getXEnd(), this.\u0153.getYStart());
                GeneralPath generalPath3 = LineSmoother.preparePath(this.\u0153, this.\u014c, this.\u0148);
                generalPath.append(generalPath3, true);
                generalPath.lineTo(this.\u0153.getXEnd(), this.\u0153.getYStart());
                generalPath.closePath();
                GeneralPath generalPath4 = LineSmoother.preparePath(this.\u0153, this.\u014b, this.\u0148, true);
                generalPath2.append(generalPath4, true);
                generalPath2.lineTo(this.\u0153.getXStart(), this.\u0153.getYStart());
                generalPath2.closePath();
                GeneralPath generalPath5 = new GeneralPath();
                generalPath5.append(generalPath3, true);
                generalPath5.append(generalPath4, true);
                generalPath5.closePath();
                this.\u015b = generalPath;
                this.\u0149 = generalPath2;
                this.\u0152 = generalPath5;
            } else {
                int n2;
                Point2D point2D;
                Object object;
                this.\u014d.addPoint(this.\u0153.getXStart(), this.\u0153.getYStart());
                this.\u0158.addPoint(this.\u0153.getXEnd(), this.\u0153.getYStart());
                Axis axis = this.\u0153.getAxisForModel(this.\u014c);
                Axis axis2 = this.\u0153.getAxisForModel(this.\u014b);
                assert (axis != null);
                ChartModel chartModel = this.\u014c;
                synchronized (chartModel) {
                    for (Chartable chartable : this.\u014c) {
                        object = new Point2D.Double(chartable.getX().position(), chartable.getY().position());
                        point2D = this.\u0153.calculatePixelPoint((Point2D)object, axis);
                        if (point2D == null) continue;
                        int n3 = this.\u0153.interpolateXForAnimation(point2D.x, this.\u014c);
                        n2 = this.\u0153.interpolateYForAnimation(point2D.y, this.\u014c);
                        this.\u014f.addPoint(n3, n2);
                        this.\u014d.addPoint(n3, n2);
                    }
                }
                this.\u014d.addPoint(this.\u0153.getXEnd(), this.\u0153.getYStart());
                chartModel = this.\u014b;
                synchronized (chartModel) {
                    int n4 = this.\u014b.getPointCount();
                    for (int i2 = n4 - 1; i2 >= 0; --i2) {
                        object = this.\u014b.getPoint(i2);
                        point2D = new Point2D.Double(object.getX().position(), object.getY().position());
                        Point point = this.\u0153.calculatePixelPoint(point2D, axis2);
                        if (point == null) continue;
                        n2 = this.\u0153.interpolateXForAnimation(point.x, this.\u014b);
                        int n5 = this.\u0153.interpolateYForAnimation(point.y, this.\u014b);
                        this.\u014f.addPoint(n2, n5);
                        this.\u0158.addPoint(n2, n5);
                    }
                }
                this.\u0158.addPoint(this.\u0153.getXStart(), this.\u0153.getYStart());
                this.\u015b = this.\u014d;
                this.\u0149 = this.\u0158;
                this.\u0152 = this.\u014f;
            }
        }
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.update();
        if (this.\u0152 != null) {
            Area area;
            Area area2;
            if (this.\u014a != null) {
                graphics2D.setPaint(this.\u014a);
                area2 = new Area(this.\u0152);
                Area area3 = area = rectangle == null ? null : new Area(rectangle);
                if (area != null) {
                    area2.intersect(area);
                }
                graphics2D.setClip(this.\u015b);
                graphics2D.fill(area2);
            }
            if (this.\u0159 != null) {
                graphics2D.setPaint(this.\u0159);
                area2 = new Area(this.\u0152);
                Area area4 = area = rectangle == null ? null : new Area(rectangle);
                if (area != null) {
                    area2.intersect(area);
                }
                graphics2D.setClip(this.\u0149);
                graphics2D.fill(area2);
            }
        }
        graphics2D.dispose();
    }

    @Override
    public boolean isAtFront() {
        return this.\u0150;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.\u0150;
        this.\u0150 = bl;
        this.\u014e.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }

    @Override
    public boolean isShadowVisible() {
        return this.\u015a;
    }

    @Override
    public void setShadowVisible(boolean bl) {
        this.\u015a = bl;
    }
}

