/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainerLayout;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class DockableBarContainer
extends JComponent
implements SwingConstants {
    private int \u0101;
    private DockableBarListList \u0104;
    public static int OFFSET = 3;
    private DockableBarManager \u0103;
    private DockableBarShrinkOrderProvider \u0102;

    public DockableBarContainer(DockableBarManager dockableBarManager, int n2) {
        this(dockableBarManager);
        this.setSide(n2);
    }

    public DockableBarContainer(DockableBarManager dockableBarManager) {
        this.\u0103 = dockableBarManager;
        this.\u0104 = new DockableBarListList(this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.\u0101();
    }

    private void \u0101() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof DockableBarContainerLayout) {
            int n2;
            if (UIDefaultsLookup.get("CommandBarContainer.verticalGap") instanceof Integer) {
                n2 = UIDefaultsLookup.getInt("CommandBarContainer.verticalGap");
                ((DockableBarContainerLayout)layoutManager).setVerticalGap(n2);
            }
            if (UIDefaultsLookup.get("CommandBarContainer.horizontalGap") instanceof Integer) {
                n2 = UIDefaultsLookup.getInt("CommandBarContainer.horizontalGap");
                ((DockableBarContainerLayout)layoutManager).setHorizontalGap(n2);
            }
            this.revalidate();
        }
    }

    public void setSide(int n2) {
        this.\u0101 = n2;
        this.setLayout(new DockableBarContainerLayout(this, this.\u0101));
        this.\u0101();
        if (this.\u0101 == 3 || this.\u0101 == 7) {
            JideSwingUtilities.setOrientationOf(this, 1);
        } else if (this.\u0101 == 1 || this.\u0101 == 5) {
            JideSwingUtilities.setOrientationOf(this, 0);
        }
    }

    public int getSide() {
        return this.\u0101;
    }

    public void setDockableBarList(DockableBarListList dockableBarListList) {
        this.removeAll();
        this.\u0104 = dockableBarListList;
        for (int i2 = 0; i2 < dockableBarListList.size(); ++i2) {
            DockableBarList dockableBarList = (DockableBarList)dockableBarListList.get(i2);
            for (int i3 = 0; i3 < dockableBarList.size(); ++i3) {
                DockableBarItem dockableBarItem = (DockableBarItem)dockableBarList.get(i3);
                dockableBarItem.getComponent().setVisible(true);
                this.add(dockableBarItem.getComponent());
            }
        }
        this.invalidate();
    }

    public DockableBarShrinkOrderProvider getShrinkOrderProvider() {
        return this.\u0102;
    }

    public void setShrinkOrderProvider(DockableBarShrinkOrderProvider dockableBarShrinkOrderProvider) {
        this.\u0102 = dockableBarShrinkOrderProvider;
    }

    public DockableBarListList getDockableBarList() {
        return this.\u0104;
    }

    public int getRowCount() {
        return this.getDockableBarList().size();
    }

    public int getRowHeight(int n2) {
        return ((DockableBarContainerLayout)this.getLayout()).getRowHeightAt(n2);
    }

    public int getRowAndGapIndexAt(Point point) {
        int n2;
        int n3 = n2 = this.getOrientation() == 0 ? point.y : point.x;
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= (this.getOrientation() == 0 ? this.getHeight() : this.getWidth())) {
            return this.getRowCount() * 2;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            if (n2 >= n4 + OFFSET && n2 < n4 + this.getRowHeight(i2) - (i2 != this.getRowCount() - 1 ? OFFSET : 0)) {
                return i2 * 2 + 1;
            }
            n4 += this.getRowHeight(i2);
            if (i2 == this.getRowCount() - 1) continue;
            if (n2 >= n4 - OFFSET && n2 < n4 + ((DockableBarContainerLayout)this.getLayout()).getVerticalGap() + OFFSET) {
                return i2 * 2 + 2;
            }
            n4 += ((DockableBarContainerLayout)this.getLayout()).getVerticalGap();
        }
        return -1;
    }

    public int getOrientation() {
        if (this.\u0101 == 1 || this.\u0101 == 5) {
            return 0;
        }
        return 1;
    }

    public boolean isHorizontal() {
        return this.getOrientation() == 0;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    protected void addImpl(Component component, Object object, int n2) {
        super.addImpl(component, object, n2);
        JideSwingUtilities.setOrientationOf(component, this.getOrientation());
    }

    public void addDockableBar(DockableBar dockableBar, int n2, boolean bl, int n3) {
        try {
            if (this.isHorizontal()) {
                dockableBar.setHoriDocked();
            } else {
                dockableBar.setVertDocked();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.add(dockableBar);
        this.\u0104.changeComponentRow(dockableBar, n2, bl, n3);
        this.revalidate();
    }

    public int getCurrentRowOf(DockableBar dockableBar) {
        DockableBarItem dockableBarItem = this.getDockableBarList().getDockableBarItemOf(dockableBar);
        return dockableBarItem.getRow();
    }

    public DockableBarManager getDockableBarManager() {
        return this.\u0103;
    }

    public static interface DockableBarShrinkOrderProvider {
        public int[] getShrinkOrder(int var1);
    }
}

