/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.repository.util.DataBufferOutputStream;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.SchemaValidator;
import com.ibm.db2.cmx.tools.Tool;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.OptionsProcessor;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SchemaValidatorImpl
extends PureQueryUtility {
    private static final String SCHEMA_DEFINITION_FILENAME_V3 = "/com/ibm/pdq/runtime/internal/xml/PDQSchema3.xsd";
    private static final String SCHEMA_DEFINITION_FILENAME_V4 = "/com/ibm/pdq/runtime/internal/xml/PDQSchema4.xsd";
    private static Transformer transformer_;
    private static Schema schemaV3;
    private static Schema schemaV4;

    public SchemaValidatorImpl(PrintWriter printWriter) {
        super(Tool.VALIDATOR, false, printWriter);
    }

    private static Schema getSchemaFromFileName(String string) {
        Schema schema = null;
        try {
            StreamSource streamSource = null;
            streamSource = DataProperties.runningUnderSecurityManager_ ? new StreamSource(AccessController.doPrivileged(SchemaValidatorImpl.getResourceAsInputStreamPriv(string))) : new StreamSource(SchemaValidatorImpl.getResourceAsInputStream(string));
            schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(streamSource);
        }
        catch (Exception exception) {
            ToolsLogger.getLogger().log(Level.FINER, "Unable to load the pureQueryXml schema definition for pureQueryXml schema validation");
        }
        return schema;
    }

    private static InputStream getResourceAsInputStream(String string) {
        InputStream inputStream = SchemaValidatorImpl.class.getResourceAsStream(string);
        if (inputStream != null) {
            ToolsLogger.getLogger().log(Level.FINER, Messages.getText("MSG_LOADED_RESOURCE", StaticProfileConstants.maskJdbcURLPasswords(SchemaValidatorImpl.class.getResource(string).toExternalForm())));
        }
        return inputStream;
    }

    private static final PrivilegedAction<InputStream> getResourceAsInputStreamPriv(final String string) {
        return new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return SchemaValidatorImpl.getResourceAsInputStream(string);
            }
        };
    }

    private static Transformer getTransformer() {
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception exception) {
            ToolsLogger.getLogger().log(Level.FINER, "Unable to create a transformer for pureQueryXml file validation: " + exception.getMessage());
        }
        return transformer;
    }

    @Override
    protected PureQueryUtility.UtilityResult processSingleArtifact(ArtifactOptionsSet artifactOptionsSet, boolean bl2) throws Exception {
        PureQueryUtility.UtilityResult utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
        String string = artifactOptionsSet.getArtifactName();
        if (PossibleArgs.PUREQUERY_XML_FILE != artifactOptionsSet.getArtifactType()) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_ARTIFACT_ILLEGAL_TYPE", new Object[]{artifactOptionsSet.getArtifactType(), string}), null, 10957);
        }
        utilityResult = SchemaValidatorImpl.validatePureQueryXml(string);
        return utilityResult;
    }

    public static PureQueryUtility.UtilityResult validatePureQueryXml(String string) {
        PureQueryUtility.UtilityResult utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
        try {
            Object object;
            Document document = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new File(string));
            if (document == null) {
                utilityResult.reason = Messages.getText("MSG_FAILED_TO_LOAD", string);
                utilityResult.utilityResultType = PureQueryUtility.UtilityResultType.FAILURE;
                return utilityResult;
            }
            Element element = document.getDocumentElement();
            String string2 = element.getNodeName();
            if (!string2.equalsIgnoreCase("programSet")) {
                utilityResult.reason = Messages.getText("MSG_NO_PROGRAM_SET", string, "programSet");
                utilityResult.utilityResultType = PureQueryUtility.UtilityResultType.FAILURE;
                return utilityResult;
            }
            String string3 = element.getAttribute("version");
            if (string3 == null) {
                utilityResult.reason = Messages.getText("MSG_NO_VERSION", "programSet", string, "version");
                utilityResult.utilityResultType = PureQueryUtility.UtilityResultType.FAILURE;
                return utilityResult;
            }
            int n2 = -1;
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                utilityResult.reason = "programSet versionis invalid.  Validation failed.";
                utilityResult.utilityResultType = PureQueryUtility.UtilityResultType.FAILURE;
                return utilityResult;
            }
            Schema schema = null;
            if (n2 == 3) {
                schema = schemaV3;
            } else if (n2 == 4) {
                schema = schemaV4;
            } else {
                utilityResult.reason = Messages.getText("MSG_UNSUPPORTED_VERSION", "programSet", n2, string);
                utilityResult.utilityResultType = PureQueryUtility.UtilityResultType.SKIP;
                return utilityResult;
            }
            if (null == schema) {
                utilityResult.reason = Messages.getText("MSG_NO_SCHEMA", string);
                utilityResult.utilityResultType = PureQueryUtility.UtilityResultType.FAILURE;
                return utilityResult;
            }
            if ("".equals(element.getAttribute("xmlns")) && transformer_ != null) {
                if (n2 == 3) {
                    element.setAttribute("xmlns", "http://www.ibm.com/xmlns/prod/optim/pureQuery/programSetV3");
                } else if (n2 == 4) {
                    element.setAttribute("xmlns", "http://www.ibm.com/xmlns/prod/optim/pureQuery/programSetV4");
                }
                try {
                    object = new DataBufferOutputStream();
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object, "UTF-8"));
                    StreamResult streamResult = new StreamResult(bufferedWriter);
                    transformer_.transform(new DOMSource(document), streamResult);
                    bufferedWriter.flush();
                    ((DataBufferOutputStream)object).close();
                    document = documentBuilder.parse(new InputSource(new InputStreamReader(((DataBufferOutputStream)object).getInputStream(), "UTF-8")));
                    if (document.getDocumentElement().getAttribute("xmlns") == "") {
                        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnlyNoLogging("The schema validator was unable to modify the namespace of the xml file.", null, 11028);
                    }
                }
                catch (Throwable throwable) {
                    if (ToolsLogger.getLogger() != null) {
                        ToolsLogger.getLogger().log(Level.FINE, "Unable to add pureQuery namespace to file " + string + " for pureQueryXml schema validation: " + throwable.getMessage());
                        ExceptionFactory.logException(ToolsLogger.getLogger(), throwable);
                    }
                    utilityResult.utilityResultType = PureQueryUtility.UtilityResultType.FAILURE;
                    utilityResult.reason = Messages.getText("MSG_FAILED_TO_ASSOCIATE_SCHEMA", string, throwable.getMessage());
                    return utilityResult;
                }
            }
            object = schema.newValidator();
            ((Validator)object).validate(new DOMSource(document));
            utilityResult.utilityResultType = PureQueryUtility.UtilityResultType.SUCCESS;
        }
        catch (SAXParseException sAXParseException) {
            String string4 = sAXParseException.getPublicId();
            String string5 = sAXParseException.getSystemId();
            int n3 = sAXParseException.getLineNumber();
            int n4 = sAXParseException.getColumnNumber();
            StringBuilder stringBuilder = new StringBuilder(Messages.getText("MSG_VALIDATE_FAIL_REASON_PREFIX", string) + "\n" + sAXParseException.getMessage());
            if (string4 != null || string5 != null || n3 != -1 || n4 != -1) {
                stringBuilder.append("\n  " + Messages.getText("MSG_PARSE_FAILURE", new Object[0]));
                if (string4 != null) {
                    stringBuilder.append(" " + Messages.getText("MSG_PUBLIC_ID", string4));
                }
                if (string5 != null) {
                    stringBuilder.append(" " + Messages.getText("MSG_SYSTEM_ID", string5));
                }
                if (n3 != -1) {
                    stringBuilder.append(" " + Messages.getText("MSG_LINE_NO", n3));
                }
                if (n4 != -1) {
                    stringBuilder.append(" " + Messages.getText("MSG_COL_NO", n4));
                }
                stringBuilder.append(".");
            }
            utilityResult.reason = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            utilityResult.reason = Messages.getText("MSG_VALIDATE_FAIL_REASON_PREFIX", string) + throwable.getMessage();
        }
        return utilityResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PureQueryUtility.UtilityResults processArtifactForTooling(List<String[]> list, String string) {
        PureQueryUtility.UtilityResults utilityResults = new PureQueryUtility.UtilityResults();
        ArtifactOptionsSet[] artifactOptionsSetArray = null;
        if (null == string) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_METHOD_NULL_ARG", "getArtifactOptionsSetAndConfigureLoggerForTooling", "artifactToProcessFromTools"), null, 10895);
        }
        if ("defaultOptions".equalsIgnoreCase(string)) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_TOOL_METHOD_INVOKED_FOR_DEFAULTOPTIONS", "defaultOptions"), null, 10896);
        }
        try {
            if (null == list) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_METHOD_NULL_ARG", "getArtifactOptionsSetAndConfigureLoggerForTooling", "optionsFileAsProperties"), null, 10886);
            }
            ArtifactOptionsSet artifactOptionsSet = OptionsProcessor.getToolingArtifactOptionsSet(this.tool_, PossibleArgs.PUREQUERY_XML_FILE, string, null, null, null, null, null, false);
            artifactOptionsSetArray = OptionsProcessor.getAllArtifactOptionsSetsAndConfigureLogger(artifactOptionsSet, this.utilityWillCreateADatabaseConnection_, list, null);
            boolean bl2 = 1 == artifactOptionsSetArray.length;
            for (ArtifactOptionsSet artifactOptionsSet2 : artifactOptionsSetArray) {
                PureQueryUtility.UtilityResult utilityResult = this.processSingleArtifactAndPrintResult(artifactOptionsSet2, false, bl2);
                utilityResults.addResult(utilityResult);
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            utilityResults.generalFailure = true;
            this.printFailure(dataRuntimeException, null, artifactOptionsSetArray);
        }
        catch (Throwable throwable) {
            utilityResults.generalFailure = true;
            DataRuntimeException dataRuntimeException = ExceptionFactory.createDataRuntimeExceptionForToolsOnly(this.getMessageForFailure(artifactOptionsSetArray), throwable, 10887);
            this.printFailure(dataRuntimeException, null, artifactOptionsSetArray);
        }
        finally {
            try {
                this.printWriter_.flush();
            }
            catch (Throwable throwable) {}
            try {
                ToolsLogger.cleanupLoggerAndDetachDriverManagerLogAndConnectionLog(null);
            }
            catch (Throwable throwable) {}
        }
        return utilityResults;
    }

    @Override
    public String getUtilityName() {
        return SchemaValidator.class.getSimpleName();
    }

    static {
        schemaV3 = SchemaValidatorImpl.getSchemaFromFileName(SCHEMA_DEFINITION_FILENAME_V3);
        schemaV4 = SchemaValidatorImpl.getSchemaFromFileName(SCHEMA_DEFINITION_FILENAME_V4);
        transformer_ = SchemaValidatorImpl.getTransformer();
    }
}

