/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.db.ProfileSection;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StaticProfileConstants {
    public static final short isPositionedUpdate__ = 1;
    public static final short isPositionedDelete__ = 2;
    public static final short isPositionedInsert__ = 4;
    public static final short isCaptureOn__ = 5;
    public static final short isCaptureOff__ = 6;
    public static final short isExecutionStatic__ = 7;
    public static final short isExecutionDynamic__ = 8;
    public static final short captureModeError__ = 17;
    public static final short executionModeError__ = 18;
    public static final short isExecutionMixed__ = 20;
    public static final short sqlLiteralSubstitutionNotSet__ = 21;
    public static final short sqlLiteralSubstitutionEnable__ = 22;
    public static final short sqlLiteralSubstitutionDisable__ = 23;
    public static final short sqlLiteralSubstitutionEnableWithParameters__ = 24;
    public static final String HELP = "-help";
    public static final String SERVERNAME = "-serverName";
    public static final String PORTNUMBER = "-portNumber";
    public static final String JDBCDRIVER = "com.ibm.db2.jcc.DB2Driver";
    public static final String CURSOR_NAME_PREFIX = "DB_PDQ_SPC";
    public static final String JCC_CURSOR_PREFIX = "SQL_CUR";
    public static final int STACK_TRACE_INDEX = 3;
    public static final String OPEN_PAREN_TOKEN = "(";
    public static final String CLOSE_PAREN_TOKEN = ")";
    public static final String CONTINUATION_TOKEN = "|";
    public static final String SEPARATOR_TOKEN = ">";
    public static final String PKG_WITH_NO_MATCH = "*NO_MATCH_FOUND*";
    public static final String VALIDATESCHEMA = "-validateschema";
    public static final int DEFAULT_SQL_LIMIT = 100;
    public static final String PROPERTY_CAPTURE = "captureMode";
    public static final String PROPERTY_EXECUTION = "executionMode";
    public static final String PROPERTY_ALLOW_DYN_SQL = "allowDynamicSQL";
    public static final String PROPERTY_INPUT_FILENAME = "pureQueryXml";
    public static final String PROPERTY_OUTPUT_FILENAME = "outputPureQueryXml";
    public static final String PROPERTY_TRACE_DEPTH = "stackTraceDepth";
    public static final String PROPERTY_MAXNONPARM_SQL = "maxNonParmSQL";
    public static final String PROPERTY_STMT_BATCH = "captureStatementBatchSQL";
    public static final String PROPERTY_MAX_STACKTRACES_CAPTURED = "maxStackTracesCaptured";
    public static final String PROPERTY_PACKAGE_PREFIX_EXCLUSIONS = "packagePrefixExclusions";
    public static final String PROPERTY_CAPTUREDONLY = "capturedOnly";
    public static final String PROPERTY_ENABLE_DYN_SQL_REPLACEMENT = "enableDynamicSQLReplacement";
    public static final String PROPERTY_SQL_STMT_LITERAL_SUBSTITUTION = "sqlLiteralSubstitution";
    public static final String PROPERTY_TRACE_FILE = "traceFile";
    public static final String PROPERTY_TRACE_LEVEL = "traceLevel";
    public static final String PROPERTY_QUERY_TIMEOUT_IN_SECONDS = "queryTimeoutInSeconds";
    public static final String PROPERTY_MAX_RESULT_ROWS = "maxResultRows";
    public static final String PROPERTY_FINAL_REPOSITORY_PROPERTIES = "finalRepositoryProperties";
    public static final String PROPERTY_PROPERTIES_REFRESH_INTERVAL = "propertiesRefreshInterval";
    public static final String PROPERTY_PROPERTIES_GROUP_ID = "propertiesGroupId";
    public static final String PROPERTY_OUTPUT_XML_REPOSITORY = "outputXmlRepository";
    public static final String PROPERTY_REPOSITORY_REQUIRED = "repositoryRequired";
    public static final String PROPERTY_REPOSITORY_RTG_ACTIVATION_CHECK_INTERVAL = "runtimeGroupActivationCheckInterval";
    public static final String PROPERTY_REPOSITORY_SCHEMA = "repositorySchema";
    public static final String PROPERTY_DISABLE_REPOSITORY_PROPERTIES_AND_XML_RELOAD = "disableRepositoryPropertiesAndXMLReload";
    public static Pattern WCOPat_ = Pattern.compile("[\\s\\)]+((?i:where)[\\s?\\S?]+(?i:current)[\\s?\\S?]+(?i:of)\\s+[\"]?\\s*)(\\w+)(\\s*[\"]?)");
    public static Pattern WCOPatTo_WHERE_ = Pattern.compile("^[\\s\\)]+");
    public static Pattern InsertValuesPat = Pattern.compile("^\\s*(?i:insert)\\s+(?i:into)[\\s\\S]+(?=(?i:values))");
    public static Pattern InsertSelectPat = Pattern.compile("^\\s*(?i:insert)\\s+(?i:into)[\\s\\S]+(?=(?i:select))");
    private static Pattern setPat = Pattern.compile("^\\s*(?i:set)[\\s\\S]");
    private static Pattern UPDATEPat = Pattern.compile("^\\s*(?i:update)[\\s\\S]");
    private static Pattern DELETEPat = Pattern.compile("^\\s*(?i:delete)[\\s\\S]");
    private static Pattern XQUERYPat = Pattern.compile("^\\s*(?i:xquery)[\\s\\S]");
    private static Pattern SELECTPat = Pattern.compile("^[\\s(]*(?i:select)[\\s\\S]");
    private static Pattern WITHPat = Pattern.compile("^[\\s(]*(?i:with)[\\s\\S]");
    public static Pattern forUpdateOfPat = Pattern.compile("\\s*((?i:for)\\s+(?i:update))(\\s+(?i:of))?");
    public static Pattern forFetchOnlyPat = Pattern.compile("\\s*((?i:for)\\s+(?i:fetch))\\s+(?i:only)");
    public static Pattern forReadOnlyPat = Pattern.compile("\\s*((?i:for)\\s+(?i:read))\\s+(?i:only)");
    public static Pattern keyPat = Pattern.compile("\\s*(\\p{Alpha}+)(?=[\\s+(])");
    public static Pattern COMMITPat = Pattern.compile("^\\s*(?i:commit)\\s*");
    public static Pattern ROLLBACKPat = Pattern.compile("^\\s*(?i:rollback)\\s*");
    public static Pattern SAVEPOINTPat = Pattern.compile("^\\s*(?i:savepoint)\\s*");
    public static Pattern SetCurrentPackagePat = Pattern.compile("^\\s*(?i:set)\\s+(?i:current)\\s+(?i:package)");
    public static Pattern ROWSETPat = Pattern.compile("\\s+(?i:rowset)");
    public static Pattern withRowsetPositioningPat = Pattern.compile("\\s*(?i:WITH)\\s+(?i:ROWSET)\\s+(?i:POSITIONING)");
    public static Pattern forRowNOfRowsetPat = Pattern.compile("\\s*FOR\\s+ROW\\s+:H:H\\s+OF\\s+ROWSET");
    public static Pattern scrollPat = Pattern.compile("([\\s\\S]+\\sSCROLL)");
    public static final Pattern scrollSensitivePat__ = Pattern.compile("\\b[A]?SENSITIVE\\b.*\\bSCROLL\\b", 2);
    public static final Pattern scrollInsensitivePat__ = Pattern.compile("\\bINSENSITIVE\\b.*\\bSCROLL\\b", 2);
    public static final Pattern withHoldPat__ = Pattern.compile("\\bWITH\\s+HOLD\\b", 2);
    public static Pattern asPat = Pattern.compile("(\\)\\s*(?i:as))\\s+");
    public static Pattern noAsPat = Pattern.compile("(\\)\\s*(?i:on))\\s*");
    public static Pattern notAtomicCont = Pattern.compile("NOT\\s+ATOMIC\\s+CONTINUE\\s+ON\\s+SQLEXCEPTION");
    public static final String databaseProductNamePrefix_db2ForZOSnLUW = "DB2";
    public static final String DB2Zos = "DB2";
    public static final String DB2Linux = "DB2/LINUXX8664";
    public static final String DB2NT = "DB2/NT";
    public static final String DB2UNIX = "DB2/UNIX64";
    public static final String IDSUNIX = "IDS/UNIX64";
    public static final String IDSNT = "IDS/NT";
    public static final String databaseProductName_db2ForSystemi = "AS";
    public static final String databaseProductVersion_db2ForZosStart = "DSN";
    public static final String databaseProductVersion_db2ForLUWStart = "SQL";
    public static final String databaseProductVersion_db2ForSystemiStart = "QSQ";
    public static final Pattern whiteSpacePat = Pattern.compile("\\s*");
    public static final short intType = 33;
    public static final short decimalType = 34;
    public static final short bigDecimalType = 35;
    public static final short doubleType = 36;
    public static final short dateType = 37;
    public static final short timeType = 38;
    public static final short timeStampType = 39;
    public static final short stringType = 40;
    public static final short nullType = 41;
    public static final short pMarkerTypeUnknown = 42;
    public static final short baseFileDefIncrements = 64;
    public static final short baseFileExeIncrements = 65;
    public static final String dateFormatPattern_ = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String SPCL_REG_UNTRACKED_UNSAFE_REG = "UNTRACKED_SET";
    public static final String SPCL_REG_CURRENT_SCHEMA = "SCHEMA";
    public static final String SPCL_REG_CURRENT_SCHEMA_DISPLAY_NAME = "CURRENT SCHEMA";
    public static final String SPCL_REG_CURRENT_PATH = "PATH";
    public static final String SPCL_REG_CURRENT_PATH_DISPLAY_NAME = "CURRENT PATH";
    public static final String SPCL_REG_CURRENT_SQLID = "SQLID";
    public static final String SPCL_REG_CURRENT_SQLID_DISPLAY_NAME = "CURRENT SQLID";
    public static final String SPCL_REG_CURRENT_DECFLOAT_ROUNDING_MODE = "DECFLOAT ROUNDING";
    public static final String SPCL_REG_CURRENT_DECFLOAT_ROUNDING_MODE_DISPLAY_NAME = "CURRENT DECFLOAT ROUNDING MODE";
    public static final String SPCL_REG_CURRENT_PRECISION = "PRECISION";
    public static final String SPCL_REG_CURRENT_PRECISION_DISPLAY_NAME = "CURRENT PRECISION";
    public static final String SPCL_REG_CURRENT_TIMEZONE = "CURRENT TIME ZONE";
    public static final String SPCL_REG_CURRENT_TIMEZONE_DISPLAY_NAME = "CURRENT TIME ZONE";
    public static final String[] SPECIAL_REG_ORDER = new String[]{"UNTRACKED_SET", "SCHEMA", "PATH", "SQLID", "DECFLOAT ROUNDING", "PRECISION"};
    public static final boolean areQuotesSignificantInBindOptionsForAnyTrackedSpecialRegisters = false;
    public static final String SPCL_REG_CURRENT_SCHEMA_BIND_OPTION_QUALIFIER = "QUALIFIER";
    public static final String SPCL_REG_CURRENT_PATH_BIND_OPTION_FUNCPATH = "FUNCPATH";
    public static final String SPCL_REG_CURRENT_DECFLOAT_ROUNDING_MODE_BIND_OPTION_ROUNDING = "ROUNDING";
    public static final String SPCL_REG_CURRENT_PRECISION_BIND_OPTION_DEC = "DEC";
    private static final Pattern currentPrecisionIncludesNoScalePat = Pattern.compile("\\s*DEC(15|31)\\s*");
    private static final Pattern currentPrecisionIncludesScalePat = Pattern.compile("\\s*D(15|31)[\\.,]([1-9])\\s*");
    private static final HashMap<String, String> specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING = new HashMap();
    public static final Pattern specialRegisterVectorSingleRegisterPat;
    public static final Pattern specialRegisterVectorFullPat;
    public static final Pattern selectIdentityValLocalPat;
    public static final String passwordReplacement = "*****";
    private static final String jdbcURLPassword_JCC_propertyStart = "password=";
    private static final Pattern jdbcURLPassword_JCC_Pat;
    private static final String jdbcURLPassword_JCC_replacement = "password=*****;";
    private static final Pattern jdbcURLPassword_oracle_Pat;
    private static final int minimumDb2ZosMajorVersionForSelectFromUDMSupport_ = 9;
    private static final int minimumDb2ZosMinorVersionForSelectFromUDMSupport_ = 1;
    private static final String minimumDb2ZosVersionForSelectFromUDMSupport = "V9.1";
    private static final int minimumDB2iSeriesMajorVersionForSelectFromInsertSupport_ = 6;
    private static final int minimumDB2iSeriesMinorVersionForSelectFromInsertSupport_ = 1;
    private static final String minimumDB2iSeriesVersionForSelectFromInsertSupport_ = "V6R1";
    private static final BigInteger zeroBigInteger__;
    private static final BigDecimal zeroBigDecimal__;

    public static String getSqlLiteralSubstitutionString(short s2) {
        switch (s2) {
            case 21: {
                return "NOT_SET";
            }
            case 22: {
                return "ENABLE";
            }
            case 23: {
                return "DISABLE";
            }
            case 24: {
                return "ENABLE_WITH_PARAMETERS";
            }
        }
        return "NOT_SET";
    }

    public static boolean isStatementOfType(String string, SqlStatementType ... sqlStatementTypeArray) {
        string = EscapeLexer.filterComments(string, false);
        block7: for (SqlStatementType sqlStatementType : sqlStatementTypeArray) {
            switch (sqlStatementType) {
                case SET: {
                    if (!setPat.matcher(string).find()) continue block7;
                    return true;
                }
                case UPDATE: {
                    if (!UPDATEPat.matcher(string).find()) continue block7;
                    return true;
                }
                case DELETE: {
                    if (!DELETEPat.matcher(string).find()) continue block7;
                    return true;
                }
                case QUERY: {
                    if (SELECTPat.matcher(string).find()) {
                        return true;
                    }
                    if (!WITHPat.matcher(string).find()) continue block7;
                    return true;
                }
                case XQUERY: {
                    if (!XQUERYPat.matcher(string).find()) continue block7;
                    return true;
                }
                default: {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{sqlStatementType}), null, 11271);
                }
            }
        }
        return false;
    }

    public static String getNameOfLiteralSubstitutionGenericType(int n2) {
        switch (n2) {
            case 33: {
                return "INTEGER";
            }
            case 34: {
                return "DECIMAL";
            }
            case 35: {
                return "DECFLOAT";
            }
            case 36: {
                return "FLOAT";
            }
            case 37: {
                return "DATE";
            }
            case 38: {
                return "TIME";
            }
            case 39: {
                return "TIMESTAMP";
            }
            case 40: {
                return "VARCHAR";
            }
            case 41: {
                return "NULL";
            }
            case 42: {
                return "unnamedParameterMarker";
            }
        }
        return Integer.toString(n2);
    }

    public static String convertSpecialRegisterSetValueToBindOptionValue_PRECISION(String string, StringBuilder stringBuilder) {
        String string2 = string;
        Matcher matcher = currentPrecisionIncludesNoScalePat.matcher(string);
        if (matcher.matches()) {
            string2 = matcher.group(1);
        } else {
            matcher = currentPrecisionIncludesScalePat.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(1);
                stringBuilder.append(matcher.group(2));
            }
        }
        return string2;
    }

    public static String convertSpecialRegisterSetValueToBindOptionValue_DECFLOATROUNDING(String string) {
        String string2 = specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING.get(string);
        if (null == string2) {
            string2 = string;
        }
        return string2;
    }

    public static String maskJdbcURLPasswords(String string) {
        Matcher matcher;
        if (null == string || 0 == string.length()) {
            return string;
        }
        Matcher matcher2 = jdbcURLPassword_JCC_Pat.matcher(string);
        if (matcher2.find()) {
            string = matcher2.replaceAll(jdbcURLPassword_JCC_replacement);
        }
        if ((matcher = jdbcURLPassword_oracle_Pat.matcher(string)).find()) {
            StringBuffer stringBuffer = new StringBuffer();
            matcher.reset();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, matcher.group(1) + passwordReplacement + matcher.group(2));
            }
            matcher.appendTail(stringBuffer);
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String maskJdbcURLPasswords(Properties properties) {
        if (null == properties) {
            return null;
        }
        return StaticProfileConstants.maskJdbcURLPasswords(properties.toString());
    }

    public static boolean isValueSet(String string) {
        return null != string && 0 < string.length() && !whiteSpacePat.matcher(string).matches();
    }

    public static boolean isCandidateForStaticMRI_configureTimeCheck(String string, boolean bl2) {
        return !bl2 && null != string && string.equals("MULTI_ROW_PARAMETERS");
    }

    public static boolean isCandidateForStaticMRI_staticRuntimeCheck(DBInfo dBInfo, boolean bl2, ProfileSection profileSection, boolean bl3) {
        return bl2 && dBInfo.supportsMRI_ && StaticProfileConstants.isCandidateForStaticMRI_configureTimeCheck(profileSection.getStmtParameterType(), bl3);
    }

    public static boolean isSectionReservedForMRI(ConnectionExecutionHandler connectionExecutionHandler, ProfileSection profileSection) {
        boolean bl2 = StaticProfileConstants.isStaticAtomicIfMRI(connectionExecutionHandler, profileSection);
        return bl2 && 0 < profileSection.getAtomicMRISection() || !bl2 && 0 < profileSection.getNonAtomicMRISection();
    }

    public static boolean attemptStaticMRIForStatement(ConnectionExecutionHandler connectionExecutionHandler, DBInfo dBInfo, boolean bl2, ProfileSection profileSection, boolean bl3) {
        return StaticProfileConstants.isCandidateForStaticMRI_staticRuntimeCheck(dBInfo, bl2, profileSection, bl3) && StaticProfileConstants.isSectionReservedForMRI(connectionExecutionHandler, profileSection);
    }

    public static boolean isStaticAtomicIfMRI(ConnectionExecutionHandler connectionExecutionHandler, ProfileSection profileSection) {
        return connectionExecutionHandler.isAtomicMRIPropertySetToYES() && null != profileSection && profileSection.isInsert();
    }

    public static boolean isDatabaseProductLevelGreaterThanOrEqualTo(DBInfo dBInfo, int n2, int n3, Character c10) {
        if (null == dBInfo) {
            dBInfo = DBInfo.dummyDBInfo_;
        }
        if (dBInfo.normalizedNFMDatabaseMajorVersion_ > n2) {
            return true;
        }
        if (dBInfo.normalizedNFMDatabaseMajorVersion_ == n2) {
            if (dBInfo.normalizedNFMDatabaseMinorVersion_ > n3) {
                return true;
            }
            if (dBInfo.normalizedNFMDatabaseMinorVersion_ == n3) {
                if (null == c10) {
                    return true;
                }
                Character c11 = dBInfo.normalizedNFMDatabaseModificationLevel_;
                if (null == c11) {
                    c11 = Character.valueOf('0');
                }
                if (c11.charValue() >= c10.charValue()) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isDatabaseProductLevelLessThan(DBInfo dBInfo, int n2, int n3, Character c10) {
        if (null == dBInfo) {
            dBInfo = DBInfo.dummyDBInfo_;
        }
        if (dBInfo.normalizedNFMDatabaseMajorVersion_ < n2) {
            return true;
        }
        if (dBInfo.normalizedNFMDatabaseMajorVersion_ == n2) {
            if (dBInfo.normalizedNFMDatabaseMinorVersion_ < n3) {
                return true;
            }
            if (dBInfo.normalizedNFMDatabaseMinorVersion_ == n3) {
                if (null == c10) {
                    return true;
                }
                Character c11 = dBInfo.normalizedNFMDatabaseModificationLevel_;
                if (null == c11) {
                    c11 = Character.valueOf('0');
                }
                if (c11.charValue() < c10.charValue()) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean areAutoGeneratedKeysRequested(String[] stringArray, int[] nArray, int n2) {
        return null != stringArray || null != nArray || StaticProfileConstants.isJDBCMethodWithAGKIndicatorParameterUsed(n2) && 2 != n2;
    }

    public static boolean areAutoGeneratedKeysRequested(Element element) {
        int n2;
        Object object;
        Element element2 = (Element)element.getElementsByTagName("autoGeneratedColumnNames").item(0);
        Element element3 = (Element)element.getElementsByTagName("autoGeneratedColumnIndexes").item(0);
        String[] stringArray = null;
        if (element2 != null && element2.hasChildNodes()) {
            object = element2.getElementsByTagName("columnName");
            stringArray = new String[object.getLength()];
            for (n2 = 0; n2 < object.getLength(); ++n2) {
                stringArray[n2] = object.item(n2).getTextContent();
            }
        }
        object = null;
        if (element3 != null && element3.hasChildNodes()) {
            NodeList nodeList = element3.getElementsByTagName("columnIndex");
            object = new int[nodeList.getLength()];
            for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
                object[i10] = Integer.parseInt(nodeList.item(i10).getTextContent());
            }
        }
        n2 = StaticProfileConstants.getAGKColumnIndicator(element);
        return StaticProfileConstants.areAutoGeneratedKeysRequested(stringArray, (int[])object, n2);
    }

    public static boolean isAutoGeneratedKeysJDBCMethodUsed(String[] stringArray, int[] nArray, int n2) {
        return StaticProfileConstants.areAutoGeneratedKeysRequested(stringArray, nArray, n2) || StaticProfileConstants.isJDBCMethodWithAGKIndicatorParameterUsed(n2);
    }

    public static boolean isAutoGeneratedKeysJDBCMethodUsed(Element element) {
        if (StaticProfileConstants.areAutoGeneratedKeysRequested(element)) {
            return true;
        }
        return StaticProfileConstants.isJDBCMethodWithAGKIndicatorParameterUsed(StaticProfileConstants.getAGKColumnIndicator(element));
    }

    private static int getAGKColumnIndicator(Element element) {
        String string;
        Element element2 = (Element)element.getElementsByTagName("autoGeneratedcolumnIndicator").item(0);
        int n2 = 0;
        if (element2 != null && !(string = element2.getTextContent()).equals("")) {
            n2 = StaticProfileCaptureHelper.getAutoGenColIndicator(string);
        }
        return n2;
    }

    private static boolean isJDBCMethodWithAGKIndicatorParameterUsed(int n2) {
        return 0 != n2;
    }

    public static boolean userSQLIsNestedInASELECTForAGKs(String string, int n2) {
        boolean bl2 = null != string && StaticProfileConstants.isValueSet(string);
        return bl2 && (1 == n2 || -1 == n2);
    }

    public static boolean userSQLIsNestedInASELECTForAGKs(Element element) {
        Element element2;
        String string = XmlFileHelper.getProcessedSql(element);
        int n2 = 0;
        NodeList nodeList = element.getElementsByTagName("autoGeneratedcolumnIndicator");
        if (null != nodeList && 0 < nodeList.getLength() && null != (element2 = (Element)nodeList.item(0))) {
            Integer n3 = XmlFileHelper.getAttributeValueInteger(element, "id", false, null);
            n2 = XmlFileHelper.getElementTextValueInteger(element2, n3, 0);
        }
        return StaticProfileConstants.userSQLIsNestedInASELECTForAGKs(string, n2);
    }

    public static String canSQLExecuteStatically(DBInfo dBInfo, String string, String string2, SqlStatementType sqlStatementType, boolean bl2, boolean bl3, String string3) {
        boolean bl4 = false;
        if (null == dBInfo) {
            dBInfo = DBInfo.dummyDBInfo_;
            bl4 = true;
        }
        if (bl3 && bl2) {
            if (DatabaseType.DB2forZOS == dBInfo.databaseType_) {
                if (SqlStatementType.INSERT != sqlStatementType && !StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(dBInfo, 9, 1, Character.valueOf('0'))) {
                    return Messages.getText("MSG_STMT_NOT_STATIC_BECAUSE_OLD_DB2", new Object[]{string, string2, "IBM DB2 for z/OS", dBInfo.databaseProductVersion_, sqlStatementType, minimumDb2ZosVersionForSelectFromUDMSupport, string3});
                }
                return null;
            }
            if (DatabaseType.DB2forLUW == dBInfo.databaseType_) {
                if (SqlStatementType.MERGE == sqlStatementType) {
                    return Messages.getText("MSG_STMT_NOT_STATIC_BECAUSE_WRONG_DB2", new Object[]{string, string2, "IBM DB2 Database for Linux, UNIX, and Windows", dBInfo.databaseProductVersion_, sqlStatementType, string3});
                }
                return null;
            }
            if (DatabaseType.DB2forIBMi == dBInfo.databaseType_) {
                if (SqlStatementType.INSERT == sqlStatementType && !StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(dBInfo, 6, 1, Character.valueOf('0'))) {
                    return Messages.getText("MSG_STMT_NOT_STATIC_BECAUSE_OLD_DB2", new Object[]{string, string2, "IBM DB2 for IBM i", dBInfo.databaseProductVersion_, sqlStatementType, minimumDB2iSeriesVersionForSelectFromInsertSupport_, string3});
                }
                return Messages.getText("MSG_STMT_NOT_STATIC_BECAUSE_WRONG_DB2", new Object[]{string, string2, "IBM DB2 for IBM i", dBInfo.databaseProductVersion_, sqlStatementType, string3});
            }
            DBInfo dBInfo2 = bl4 ? null : dBInfo;
            return Messages.getText("ERR_INVALID_SWITCH_CASE", dBInfo2) + "  " + Messages.getText("MSG_STMT_NOT_STATIC_BECAUSE_WRONG_DB2", new Object[]{string, string2, dBInfo.databaseProductName_, dBInfo.databaseProductVersion_, sqlStatementType, string3});
        }
        return null;
    }

    public static <T extends Number> T readStringAsNumber(String string, Class<? extends Number> clazz, boolean bl2) throws NumberFormatException {
        if (BigInteger.class == clazz) {
            BigInteger bigInteger = new BigInteger(string);
            if (!bl2 && bigInteger.compareTo(zeroBigInteger__) < 0) {
                bigInteger = zeroBigInteger__;
            }
            return (T)bigInteger;
        }
        if (Integer.class == clazz) {
            BigInteger bigInteger = new BigInteger(string);
            int n2 = StaticProfileConstants.toInt(bigInteger);
            if (!bl2 && 0 > n2) {
                n2 = 0;
            }
            return (T)new Integer(n2);
        }
        if (Long.class == clazz) {
            BigInteger bigInteger = new BigInteger(string);
            long l8 = StaticProfileConstants.toLong(bigInteger);
            if (!bl2 && 0L > l8) {
                l8 = 0L;
            }
            return (T)new Long(l8);
        }
        if (BigDecimal.class == clazz) {
            BigDecimal bigDecimal = new BigDecimal(string);
            if (!bl2 && bigDecimal.compareTo(zeroBigDecimal__) < 0) {
                bigDecimal = zeroBigDecimal__;
            }
            return (T)bigDecimal;
        }
        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnlyNoLogging(Messages.getText("ERR_INVALID_SWITCH_CASE", clazz.getCanonicalName()), null, 11196);
    }

    public static int toInt(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            return Integer.MAX_VALUE;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            return Integer.MIN_VALUE;
        }
        return bigInteger.intValue();
    }

    public static long toLong(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            return Long.MAX_VALUE;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            return Long.MIN_VALUE;
        }
        return bigInteger.longValue();
    }

    public static String getIsolationLevelAsString(int n2, boolean bl2) {
        switch (n2) {
            case 0: {
                return "java.sql.Connection.TRANSACTION_NONE";
            }
            case 2: {
                return "java.sql.Connection.TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "java.sql.Connection.TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "java.sql.Connection.TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "java.sql.Connection.TRANSACTION_SERIALIZABLE";
            }
            case -1: {
                if (!bl2) break;
                return "com.ibm.db2.jcc.DB2Connection.TRANSACTION_IDS_CURSOR_STABILITY";
            }
            case -2: {
                if (!bl2) break;
                return "com.ibm.db2.jcc.DB2Connection.TRANSACTION_IDS_LAST_COMMITTED";
            }
        }
        return Integer.toString(n2);
    }

    static {
        specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING.put("ROUND_CEILING", "CEILING");
        specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING.put("ROUND_DOWN", "DOWN");
        specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING.put("ROUND_FLOOR", "FLOOR");
        specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING.put("ROUND_HALF_DOWN", "HALFDOWN");
        specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING.put("ROUND_HALF_EVEN", "HALFEVEN");
        specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING.put("ROUND_HALF_UP", "HALFUP");
        specialRegisterValueToBindOptionValueMap_DEFLOATROUNDING.put("ROUND_UP", "UP");
        specialRegisterVectorSingleRegisterPat = Pattern.compile("([\\w\\s]+):\\s+([^|]+)");
        specialRegisterVectorFullPat = Pattern.compile("^" + specialRegisterVectorSingleRegisterPat.toString() + "(?:\\|" + specialRegisterVectorSingleRegisterPat.toString() + ")+");
        selectIdentityValLocalPat = Pattern.compile("^\\s*select\\s+IDENTITY_VAL_LOCAL\\s*\\(\\)\\s+from\\s+SYSIBM.SYSDUMMY1\\s*$", 2);
        jdbcURLPassword_JCC_Pat = Pattern.compile("password=[^;]*;");
        jdbcURLPassword_oracle_Pat = Pattern.compile("(jdbc:oracle[^@]*?/)[^@/]*?(@)");
        zeroBigInteger__ = new BigInteger("0");
        zeroBigDecimal__ = new BigDecimal(0);
    }

    public static class DBInfo {
        public final String databaseProductName_;
        public final String databaseProductVersion_;
        public int normalizedNFMDatabaseMajorVersion_;
        public int normalizedNFMDatabaseMinorVersion_;
        public Character normalizedNFMDatabaseModificationLevel_;
        public final DatabaseType databaseType_;
        public final String databaseTypeDisplayName_;
        public final boolean supportsDecFloat_;
        public final boolean supportsBigInt_;
        public final boolean supportsTimestampPrecisionGreaterThan6_;
        public final boolean supportsSpecialRegisterPRECISION_;
        public final boolean supportsTimestampWithTimeZone_;
        public final boolean supportsMRI_;
        public static final DBInfo dummyDBInfo_ = new DBInfo(null, null, 0, 0);

        public DBInfo(DatabaseMetaData databaseMetaData) throws SQLException {
            this(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDatabaseMajorVersion(), databaseMetaData.getDatabaseMinorVersion());
        }

        public DBInfo(String string, String string2, int n2, int n3) {
            int n4;
            this.databaseProductName_ = string;
            this.databaseProductVersion_ = string2;
            this.normalizedNFMDatabaseMajorVersion_ = n2;
            this.normalizedNFMDatabaseMinorVersion_ = n3;
            if (null == this.databaseProductName_) {
                this.databaseType_ = DatabaseType.Other;
                this.databaseTypeDisplayName_ = "unknown";
            } else if (this.databaseProductName_.startsWith("DB2")) {
                if (null == this.databaseProductVersion_) {
                    this.databaseType_ = DatabaseType.Other;
                    this.databaseTypeDisplayName_ = "DB2 - unknown version";
                } else if (this.databaseProductVersion_.startsWith(StaticProfileConstants.databaseProductVersion_db2ForZosStart)) {
                    this.databaseType_ = DatabaseType.DB2forZOS;
                    this.databaseTypeDisplayName_ = "IBM DB2 for z/OS";
                } else if (this.databaseProductVersion_.startsWith(StaticProfileConstants.databaseProductVersion_db2ForLUWStart)) {
                    this.databaseType_ = DatabaseType.DB2forLUW;
                    this.databaseTypeDisplayName_ = "IBM DB2 Database for Linux, UNIX, and Windows";
                } else {
                    this.databaseType_ = DatabaseType.Other;
                    this.databaseTypeDisplayName_ = "DB2 - unknown version";
                }
            } else if (this.databaseProductName_.equals(StaticProfileConstants.databaseProductName_db2ForSystemi)) {
                if (null != this.databaseProductVersion_ && this.databaseProductVersion_.startsWith(StaticProfileConstants.databaseProductVersion_db2ForSystemiStart)) {
                    this.databaseType_ = DatabaseType.DB2forIBMi;
                    this.databaseTypeDisplayName_ = "IBM DB2 for IBM i";
                } else {
                    this.databaseType_ = DatabaseType.Other;
                    this.databaseTypeDisplayName_ = "DB2 for iSerias - unknown version";
                }
            } else if (string.toLowerCase().contains("oracle")) {
                this.databaseType_ = DatabaseType.Oracle;
                this.databaseTypeDisplayName_ = "Oracle";
            } else if (string.startsWith("INFORMIX") || string.startsWith("IDS")) {
                this.databaseType_ = DatabaseType.Informix;
                this.databaseTypeDisplayName_ = "Informix Dynamic Server";
            } else if (string.contains("DERBY")) {
                this.databaseType_ = DatabaseType.Derby;
                this.databaseTypeDisplayName_ = "Derby";
            } else {
                this.databaseType_ = DatabaseType.Other;
                this.databaseTypeDisplayName_ = "unknown";
            }
            this.normalizedNFMDatabaseModificationLevel_ = !this.databaseType_.isDB2() ? null : (null == this.databaseProductVersion_ || 8 > this.databaseProductVersion_.length() ? null : Character.valueOf(this.databaseProductVersion_.charAt(7)));
            if (null != this.normalizedNFMDatabaseModificationLevel_ && null != this.databaseProductVersion_ && this.databaseProductVersion_.startsWith(StaticProfileConstants.databaseProductVersion_db2ForZosStart) && (n4 = Integer.valueOf(String.valueOf(this.normalizedNFMDatabaseModificationLevel_)).intValue()) < 5) {
                if (this.normalizedNFMDatabaseMajorVersion_ == 11) {
                    this.normalizedNFMDatabaseMajorVersion_ = 10;
                    this.normalizedNFMDatabaseMinorVersion_ = 1;
                    this.normalizedNFMDatabaseModificationLevel_ = Character.valueOf('5');
                } else if (this.normalizedNFMDatabaseMajorVersion_ == 10) {
                    if (n4 == 2 || n4 == 3) {
                        this.normalizedNFMDatabaseMajorVersion_ = 9;
                        this.normalizedNFMDatabaseMinorVersion_ = 1;
                        this.normalizedNFMDatabaseModificationLevel_ = Character.valueOf('5');
                    } else if (n4 == 0 || n4 == 1) {
                        this.normalizedNFMDatabaseMajorVersion_ = 8;
                        this.normalizedNFMDatabaseMinorVersion_ = 1;
                        this.normalizedNFMDatabaseModificationLevel_ = Character.valueOf('5');
                    }
                } else if (this.normalizedNFMDatabaseMajorVersion_ == 9) {
                    this.normalizedNFMDatabaseMajorVersion_ = 8;
                    this.normalizedNFMDatabaseMinorVersion_ = 1;
                    this.normalizedNFMDatabaseModificationLevel_ = Character.valueOf('5');
                }
            }
            switch (this.databaseType_) {
                case DB2forZOS: {
                    this.supportsDecFloat_ = this.supportsBigInt_ = StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this, 9, 1, Character.valueOf('5'));
                    this.supportsTimestampPrecisionGreaterThan6_ = this.supportsTimestampWithTimeZone_ = StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this, 10, 1, Character.valueOf('5'));
                    this.supportsSpecialRegisterPRECISION_ = true;
                    this.supportsMRI_ = StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this, 8, 1, Character.valueOf('5'));
                    break;
                }
                case DB2forLUW: {
                    this.supportsDecFloat_ = StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this, 9, 5, Character.valueOf('0'));
                    this.supportsBigInt_ = StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this, 8, 1, Character.valueOf('0'));
                    this.supportsTimestampPrecisionGreaterThan6_ = StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this, 9, 7, Character.valueOf('0'));
                    this.supportsSpecialRegisterPRECISION_ = false;
                    this.supportsTimestampWithTimeZone_ = false;
                    this.supportsMRI_ = false;
                    break;
                }
                case DB2forIBMi: {
                    this.supportsDecFloat_ = StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this, 6, 1, Character.valueOf('0'));
                    this.supportsBigInt_ = StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this, 5, 2, Character.valueOf('0'));
                    this.supportsTimestampPrecisionGreaterThan6_ = false;
                    this.supportsSpecialRegisterPRECISION_ = false;
                    this.supportsTimestampWithTimeZone_ = false;
                    this.supportsMRI_ = false;
                    break;
                }
                default: {
                    this.supportsDecFloat_ = false;
                    this.supportsBigInt_ = false;
                    this.supportsTimestampPrecisionGreaterThan6_ = false;
                    this.supportsSpecialRegisterPRECISION_ = false;
                    this.supportsTimestampWithTimeZone_ = false;
                    this.supportsMRI_ = false;
                }
            }
        }
    }

    public static enum DatabaseType {
        DB2forZOS,
        DB2forLUW,
        DB2forIBMi,
        Derby,
        Informix,
        Oracle,
        Other;


        public boolean isDB2() {
            switch (this) {
                case DB2forZOS: 
                case DB2forLUW: 
                case DB2forIBMi: {
                    return true;
                }
            }
            return false;
        }
    }
}

