/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigFileMonitorTask
extends TimerTask {
    private long lastFileModificationTime_ = -1L;
    private File configFile_;
    private long oldTracePollingInterval_;

    public ConfigFileMonitorTask(String string, long l8) throws URISyntaxException {
        this.oldTracePollingInterval_ = l8;
        this.configFile_ = string.startsWith("file:") ? new File(new URI(string)) : new File(string);
        this.lastFileModificationTime_ = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(ConfigFileMonitorTask.this.configFile_.lastModified());
            }
        });
        if (this.lastFileModificationTime_ == 0L) {
            throw new URISyntaxException(string, "Unable to obtain file mod time for file URI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long l8 = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(ConfigFileMonitorTask.this.configFile_.lastModified());
                }
            });
            if (!DataProperties.isDataPropertiesInitialized()) {
                return;
            }
            if (this.lastFileModificationTime_ == l8) {
                return;
            }
            if (this.lastFileModificationTime_ != l8) {
                long l9;
                Object object;
                Log.getGlobalLogger().info("Detected change to CMX runtime config file (pdq.properties)");
                this.lastFileModificationTime_ = l8;
                Properties properties = DataProperties.cloneProperties();
                Properties properties2 = DataProperties.getPolledPropertiesFromFile(this.configFile_);
                DataProperties.mergeDynamicProperties(properties2);
                if (DataProperties.isDataPropertiesInitialized()) {
                    object = Log.initializeLock__;
                    synchronized (object) {
                        Log.configureLogger(false, true, properties);
                    }
                }
                Log.getGlobalLogger().info("CMX runtime logger has been reconfigured");
                object = DataProperties.getProperty("pdq.enableTracePolling");
                if (!((String)object).trim().equals("ON")) {
                    this.cancel();
                    DataProperties.traceTimer_.purge();
                    return;
                }
                String string = DataProperties.getProperty("pdq.tracePollingInterval");
                long l10 = l9 = Long.valueOf("30").longValue();
                try {
                    l10 = string == null ? l9 : Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    l10 = l9;
                }
                if (l10 <= 0L) {
                    l10 = l9;
                }
                if (l10 != this.oldTracePollingInterval_) {
                    try {
                        DataProperties.traceTimer_.schedule((TimerTask)this, l10 * 1000L, l10 * 1000L);
                        this.oldTracePollingInterval_ = l10;
                    }
                    catch (Exception exception) {
                        Logger logger = Log.getGlobalLogger();
                        if (logger == null) {
                            exception.printStackTrace();
                        }
                        logger.logp(Level.WARNING, "ConfigFileMonitorTask", "run", "Unable to reschedule the config file polling interval for trace", exception);
                    }
                }
            }
            DataLogger.logRuntimeMemoryUsage(Log.getGlobalLogger());
        }
        catch (Exception exception) {
            Logger logger = Log.getGlobalLogger();
            if (logger == null) {
                exception.printStackTrace();
            }
            logger.logp(Level.WARNING, "ConfigFileMonitorTask", "run", "Unable to poll property file", exception);
        }
    }
}

