/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStore;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.MDOutputStream;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.manager.ConnectionManager;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryDataFactory;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.sql.AsyncRefreshMaintenance;
import com.ibm.db2.cmx.runtime.internal.repository.sql.MetadataGroupDataActiveRefresh;
import com.ibm.db2.cmx.runtime.internal.repository.sql.db2.DB2AsyncRefreshMaintenance;
import com.ibm.db2.cmx.runtime.internal.repository.sql.generic.GenericAsyncRefreshMaintenance;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.tools.DataVersion;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import com.ibm.db2.jcc.DB2Connection;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.naming.InitialContext;

public class CentralStoreKey {
    private CentralStoreKeyType keyType_ = null;
    private String propertiesGroupId_ = null;
    private String repositorySchema_ = null;
    private String fileName_ = null;
    private String dsName_ = null;
    private String url_ = null;
    private String urlWithPasswordMasked_ = null;
    private String recordKeyPart2_ = null;
    private String keyExtension_ = "";
    private boolean isVariableKey_ = false;
    private boolean variableKeyProcessed_ = false;
    private boolean hasExtension_ = false;
    private CentralStore.CentralStoreFlags centralStoreFlags_ = null;
    private SQLException exceptionChain_ = null;
    private File tempFile_ = null;
    private long propertiesLastModifiedTime_ = 0L;
    private long inputXmlLastModifiedTime_ = 0L;
    private long outputXmlLastModifiedTime_ = 0L;
    private String xmlExtensionFound_ = null;
    private boolean inputRecordsExistanceChecked_ = false;
    private boolean outputRecordsExistanceChecked_ = false;
    private boolean propertiesExistsForRead_ = false;
    private boolean propertiesExistsForWrite_ = false;
    private boolean inputXmlExistsForRead_ = false;
    private boolean outputXmlExistsForRead_ = false;
    private boolean inputXmlExistsForWrite_ = false;
    private boolean outputXmlExistsForWrite_ = false;
    private long inputXmlLength_ = 0L;
    private long outputXmlLength_ = 0L;
    private int repositoryFileInfoKey_ = 0;
    private InputStream tempInputStreamHold_ = null;
    private boolean modified_ = false;
    private Connection con_ = null;
    private long lastCheckedTime_ = 0L;
    private long propertiesRefreshIntervalInMillis_ = 0L;
    private long propertiesRefreshIntervalInMinutes_ = 0L;
    private CentralStoreKey xmlKey_ = null;
    private MDOutputStream tempMDOutputStream_ = null;
    private ConnectionExecutionHandler.CachedResolvedStates resovedStatesBeforeRedirect_ = null;
    private WeakReference<ClassLoader> appClassLoader_ = null;
    private int cachedHashCode_ = 0;
    private String groupVersion_ = null;
    private boolean deepCompare_ = true;
    private boolean compareForSameDBMSRepository_ = false;
    private boolean dataProperties_ = false;
    private ConnectionExecutionHandler repositoryConnectionExecutionHandler_ = null;
    private CachedConnectionInfo cachedConnectionInfo_ = null;
    private boolean havePropertiesBeenLoaded_ = false;
    private final DataProperties.SourceInfoForNonGlobalProperties sourceInfoForNonGlobalProperties_;
    private Properties actualLoadedProps_ = null;
    private RepositoryVersion repositoryVersion_ = null;
    private ConnectionManager.ConnectionInfo repositoryConnecticnInfo_ = new ConnectionManager.ConnectionInfo();
    private int compareToRV_2_2_7_ = -1;
    private Integer repositoryAsyncRefreshTrack_ = null;
    private Long UUID_mostSignificantBits_ = null;
    private Long UUID_leastSignificantBits_ = null;
    private String moduleAppName_;

    private CentralStoreKey() {
        this.sourceInfoForNonGlobalProperties_ = null;
    }

    protected CentralStoreKey(String string, String string2, String string3, boolean bl2, boolean bl3, String string4, CentralStoreKeyType centralStoreKeyType, String string5, String string6, CentralStore.CentralStoreFlags centralStoreFlags, SQLException sQLException, boolean bl4, File file, long l8, long l9, long l10, String string7, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, long l11, long l12, CentralStoreKey centralStoreKey, ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates, long l13, String string8, boolean bl14, boolean bl15, WeakReference<ClassLoader> weakReference, CachedConnectionInfo cachedConnectionInfo, long l14, long l15, DataProperties.SourceInfoForNonGlobalProperties sourceInfoForNonGlobalProperties, boolean bl16, RepositoryVersion repositoryVersion, ConnectionManager.ConnectionInfo connectionInfo, Integer n2, int n3, Long l16, Long l17, String string9, String string10) {
        this.dsName_ = string;
        this.fileName_ = string2;
        this.setUrl(string3);
        this.hasExtension_ = bl2;
        this.isVariableKey_ = bl3;
        this.keyExtension_ = string4;
        this.keyType_ = centralStoreKeyType;
        this.propertiesGroupId_ = string5;
        this.repositorySchema_ = string9;
        this.recordKeyPart2_ = string6;
        this.centralStoreFlags_ = centralStoreFlags;
        this.exceptionChain_ = sQLException;
        this.variableKeyProcessed_ = bl4;
        this.tempFile_ = file;
        this.propertiesLastModifiedTime_ = l8;
        this.inputXmlLastModifiedTime_ = l9;
        this.outputXmlLastModifiedTime_ = l10;
        this.xmlExtensionFound_ = string7;
        this.inputRecordsExistanceChecked_ = bl5;
        this.outputRecordsExistanceChecked_ = bl6;
        this.propertiesExistsForRead_ = bl7;
        this.propertiesExistsForWrite_ = bl8;
        this.inputXmlExistsForRead_ = bl9;
        this.outputXmlExistsForRead_ = bl10;
        this.inputXmlExistsForWrite_ = bl11;
        this.outputXmlExistsForWrite_ = bl12;
        this.modified_ = bl13;
        this.lastCheckedTime_ = l11;
        this.propertiesRefreshIntervalInMillis_ = l12;
        this.xmlKey_ = centralStoreKey;
        this.resovedStatesBeforeRedirect_ = cachedResolvedStates;
        this.propertiesRefreshIntervalInMinutes_ = l13;
        this.groupVersion_ = string8;
        this.deepCompare_ = bl14;
        this.dataProperties_ = bl15;
        this.appClassLoader_ = weakReference;
        this.cachedConnectionInfo_ = cachedConnectionInfo;
        this.inputXmlLength_ = l14;
        this.outputXmlLength_ = l15;
        this.sourceInfoForNonGlobalProperties_ = sourceInfoForNonGlobalProperties;
        this.havePropertiesBeenLoaded_ = bl16;
        this.repositoryVersion_ = repositoryVersion;
        this.repositoryConnecticnInfo_ = connectionInfo;
        this.repositoryAsyncRefreshTrack_ = n2;
        this.compareToRV_2_2_7_ = n3;
        this.UUID_mostSignificantBits_ = l16;
        this.UUID_leastSignificantBits_ = l17;
        this.moduleAppName_ = string10;
        if (DataProperties.isDataPropertiesInitialized() && CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
            CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, created key: ", DataLogger.getShortName(this), 5);
        }
    }

    public CentralStoreKey(String string, String string2, boolean bl2, DataProperties.SourceInfoForNonGlobalProperties sourceInfoForNonGlobalProperties) throws SQLException {
        this(string, string2, null, bl2, sourceInfoForNonGlobalProperties);
    }

    public CentralStoreKey(String string, String string2, String string3, boolean bl2, DataProperties.SourceInfoForNonGlobalProperties sourceInfoForNonGlobalProperties) throws SQLException {
        this.sourceInfoForNonGlobalProperties_ = sourceInfoForNonGlobalProperties;
        this.repositorySchema_ = string3;
        this.parseKeyString(string, string2, bl2);
        this.setApplicationName();
        if (DataProperties.isDataPropertiesInitialized() && CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
            CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, created key: ", DataLogger.getShortName(this), 5);
        }
    }

    public CentralStoreKeyType getKeyType() {
        return this.keyType_;
    }

    public String getKeyPart1() {
        return this.propertiesGroupId_;
    }

    public String getKeyPart2() {
        if (this.isVariableKey_) {
            if (this.recordKeyPart2_ == null) {
                return "$X";
            }
            return this.recordKeyPart2_;
        }
        return "";
    }

    public String getKeyExtension() {
        return this.keyExtension_;
    }

    public boolean isVariableKey() {
        return this.isVariableKey_;
    }

    public boolean hasExtension() {
        return this.hasExtension_;
    }

    protected void setKeyType(CentralStoreKeyType centralStoreKeyType) {
        this.cachedHashCode_ = 0;
        this.keyType_ = centralStoreKeyType;
    }

    protected void setPropertiesGroupId(String string) {
        this.cachedHashCode_ = 0;
        this.propertiesGroupId_ = string;
    }

    public void setRepositorySchema(String string) {
        this.cachedHashCode_ = 0;
        this.repositorySchema_ = string;
    }

    protected void setRecordKeyPart2(String string) {
        this.cachedHashCode_ = 0;
        this.recordKeyPart2_ = string;
    }

    protected void setKeyExtension(String string) {
        this.cachedHashCode_ = 0;
        this.keyExtension_ = string;
        this.hasExtension_ = true;
        if (string == null) {
            this.hasExtension_ = false;
            return;
        }
        if (string.equals("")) {
            this.hasExtension_ = false;
            this.keyExtension_ = null;
        }
    }

    public CentralStore.CentralStoreFlags getCentralStoreFlags() {
        return this.centralStoreFlags_;
    }

    protected void setCentralStoreFlags(CentralStore.CentralStoreFlags centralStoreFlags) {
        if (CentralStore.CentralStoreFlags.FETCH_PROPERTIES == centralStoreFlags || CentralStore.CentralStoreFlags.FETCH_PROPERTIES_XML_FILE == centralStoreFlags) {
            this.havePropertiesBeenLoaded_ = true;
        }
        this.centralStoreFlags_ = centralStoreFlags;
    }

    private void parseKeyString(String string, String string2, boolean bl2) throws SQLException {
        string.trim();
        int n2 = string.indexOf("//");
        int n3 = string.length();
        int n4 = n3 >= 5 ? 5 : n3;
        String string3 = string.substring(0, n4).toLowerCase();
        n2 = string.indexOf("//");
        if (string3.startsWith("ds:")) {
            if (string2 == null || string2.equals("")) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_CS_INV_URL", "pdq.propertiesGroupId", string2, string, "ds:") + (bl2 ? DataProperties.getMessageDescribingPropertyLocations(null, this.sourceInfoForNonGlobalProperties_, false, "  ") : ""), null, null, 10879);
            }
            if (n2 == -1) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_CS_INV_URL2", string) + (bl2 ? DataProperties.getMessageDescribingPropertyLocations(null, this.sourceInfoForNonGlobalProperties_, false, "  ") : ""), null, null, 10880);
            }
            this.dsName_ = string.substring(n2 + 2, n3);
            this.propertiesGroupId_ = string2;
            this.keyType_ = CentralStoreKeyType.DATASOURCE;
        } else if (string3.equals("file:")) {
            if (string2 != null && (string2.equals("") || string2.equals("*"))) {
                string2 = null;
            }
            if (string2 != null) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_CS_INV_URL", "pdq.propertiesGroupId", string2, string, "file:") + (bl2 ? DataProperties.getMessageDescribingPropertyLocations(null, this.sourceInfoForNonGlobalProperties_, false, "  ") : ""), null, null, 10881);
            }
            if (n2 != 5) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_CS_INV_URL2", string) + (bl2 ? DataProperties.getMessageDescribingPropertyLocations(null, this.sourceInfoForNonGlobalProperties_, false, "  ") : ""), null, null, 10882);
            }
            this.fileName_ = this.propertiesGroupId_ = string.substring(7, n3);
            this.keyType_ = CentralStoreKeyType.FILE_SYSTEM;
        } else if (string3.equals("jdbc:")) {
            if (string2 == null || string2.equals("")) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_CS_INV_URL", "pdq.propertiesGroupId", string2, string, "jdbc:") + (bl2 ? DataProperties.getMessageDescribingPropertyLocations(null, this.sourceInfoForNonGlobalProperties_, false, "  ") : ""), null, null, 10883);
            }
            string = string.replaceAll("\\\\x3[bB]", ";");
            string = string.replaceAll("\\\\3[bB]", ";");
            this.setUrl(string);
            this.propertiesGroupId_ = string2;
            this.keyType_ = CentralStoreKeyType.URL;
        } else {
            if (string2 != null && (string2.equals("") || string2.equals("*"))) {
                string2 = null;
            }
            if (string2 != null) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_CS_INV_URL", "pdq.propertiesGroupId", string2, string, "file:") + (bl2 ? DataProperties.getMessageDescribingPropertyLocations(null, this.sourceInfoForNonGlobalProperties_, false, "  ") : ""), null, null, 10885);
            }
            this.fileName_ = this.propertiesGroupId_ = string;
            this.keyType_ = CentralStoreKeyType.FILE_SYSTEM;
        }
        if (this.fileName_ != null) {
            int n5 = this.fileName_.lastIndexOf(46);
            if (n5 != -1) {
                this.setKeyExtension(this.fileName_.substring(n5 + 1));
                this.fileName_ = this.fileName_.substring(0, n5);
            }
            if (this.fileName_.endsWith("$X") || this.fileName_.endsWith("$x")) {
                this.isVariableKey_ = true;
                this.fileName_ = this.fileName_.substring(0, this.fileName_.length() - 2);
            }
            this.propertiesGroupId_ = this.fileName_;
        }
    }

    public void computeVariableKey(ClassLoader classLoader) {
        if (this.keyType_ == CentralStoreKeyType.FILE_SYSTEM && this.isVariableKey_ && !this.variableKeyProcessed_) {
            String string;
            this.variableKeyProcessed_ = true;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'-'HH-mm-ss.SSS");
            this.recordKeyPart2_ = string = "@" + Integer.toHexString(classLoader.hashCode()) + "_" + simpleDateFormat.format(Calendar.getInstance().getTime());
            this.cachedHashCode_ = 0;
        }
    }

    public String toString() {
        String string = "";
        switch (this.keyType_) {
            case DATASOURCE: {
                return this.keyType_.getPropertyKey() + this.dsName_ + " " + this.propertiesGroupId_ + string + this.variableKeyToString() + " App Name: " + this.moduleAppName_;
            }
            case FILE_SYSTEM: {
                return this.fileName_ + string + this.variableKeyToString() + (this.hasExtension_ ? "." + this.keyExtension_ : "") + " App Name: " + this.moduleAppName_;
            }
            case URL: {
                return this.urlWithPasswordMasked_ + " " + this.propertiesGroupId_ + string + this.variableKeyToString();
            }
        }
        return null;
    }

    public String getComposedResourceString() {
        switch (this.keyType_) {
            case DATASOURCE: {
                return this.keyType_.getPropertyKey() + this.dsName_ + " " + this.propertiesGroupId_ + this.variableKeyToString();
            }
            case FILE_SYSTEM: {
                return this.fileName_ + this.variableKeyToString() + (this.hasExtension_ ? "." + this.keyExtension_ : "");
            }
            case URL: {
                return this.urlWithPasswordMasked_ + " " + this.propertiesGroupId_ + this.variableKeyToString();
            }
        }
        return null;
    }

    public String getComposedFileName() {
        if (CentralStoreKeyType.FILE_SYSTEM == this.keyType_) {
            return this.fileName_ + this.variableKeyToString() + (this.hasExtension_ ? "." + this.keyExtension_ : "");
        }
        return null;
    }

    public String getFileName() {
        return this.fileName_;
    }

    protected void setFileName(String string) {
        this.fileName_ = string;
    }

    public String getDsName() {
        return this.dsName_;
    }

    protected void setDsName(String string) {
        this.cachedHashCode_ = 0;
        this.dsName_ = string;
    }

    public String getUrl() {
        return this.url_;
    }

    protected void setUrl(String string) {
        this.cachedHashCode_ = 0;
        this.url_ = string;
        this.urlWithPasswordMasked_ = StaticProfileConstants.maskJdbcURLPasswords(this.url_);
    }

    public String getPropertiesGroupId() {
        return this.propertiesGroupId_;
    }

    public String getRepositorySchema() {
        return this.repositorySchema_;
    }

    protected String getRecordKeyPart2() {
        return this.recordKeyPart2_;
    }

    public CentralStoreKey cloneKey() {
        return new CentralStoreKey(this.dsName_, this.fileName_, this.url_, this.hasExtension_, this.isVariableKey_, this.keyExtension_, this.keyType_, this.propertiesGroupId_, this.recordKeyPart2_, this.centralStoreFlags_, this.exceptionChain_, this.variableKeyProcessed_, this.tempFile_, this.propertiesLastModifiedTime_, this.inputXmlLastModifiedTime_, this.outputXmlLastModifiedTime_, this.xmlExtensionFound_, this.inputRecordsExistanceChecked_, this.outputRecordsExistanceChecked_, this.propertiesExistsForRead_, this.propertiesExistsForWrite_, this.inputXmlExistsForRead_, this.outputXmlExistsForRead_, this.inputXmlExistsForWrite_, this.outputXmlExistsForWrite_, this.modified_, this.lastCheckedTime_, this.propertiesRefreshIntervalInMillis_, this.xmlKey_, this.resovedStatesBeforeRedirect_, this.propertiesRefreshIntervalInMinutes_, this.groupVersion_, this.deepCompare_, this.dataProperties_, this.appClassLoader_, this.cachedConnectionInfo_, this.inputXmlLength_, this.outputXmlLength_, this.sourceInfoForNonGlobalProperties_, this.havePropertiesBeenLoaded_, this.repositoryVersion_, this.repositoryConnecticnInfo_, this.repositoryAsyncRefreshTrack_, this.compareToRV_2_2_7_, this.UUID_mostSignificantBits_, this.UUID_leastSignificantBits_, this.repositorySchema_, this.moduleAppName_);
    }

    public int hashCode() {
        if (this.cachedHashCode_ != 0) {
            return this.cachedHashCode_;
        }
        int n2 = 1;
        if (this.compareForSameDBMSRepository_) {
            n2 = 31 * n2 + (this.UUID_mostSignificantBits_ == null ? 0 : this.UUID_mostSignificantBits_.hashCode());
            n2 = 31 * n2 + (this.UUID_leastSignificantBits_ == null ? 0 : this.UUID_leastSignificantBits_.hashCode());
        } else {
            n2 = 31 * n2 + (this.dsName_ == null ? 0 : this.dsName_.hashCode());
            n2 = 31 * n2 + (this.keyType_ == null ? 0 : this.keyType_.hashCode());
            n2 = 31 * n2 + (this.url_ == null ? 0 : this.url_.hashCode());
            n2 = 31 * n2 + (this.keyExtension_ == null ? 0 : this.keyExtension_.hashCode());
            n2 = 31 * n2 + (this.propertiesGroupId_ == null ? 0 : this.propertiesGroupId_.hashCode());
            n2 = 31 * n2 + (this.repositorySchema_ == null ? 0 : this.repositorySchema_.hashCode());
            n2 = 31 * n2 + (this.dataProperties_ ? 1 : 0);
            if (this.recordKeyPart2_ != null) {
                n2 = 31 * n2 + this.recordKeyPart2_.hashCode();
            }
            if (this.deepCompare_) {
                n2 = 31 * n2 + (int)(this.propertiesLastModifiedTime_ ^ this.propertiesLastModifiedTime_ >>> 32);
                n2 = 31 * n2 + (int)(this.inputXmlLastModifiedTime_ ^ this.inputXmlLastModifiedTime_ >>> 32);
                n2 = 31 * n2 + (this.appClassLoader_ == null ? 0 : ((ClassLoader)this.appClassLoader_.get()).hashCode());
            }
        }
        this.cachedHashCode_ = n2;
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CentralStoreKey centralStoreKey = (CentralStoreKey)object;
        boolean bl3 = bl2 = this.compareForSameDBMSRepository_ && centralStoreKey.compareForSameDBMSRepository_;
        if (bl2) {
            if (this.UUID_mostSignificantBits_ != null ? !this.UUID_mostSignificantBits_.equals(centralStoreKey.UUID_mostSignificantBits_) : centralStoreKey.UUID_mostSignificantBits_ != null) {
                return false;
            }
            if (this.UUID_leastSignificantBits_ != null ? !this.UUID_leastSignificantBits_.equals(centralStoreKey.UUID_leastSignificantBits_) : centralStoreKey.UUID_leastSignificantBits_ != null) {
                return false;
            }
        } else {
            boolean bl4;
            if (this.dsName_ == null ? centralStoreKey.dsName_ != null : !this.dsName_.equals(centralStoreKey.dsName_)) {
                return false;
            }
            if (this.keyType_ != null ? this.keyType_ != centralStoreKey.keyType_ : centralStoreKey.keyType_ != null) {
                return false;
            }
            if (this.url_ == null ? centralStoreKey.url_ != null : !this.url_.equals(centralStoreKey.url_)) {
                return false;
            }
            if (this.dataProperties_ != centralStoreKey.dataProperties_) {
                return false;
            }
            if (this.propertiesGroupId_ == null ? centralStoreKey.propertiesGroupId_ != null : !this.propertiesGroupId_.equals(centralStoreKey.propertiesGroupId_)) {
                return false;
            }
            if (this.repositorySchema_ == null ? centralStoreKey.repositorySchema_ != null : !this.repositorySchema_.equals(centralStoreKey.repositorySchema_)) {
                return false;
            }
            if (this.keyExtension_ == null ? centralStoreKey.keyExtension_ != null : !this.keyExtension_.equals(centralStoreKey.keyExtension_)) {
                return false;
            }
            if (this.recordKeyPart2_ == null ? centralStoreKey.recordKeyPart2_ != null : !this.recordKeyPart2_.equals(centralStoreKey.recordKeyPart2_)) {
                return false;
            }
            boolean bl5 = bl4 = this.deepCompare_ && centralStoreKey.deepCompare_;
            if (bl4) {
                if (this.propertiesLastModifiedTime_ != centralStoreKey.propertiesLastModifiedTime_) {
                    return false;
                }
                if (this.inputXmlLastModifiedTime_ != centralStoreKey.inputXmlLastModifiedTime_) {
                    return false;
                }
                if (this.appClassLoader_ == null ? centralStoreKey.appClassLoader_ != null : !((ClassLoader)this.appClassLoader_.get()).equals(centralStoreKey.appClassLoader_.get())) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shallowEquals(CentralStoreKey centralStoreKey) {
        boolean bl2 = this.deepCompare_;
        try {
            this.deepCompare_ = false;
            boolean bl3 = this.equals(centralStoreKey);
            return bl3;
        }
        finally {
            this.deepCompare_ = bl2;
        }
    }

    public SQLException getExceptionChain() {
        return this.exceptionChain_;
    }

    protected void setExceptionChain(SQLException sQLException) {
        this.exceptionChain_ = sQLException;
    }

    protected void addToExceptionChain(SQLException sQLException) {
        SQLException sQLException2 = this.exceptionChain_;
        if (sQLException2 == null) {
            this.exceptionChain_ = sQLException;
        } else {
            sQLException2.setNextException(sQLException);
        }
    }

    public boolean isVariableKeyProcessed() {
        return this.variableKeyProcessed_;
    }

    protected void setVariableKeyProcessed(boolean bl2) {
        this.variableKeyProcessed_ = bl2;
    }

    private String variableKeyToString() {
        if (this.isVariableKey_) {
            return this.getKeyPart2();
        }
        return "";
    }

    protected File getTempFile() {
        return this.tempFile_;
    }

    protected void setTempFile(File file) {
        this.tempFile_ = file;
    }

    public long getPropertiesLastModifiedTime() {
        if (!this.inputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, true);
            }
            catch (SQLException sQLException) {
                return 0L;
            }
        }
        return this.propertiesLastModifiedTime_;
    }

    protected void setPropertiesLastModifiedTime(long l8) {
        this.inputRecordsExistanceChecked_ = true;
        this.propertiesLastModifiedTime_ = l8;
        this.cachedHashCode_ = 0;
    }

    public boolean isPropertiesExistsForRead() {
        if (!this.inputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, true);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return this.propertiesExistsForRead_;
    }

    protected void setPropertiesExistsForRead(boolean bl2) {
        this.inputRecordsExistanceChecked_ = true;
        this.propertiesExistsForRead_ = bl2;
    }

    protected void setPropertiesExistsForWrite(boolean bl2) {
        this.inputRecordsExistanceChecked_ = true;
        this.propertiesExistsForWrite_ = bl2;
    }

    public long getInputXmlLastModifiedTime() {
        if (!this.inputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, true);
            }
            catch (SQLException sQLException) {
                return 0L;
            }
        }
        return this.inputXmlLastModifiedTime_;
    }

    public long getOutputXmlLastModifiedTime() {
        if (!this.outputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, false);
            }
            catch (SQLException sQLException) {
                return 0L;
            }
        }
        return this.outputXmlLastModifiedTime_;
    }

    protected void setInputXmlLastModifiedTime(long l8) {
        this.inputRecordsExistanceChecked_ = true;
        this.inputXmlLastModifiedTime_ = l8;
        this.cachedHashCode_ = 0;
    }

    protected void setOutputXmlLastModifiedTime(long l8) {
        this.outputRecordsExistanceChecked_ = true;
        this.outputXmlLastModifiedTime_ = l8;
    }

    protected String getXmlExtensionFound() {
        return this.xmlExtensionFound_;
    }

    protected void setXmlExtensionFound(String string) {
        this.xmlExtensionFound_ = string;
    }

    public boolean isInputXmlExists() {
        if (!this.inputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, true);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.out);
                this.inputRecordsExistanceChecked_ = false;
                return this.tempInputStreamHold_ != null;
            }
        }
        return this.inputXmlExistsForRead_ || this.inputXmlExistsForWrite_ || this.tempInputStreamHold_ != null;
    }

    public boolean isOutputXmlExists() {
        if (!this.outputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, false);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return this.outputXmlExistsForRead_ || this.outputXmlExistsForWrite_;
    }

    public boolean isInputXmlExistsForRead() {
        if (!this.inputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, true);
            }
            catch (SQLException sQLException) {
                return this.tempInputStreamHold_ != null;
            }
        }
        return this.inputXmlExistsForRead_ || this.tempInputStreamHold_ != null;
    }

    public boolean isOutputXmlExistsForRead() {
        if (!this.outputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, false);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return this.outputXmlExistsForRead_;
    }

    protected void setInputXmlExistsForRead(boolean bl2) {
        this.inputRecordsExistanceChecked_ = true;
        this.inputXmlExistsForRead_ = bl2;
    }

    protected void setOutputXmlExistsForRead(boolean bl2) {
        this.outputRecordsExistanceChecked_ = true;
        this.outputXmlExistsForRead_ = bl2;
    }

    public boolean isInputXmlExistsForWrite() {
        if (!this.inputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, true);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return this.inputXmlExistsForWrite_;
    }

    public boolean isOutputXmlExistsForWrite() {
        if (!this.outputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, false);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return this.outputXmlExistsForWrite_;
    }

    protected void setInputXmlExistsForWrite(boolean bl2) {
        this.inputRecordsExistanceChecked_ = true;
        this.inputXmlExistsForWrite_ = bl2;
    }

    protected void setOutputXmlExistsForWrite(boolean bl2) {
        this.outputRecordsExistanceChecked_ = true;
        this.outputXmlExistsForWrite_ = bl2;
    }

    public long getInputXmlLength() {
        if (!this.inputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, true);
            }
            catch (SQLException sQLException) {
                return 0L;
            }
        }
        return this.inputXmlLength_;
    }

    public long getOutputXmlLength() {
        if (!this.outputRecordsExistanceChecked_) {
            try {
                CentralStore.checkRecordStatus(this, false);
            }
            catch (SQLException sQLException) {
                return 0L;
            }
        }
        return this.outputXmlLength_;
    }

    protected void setInputXmlLength(long l8) {
        this.inputRecordsExistanceChecked_ = true;
        this.inputXmlLength_ = l8;
    }

    protected void setOutputXmlLength(long l8) {
        this.outputRecordsExistanceChecked_ = true;
        this.outputXmlLength_ = l8;
    }

    public int getRepositoryFileInfoKey() {
        return this.repositoryFileInfoKey_;
    }

    public void setRepositoryFileInfoKey(int n2) {
        this.repositoryFileInfoKey_ = n2;
    }

    public InputStream getTempInputStreamHold() {
        if (CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
            CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, get xmlInputStream", DataLogger.getShortName(this.tempInputStreamHold_), 5);
        }
        return this.tempInputStreamHold_;
    }

    public void setTempInputStreamHold(InputStream inputStream) {
        this.tempInputStreamHold_ = inputStream;
        if (CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
            CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, setting xmlInputStream", DataLogger.getShortName(this.tempInputStreamHold_), 5);
        }
    }

    public boolean isModified() {
        if (this.modified_) {
            return true;
        }
        return this.xmlKey_ != null && this.xmlKey_.isModified();
    }

    public void setModified(boolean bl2) {
        this.modified_ = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetadataGroupDataActiveRefresh[] getMetadataGroupDataActiveRefresh() {
        Connection connection = null;
        AsyncRefreshMaintenance asyncRefreshMaintenance = null;
        MetadataGroupDataActiveRefresh[] metadataGroupDataActiveRefreshArray = null;
        try {
            connection = CentralStore.getConnection(this);
            String string = this.getCachedConnectionInfo().dbInfo_.databaseProductName_;
            asyncRefreshMaintenance = string.contains("DB2") || string.equals("AS") ? (AsyncRefreshMaintenance)RepositoryDataFactory.getData(DB2AsyncRefreshMaintenance.class, connection, this.getRepositoryConnecticnInfo()) : (AsyncRefreshMaintenance)RepositoryDataFactory.getData(GenericAsyncRefreshMaintenance.class, connection, this.getRepositoryConnecticnInfo());
            metadataGroupDataActiveRefreshArray = asyncRefreshMaintenance.getMetadataGroupDataActiveRefresh(this.repositoryAsyncRefreshTrack_);
        }
        catch (SQLException sQLException) {
            this.addToExceptionChain(sQLException);
        }
        finally {
            if (this.getConnection() != null) {
                try {
                    this.closeCon();
                }
                catch (Exception exception) {}
            }
        }
        return metadataGroupDataActiveRefreshArray;
    }

    public void setConnection(ConnectionExecutionHandler connectionExecutionHandler, Connection connection) throws SQLException {
        this.repositoryConnectionExecutionHandler_ = connectionExecutionHandler;
        this.con_ = connection;
        if (connection != null && this.getCachedConnectionInfo() == null) {
            connectionExecutionHandler.createConnInfo();
            this.setCachedConnectionInfo(connectionExecutionHandler.getConnInfo());
        }
        if (CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
            CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, setConnection", DataLogger.getShortName(this.con_) + ":" + DataLogger.getShortName(this.repositoryConnectionExecutionHandler_), 5);
        }
    }

    public Connection getConnection() {
        if (CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
            CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, getConnection", DataLogger.getShortName(this.con_), 5);
        }
        return this.con_;
    }

    public void closeConUnlesstempMDOutputStreamExists() {
        this.closeConX(false);
    }

    public void closeCon() {
        this.closeConX(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConX(boolean bl2) {
        block26: {
            Object object;
            if (this.tempInputStreamHold_ != null) {
                object = this.tempInputStreamHold_;
                try {
                    this.tempInputStreamHold_ = null;
                    ((InputStream)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
                    CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, closing xmlInputStream", DataLogger.getShortName(this.tempInputStreamHold_), 5);
                }
            }
            if (this.con_ != null && (bl2 || this.tempMDOutputStream_ == null)) {
                try {
                    CentralStore.logRepositoryConnectionClose(this.con_, this, 6);
                    if (this.tempMDOutputStream_ != null) {
                        try {
                            object = this.tempMDOutputStream_.getDataInfo();
                            if (object != null) {
                                this.setOutputXmlLength(object.getLength());
                                this.setOutputXmlLastModifiedTime(object.getUpdateTime());
                                this.setRepositoryFileInfoKey(object.getKey());
                            }
                            this.tempMDOutputStream_ = null;
                            CentralStore.logCentralStoreWriteResults(this);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.getExceptionChain() == null) {
                            this.con_.commit();
                            break block26;
                        }
                        this.con_.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        ManagerFactory.restoreConnection(this.con_);
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (MetadataException metadataException) {}
                    try {
                        this.con_.close();
                    }
                    catch (SQLException sQLException) {}
                    if (this.repositoryConnectionExecutionHandler_ != null) {
                        this.repositoryConnectionExecutionHandler_.setRepositoryConnection(false);
                    }
                    this.con_ = null;
                    this.tempInputStreamHold_ = null;
                    this.tempMDOutputStream_ = null;
                }
            }
        }
    }

    public long getLastCheckedTime() {
        return this.lastCheckedTime_;
    }

    public void setLastCheckedTime(long l8) {
        this.lastCheckedTime_ = l8;
    }

    public long getPropertiesRefreshIntervalInMillis() {
        return this.propertiesRefreshIntervalInMillis_;
    }

    public long getPropertiesRefreshIntervalInMinutes() {
        return this.propertiesRefreshIntervalInMinutes_;
    }

    public void setPropertiesRefreshIntervalInMinutes(long l8) {
        this.propertiesRefreshIntervalInMinutes_ = l8;
        this.propertiesRefreshIntervalInMillis_ = l8 * 60000L;
    }

    protected void resetExistanceCheckedFlags() {
        this.inputRecordsExistanceChecked_ = false;
        this.outputRecordsExistanceChecked_ = false;
    }

    protected CentralStoreKey getXmlKey() {
        return this.xmlKey_;
    }

    public void setXmlKey(CentralStoreKey centralStoreKey) {
        this.xmlKey_ = centralStoreKey;
    }

    public ConnectionExecutionHandler.CachedResolvedStates getResovedStatesBeforeRedirect() {
        return this.resovedStatesBeforeRedirect_;
    }

    public void setResovedStatesBeforeRedirect(ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates) {
        this.resovedStatesBeforeRedirect_ = cachedResolvedStates;
    }

    protected void setTempMDOutputStream(MDOutputStream mDOutputStream) {
        this.tempMDOutputStream_ = mDOutputStream;
        if (CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
            CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, setTempMDOutputStream", DataLogger.getShortName(this.tempMDOutputStream_), 5);
        }
    }

    protected MDOutputStream getTempMDOutputStream() {
        if (CentralStore.willLogRepositoryConnectionAtLevel(Level.FINER)) {
            CentralStore.logRepositoryConnectionAtLevel(Level.FINER, this, "Repository, getTempMDOutputStream", DataLogger.getShortName(this.tempMDOutputStream_), 5);
        }
        return this.tempMDOutputStream_;
    }

    public boolean isTempMDOutputStreamPresent() {
        return this.tempMDOutputStream_ != null;
    }

    public ClassLoader getAppClassLoader() {
        if (this.appClassLoader_ == null) {
            return null;
        }
        ClassLoader classLoader = (ClassLoader)this.appClassLoader_.get();
        if (classLoader == null) {
            this.appClassLoader_ = null;
        }
        return classLoader;
    }

    public void setAppClassLoader(ClassLoader classLoader) {
        this.appClassLoader_ = classLoader == null ? null : new WeakReference<ClassLoader>(classLoader);
        this.cachedHashCode_ = 0;
    }

    public String getGroupVersion() {
        return this.groupVersion_;
    }

    public void setGroupVersion(String string) {
        this.groupVersion_ = string;
    }

    public boolean isDeepCompare() {
        return this.deepCompare_;
    }

    public void setDeepCompare(boolean bl2) {
        this.deepCompare_ = bl2;
        this.cachedHashCode_ = 0;
    }

    public boolean isCompareForSameDBMSRepository() {
        return this.compareForSameDBMSRepository_;
    }

    public void setCompareForSameDBMSRepository(boolean bl2) {
        this.compareForSameDBMSRepository_ = bl2;
        this.cachedHashCode_ = 0;
    }

    public ConnectionExecutionHandler getRepositoryConnectionExecutionHandler() {
        return this.repositoryConnectionExecutionHandler_;
    }

    public DataProperties.SourceInfoForNonGlobalProperties getSourceInfoForNonGlobalProperties() {
        return this.sourceInfoForNonGlobalProperties_;
    }

    public boolean isDataProperties() {
        return this.dataProperties_;
    }

    public void setDataProperties(boolean bl2) {
        this.cachedHashCode_ = 0;
        this.dataProperties_ = bl2;
    }

    public CachedConnectionInfo getCachedConnectionInfo() {
        return this.cachedConnectionInfo_;
    }

    public void setCachedConnectionInfo(CachedConnectionInfo cachedConnectionInfo) {
        this.cachedConnectionInfo_ = cachedConnectionInfo;
    }

    public boolean getHavePropertiesBeenLoaded() {
        return this.havePropertiesBeenLoaded_;
    }

    public Properties getActualLoadedProps() {
        return this.actualLoadedProps_;
    }

    public void setActualLoadedProps(Properties properties) {
        this.actualLoadedProps_ = properties;
    }

    public RepositoryVersion getRepositoryVersion() {
        return this.repositoryVersion_;
    }

    public void setRepositoryVersion(RepositoryVersion repositoryVersion) {
        this.repositoryVersion_ = repositoryVersion;
        if (repositoryVersion == null) {
            this.compareToRV_2_2_7_ = -1;
        } else {
            RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 7);
            this.compareToRV_2_2_7_ = repositoryVersion.compareTo(repositoryVersionImpl);
        }
    }

    public Long[] getRepositoryUUID() {
        Long[] longArray = new Long[]{this.UUID_mostSignificantBits_, this.UUID_leastSignificantBits_};
        return longArray;
    }

    public void setRepositoryUUID(Long l8, Long l9) {
        this.UUID_mostSignificantBits_ = l8;
        this.UUID_leastSignificantBits_ = l9;
        this.cachedHashCode_ = 0;
    }

    public ConnectionManager.ConnectionInfo getRepositoryConnecticnInfo() {
        return this.repositoryConnecticnInfo_;
    }

    public void setRepositoryConnecticnInfo(ConnectionManager.ConnectionInfo connectionInfo) {
        this.repositoryConnecticnInfo_ = connectionInfo;
    }

    public Integer getRepositoryAsyncRefreshTrack() {
        return this.repositoryAsyncRefreshTrack_;
    }

    public void setRepositoryAsyncRefreshTrack(Integer n2) {
        this.repositoryAsyncRefreshTrack_ = n2;
    }

    public int getCompareToRV_2_2_7() {
        return this.compareToRV_2_2_7_;
    }

    private void setApplicationName() {
        try {
            String string;
            String string2 = (String)new InitialContext().lookup("java:module/ModuleName");
            if (string2 != null) {
                this.moduleAppName_ = string2 + "@";
            }
            if ((string = (String)new InitialContext().lookup("java:app/AppName")) != null) {
                this.moduleAppName_ = this.moduleAppName_ != null ? this.moduleAppName_ + string : string;
            }
        }
        catch (Throwable throwable) {
            this.logToDriverLogWriter("Lookup Exception occurred!", "setApplicationName()", throwable);
        }
    }

    private void logToDriverLogWriter(String string, String string2, Throwable throwable) {
        if (this.con_ != null && this.con_ instanceof DB2Connection) {
            try {
                PrintWriter printWriter = ((DB2Connection)this.con_).getJccLogWriter();
                if (printWriter != null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
                    TimeZone timeZone = TimeZone.getDefault();
                    simpleDateFormat.setTimeZone(timeZone);
                    Calendar calendar = Calendar.getInstance(timeZone);
                    calendar.setTimeInMillis(System.currentTimeMillis());
                    String string3 = simpleDateFormat.format(calendar.getTime());
                    String string4 = "[pdq][profiler][" + DataVersion.getProductVersion() + "]";
                    String string5 = string4 + "[Time:" + string3 + "][Thread:" + Thread.currentThread().getName();
                    string5 = string5 + "[" + string2 + "]";
                    if (string != null) {
                        string5 = string5 + string;
                    }
                    if (throwable != null) {
                        string5 = string5 + " Exception: " + throwable;
                    }
                    printWriter.println(string5);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getModuleAppName() {
        return this.moduleAppName_;
    }

    public static boolean shallowEqualsWithAppName(CentralStoreKey centralStoreKey, CentralStoreKey centralStoreKey2) {
        if (centralStoreKey == null || centralStoreKey2 == null) {
            return false;
        }
        if (centralStoreKey == centralStoreKey2) {
            return true;
        }
        if (centralStoreKey.getModuleAppName() == null || centralStoreKey2.getModuleAppName() == null) {
            return false;
        }
        boolean bl2 = centralStoreKey.getModuleAppName().equals(centralStoreKey2.getModuleAppName());
        if (bl2) {
            return centralStoreKey.shallowEquals(centralStoreKey2);
        }
        return bl2;
    }

    public static class CachedConnectionInfo {
        public String connExecHandlerClassStr_ = null;
        public Object baseDS_;
        public String globalPropertyString_;
        public String dsName_;
        public String driverName_;
        public String driverVersion_;
        public int driverMajorVersion_;
        public int driverMinorVersion_;
        public final StaticProfileConstants.DBInfo dbInfo_;
        public String url_;
        public String userId_;
        public String currentSchema_;
        public String databaseName_;
        private boolean doesDatabaseSupportRowsetCursors_;
        private DataRuntimeException cachedExceptionCheckingDoesDatabaseSupportRowsetCursors_ = null;

        public CachedConnectionInfo(Object object, String string, StaticProfileConstants.DBInfo dBInfo, DatabaseMetaData databaseMetaData, String string2, String string3, String string4) {
            this.baseDS_ = object;
            this.connExecHandlerClassStr_ = string;
            this.dbInfo_ = null != dBInfo ? dBInfo : StaticProfileConstants.DBInfo.dummyDBInfo_;
            this.dsName_ = string2;
            this.globalPropertyString_ = string3;
            this.databaseName_ = string4;
            try {
                this.doesDatabaseSupportRowsetCursors_ = StatementUtilities.doesDatabaseSupportRowsetCursors(databaseMetaData);
            }
            catch (DataRuntimeException dataRuntimeException) {
                this.cachedExceptionCheckingDoesDatabaseSupportRowsetCursors_ = dataRuntimeException;
            }
            try {
                this.driverMajorVersion_ = databaseMetaData.getDriverMajorVersion();
                this.driverMinorVersion_ = databaseMetaData.getDriverMinorVersion();
                this.driverName_ = databaseMetaData.getDriverName();
                this.driverVersion_ = databaseMetaData.getDriverVersion();
                this.url_ = databaseMetaData.getURL();
                this.userId_ = databaseMetaData.getUserName();
                this.currentSchema_ = databaseMetaData.getUserName();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public boolean doesDatabaseSupportRowsetCursors() {
            if (this.cachedExceptionCheckingDoesDatabaseSupportRowsetCursors_ != null) {
                this.cachedExceptionCheckingDoesDatabaseSupportRowsetCursors_.fillInStackTrace();
                throw this.cachedExceptionCheckingDoesDatabaseSupportRowsetCursors_;
            }
            return this.doesDatabaseSupportRowsetCursors_;
        }
    }

    public static enum CentralStoreKeyType {
        FILE_SYSTEM("file://"),
        DATASOURCE("ds://"),
        URL("url");

        private String propertyKey;

        private CentralStoreKeyType(String string2) {
            this.propertyKey = string2;
        }

        String getPropertyKey() {
            return this.propertyKey;
        }
    }
}

