/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.PooledConnection;
import oracle.jdbc.OraclePooledConnectionBuilder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OraclePooledConnectionBuilderImpl;
import oracle.jdbc.replay.OracleDataSourceImpl;
import oracle.jdbc.replay.driver.PooledConnectionImpl;
import oracle.jdbc.replay.internal.OracleConnectionPoolDataSource;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class OracleConnectionPoolDataSourceImpl
extends OracleDataSourceImpl
implements OracleConnectionPoolDataSource,
Serializable,
Referenceable,
ObjectFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        String string = null;
        String string2 = null;
        OracleConnectionPoolDataSourceImpl oracleConnectionPoolDataSourceImpl = this;
        synchronized (oracleConnectionPoolDataSourceImpl) {
            string = this.user;
            string2 = this.password.get();
        }
        return this.getPooledConnection(string, string2);
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        Connection connection = this.getPhysicalConnection(string, string2);
        PooledConnectionImpl pooledConnectionImpl = new PooledConnectionImpl(connection);
        if (string2 == null) {
            string2 = this.password.get();
        }
        pooledConnectionImpl.setUserName(!string.startsWith("\"") ? string.toLowerCase() : string, string2);
        return pooledConnectionImpl;
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    public Connection getConnection(Properties properties) throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    public Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    protected Connection getPhysicalConnection() throws SQLException {
        return super.getConnection();
    }

    protected Connection getPhysicalConnection(String string, String string2, String string3) throws SQLException {
        this.setURL(string);
        return super.getConnection(string2, string3);
    }

    protected Connection getPhysicalConnection(String string, String string2) throws SQLException {
        return super.getConnection(string, string2);
    }

    protected OraclePooledConnection getPooledConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        String string;
        Connection connection = super.getConnection(oracleConnectionBuilderImpl);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        String string2 = oracleConnectionBuilderImpl.getUser();
        if (string2 == null) {
            string2 = ((OracleConnection)connection).getUserName();
        }
        if ((string = oracleConnectionBuilderImpl.getPassword()) == null) {
            string = this.password.get();
        }
        oraclePooledConnection.setUserName(!string2.startsWith("\"") ? string2.toLowerCase() : string2, string);
        return oraclePooledConnection;
    }

    @Override
    public OraclePooledConnectionBuilder createPooledConnectionBuilder() throws SQLException {
        return new OraclePooledConnectionBuilderImpl(){

            @Override
            public OraclePooledConnection build() throws SQLException {
                OracleConnectionBuilderImpl oracleConnectionBuilderImpl = OracleConnectionPoolDataSourceImpl.this.createConnectionBuilder().user(this.user).password(this.password).instanceName(this.instanceName).serviceName(this.serviceName).shardingKey(this.shardingKey).superShardingKey(this.superShardingKey);
                return OracleConnectionPoolDataSourceImpl.this.getPooledConnection(oracleConnectionBuilderImpl);
            }
        };
    }
}

