/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oci.OracleOCIConnection;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;

    T2CDriverExtension() {
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    Connection getConnection(String string, Properties properties) throws SQLException {
        T2CConnection t2CConnection = null;
        t2CConnection = properties.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection(string, properties, (Object)this) : new T2CConnection(string, properties, this);
        t2CConnection.connect();
        return t2CConnection;
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    OracleStatement allocateStatement(PhysicalConnection physicalConnection, int n2, int n3) throws SQLException {
        return new T2CStatement((T2CConnection)physicalConnection, 1, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        return new T2CPreparedStatement((T2CConnection)physicalConnection, string, physicalConnection.defaultExecuteBatch, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    OracleCallableStatement allocateCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        return new T2CCallableStatement((T2CConnection)physicalConnection, string, physicalConnection.defaultExecuteBatch, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        return new T2CInputStream(oracleStatement, n2, accessor);
    }
}

