/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.Resources;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.SQLException;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.Value;
import java.math.BigDecimal;

public class ValueShort
extends Value {
    private final short value;

    public ValueShort(short value) {
        this.value = value;
    }

    public ValueShort(Object value) {
        this.value = value instanceof Number ? ((Number)value).shortValue() : (value instanceof Boolean ? (short)(Boolean.TRUE.equals(value) ? 1 : 0) : Short.parseShort(value.toString()));
    }

    @Override
    int getType() {
        return 4;
    }

    @Override
    int getScale() {
        return 0;
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws java.sql.SQLException {
        dataStream.encodeInt(this.getShort());
    }

    @Override
    boolean getBoolean() {
        return this.value != 0;
    }

    @Override
    String getString() {
        return ValueShort.getString(this.value, 0);
    }

    @Override
    String getZeroPaddedString(int numZeroes, SQLContext context) {
        return ValueShort.getString(this.value, 0, numZeroes);
    }

    @Override
    byte getByte() throws java.sql.SQLException {
        short value = this.getShort();
        if (value < -128 || value > 127) {
            throw new SQLException(Resources.getMessage("error.byte.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (byte)value;
    }

    @Override
    short getShort() {
        return this.value;
    }

    @Override
    int getInt() {
        return this.getShort();
    }

    @Override
    long getLong() {
        return this.getShort();
    }

    @Override
    double getDouble() {
        return this.getInt();
    }

    @Override
    float getFloat() {
        return this.getInt();
    }

    @Override
    BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.value, 0);
    }

    @Override
    Object getObject() {
        return this.getShort();
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.getShort());
    }
}

