/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.NuoDBXAException;
import com.nuodb.jdbc.NuoXid;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemXAResource;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RemXAConnection
implements XAConnection {
    private String url;
    private Properties properties;
    private RemXAResource resource;
    private RemConnection connection;
    private Hashtable<Integer, NuoXid> recoverXids = new Hashtable();

    public RemXAConnection(String url, Properties properties) {
        this.url = url;
        this.properties = properties;
    }

    private RemConnection createXAConnection() throws XAException {
        try {
            try {
                Class.forName("com.nuodb.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                throw new NuoDBXAException(-3, "Unable to find class com.nuodb.jdbc.Driver");
            }
            RemConnection conn = (RemConnection)DriverManager.getConnection(this.url, this.properties);
            return conn;
        }
        catch (SQLException exception) {
            throw new NuoDBXAException(-3, exception.getMessage());
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        if (this.resource != null) {
            return this.resource;
        }
        this.resource = new RemXAResource(this);
        return this.resource;
    }

    public NuoXid findRecoverXid(Xid xid) {
        return this.recoverXids.get(xid.hashCode());
    }

    public void saveRecoverXid(NuoXid xid) {
        this.recoverXids.put(xid.hashCode(), xid);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public RemConnection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            try {
                this.connection = this.createXAConnection();
            }
            catch (XAException exception) {
                throw new SQLException("Failure getting connection.", exception);
            }
        }
        return this.connection;
    }

    public RemConnection getExistingConnection() {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

