/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.StringUtils;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.ProtectionDomain;

public class Env {
    public static final String PROJECT_NAME = "nuodb";
    public static final String UNIX_LOG_DIR = "log";
    public static final String WINDOWS_LOG_DIR = "LogFiles";
    public static final String UNIX_EXECUTABLE_NAME = "nuodb";
    public static final String WINDOWS_EXECUTABLE_NAME = "nuodb.exe";
    public static final String NUODB_EXEC_PROP_NAME = "nuodbBinary";

    public static String homeDir(Class<?> clazz, String homeDir) {
        File homeFile;
        if (homeDir == null) {
            homeDir = System.getProperty("NUODB_HOME", System.getenv("NUODB_HOME"));
        }
        if (homeDir == null) {
            File t = Env.getContainingDirectory(clazz);
            homeDir = t.getParentFile().getAbsolutePath();
        }
        if (!(homeFile = new File(homeDir)).exists()) {
            throw new IllegalStateException("NuoDB home directory " + homeFile.getAbsolutePath() + " does not exist.");
        }
        return homeDir;
    }

    public static boolean isPackage(String homeDir) {
        File etcFile = new File(homeDir, "etc");
        File pkgFile = new File(etcFile, ".package.ver");
        return pkgFile.exists();
    }

    public static String configDir(String cfgDir, String homeDir) {
        if (cfgDir == null) {
            cfgDir = System.getProperty("NUODB_CFGDIR", System.getenv("NUODB_CFGDIR"));
        }
        if (cfgDir == null) {
            File cfgFile;
            if (!Env.isPackage(homeDir)) {
                File t = new File(homeDir, "var");
                cfgFile = new File(t, "etc");
            } else if (Env.isWindows()) {
                String e = System.getenv("ALLUSERSPROFILE");
                if (e == null) {
                    e = "C:\\ProgramData";
                }
                File t = new File(e);
                cfgFile = new File(t, "nuodb");
            } else {
                File t = new File("/etc");
                cfgFile = new File(t, "nuodb");
            }
            cfgDir = cfgFile.getAbsolutePath();
        }
        return cfgDir;
    }

    public static String varDir(String varDir, String homeDir) {
        if (varDir == null) {
            varDir = System.getProperty("NUODB_VARDIR", System.getenv("NUODB_VARDIR"));
        }
        if (varDir == null) {
            String e;
            File varDirFile = !Env.isPackage(homeDir) ? new File(new File(homeDir, "var"), "opt") : (Env.isWindows() ? new File((e = System.getenv("ALLUSERSPROFILE")) != null ? e : "C:\\ProgramData", "nuodb") : new File(new File("/var/opt"), "nuodb"));
            varDir = varDirFile.getAbsolutePath();
        }
        return varDir;
    }

    public static String logDir(String logDir, File varDir, String homeDir) {
        if (logDir == null) {
            logDir = System.getProperty("NUODB_LOGDIR", System.getenv("NUODB_LOGDIR"));
        }
        if (logDir == null) {
            File logFile;
            if (Env.isWindows()) {
                logFile = new File(varDir, WINDOWS_LOG_DIR);
            } else if (Env.isPackage(homeDir)) {
                logFile = new File(new File("/var/log"), "nuodb");
            } else {
                File home = new File(homeDir);
                logFile = new File(new File(home, "var"), UNIX_LOG_DIR);
            }
            logDir = logFile.getAbsolutePath();
        }
        return logDir;
    }

    public static String tmpDir(String tmpDir, File varDir) {
        if (tmpDir == null) {
            tmpDir = System.getProperty("NUODB_TEST_TEMP", System.getenv("NUODB_TEST_TEMP"));
        }
        if (tmpDir == null) {
            tmpDir = System.getProperty(Env.isWindows() ? "TEMP" : "TMPDIR");
        }
        if (tmpDir == null) {
            String profile;
            tmpDir = Env.isWindows() ? ((profile = System.getProperty("USERPROFILE", System.getenv("USERPROFILE"))) != null ? profile + File.separator + "AppData" + File.separator + "Local" + File.separator + "Temp" : varDir.getAbsolutePath()) : "/tmp";
        }
        return tmpDir;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static File getContainingDirectory(Class<?> clazz) {
        ProtectionDomain domain = clazz.getProtectionDomain();
        URL urlPath = domain.getCodeSource().getLocation();
        try {
            File pathFile = new File(urlPath.toURI());
            if (pathFile.isDirectory()) {
                return pathFile;
            }
            return pathFile.getParentFile();
        }
        catch (URISyntaxException ue) {
            throw new IllegalStateException("URI Syntax error ", ue);
        }
    }

    public static String getNuodbExecutableName() {
        String binary = System.getProperty(NUODB_EXEC_PROP_NAME, System.getenv(NUODB_EXEC_PROP_NAME));
        if (StringUtils.isBlank(binary)) {
            return Env.isWindows() ? WINDOWS_EXECUTABLE_NAME : "nuodb";
        }
        return binary;
    }
}

