/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats;

import com.nuodb.impl.stats.AlarmDef;
import com.nuodb.impl.stats.AlarmWatch;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Alarm {
    public static final long NO_SIG_TS = -1L;
    final String id;
    final String entityId;
    final AlarmDef def;
    long signalTime = -1L;
    private String userData = null;
    public static Comparator<Alarm> timeComparator = new Comparator<Alarm>(){

        @Override
        public int compare(Alarm a1, Alarm a2) {
            if (a1.getSignalTime() < a2.getSignalTime()) {
                return -1;
            }
            if (a1.getSignalTime() == a2.getSignalTime()) {
                return 0;
            }
            return 1;
        }
    };

    public Alarm(AlarmDef def, String entityId) {
        this(def, entityId, UUID.randomUUID().toString(), -1L);
    }

    private Alarm(AlarmDef def, String entityId, String id, long ts) {
        this.def = def;
        this.entityId = entityId;
        this.id = id;
        this.signalTime = ts;
        Preconditions.checkArgument(def != null, "AlarmDef must be suplied, %s", this);
        Preconditions.checkArgument(!StringUtils.isBlank(entityId), "empty entityId, %s", this);
        Preconditions.checkArgument(!StringUtils.isBlank(id), "empty Id, %s", this);
    }

    public Alarm(Tag t) throws XmlException {
        this(t, new AlarmDef(t.findChild("AlarmDefinition")));
    }

    protected Alarm(Tag t, AlarmDef def) throws XmlException {
        this(def, t.getAttribute("entityId"), t.getAttribute("id"), t.getLongAttribute("signalTime", -1L));
        this.userData = t.getAttribute("userData", null);
    }

    public Tag toTag() {
        Tag tag = TagFactory.createTag("Alarm");
        this.encode(tag);
        return tag;
    }

    public void encode(Tag tag) {
        tag.addAttribute("id", this.id);
        tag.addAttribute("entityId", this.entityId);
        if (this.userData != null) {
            tag.addAttribute("userData", this.userData);
        }
        tag.addAttribute("signalTime", this.signalTime);
        Tag defTag = tag.addChild("AlarmDefinition");
        this.def.encode(defTag);
    }

    public String getId() {
        return this.id;
    }

    public AlarmDef getDef() {
        return this.def;
    }

    public boolean isSame(AlarmDef aDef) {
        return aDef != null && this.def.getName().equals(aDef.getName());
    }

    public String getEntity() {
        return this.entityId;
    }

    public String getUserData() {
        return this.userData;
    }

    public Alarm signal() {
        return this.signal(System.currentTimeMillis());
    }

    public Alarm signal(String userData) {
        this.userData = userData;
        return this.signal(System.currentTimeMillis());
    }

    public Alarm signal(long ts) {
        this.signalTime = ts;
        return this;
    }

    public long getSignalTime() {
        return this.signalTime;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.id.equals(((Alarm)o).id);
    }

    public String toString() {
        return this.toString(this.entityId);
    }

    public String toString(String prettyEntityId) {
        return String.format("Alarm id=%s entity=[%s] def=[%s] ud=[%s]", this.id, prettyEntityId != null ? prettyEntityId : this.entityId, this.def, this.userData != null ? this.userData : "");
    }

    public static List<Alarm> sortByTime(Collection<Alarm> alarms) {
        ArrayList<Alarm> sorted = new ArrayList<Alarm>(alarms);
        Collections.sort(sorted, timeComparator);
        return sorted;
    }

    public static void prune(Map<String, Alarm> alarms, int max, int div) {
        if (alarms.size() > max) {
            List<Alarm> sorted = Alarm.sortByTime(alarms.values());
            int num = 0;
            for (Alarm i : sorted) {
                if (++num >= max / div) {
                    return;
                }
                alarms.remove(i.getId());
            }
        }
    }

    public static Alarm asAlarm(Tag message) throws XmlException {
        if ("AlarmWatch".equals(message.getName())) {
            return new AlarmWatch(message);
        }
        if ("Alarm".equals(message.getName())) {
            return new Alarm(message);
        }
        throw new IllegalStateException("Not an Alarm class: " + message.getName());
    }
}

