/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.net;

import com.nuodb.impl.net.LengthUtil;
import com.nuodb.impl.security.Cipher;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CryptoOutputStream
extends OutputStream {
    OutputStream stream;
    Cipher cipher;
    byte[] lengthBuffer;

    public CryptoOutputStream(OutputStream outputStream) {
        this.stream = new BufferedOutputStream(outputStream);
    }

    public void encrypt(Cipher encryptionEngine) {
        this.cipher = encryptionEngine;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.cipher == null) {
            this.stream.write(b);
        } else {
            byte[] array = new byte[]{(byte)b};
            this.write(array, 0, 1);
        }
    }

    public void writeLength(int messageLength) throws IOException {
        if (this.lengthBuffer == null) {
            this.lengthBuffer = new byte[4];
        }
        LengthUtil.writeLength(messageLength, this.lengthBuffer);
        this.stream.write(this.lengthBuffer);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        if (this.cipher == null) {
            this.stream.write(b, offset, length);
        } else {
            this.cipher.write(this.stream, b, offset, length);
        }
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }
}

