/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.descriptions;

import com.nuodb.descriptions.Description;
import com.nuodb.descriptions.DescriptionArchives;
import com.nuodb.descriptions.DescriptionBackoffStats;
import com.nuodb.descriptions.Mapper;
import com.nuodb.impl.stats.Alarm;
import com.nuodb.impl.util.ArchiveUtil;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescriptionImpl
implements Description {
    public static final String DESCRIPTION_TAG_NAME = "Database";
    public static final String DATABASE_NAME_ATTR_NAME = "DatabaseName";
    public static final String TEMPLATE_TAG_NAME = "Template";
    public static final String OPTION_LIST_TAG_NAME = "Options";
    public static final String OPTION_TAG_NAME = "Option";
    public static final String PROCESS_GROUP_TAG_NAME = "ProcessGroup";
    public static final String PROCESS_GROUP_NAME_ATTR_NAME = "Name";
    public static final String GROUP_OPTION_LIST_TAG_NAME = "GroupOptions";
    public static final String GROUP_OPTION_TAG_NAME = "GroupOption";
    public static final String TAG_CONSTRAINT_LIST_TAG_NAME = "TagConstraints";
    public static final String TAG_CONSTRAINT_TAG_NAME = "TagConstraint";
    public static final String VARIABLE_LIST_TAG_NAME = "Variables";
    public static final String VARIABLE_TAG_NAME = "Variable";
    public static final String KEY_ATTR_NAME = "Key";
    public static final String STATUS_TAG_NAME = "Status";
    public static final String LIVE_STATUS_TAG_NAME = "LiveStatus";
    public static final String DATABASE_UUID_TAG_NAME = "DatabaseUUID";
    public static final String DB_REQ_STATUS_TAG_NAME = "DatabaseRequirementsStatus";
    public static final String REGION_ATTR_NAME = "Region";
    public static final String HOST_KEY = "HOST";
    private final String name;
    private final String templateName;
    private final Map<String, String> options;
    private final Map<String, Map<String, String>> groupOptions;
    private final Map<String, Map<String, String>> tagConstraints;
    private final Map<String, String> variables;
    private final DescriptionArchives archives;
    private final Description.Status status;
    private final String databaseUuid;
    private final List<DescriptionBackoffStats> backoffStats;
    private final Alarm lastError;
    private final Description.LiveStatus liveStatus;
    private final Map<String, List<String>> unmetMessages;

    public static Description getUnmanagedDescription(String dbName) {
        return new DescriptionBuilder().withName(dbName).withTemplateName("UnmanagedTemplate").withStatus(Description.Status.STARTED).withLiveStatus(Description.LiveStatus.STARTED).withUnmetMessages(new HashMap<String, List<String>>()).build();
    }

    public static Description decodeConfig(Tag descriptionTag) throws XmlException {
        return new DescriptionTagDecoder(descriptionTag).decodeConfig();
    }

    public static Description decodeMessage(Tag descriptionTag) throws XmlException {
        return new DescriptionTagDecoder(descriptionTag).decodeMessage();
    }

    private DescriptionImpl(String name, String templateName, Map<String, String> options, Map<String, Map<String, String>> groupOptions, Map<String, Map<String, String>> tagConstraints, Map<String, String> variables, DescriptionArchives archives, Description.Status status, String databaseUuid, Description.LiveStatus liveStatus, Map<String, List<String>> unmetMessages, List<DescriptionBackoffStats> backoffStats, Alarm lastError) {
        this.name = name;
        this.templateName = templateName;
        this.options = Collections.unmodifiableMap(options);
        this.groupOptions = Collections.unmodifiableMap(groupOptions);
        this.tagConstraints = Collections.unmodifiableMap(tagConstraints);
        this.variables = Collections.unmodifiableMap(variables);
        this.archives = DescriptionArchives.withUnmodifiableMap(archives);
        this.status = status;
        this.databaseUuid = databaseUuid;
        this.liveStatus = liveStatus;
        this.unmetMessages = unmetMessages != null ? Collections.unmodifiableMap(unmetMessages) : null;
        this.backoffStats = backoffStats != null ? Collections.unmodifiableList(backoffStats) : null;
        this.lastError = lastError;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public Map<String, Map<String, String>> getGroupOptions() {
        return this.groupOptions;
    }

    @Override
    public Map<String, Map<String, String>> getTagConstraints() {
        return this.tagConstraints;
    }

    @Override
    public Map<String, String> getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, String> getVariables(Mapper<String, String> idMapper) {
        HashMap<String, String> mappedVariables = new HashMap<String, String>(this.variables);
        String premappedHostId = (String)mappedVariables.remove(HOST_KEY);
        if (premappedHostId != null) {
            mappedVariables.put(HOST_KEY, idMapper.map(premappedHostId));
        }
        return mappedVariables;
    }

    @Override
    public DescriptionArchives getArchives() {
        return this.archives;
    }

    @Override
    public Description.Status getStatus() {
        return this.status;
    }

    @Override
    public String getDatabaseUuid() {
        return this.databaseUuid;
    }

    @Override
    public Description.LiveStatus getLiveStatus() {
        return this.liveStatus;
    }

    @Override
    public Map<String, List<String>> getUnmetMessages() {
        return this.unmetMessages;
    }

    @Override
    public List<DescriptionBackoffStats> getBackoffStatus() {
        return this.backoffStats;
    }

    @Override
    public Tag getLastEnforcerFailedAlarm() {
        return this.lastError != null ? this.lastError.toTag() : null;
    }

    public String toString() {
        return String.format("Description[name=%s, templateName=%s, options=%s, groupOptions=%s, tagConstraints=%s, variables=%s, archives=%s, status=%s, databaseUuid=%s, liveStatus=%s, unmetMessages=%s backoffStats=%s, lastError=%s]", new Object[]{this.name, this.templateName, this.options, this.groupOptions, this.tagConstraints, this.variables, this.archives, this.status, this.databaseUuid, this.liveStatus, this.unmetMessages, this.backoffStats, this.lastError != null ? Long.toString(this.lastError.getSignalTime()) : ""});
    }

    @Override
    public Tag encodeBase() {
        return this.encodeBase(TagFactory.createTag(DESCRIPTION_TAG_NAME));
    }

    @Override
    public Tag encodeBase(Tag tag) {
        return this.encodeBase(tag, new Mapper<String, String>(){

            @Override
            public String map(String arg) {
                return arg;
            }
        });
    }

    private Tag encodeBase(Tag tag, Mapper<String, String> idMapper) {
        tag.addAttribute(DATABASE_NAME_ATTR_NAME, this.name);
        tag.addChild(TEMPLATE_TAG_NAME).setText(this.templateName);
        tag.addChild(DescriptionImpl.getTagFromMap(this.options, OPTION_LIST_TAG_NAME, OPTION_TAG_NAME));
        tag.addChild(DescriptionImpl.getTagFromGroupedMap(this.groupOptions, GROUP_OPTION_LIST_TAG_NAME, GROUP_OPTION_TAG_NAME));
        tag.addChild(DescriptionImpl.getTagFromGroupedMap(this.tagConstraints, TAG_CONSTRAINT_LIST_TAG_NAME, TAG_CONSTRAINT_TAG_NAME));
        tag.addChild(DescriptionImpl.getTagFromMap(this.getVariables(idMapper), VARIABLE_LIST_TAG_NAME, VARIABLE_TAG_NAME));
        tag.addChild(ArchiveUtil.getArchivesTag(this.archives, idMapper));
        if (this.status != null) {
            tag.addChild(STATUS_TAG_NAME).setText(this.status.toString());
        }
        if (this.databaseUuid != null) {
            tag.addChild(DATABASE_UUID_TAG_NAME).setText(this.databaseUuid);
        }
        return tag;
    }

    private static Tag getTagFromMap(Map<String, String> map, String mapTagName, String entryTagName) {
        Tag tag = TagFactory.createTag(mapTagName);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Tag entryTag = tag.addChild(entryTagName);
            entryTag.addAttribute(KEY_ATTR_NAME, entry.getKey());
            entryTag.setText(entry.getValue());
        }
        return tag;
    }

    private static Tag getTagFromGroupedMap(Map<String, Map<String, String>> groupedMap, String groupedMapTagName, String entryTagName) {
        Tag tag = TagFactory.createTag(groupedMapTagName);
        for (Map.Entry<String, Map<String, String>> groupEntry : groupedMap.entrySet()) {
            Tag groupTag = DescriptionImpl.getTagFromMap(groupEntry.getValue(), PROCESS_GROUP_TAG_NAME, entryTagName);
            groupTag.addAttribute(PROCESS_GROUP_NAME_ATTR_NAME, groupEntry.getKey());
            tag.addChild(groupTag);
        }
        return tag;
    }

    public static class DescriptionTagDecoder {
        private Tag descriptionTag;

        public DescriptionTagDecoder(Tag descriptionTag) {
            this(descriptionTag, false);
        }

        public DescriptionTagDecoder(Tag descriptionTag, boolean checkName) {
            Preconditions.checkArgument(!checkName || descriptionTag.isNamed(DescriptionImpl.DESCRIPTION_TAG_NAME), "Invalid description tag: " + descriptionTag);
            this.descriptionTag = descriptionTag;
        }

        public Description decodeConfig() throws XmlException {
            return new DescriptionImpl(this.getName(), this.getTemplateName(), this.getOptions(), this.getGroupOptions(), this.getTagConstraints(), this.getVariables(), this.getArchives(), this.getStatus(), this.getDatabaseUuid(), null, null, null, this.getLastEnforcerFailedAlarm());
        }

        public Description decodeMessage() throws XmlException {
            return new DescriptionImpl(this.getName(), this.getTemplateName(), this.getOptions(), this.getGroupOptions(), this.getTagConstraints(), this.getVariables(), this.getArchives(), this.getStatus(), this.getDatabaseUuid(), this.getLiveStatus(), this.getUnmetMessages(), this.getBackoffStatus(), this.getLastEnforcerFailedAlarm());
        }

        public String getName() throws XmlException {
            return this.descriptionTag.getAttribute(DescriptionImpl.DATABASE_NAME_ATTR_NAME);
        }

        public String getTemplateName() throws XmlException {
            Tag templateTag = this.descriptionTag.getChild(DescriptionImpl.TEMPLATE_TAG_NAME);
            return templateTag.getText();
        }

        public Map<String, String> getOptions() throws XmlException {
            return DescriptionTagDecoder.getMap(this.descriptionTag.findChild(DescriptionImpl.OPTION_LIST_TAG_NAME), DescriptionImpl.OPTION_TAG_NAME);
        }

        public Map<String, Map<String, String>> getGroupOptions() throws XmlException {
            return DescriptionTagDecoder.getGroupedMap(this.descriptionTag.findChild(DescriptionImpl.GROUP_OPTION_LIST_TAG_NAME), DescriptionImpl.GROUP_OPTION_TAG_NAME);
        }

        public Map<String, Map<String, String>> getTagConstraints() throws XmlException {
            return DescriptionTagDecoder.getGroupedMap(this.descriptionTag.findChild(DescriptionImpl.TAG_CONSTRAINT_LIST_TAG_NAME), DescriptionImpl.TAG_CONSTRAINT_TAG_NAME);
        }

        public Map<String, String> getVariables() throws XmlException {
            return DescriptionTagDecoder.getMap(this.descriptionTag.findChild(DescriptionImpl.VARIABLE_LIST_TAG_NAME), DescriptionImpl.VARIABLE_TAG_NAME);
        }

        public DescriptionArchives getArchives() {
            return ArchiveUtil.getArchives(this.descriptionTag);
        }

        public Description.Status getStatus() {
            Tag statusTag = this.descriptionTag.findChild(DescriptionImpl.STATUS_TAG_NAME);
            if (statusTag != null) {
                try {
                    return Description.Status.valueOf(statusTag.getText());
                }
                catch (IllegalArgumentException e) {
                    Description.LiveStatus liveStatus = Description.LiveStatus.valueOf(statusTag.getText());
                    if (liveStatus == Description.LiveStatus.STOPPED) {
                        return Description.Status.STOPPED;
                    }
                    return Description.Status.STARTED;
                }
            }
            return null;
        }

        public Description.LiveStatus getLiveStatus() {
            Tag liveStatusTag = this.descriptionTag.findChild(DescriptionImpl.LIVE_STATUS_TAG_NAME);
            if (liveStatusTag != null) {
                return Description.LiveStatus.valueOf(liveStatusTag.getText());
            }
            Tag statusTag = this.descriptionTag.findChild(DescriptionImpl.STATUS_TAG_NAME);
            if (statusTag != null) {
                return Description.LiveStatus.valueOf(statusTag.getText());
            }
            return null;
        }

        public String getDatabaseUuid() {
            Tag uuidTag = this.descriptionTag.findChild(DescriptionImpl.DATABASE_UUID_TAG_NAME);
            if (uuidTag != null) {
                return uuidTag.getText();
            }
            return null;
        }

        public Map<String, List<String>> getUnmetMessages() throws XmlException {
            HashMap<String, List<String>> regionMessages = new HashMap<String, List<String>>();
            Tag reqStatusTag = this.descriptionTag.findChild(DescriptionImpl.DB_REQ_STATUS_TAG_NAME);
            if (reqStatusTag == null) {
                return null;
            }
            for (Tag regionMessagesTag : reqStatusTag) {
                String regionName = regionMessagesTag.getAttribute(DescriptionImpl.REGION_ATTR_NAME);
                ArrayList<String> messages = new ArrayList<String>();
                regionMessages.put(regionName, messages);
                for (Tag processStatusTag : regionMessagesTag) {
                    messages.add(processStatusTag.getText());
                }
            }
            return regionMessages;
        }

        public List<DescriptionBackoffStats> getBackoffStatus() throws XmlException {
            Tag backoffTag = this.descriptionTag.findChild("Backoff");
            if (backoffTag == null) {
                return null;
            }
            ArrayList<DescriptionBackoffStats> statsMessages = new ArrayList<DescriptionBackoffStats>();
            for (Tag statsTag : backoffTag) {
                statsMessages.add(new DescriptionBackoffStats(statsTag));
            }
            return statsMessages;
        }

        public Alarm getLastEnforcerFailedAlarm() throws XmlException {
            Tag alarmTag;
            Tag errorsTag = this.descriptionTag.findChild("Errors");
            if (errorsTag != null && (alarmTag = errorsTag.findChild("LastEnforcerFailedAlarm")) != null) {
                return new Alarm(alarmTag);
            }
            return null;
        }

        private static Map<String, String> getMap(Tag mapTag, String entryTagName) throws XmlException {
            HashMap<String, String> map = new HashMap<String, String>();
            if (mapTag != null) {
                for (Tag entry : mapTag) {
                    Preconditions.checkArgument(entry.isNamed(entryTagName), "Expected tag %s but found %s", entryTagName, entry.getName());
                    String key = entry.getAttribute(DescriptionImpl.KEY_ATTR_NAME);
                    String value = entry.getText();
                    if (value == null) continue;
                    map.put(key, value);
                }
            }
            return map;
        }

        private static Map<String, Map<String, String>> getGroupedMap(Tag groupedMapTag, String entryTagName) throws XmlException {
            HashMap<String, Map<String, String>> groupedMap = new HashMap<String, Map<String, String>>();
            if (groupedMapTag != null) {
                for (Tag groupTag : groupedMapTag) {
                    Preconditions.checkArgument(groupTag.isNamed(DescriptionImpl.PROCESS_GROUP_TAG_NAME), "Expected %s but found %s", DescriptionImpl.PROCESS_GROUP_TAG_NAME, groupTag.getName());
                    String groupName = groupTag.getAttribute(DescriptionImpl.PROCESS_GROUP_NAME_ATTR_NAME);
                    Map<String, String> map = DescriptionTagDecoder.getMap(groupTag, entryTagName);
                    if (map.isEmpty()) continue;
                    groupedMap.put(groupName, Collections.unmodifiableMap(map));
                }
            }
            return groupedMap;
        }
    }

    public static class DescriptionBuilder {
        private String name = null;
        private String templateName = null;
        private Map<String, String> options = new HashMap<String, String>();
        private Map<String, Map<String, String>> groupOptions = new HashMap<String, Map<String, String>>();
        private Map<String, Map<String, String>> tagConstraints = new HashMap<String, Map<String, String>>();
        private Map<String, String> variables = new HashMap<String, String>();
        private DescriptionArchives archives = new DescriptionArchives();
        private Description.Status status = null;
        private String databaseUuid = null;
        private Description.LiveStatus liveStatus = null;
        private Map<String, List<String>> unmetMessages = null;
        private Alarm lastError = null;

        public DescriptionBuilder() {
        }

        public DescriptionBuilder(Description description) {
            this.withName(description.getName());
            this.withTemplateName(description.getTemplateName());
            this.withOptions(description.getOptions());
            this.withGroupOptions(description.getGroupOptions());
            this.withTagConstraints(description.getTagConstraints());
            this.withVariables(description.getVariables());
            this.withArchives(description.getArchives());
            this.withStatus(description.getStatus());
            this.withDatabaseUuid(description.getDatabaseUuid());
            this.withLiveStatus(description.getLiveStatus());
            this.withUnmetMessages(description.getUnmetMessages());
            this.withLastError(description.getLastEnforcerFailedAlarm());
        }

        public DescriptionBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public DescriptionBuilder withTemplateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public DescriptionBuilder withOptions(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public DescriptionBuilder withGroupOptions(Map<String, Map<String, String>> groupOptions) {
            this.groupOptions = groupOptions;
            return this;
        }

        public DescriptionBuilder withTagConstraints(Map<String, Map<String, String>> tagConstraints) {
            this.tagConstraints = tagConstraints;
            return this;
        }

        public DescriptionBuilder withVariables(Map<String, String> variables) {
            this.variables = variables;
            return this;
        }

        public DescriptionBuilder withArchives(DescriptionArchives archives) {
            this.archives = archives;
            return this;
        }

        public DescriptionBuilder withStatus(Description.Status status) {
            this.status = status;
            return this;
        }

        public DescriptionBuilder withDatabaseUuid(String databaseUuid) {
            this.databaseUuid = databaseUuid;
            return this;
        }

        public DescriptionBuilder withLiveStatus(Description.LiveStatus liveStatus) {
            this.liveStatus = liveStatus;
            return this;
        }

        public DescriptionBuilder withUnmetMessages(Map<String, List<String>> unmetMessages) {
            this.unmetMessages = unmetMessages;
            return this;
        }

        public void withLastError(Tag lastError) {
            if (lastError != null) {
                try {
                    this.lastError = new Alarm(lastError);
                }
                catch (XmlException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        public DescriptionImpl build() {
            return new DescriptionImpl(this.name, this.templateName, this.options, this.groupOptions, this.tagConstraints, this.variables, this.archives, this.status, this.databaseUuid, this.liveStatus, this.unmetMessages, null, this.lastError);
        }

        public Tag encodeConfig() {
            return this.build().encodeBase();
        }

        public Tag encodeMessage(Mapper<String, String> idMapper, Description.LiveStatus liveStatus, Tag requirementsStatus, Tag backoffStatus, Tag errorsTag) {
            DescriptionImpl description = this.build();
            Tag descriptionTag = description.encodeBase(TagFactory.createTag(DescriptionImpl.DESCRIPTION_TAG_NAME), idMapper);
            descriptionTag.addChild(DescriptionImpl.LIVE_STATUS_TAG_NAME).setText(liveStatus.toString());
            descriptionTag.addChild(requirementsStatus);
            descriptionTag.addChild(backoffStatus);
            descriptionTag.addChild(errorsTag);
            return descriptionTag;
        }
    }
}

