/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class SwingWorker<T, V>
implements Future<T>,
Runnable {
    private static final int \u0106 = 10;
    private volatile int \u0102;
    private volatile StateValue \u0103;
    private final FutureTask<T> \u0107;
    private final PropertyChangeSupport \u0108;
    private com.jidesoft.utils.B<V> \u0105;
    private com.jidesoft.utils.B<Integer> \u0101;
    private static final com.jidesoft.utils.B<Runnable> \u0104 = new A();
    private static ExecutorService \u0109 = null;

    public SwingWorker() {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                SwingWorker.this.\u0101(StateValue.STARTED);
                return SwingWorker.this.doInBackground();
            }
        };
        this.\u0107 = new FutureTask<T>(callable){

            @Override
            protected void done() {
                SwingWorker.this.\u0102();
                SwingWorker.this.\u0101(StateValue.DONE);
            }
        };
        this.\u0103 = StateValue.PENDING;
        this.\u0108 = new B(this);
        this.\u0105 = null;
        this.\u0101 = null;
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        this.\u0107.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void publish(V ... VArray) {
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.\u0105 == null) {
                this.\u0105 = new com.jidesoft.utils.B<V>(){

                    @Override
                    public void \u0101(List<V> list) {
                        SwingWorker.this.process(list);
                    }

                    @Override
                    protected void \u0102() {
                        \u0104.\u0101(this);
                    }
                };
            }
        }
        this.\u0105.\u0101(VArray);
    }

    protected void process(List<V> list) {
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProgress(int n2) {
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException("the value should be from 0 to 100");
        }
        if (this.\u0102 == n2) {
            return;
        }
        int n3 = this.\u0102;
        this.\u0102 = n2;
        if (!this.getPropertyChangeSupport().hasListeners("progress")) {
            return;
        }
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.\u0101 == null) {
                this.\u0101 = new com.jidesoft.utils.B<Integer>(){

                    @Override
                    public void \u0101(List<Integer> list) {
                        SwingWorker.this.firePropertyChange("progress", list.get(0), list.get(list.size() - 1));
                    }

                    @Override
                    protected void \u0102() {
                        \u0104.\u0101(this);
                    }
                };
            }
        }
        this.\u0101.\u0101((Integer[])new Integer[]{n3, n2});
    }

    public final int getProgress() {
        return this.\u0102;
    }

    public final void execute() {
        SwingWorker.\u0103().execute(this);
    }

    @Override
    public final boolean cancel(boolean bl) {
        return this.\u0107.cancel(bl);
    }

    @Override
    public final boolean isCancelled() {
        return this.\u0107.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.\u0107.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.\u0107.get();
    }

    @Override
    public final T get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.\u0107.get(l2, timeUnit);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    public final PropertyChangeSupport getPropertyChangeSupport() {
        return this.\u0108;
    }

    public final StateValue getState() {
        if (this.isDone()) {
            return StateValue.DONE;
        }
        return this.\u0103;
    }

    private void \u0101(StateValue stateValue) {
        StateValue stateValue2 = this.\u0103;
        this.\u0103 = stateValue;
        this.firePropertyChange("state", (Object)stateValue2, (Object)stateValue);
    }

    private void \u0102() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.done();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            \u0104.\u0101((Runnable[])new Runnable[]{runnable});
        }
    }

    private static synchronized ExecutorService \u0103() {
        if (\u0109 == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                final AtomicInteger \u0101 = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable runnable) {
                    StringBuilder stringBuilder = new StringBuilder("SwingWorker-pool-");
                    stringBuilder.append(System.identityHashCode(this));
                    stringBuilder.append("-thread-");
                    stringBuilder.append(this.\u0101.getAndIncrement());
                    Thread thread = new Thread(runnable, stringBuilder.toString());
                    if (thread.isDaemon()) {
                        thread.setDaemon(false);
                    }
                    if (thread.getPriority() != 5) {
                        thread.setPriority(5);
                    }
                    return thread;
                }
            };
            \u0109 = new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory){
                private final ReentrantLock \u0104 = new ReentrantLock();
                private final Condition \u0102 = this.\u0104.newCondition();
                private boolean \u0101 = false;
                private final ReentrantLock \u0103 = new ReentrantLock();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(Runnable runnable) {
                    this.\u0103.lock();
                    try {
                        this.\u0104.lock();
                        try {
                            this.\u0101 = true;
                        }
                        finally {
                            this.\u0104.unlock();
                        }
                        this.setCorePoolSize(10);
                        super.execute(runnable);
                        this.setCorePoolSize(0);
                        this.\u0104.lock();
                        try {
                            this.\u0101 = false;
                            this.\u0102.signalAll();
                        }
                        finally {
                            this.\u0104.unlock();
                        }
                    }
                    finally {
                        this.\u0103.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void afterExecute(Runnable runnable, Throwable throwable) {
                    super.afterExecute(runnable, throwable);
                    this.\u0104.lock();
                    try {
                        while (this.\u0101) {
                            this.\u0102.await();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.\u0104.unlock();
                    }
                }
            };
        }
        return \u0109;
    }

    private class B
    extends PropertyChangeSupport {
        B(Object object) {
            super(object);
        }

        @Override
        public void firePropertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(propertyChangeEvent);
            } else {
                \u0104.\u0101(new Runnable(){

                    @Override
                    public void run() {
                        B.this.firePropertyChange(propertyChangeEvent);
                    }
                });
            }
        }
    }

    private static class A
    extends com.jidesoft.utils.B<Runnable>
    implements ActionListener {
        private static final int \u0104 = 33;

        private A() {
        }

        @Override
        protected void \u0101(List<Runnable> list) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }

        @Override
        protected void \u0102() {
            Timer timer = new Timer(33, this);
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }

    public static enum StateValue {
        PENDING,
        STARTED,
        DONE;

    }
}

