/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Comparator;
import java.util.Random;
import java.util.StringTokenizer;

public abstract class ArrayLib {
    public static final int SORT_THRESHOLD = 30;

    public static final void shuffle(int[] nArray, Random random) {
        ArrayLib.shuffle(nArray, 0, nArray.length, random);
    }

    public static final void shuffle(int[] nArray, int n2, int n3, Random random) {
        int n4 = n2 + n3;
        while (--n4 > 0) {
            int n5 = nArray[n4];
            int n6 = random.nextInt(n4);
            nArray[n4] = nArray[n6];
            nArray[n6] = n5;
        }
    }

    public static final void shuffle(long[] lArray, Random random) {
        ArrayLib.shuffle(lArray, 0, lArray.length, random);
    }

    public static final void shuffle(long[] lArray, int n2, int n3, Random random) {
        for (int i2 = n2 + n3; i2 > 1; --i2) {
            long l2 = lArray[i2];
            int n4 = random.nextInt(i2);
            lArray[i2] = lArray[n4];
            lArray[n4] = l2;
        }
    }

    public static final void shuffle(float[] fArray, Random random) {
        ArrayLib.shuffle(fArray, 0, fArray.length, random);
    }

    public static final void shuffle(float[] fArray, int n2, int n3, Random random) {
        for (int i2 = n2 + n3; i2 > 1; --i2) {
            float f2 = fArray[i2];
            int n4 = random.nextInt(i2);
            fArray[i2] = fArray[n4];
            fArray[n4] = f2;
        }
    }

    public static final void shuffle(double[] dArray, Random random) {
        ArrayLib.shuffle(dArray, 0, dArray.length, random);
    }

    public static final void shuffle(double[] dArray, int n2, int n3, Random random) {
        for (int i2 = n2 + n3; i2 > 1; --i2) {
            double d2 = dArray[i2];
            int n4 = random.nextInt(i2);
            dArray[i2] = dArray[n4];
            dArray[n4] = d2;
        }
    }

    public static final void shuffle(Object[] objectArray, Random random) {
        ArrayLib.shuffle(objectArray, 0, objectArray.length, random);
    }

    public static final void shuffle(Object[] objectArray, int n2, int n3, Random random) {
        for (int i2 = n2 + n3; i2 > 1; --i2) {
            Object object = objectArray[i2];
            int n4 = random.nextInt(i2);
            objectArray[i2] = objectArray[n4];
            objectArray[n4] = object;
        }
    }

    public static final double max(double[] dArray) {
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] > d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static final double min(double[] dArray) {
        double d2 = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] < d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static final int binarySearch(int[] nArray, int n2) {
        int n3 = 0;
        int n4 = nArray.length;
        int n5 = n4 / 2;
        while (n3 < n4) {
            if (nArray[n5] == n2) {
                return n5;
            }
            if (nArray[n5] < n2) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(int[] nArray, int n2, int n3) {
        int n4 = 0;
        int n5 = n3;
        int n6 = n5 / 2;
        while (n4 < n5) {
            if (nArray[n6] == n2) {
                return n6;
            }
            if (nArray[n6] < n2) {
                n4 = n6 + 1;
            } else {
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
        }
        return -1 * (n6 + 1);
    }

    public static final int binarySearch(int[] nArray, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        int n7 = n5 + (n6 - n5) / 2;
        while (n5 < n6) {
            if (nArray[n7] == n2) {
                return n7;
            }
            if (nArray[n7] < n2) {
                n5 = n7 + 1;
            } else {
                n6 = n7;
            }
            n7 = n5 + (n6 - n5) / 2;
        }
        return -1 * (n7 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object) {
        int n2 = 0;
        int n3 = objectArray.length;
        int n4 = n3 / 2;
        while (n2 < n3) {
            int n5 = ((Comparable)objectArray[n4]).compareTo(object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * (n4 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = n4 / 2;
        while (n3 < n4) {
            int n6 = ((Comparable)objectArray[n5]).compareTo(object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = n4 + (n5 - n4) / 2;
        while (n4 < n5) {
            int n7 = ((Comparable)objectArray[n6]).compareTo(object);
            if (n7 == 0) {
                return n6;
            }
            if (n7 < 0) {
                n4 = n6 + 1;
            } else {
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
        }
        return -1 * (n6 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator) {
        int n2 = 0;
        int n3 = objectArray.length;
        int n4 = n3 / 2;
        while (n2 < n3) {
            int n5 = comparator.compare(objectArray[n4], object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * (n4 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = n4 / 2;
        while (n3 < n4) {
            int n6 = comparator.compare(objectArray[n5], object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = n4 + (n5 - n4) / 2;
        while (n4 < n5) {
            int n7 = comparator.compare(objectArray[n6], object);
            if (n7 == 0) {
                return n6;
            }
            if (n7 < 0) {
                n4 = n6 + 1;
            } else {
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
        }
        return -1 * (n6 + 1);
    }

    public static final int find(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static final int find(int[] nArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static final int find(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = n3; i2 < n4; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static final int[] resize(int[] nArray, int n2) {
        if (nArray.length >= n2) {
            return nArray;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final float[] resize(float[] fArray, int n2) {
        if (fArray.length >= n2) {
            return fArray;
        }
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public static final double[] resize(double[] dArray, int n2) {
        if (dArray.length >= n2) {
            return dArray;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static final Object[] resize(Object[] objectArray, int n2) {
        if (objectArray.length >= n2) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static final int[] trim(int[] nArray, int n2) {
        if (nArray.length == n2) {
            return nArray;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static final float[] trim(float[] fArray, int n2) {
        if (fArray.length == n2) {
            return fArray;
        }
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        return fArray2;
    }

    public static final double[] trim(double[] dArray, int n2) {
        if (dArray.length == n2) {
            return dArray;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        return dArray2;
    }

    public static final Object[] trim(Object[] objectArray, int n2) {
        if (objectArray.length == n2) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    public static final void sort(int[] nArray, double[] dArray) {
        ArrayLib.mergesort(nArray, dArray, 0, nArray.length - 1);
    }

    public static final void sort(int[] nArray, double[] dArray, int n2) {
        ArrayLib.mergesort(nArray, dArray, 0, n2 - 1);
    }

    public static final void sort(int[] nArray, double[] dArray, int n2, int n3) {
        ArrayLib.mergesort(nArray, dArray, n2, n3 - 1);
    }

    protected static final void insertionsort(int[] nArray, double[] dArray, int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n4 = nArray[i2];
            double d2 = dArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && nArray[i3] > n4; --i3) {
                nArray[i3 + 1] = nArray[i3];
                dArray[i3 + 1] = dArray[i3];
            }
            nArray[i3 + 1] = n4;
            dArray[i3 + 1] = d2;
        }
    }

    protected static final void mergesort(int[] nArray, double[] dArray, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        if (n3 - n2 + 1 < 30) {
            ArrayLib.insertionsort(nArray, dArray, n2, n3);
        } else {
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(nArray, dArray, n2, n4);
            ArrayLib.mergesort(nArray, dArray, n4 + 1, n3);
            ArrayLib.merge(nArray, dArray, n2, n4, n3);
        }
    }

    protected static final void merge(int[] nArray, double[] dArray, int n2, int n3, int n4) {
        int[] nArray2 = new int[n4 - n2 + 1];
        double[] dArray2 = new double[n4 - n2 + 1];
        int n5 = n2;
        int n6 = n3 + 1;
        int n7 = 0;
        while (n5 <= n3 && n6 <= n4) {
            if (nArray[n5] < nArray[n6]) {
                dArray2[n7] = dArray[n5];
                nArray2[n7] = nArray[n5++];
            } else {
                dArray2[n7] = dArray[n6];
                nArray2[n7] = nArray[n6++];
            }
            ++n7;
        }
        while (n5 <= n3) {
            dArray2[n7] = dArray[n5];
            nArray2[n7] = nArray[n5];
            ++n5;
            ++n7;
        }
        while (n6 <= n4) {
            dArray2[n7] = dArray[n6];
            nArray2[n7] = nArray[n6];
            ++n6;
            ++n7;
        }
        n7 = 0;
        n5 = n2;
        while (n7 < nArray2.length) {
            dArray[n5] = dArray2[n7];
            nArray[n5] = nArray2[n7];
            ++n7;
            ++n5;
        }
    }

    public static final void sort(int[] nArray, int[] nArray2) {
        ArrayLib.mergesort(nArray, nArray2, 0, nArray.length - 1);
    }

    public static final void sort(int[] nArray, int[] nArray2, int n2) {
        ArrayLib.mergesort(nArray, nArray2, 0, n2 - 1);
    }

    public static final void sort(int[] nArray, int[] nArray2, int n2, int n3) {
        ArrayLib.mergesort(nArray, nArray2, n2, n3 - 1);
    }

    protected static final void insertionsort(int[] nArray, int[] nArray2, int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n4 = nArray[i2];
            int n5 = nArray2[i2];
            for (int i3 = i2 - 1; i3 >= n2 && nArray[i3] > n4; --i3) {
                nArray[i3 + 1] = nArray[i3];
                nArray2[i3 + 1] = nArray2[i3];
            }
            nArray[i3 + 1] = n4;
            nArray2[i3 + 1] = n5;
        }
    }

    protected static final void mergesort(int[] nArray, int[] nArray2, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        if (n3 - n2 + 1 < 30) {
            ArrayLib.insertionsort(nArray, nArray2, n2, n3);
        } else {
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(nArray, nArray2, n2, n4);
            ArrayLib.mergesort(nArray, nArray2, n4 + 1, n3);
            ArrayLib.merge(nArray, nArray2, n2, n4, n3);
        }
    }

    protected static final void merge(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        int[] nArray3 = new int[n4 - n2 + 1];
        int[] nArray4 = new int[n4 - n2 + 1];
        int n5 = n2;
        int n6 = n3 + 1;
        int n7 = 0;
        while (n5 <= n3 && n6 <= n4) {
            if (nArray[n5] < nArray[n6]) {
                nArray4[n7] = nArray2[n5];
                nArray3[n7] = nArray[n5++];
            } else {
                nArray4[n7] = nArray2[n6];
                nArray3[n7] = nArray[n6++];
            }
            ++n7;
        }
        while (n5 <= n3) {
            nArray4[n7] = nArray2[n5];
            nArray3[n7] = nArray[n5];
            ++n5;
            ++n7;
        }
        while (n6 <= n4) {
            nArray4[n7] = nArray2[n6];
            nArray3[n7] = nArray[n6];
            ++n6;
            ++n7;
        }
        n7 = 0;
        n5 = n2;
        while (n7 < nArray3.length) {
            nArray2[n5] = nArray4[n7];
            nArray[n5] = nArray3[n7];
            ++n7;
            ++n5;
        }
    }

    public static final void sort(int[] nArray, Object[] objectArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 30) {
            ArrayLib.insertionsort(nArray, objectArray, n2, n3 - 1);
            return;
        }
        int[] nArray2 = new int[n4];
        Object[] objectArray2 = new Object[n4];
        int n5 = 0;
        int n6 = n2;
        while (n5 < n4) {
            nArray2[n5] = nArray[n6];
            objectArray2[n5] = objectArray[n6];
            ++n5;
            ++n6;
        }
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n2, n3, -n2);
    }

    public static final void sort(int[] nArray, Object[] objectArray, int[] nArray2, Object[] objectArray2, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 30) {
            ArrayLib.insertionsort(nArray, objectArray, n2, n3 - 1);
            return;
        }
        int n5 = 0;
        int n6 = n2;
        while (n5 < n4) {
            nArray2[n5] = nArray[n6];
            objectArray2[n5] = objectArray[n6];
            ++n5;
            ++n6;
        }
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n2, n3, -n2);
    }

    protected static final void insertionsort(int[] nArray, Object[] objectArray, int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n4 = nArray[i2];
            Object object = objectArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && nArray[i3] > n4; --i3) {
                nArray[i3 + 1] = nArray[i3];
                objectArray[i3 + 1] = objectArray[i3];
            }
            nArray[i3 + 1] = n4;
            objectArray[i3 + 1] = object;
        }
    }

    protected static void mergesort(int[] nArray, int[] nArray2, Object[] objectArray, Object[] objectArray2, int n2, int n3, int n4) {
        int n5 = n3 - n2;
        if (n5 < 30) {
            ArrayLib.insertionsort(nArray2, objectArray2, n2, n3 - 1);
            return;
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = (n2 += n4) + (n3 += n4) >> 1;
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n2, n8, -n4);
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n8, n3, -n4);
        if (nArray[n8 - 1] <= nArray[n8]) {
            System.arraycopy(nArray, n2, nArray2, n6, n5);
            System.arraycopy(objectArray, n2, objectArray2, n6, n5);
            return;
        }
        int n9 = n2;
        int n10 = n8;
        for (int i2 = n6; i2 < n7; ++i2) {
            if (n10 >= n3 || n9 < n8 && nArray[n9] <= nArray[n10]) {
                objectArray2[i2] = objectArray[n9];
                nArray2[i2] = nArray[n9++];
                continue;
            }
            objectArray2[i2] = objectArray[n10];
            nArray2[i2] = nArray[n10++];
        }
    }

    protected static final void merge(int[] nArray, Object[] objectArray, int n2, int n3, int n4) {
        int[] nArray2 = new int[n4 - n2 + 1];
        Object[] objectArray2 = new Object[n4 - n2 + 1];
        int n5 = n2;
        int n6 = n3 + 1;
        int n7 = 0;
        while (n5 <= n3 && n6 <= n4) {
            if (nArray[n5] < nArray[n6]) {
                objectArray2[n7] = objectArray[n5];
                nArray2[n7] = nArray[n5++];
            } else {
                objectArray2[n7] = objectArray[n6];
                nArray2[n7] = nArray[n6++];
            }
            ++n7;
        }
        while (n5 <= n3) {
            objectArray2[n7] = objectArray[n5];
            nArray2[n7] = nArray[n5];
            ++n5;
            ++n7;
        }
        while (n6 <= n4) {
            objectArray2[n7] = objectArray[n6];
            nArray2[n7] = nArray[n6];
            ++n6;
            ++n7;
        }
        n7 = 0;
        n5 = n2;
        while (n7 < nArray2.length) {
            objectArray[n5] = objectArray2[n7];
            nArray[n5] = nArray2[n7];
            ++n7;
            ++n5;
        }
    }

    public static final void sort(double[] dArray, int[] nArray) {
        ArrayLib.mergesort(dArray, nArray, 0, dArray.length - 1);
    }

    public static final void sort(double[] dArray, int[] nArray, int n2) {
        ArrayLib.mergesort(dArray, nArray, 0, n2 - 1);
    }

    public static final void sort(double[] dArray, int[] nArray, int n2, int n3) {
        ArrayLib.mergesort(dArray, nArray, n2, n3 - 1);
    }

    protected static final void insertionsort(double[] dArray, int[] nArray, int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            double d2 = dArray[i2];
            int n4 = nArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && dArray[i3] > d2; --i3) {
                dArray[i3 + 1] = dArray[i3];
                nArray[i3 + 1] = nArray[i3];
            }
            dArray[i3 + 1] = d2;
            nArray[i3 + 1] = n4;
        }
    }

    protected static final void mergesort(double[] dArray, int[] nArray, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        if (n3 - n2 + 1 < 30) {
            ArrayLib.insertionsort(dArray, nArray, n2, n3);
        } else {
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(dArray, nArray, n2, n4);
            ArrayLib.mergesort(dArray, nArray, n4 + 1, n3);
            ArrayLib.merge(dArray, nArray, n2, n4, n3);
        }
    }

    protected static final void merge(double[] dArray, int[] nArray, int n2, int n3, int n4) {
        double[] dArray2 = new double[n4 - n2 + 1];
        int[] nArray2 = new int[n4 - n2 + 1];
        int n5 = n2;
        int n6 = n3 + 1;
        int n7 = 0;
        while (n5 <= n3 && n6 <= n4) {
            if (dArray[n5] < dArray[n6]) {
                nArray2[n7] = nArray[n5];
                dArray2[n7] = dArray[n5++];
            } else {
                nArray2[n7] = nArray[n6];
                dArray2[n7] = dArray[n6++];
            }
            ++n7;
        }
        while (n5 <= n3) {
            nArray2[n7] = nArray[n5];
            dArray2[n7] = dArray[n5];
            ++n5;
            ++n7;
        }
        while (n6 <= n4) {
            nArray2[n7] = nArray[n6];
            dArray2[n7] = dArray[n6];
            ++n6;
            ++n7;
        }
        n7 = 0;
        n5 = n2;
        while (n7 < dArray2.length) {
            nArray[n5] = nArray2[n7];
            dArray[n5] = dArray2[n7];
            ++n7;
            ++n5;
        }
    }

    public static final void sort(float[] fArray, int[] nArray) {
        ArrayLib.mergesort(fArray, nArray, 0, fArray.length - 1);
    }

    public static final void sort(float[] fArray, int[] nArray, int n2) {
        ArrayLib.mergesort(fArray, nArray, 0, n2 - 1);
    }

    public static final void sort(float[] fArray, int[] nArray, int n2, int n3) {
        ArrayLib.mergesort(fArray, nArray, n2, n3 - 1);
    }

    protected static final void insertionsort(float[] fArray, int[] nArray, int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            float f2 = fArray[i2];
            int n4 = nArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && fArray[i3] > f2; --i3) {
                fArray[i3 + 1] = fArray[i3];
                nArray[i3 + 1] = nArray[i3];
            }
            fArray[i3 + 1] = f2;
            nArray[i3 + 1] = n4;
        }
    }

    protected static final void mergesort(float[] fArray, int[] nArray, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        if (n3 - n2 + 1 < 30) {
            ArrayLib.insertionsort(fArray, nArray, n2, n3);
        } else {
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(fArray, nArray, n2, n4);
            ArrayLib.mergesort(fArray, nArray, n4 + 1, n3);
            ArrayLib.merge(fArray, nArray, n2, n4, n3);
        }
    }

    protected static final void merge(float[] fArray, int[] nArray, int n2, int n3, int n4) {
        float[] fArray2 = new float[n4 - n2 + 1];
        int[] nArray2 = new int[n4 - n2 + 1];
        int n5 = n2;
        int n6 = n3 + 1;
        int n7 = 0;
        while (n5 <= n3 && n6 <= n4) {
            if (fArray[n5] < fArray[n6]) {
                nArray2[n7] = nArray[n5];
                fArray2[n7] = fArray[n5++];
            } else {
                nArray2[n7] = nArray[n6];
                fArray2[n7] = fArray[n6++];
            }
            ++n7;
        }
        while (n5 <= n3) {
            nArray2[n7] = nArray[n5];
            fArray2[n7] = fArray[n5];
            ++n5;
            ++n7;
        }
        while (n6 <= n4) {
            nArray2[n7] = nArray[n6];
            fArray2[n7] = fArray[n6];
            ++n6;
            ++n7;
        }
        n7 = 0;
        n5 = n2;
        while (n7 < fArray2.length) {
            nArray[n5] = nArray2[n7];
            fArray[n5] = fArray2[n7];
            ++n7;
            ++n5;
        }
    }

    public static final void sort(Object[] objectArray, int[] nArray, Comparator comparator) {
        ArrayLib.mergesort(objectArray, nArray, 0, objectArray.length - 1, comparator);
    }

    public static final void sort(Object[] objectArray, int[] nArray, int n2, Comparator comparator) {
        ArrayLib.mergesort(objectArray, nArray, 0, n2 - 1, comparator);
    }

    public static final void sort(Object[] objectArray, int[] nArray, int n2, int n3, Comparator comparator) {
        ArrayLib.mergesort(objectArray, nArray, n2, n3 - 1, comparator);
    }

    protected static final void insertionsort(Object[] objectArray, int[] nArray, int n2, int n3, Comparator comparator) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            Object object = objectArray[i2];
            int n4 = nArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && comparator.compare(objectArray[i3], object) > 0; --i3) {
                objectArray[i3 + 1] = objectArray[i3];
                nArray[i3 + 1] = nArray[i3];
            }
            objectArray[i3 + 1] = object;
            nArray[i3 + 1] = n4;
        }
    }

    protected static final void mergesort(Object[] objectArray, int[] nArray, int n2, int n3, Comparator comparator) {
        if (n2 >= n3) {
            return;
        }
        if (n3 - n2 + 1 < 30) {
            ArrayLib.insertionsort(objectArray, nArray, n2, n3, comparator);
        } else {
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(objectArray, nArray, n2, n4, comparator);
            ArrayLib.mergesort(objectArray, nArray, n4 + 1, n3, comparator);
            ArrayLib.merge(objectArray, nArray, n2, n4, n3, comparator);
        }
    }

    protected static final void merge(Object[] objectArray, int[] nArray, int n2, int n3, int n4, Comparator comparator) {
        Object[] objectArray2 = new Object[n4 - n2 + 1];
        int[] nArray2 = new int[n4 - n2 + 1];
        int n5 = n2;
        int n6 = n3 + 1;
        int n7 = 0;
        while (n5 <= n3 && n6 <= n4) {
            if (comparator.compare(objectArray[n5], objectArray[n6]) < 0) {
                nArray2[n7] = nArray[n5];
                objectArray2[n7] = objectArray[n5++];
            } else {
                nArray2[n7] = nArray[n6];
                objectArray2[n7] = objectArray[n6++];
            }
            ++n7;
        }
        while (n5 <= n3) {
            nArray2[n7] = nArray[n5];
            objectArray2[n7] = objectArray[n5];
            ++n5;
            ++n7;
        }
        while (n6 <= n4) {
            nArray2[n7] = nArray[n6];
            objectArray2[n7] = objectArray[n6];
            ++n6;
            ++n7;
        }
        n7 = 0;
        n5 = n2;
        while (n7 < objectArray2.length) {
            nArray[n5] = nArray2[n7];
            objectArray[n5] = objectArray2[n7];
            ++n7;
            ++n5;
        }
    }

    public static int[] getIntArray(String string) {
        int[] nArray = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n2 = stringTokenizer.countTokens();
            int n3 = 0;
            nArray = new int[n2];
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("#")) continue;
                nArray[n3++] = Integer.parseInt(string3);
            }
            if (n3 != n2) {
                nArray = ArrayLib.trim(nArray, n3);
            }
            return nArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

