/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.tuple;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.event.TupleSetListener;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.data.expression.parser.ExpressionParser;
import com.jidesoft.thirdparty.prefuse.data.expression.parser.ParseException;
import com.jidesoft.thirdparty.prefuse.data.tuple.AbstractTupleSet;
import com.jidesoft.thirdparty.prefuse.data.tuple.TupleSet;
import com.jidesoft.thirdparty.prefuse.util.collections.CompositeIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class CompositeTupleSet
extends AbstractTupleSet {
    private static final Logger \u0108 = Logger.getLogger(CompositeTupleSet.class.getName());
    private Map \u0105 = new LinkedHashMap();
    private Set \u0107 = new HashSet();
    private int \u0104 = 0;
    private A \u0106;

    public CompositeTupleSet() {
        this(true);
    }

    protected CompositeTupleSet(boolean bl) {
        this.\u0106 = bl ? new A() : null;
    }

    public void addSet(String string, TupleSet tupleSet) {
        if (this.hasSet(string)) {
            throw new IllegalArgumentException("Name already in use: " + string);
        }
        this.\u0105.put(string, tupleSet);
        this.\u0107.add(tupleSet);
        this.\u0104 += tupleSet.getTupleCount();
        if (this.\u0106 != null) {
            tupleSet.addTupleSetListener(this.\u0106);
        }
    }

    public boolean hasSet(String string) {
        return this.\u0105.containsKey(string);
    }

    public boolean containsSet(TupleSet tupleSet) {
        return this.\u0107.contains(tupleSet);
    }

    public TupleSet getSet(String string) {
        return (TupleSet)this.\u0105.get(string);
    }

    public Iterator setNames() {
        return this.\u0105.keySet().iterator();
    }

    public Iterator sets() {
        return this.\u0105.values().iterator();
    }

    public TupleSet removeSet(String string) {
        TupleSet tupleSet = (TupleSet)this.\u0105.remove(string);
        if (tupleSet != null) {
            this.\u0107.remove(tupleSet);
            if (this.\u0106 != null) {
                tupleSet.removeTupleSetListener(this.\u0106);
            }
        }
        return tupleSet;
    }

    public void removeAllSets() {
        Iterator iterator = this.\u0105.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            iterator.remove();
            this.\u0107.remove(tupleSet);
            if (this.\u0106 == null) continue;
            tupleSet.removeTupleSetListener(this.\u0106);
        }
        this.\u0104 = 0;
    }

    @Override
    public void clear() {
        for (Map.Entry entry : this.\u0105.entrySet()) {
            ((TupleSet)entry.getValue()).clear();
        }
        this.\u0104 = 0;
    }

    @Override
    public Tuple addTuple(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tuple setTuple(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        Table table = tuple.getTable();
        if (this.\u0107.contains(table)) {
            return table.removeTuple(tuple);
        }
        return false;
    }

    @Override
    public boolean containsTuple(Tuple tuple) {
        Table table = tuple.getTable();
        return this.containsSet(table);
    }

    @Override
    public int getTupleCount() {
        if (this.\u0106 != null) {
            return this.\u0104;
        }
        int n2 = 0;
        Iterator iterator = this.\u0105.entrySet().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            n2 += tupleSet.getTupleCount();
            ++n3;
        }
        return n2;
    }

    @Override
    public Iterator tuples() {
        CompositeIterator compositeIterator = new CompositeIterator(this.\u0105.size());
        Iterator iterator = this.\u0105.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            compositeIterator.setIterator(n2, tupleSet.tuples());
            ++n2;
        }
        return compositeIterator;
    }

    @Override
    public Iterator tuples(Predicate predicate) {
        CompositeIterator compositeIterator = new CompositeIterator(this.\u0105.size());
        Iterator iterator = this.\u0105.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            compositeIterator.setIterator(n2, tupleSet.tuples(predicate));
            ++n2;
        }
        return compositeIterator;
    }

    @Override
    public boolean isAddColumnSupported() {
        return true;
    }

    @Override
    public void addColumn(String string, Class clazz, Object object) {
        for (Map.Entry entry : this.\u0105.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, clazz, object);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            \u0108.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String string, Class clazz) {
        for (Map.Entry entry : this.\u0105.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            \u0108.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String string, Expression expression) {
        for (Map.Entry entry : this.\u0105.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, expression);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            \u0108.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String string, String string2) {
        Expression expression = null;
        try {
            expression = ExpressionParser.parse(string2);
            Throwable throwable = ExpressionParser.getError();
            if (throwable != null) {
                throw new RuntimeException(throwable);
            }
            this.addColumn(string, expression);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    private class A
    implements TupleSetListener {
        private A() {
        }

        @Override
        public void tupleSetChanged(TupleSet tupleSet, Tuple[] tupleArray, Tuple[] tupleArray2) {
            CompositeTupleSet.this.\u0104 = CompositeTupleSet.this.\u0104 + (tupleArray.length - tupleArray2.length);
            CompositeTupleSet.this.fireTupleEvent(tupleArray, tupleArray2);
        }
    }
}

