/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Overlayable;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DefaultOverlayable
extends JPanel
implements Overlayable,
ComponentListener {
    private JComponent \u0104;
    private Insets \u0102 = new Insets(0, 0, 0, 0);
    private List<JComponent> \u0101;
    private Map<JComponent, Integer> \u0103;

    public DefaultOverlayable() {
        this.\u0101();
    }

    public DefaultOverlayable(JComponent jComponent) {
        this.\u0101();
        this.setActualComponent(jComponent);
    }

    public DefaultOverlayable(JComponent jComponent, JComponent jComponent2, int n2) {
        this.\u0101();
        this.setActualComponent(jComponent);
        this.addOverlayComponent(jComponent2, n2);
    }

    public DefaultOverlayable(JComponent jComponent, JComponent jComponent2) {
        this.\u0101();
        this.setActualComponent(jComponent);
        this.addOverlayComponent(jComponent2, 0);
    }

    private void \u0101() {
        this.setLayout(null);
        this.\u0101 = new Vector<JComponent>();
        this.\u0103 = new Hashtable<JComponent, Integer>();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getActualComponent() == null ? new Dimension(0, 0) : this.getActualComponent().getPreferredSize();
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            dimension.width += Math.max(0, insets.left) + Math.max(0, insets.right);
            dimension.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        return dimension;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        if (this.getActualComponent() != null) {
            Insets insets;
            if (dimension != null && (insets = this.getOverlayLocationInsets()) != null) {
                dimension.width -= Math.max(0, insets.left) + Math.max(0, insets.right);
                dimension.width = Math.max(0, dimension.width);
                dimension.height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
                dimension.height = Math.max(0, dimension.height);
            }
            this.getActualComponent().setPreferredSize(dimension);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.getActualComponent() == null ? new Dimension(0, 0) : this.getActualComponent().getMinimumSize();
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            dimension.width += Math.max(0, insets.left) + Math.max(0, insets.right);
            dimension.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        return dimension;
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(dimension);
        if (this.getActualComponent() != null) {
            Insets insets;
            if (dimension != null && (insets = this.getOverlayLocationInsets()) != null) {
                dimension.width -= Math.max(0, insets.left) + Math.max(0, insets.right);
                dimension.width = Math.max(0, dimension.width);
                dimension.height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
                dimension.height = Math.max(0, dimension.height);
            }
            this.getActualComponent().setMinimumSize(dimension);
        }
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            n2 = Math.max(0, insets.left);
            n3 = Math.max(0, insets.top);
            n4 -= Math.max(0, insets.left) + Math.max(0, insets.right);
            n5 -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        if (this.getActualComponent() != null) {
            this.getActualComponent().setBounds(n2, n3, n4, n5);
        }
        this.\u0102();
    }

    private void \u0102() {
        JComponent[] jComponentArray;
        for (JComponent jComponent : jComponentArray = this.getOverlayComponents()) {
            if (jComponent == null) {
                return;
            }
            Rectangle rectangle = this.getOverlayComponentBounds(jComponent);
            jComponent.setBounds(rectangle);
        }
    }

    protected Rectangle getOverlayComponentBounds(JComponent jComponent) {
        JComponent jComponent2 = this.getActualComponent();
        Rectangle rectangle = jComponent2.getBounds();
        if (jComponent2 != this.getActualComponent()) {
            rectangle = SwingUtilities.convertRectangle(jComponent2.getParent(), rectangle, this.getActualComponent());
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        Insets insets = this.getOverlayLocationInsets();
        rectangle2.x -= insets.left;
        rectangle2.y -= insets.top;
        rectangle2.width += insets.left + insets.right;
        rectangle2.height += insets.top + insets.bottom;
        int n2 = 0;
        int n3 = 0;
        Dimension dimension = jComponent.getPreferredSize();
        int n4 = dimension.width;
        int n5 = dimension.height;
        int n6 = this.getOverlayLocation(jComponent);
        if (n6 == 10) {
            if (jComponent.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                n6 = 7;
            } else if (jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                n6 = 3;
            }
        } else if (n6 == 11) {
            if (jComponent.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                n6 = 3;
            } else if (jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                n6 = 7;
            }
        }
        switch (n6) {
            case 0: {
                n2 = rectangle.x + (rectangle.width - n4) / 2;
                n3 = rectangle.y + (rectangle.height - n5) / 2;
                break;
            }
            case 1: {
                n2 = rectangle.x + (rectangle.width - n4) / 2;
                n3 = rectangle2.y;
                break;
            }
            case 5: {
                n2 = rectangle.x + (rectangle.width - n4) / 2;
                n3 = rectangle2.y + rectangle2.height - n5;
                break;
            }
            case 7: {
                n2 = rectangle2.x;
                n3 = rectangle.y + (rectangle.height - n5) / 2;
                break;
            }
            case 3: {
                n2 = rectangle2.x + rectangle2.width - n4;
                n3 = rectangle.y + (rectangle.height - n5) / 2;
                break;
            }
            case 8: {
                n2 = rectangle2.x;
                n3 = rectangle2.y;
                break;
            }
            case 2: {
                n2 = rectangle2.x + rectangle2.width - n4;
                n3 = rectangle2.y;
                break;
            }
            case 6: {
                n2 = rectangle2.x;
                n3 = rectangle2.y + rectangle2.height - n5;
                break;
            }
            case 4: {
                n2 = rectangle2.x + rectangle2.width - n4;
                n3 = rectangle2.y + rectangle2.height - n5;
            }
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    @Override
    public int getOverlayLocation(JComponent jComponent) {
        Integer n2 = this.\u0103.get(jComponent);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    @Override
    public void setOverlayLocation(JComponent jComponent, int n2) {
        this.\u0101(jComponent, null, n2);
    }

    private void \u0101(JComponent jComponent, Component component, int n2) {
        boolean bl = false;
        int n3 = this.getOverlayLocation(jComponent);
        if (n3 != n2) {
            this.\u0103.put(jComponent, n2);
            bl = true;
        }
        if (bl) {
            this.\u0102();
        }
    }

    @Override
    public void addOverlayComponent(JComponent jComponent) {
        this.addOverlayComponent(jComponent, 0, -1);
    }

    @Override
    public void addOverlayComponent(JComponent jComponent, int n2) {
        this.addOverlayComponent(jComponent, n2, -1);
    }

    @Override
    public void addOverlayComponent(JComponent jComponent, int n2, int n3) {
        this.\u0101(jComponent, null, n2, n3);
    }

    private void \u0101(JComponent jComponent, Component component, int n2, int n3) {
        if (this.\u0101.contains(jComponent)) {
            this.\u0101.remove(jComponent);
        }
        if (n3 == -1) {
            this.\u0101.add(jComponent);
            this.add((Component)jComponent, this.getComponentCount() - 1);
        } else {
            this.\u0101.add(n3, jComponent);
            this.add((Component)jComponent, n3);
        }
        this.\u0101(jComponent, component, n2);
    }

    @Override
    public void removeOverlayComponent(JComponent jComponent) {
        if (this.\u0101.contains(jComponent)) {
            this.\u0101.remove(jComponent);
            this.\u0103.remove(jComponent);
            this.remove(jComponent);
        }
    }

    @Override
    public JComponent[] getOverlayComponents() {
        return this.\u0101.toArray(new JComponent[this.\u0101.size()]);
    }

    public JComponent getActualComponent() {
        return this.\u0104;
    }

    public void setActualComponent(JComponent jComponent) {
        if (this.\u0104 != null) {
            this.remove(this.\u0104);
            this.\u0104.putClientProperty("Overlayable.overlayable", null);
        }
        this.\u0104 = jComponent;
        this.\u0104.putClientProperty("Overlayable.overlayable", this);
        this.add(this.\u0104);
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
        }
    }

    @Override
    public Insets getOverlayLocationInsets() {
        return this.\u0102;
    }

    @Override
    public void setOverlayLocationInsets(Insets insets) {
        this.\u0102 = insets;
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
        }
    }

    @Override
    public void setOverlayVisible(boolean bl) {
        JComponent[] jComponentArray;
        for (JComponent jComponent : jComponentArray = this.getOverlayComponents()) {
            jComponent.setVisible(bl);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.\u0102();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.\u0102();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.\u0102();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.\u0102();
    }
}

