/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.combobox.ComboBoxModelWrapperUtils;
import com.jidesoft.combobox.DefaultButtonProvider;
import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.FilterableComboBoxModel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.combobox.TableExComboBox;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.ResizableWindow;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class ExComboBoxPopup
extends BasicComboPopup
implements PopupMenuListener,
PropertyChangeListener {
    protected StandardDialog _dialog;
    protected JidePopup _popup;
    protected PopupPanel _popupPanel;
    private ItemListener \u0105;
    private ItemListener \u0103;
    private Action \u0101;
    private Action \u0102;
    private int \u0104 = Integer.MIN_VALUE;
    protected ExComboBox _comboBox;
    public LineBorder LINE_BORDER = new LineBorder(Color.BLACK, 1);

    public ExComboBoxPopup(JComboBox jComboBox) {
        super(jComboBox);
        if (!(this.comboBox instanceof ExComboBox)) {
            throw new IllegalArgumentException("The comboBox passed to ExComboBoxPopup must be an instance of ExComboBox");
        }
        this._comboBox = (ExComboBox)this.comboBox;
        this._comboBox.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ExComboBoxPopup.this.resetPopup();
            }
        });
    }

    @Override
    public void show() {
        if (!Boolean.TRUE.equals(this._comboBox.getClientProperty("doNotHidePopupMenu"))) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        if (SystemInfo.isJdk6u25Above()) {
            this._comboBox.firePopupMenuWillBecomeVisible();
        }
        this.showPopupPanel();
    }

    protected void showPopupPanel() {
        if (this._comboBox.getPopupType() == 0) {
            this.\u0101();
        } else {
            this.\u0102();
        }
    }

    private void \u0101() {
        this.showPopupPanelAsPopup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showPopupPanelAsPopup(boolean bl) {
        ComboBoxModel comboBoxModel;
        if (this._popupPanel == null || this._comboBox.isPopupVolatile()) {
            this.resetPopup();
            this._popupPanel = this._comboBox.createPopupComponent();
            this._comboBox.putClientProperty("ExComboBox.popupPanel", this._popupPanel);
            this._popupPanel.setLocale(this._comboBox.getLocale());
            JideSwingUtilities.putClientPropertyRecursively(this._popupPanel, "doNotCancelPopup", this.comboBox.getClientProperty("doNotCancelPopup"));
            if (this._comboBox.isStretchToFitSet()) {
                this._popupPanel.setStretchToFit(this._comboBox.isStretchToFit());
            }
            this.\u0105 = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (!ExComboBoxPopup.this._comboBox.isRetrievingValueFromPopup() && ExComboBoxPopup.this._popupPanel != null) {
                            ExComboBoxPopup.this._comboBox.setSelectedItem(ExComboBoxPopup.this._popupPanel.getSelectedObject());
                        }
                        if (ExComboBoxPopup.this.isPopupVisible()) {
                            ExComboBoxPopup.this.hide();
                        }
                    }
                }
            };
            this._popupPanel.addItemListener(this.\u0105, 0);
            this.customizePopupPanel(this._popupPanel);
        }
        if (!bl) {
            return;
        }
        if (this._popup == null) {
            this._popup = this.createPopupWindow();
            this.customizePopup(this._popup);
            this._popup.applyComponentOrientation(this.getComponentOrientation());
        } else {
            boolean bl2 = false;
            comboBoxModel = ComboBoxModelWrapperUtils.getActualComboBoxModel(this._comboBox.getModel(), FilterableComboBoxModel.class);
            if (comboBoxModel instanceof FilterableComboBoxModel && ((FilterableComboBoxModel)comboBoxModel).isFiltersApplied() && ((FilterableComboBoxModel)comboBoxModel).getFilters().length > 0) {
                bl2 = true;
            } else if (this._comboBox instanceof TableExComboBox && ((TableExComboBox)this._comboBox).getTableModel() instanceof FilterableTableModel && ((FilterableTableModel)((TableExComboBox)this._comboBox).getTableModel()).isFiltersApplied() && ((FilterableTableModel)((TableExComboBox)this._comboBox).getTableModel()).hasFilter()) {
                bl2 = true;
            }
            if (bl2) {
                this._popup.setPreferredSize(null);
            }
        }
        if (this._popupPanel.isStretchToFit() && this._popupPanel.getActualPreferredSize().width != this.getPreferredWidth()) {
            Border border = this._popup.getPopupBorder();
            int n2 = 0;
            if (border != null) {
                Insets insets = border.getBorderInsets(this._popupPanel);
                n2 = insets.left + insets.right;
            }
            int n3 = Math.max(this._popupPanel.getActualPreferredSize().width, this.getPreferredWidth() - n2);
            this._popupPanel.setPreferredSize(new Dimension(n3, this._popupPanel.getPreferredSize().height));
        }
        if (!this._popup.isPopupVisible()) {
            if (this._popupPanel.getDefaultFocusComponent() != null) {
                this._popup.setDefaultFocusComponent(this._popupPanel.getDefaultFocusComponent());
            }
            if (this._popup.isFocusable() || this._popup.getDefaultFocusComponent() != null) {
                this._popup.setReturnFocusToOwner(true);
            } else {
                this._popup.setReturnFocusToOwner(false);
            }
            this._popup.setResizable(this._popupPanel.isResizable());
            if (this.comboBox instanceof ExComboBox && ((ExComboBox)this.comboBox).isSettingPopupInitialValue()) {
                this._popupPanel.removeItemListener(this.\u0105);
                try {
                    this._popupPanel.setSelectedObject(this.comboBox.getEditor().getItem());
                }
                finally {
                    this._popupPanel.addItemListener(this.\u0105, 0);
                }
            }
        }
        if (this.comboBox instanceof ExComboBox) {
            ((ExComboBox)this.comboBox).customizePopup(this._popup, this._popupPanel);
        }
        Point point = this.calculatePopupLocation();
        if (this.comboBox.isEditable() && this.comboBox.isEnabled()) {
            if (this._popup.getOwner() == null) {
                comboBoxModel = this.comboBox.getEditor();
                this._popup.setOwner(comboBoxModel.getEditorComponent());
            }
            this._popup.showPopup(point.x, point.y);
        } else {
            this._popup.showPopup(point.x, point.y, this.comboBox);
        }
        if (this._popup == null || this._popupPanel == null) {
            System.err.println("Please check your popup menu listener. You code causes the popup be hidden immediately. Most likely you are trying to reset the model of ExComboBox.");
            return;
        }
        if (this._popupPanel.isResizable()) {
            this._popup.setupResizeCorner(this._popupPanel.getResizableCorners());
        }
        if (this._popupPanel instanceof DefaultButtonProvider && (comboBoxModel = ((DefaultButtonProvider)((Object)this._popupPanel)).getDefaultButton()) != null) {
            this._popupPanel.getRootPane().setDefaultButton((JButton)((Object)comboBoxModel));
        }
    }

    protected void customizePopupPanel(PopupPanel popupPanel) {
        popupPanel.setBorder(this.LINE_BORDER);
    }

    protected int getPreferredWidth() {
        return this.comboBox.getWidth();
    }

    protected void customizePopup(JidePopup jidePopup) {
        ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
        jidePopup.setOwner(comboBoxEditor.getEditorComponent());
        jidePopup.addExcludedComponent(this.comboBox);
        jidePopup.add(this._popupPanel);
        jidePopup.addPopupMenuListener(this);
        if (this.comboBox instanceof ExComboBox) {
            jidePopup.setPreferredPopupSize(((ExComboBox)this.comboBox).getPreferredPopupSize());
            jidePopup.setKeepPreviousSize(((ExComboBox)this.comboBox).isKeepPopupSize());
        }
        jidePopup.setBorder(BorderFactory.createEmptyBorder());
        if (SystemInfo.isMacOSX()) {
            jidePopup.putClientProperty("windowOpaque", false);
        }
    }

    public void resetPopup() {
        if (this.isPopupVisible()) {
            this.hide();
        }
        if (this._popup != null) {
            this._popup.removePopupMenuListener(this);
            this._popup.removeAllExcludedComponents();
            this._popup = null;
        }
        if (this._popupPanel != null) {
            if (this.\u0105 != null) {
                this._popupPanel.removeItemListener(this.\u0105);
                this.\u0105 = null;
            }
            if (this.\u0103 != null) {
                this._popupPanel.removeItemListener(this.\u0103);
                this.\u0103 = null;
            }
            this._popupPanel.removeAllListeners();
            this._popupPanel.removeAll();
            this._popupPanel = null;
            this._comboBox.putClientProperty("ExComboBox.popupPanel", null);
        }
    }

    protected JidePopup createPopupWindow() {
        JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
        jidePopup.setDetached(false);
        jidePopup.setResizable(false);
        jidePopup.putClientProperty("popupType", "comboBox");
        jidePopup.setPopupBorder(BorderFactory.createEmptyBorder());
        return jidePopup;
    }

    protected Point calculatePopupLocation() {
        Dimension dimension;
        Cloneable cloneable;
        Border border = this._popup.getPopupBorder();
        int n2 = 0;
        int n3 = 0;
        if (border != null) {
            cloneable = border.getBorderInsets(this._popupPanel);
            n2 = cloneable.left + cloneable.right;
            n3 = cloneable.top + cloneable.bottom;
        }
        try {
            cloneable = this.comboBox.getLocationOnScreen();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cloneable = this.comboBox.getLocation();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            cloneable = this.comboBox.getLocation();
        }
        ((Point)cloneable).y += this.comboBox.getHeight();
        try {
            dimension = this._popupPanel.getPreferredSize();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dimension = new Dimension(240, 240);
        }
        ((Point)cloneable).x = this.\u0104 == Integer.MIN_VALUE ? (((Point)cloneable).x -= dimension.width - this.getPreferredWidth() + n2) : (((Point)cloneable).x += this.\u0104);
        int n4 = ((Point)cloneable).y + dimension.height;
        Rectangle rectangle = PortingUtils.getContainingScreenBounds(new Rectangle((Point)cloneable, dimension), true);
        if (n4 > rectangle.y + rectangle.height) {
            ((Point)cloneable).y = ((Point)cloneable).y - dimension.height - this._comboBox.getHeight() - n3;
            this._comboBox.setPopupLocation(1);
        } else {
            this._comboBox.setPopupLocation(3);
        }
        Rectangle rectangle2 = PortingUtils.containsInScreenBounds(this._comboBox, new Rectangle((Point)cloneable, dimension), this._comboBox.isPopupInLocalScreen());
        ((Point)cloneable).x = rectangle2.x;
        ((Point)cloneable).y = rectangle2.y;
        return cloneable;
    }

    private void \u0102() {
        if (this._popupPanel == null || this._comboBox.isPopupVolatile()) {
            this.resetPopup();
            this._popupPanel = this._comboBox.createPopupComponent();
            this._comboBox.putClientProperty("ExComboBox.popupPanel", this._popupPanel);
            this._popupPanel.setLocale(this._comboBox.getLocale());
        }
        if (this.\u0103 != null) {
            this._popupPanel.removeItemListener(this.\u0103);
        }
        this._popupPanel.setSelectedObject(this.comboBox.getEditor().getItem());
        if (this.\u0103 != null) {
            this._popupPanel.addItemListener(this.\u0103, 0);
        }
        if (this._dialog == null) {
            Window window = JideSwingUtilities.getWindowForComponent(this.comboBox);
            this._dialog = window instanceof Frame ? new A((Frame)window, this._popupPanel.getTitle() == null ? "" : this._popupPanel.getTitle(), true, this._popupPanel, this.getDialogOKAction(), this.getDialogCancelAction()) : new A((Dialog)window, this._popupPanel.getTitle() == null ? "" : this._popupPanel.getTitle(), true, this._popupPanel, this.getDialogOKAction(), this.getDialogCancelAction());
            this._dialog.applyComponentOrientation(this.getComponentOrientation());
        }
        this.firePopupMenuWillBecomeVisible();
        this._dialog.setInitFocusedComponent(this._popupPanel.getDefaultFocusComponent());
        this._dialog.setResizable(this._popupPanel.isResizable());
        this.customizeDialog(this._dialog);
        this._dialog.pack();
        this.customizeDialogLocation(this._dialog);
        this._dialog.setVisible(true);
        if (this._dialog.getDialogResult() == -1) {
            this.firePopupMenuCanceled();
        }
        this.firePopupMenuWillBecomeInvisible();
        this._dialog.dispose();
        this._dialog = null;
    }

    protected Action getDialogOKAction() {
        if (this.\u0101 == null) {
            Action action;
            this.\u0101 = new AbstractAction(){
                private static final long \u0102 = -7149449840313602840L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExComboBoxPopup.this._dialog != null) {
                        ExComboBoxPopup.this._dialog.setDialogResult(0);
                        ExComboBoxPopup.this._dialog.setVisible(false);
                    }
                    if (ExComboBoxPopup.this.comboBox instanceof ExComboBox && ((ExComboBox)ExComboBoxPopup.this.comboBox).getDialogOKAction() != null) {
                        ((ExComboBox)ExComboBoxPopup.this.comboBox).getDialogOKAction().actionPerformed(actionEvent);
                    } else if (ExComboBoxPopup.this.comboBox.getEditor() != null) {
                        ExComboBoxPopup.this.comboBox.setSelectedItem(ExComboBoxPopup.this._popupPanel.getSelectedObject());
                        ExComboBoxPopup.this.comboBox.getEditor().getEditorComponent().repaint();
                    }
                }
            };
            if (this.comboBox instanceof ExComboBox && (action = ((ExComboBox)this.comboBox).getDialogOKAction()) != null) {
                this.\u0101(action, this.\u0101);
                action.removePropertyChangeListener(this);
                action.addPropertyChangeListener(this);
            }
        }
        return this.\u0101;
    }

    protected Action getDialogCancelAction() {
        Action action;
        if (this.\u0102 == null) {
            this.\u0102 = new AbstractAction(){
                private static final long \u0102 = -5653555874369511434L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExComboBoxPopup.this._dialog != null) {
                        ExComboBoxPopup.this._dialog.setVisible(false);
                    }
                    if (ExComboBoxPopup.this.comboBox instanceof ExComboBox && ((ExComboBox)ExComboBoxPopup.this.comboBox).getDialogCancelAction() != null) {
                        ((ExComboBox)ExComboBoxPopup.this.comboBox).getDialogCancelAction().actionPerformed(actionEvent);
                    }
                }
            };
        }
        if (this.comboBox instanceof ExComboBox && (action = ((ExComboBox)this.comboBox).getDialogCancelAction()) != null) {
            this.\u0101(action, this.\u0102);
            action.removePropertyChangeListener(this);
            action.addPropertyChangeListener(this);
        }
        return this.\u0102;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (this.comboBox instanceof ExComboBox) {
            if (object == ((ExComboBox)this.comboBox).getDialogOKAction()) {
                this.\u0101((Action)object, this.\u0101);
            } else if (object == ((ExComboBox)this.comboBox).getDialogCancelAction()) {
                this.\u0101((Action)object, this.\u0102);
            }
        }
    }

    private void \u0101(Action action, Action action2) {
        if (action == null || action2 == null) {
            return;
        }
        action2.setEnabled(action.isEnabled());
        action2.putValue("AcceleratorKey", action.getValue("AcceleratorKey"));
        action2.putValue("ActionCommandKey", action.getValue("ActionCommandKey"));
        action2.putValue("ShortDescription", action.getValue("ShortDescription"));
        action2.putValue("LongDescription", action.getValue("LongDescription"));
        action2.putValue("SmallIcon", action.getValue("SmallIcon"));
        action2.putValue("MnemonicKey", action.getValue("MnemonicKey"));
        if (SystemInfo.isJdk6Above()) {
            action2.putValue("SwingSelectedKey", action.getValue("SwingSelectedKey"));
            action2.putValue("SwingDisplayedMnemonicIndexKey", action.getValue("SwingDisplayedMnemonicIndexKey"));
        }
        action2.putValue("SwingLargeIconKey", action.getValue("SwingLargeIconKey"));
        Object object = action.getValue("Name");
        if (object != null && !"".equals(object)) {
            action2.putValue("Name", object);
        }
    }

    protected void customizeDialogLocation(JDialog jDialog) {
        jDialog.setLocationRelativeTo(null);
        if (this._comboBox != null) {
            this._comboBox.customizeDialogLocation(jDialog);
        }
    }

    protected void customizeDialog(JDialog jDialog) {
        if (this._comboBox != null) {
            this._comboBox.customizeDialog(jDialog);
        }
    }

    public PopupPanel getPopupPanel() {
        return this._popupPanel;
    }

    public void showPopup() {
        this.showPopupPanel();
    }

    @Override
    public void hide() {
        this.setPopupVisible(false);
    }

    @Override
    protected void togglePopup() {
        if (!this.isPopupVisible() && this._comboBox.isButtonVisible()) {
            if (this._comboBox.getPopupType() == 1) {
                Component[] componentArray;
                for (Component component : componentArray = this._comboBox.getComponents()) {
                    if (!(component instanceof AbstractButton)) continue;
                    ((AbstractButton)component).getModel().setPressed(false);
                }
            }
            this.show();
        } else {
            this.hide();
        }
    }

    public void setPopupVisible(boolean bl) {
        if (bl) {
            this.\u0101();
        } else if (this.isPopupVisible()) {
            ComboBoxModel comboBoxModel;
            Cloneable cloneable;
            if (this._popup != null && this._comboBox.isKeepPopupSize()) {
                cloneable = this._comboBox.getLocation();
                SwingUtilities.convertPointToScreen(cloneable, this._comboBox.getParent());
                for (comboBoxModel = this._popup.getParent(); comboBoxModel != null && !(comboBoxModel instanceof ResizableWindow); comboBoxModel = ((Component)((Object)comboBoxModel)).getParent()) {
                }
                if (comboBoxModel != null) {
                    this.\u0104 = ((Component)((Object)comboBoxModel)).getLocation().x - cloneable.x;
                }
            }
            if (this._popup != null) {
                if (this._comboBox.isKeepPopupSize()) {
                    cloneable = this._popupPanel.getSize();
                    comboBoxModel = ComboBoxModelWrapperUtils.getActualComboBoxModel(this._comboBox.getModel(), FilterableComboBoxModel.class);
                    if (comboBoxModel instanceof FilterableComboBoxModel && ((FilterableComboBoxModel)comboBoxModel).isFiltersApplied() && ((FilterableComboBoxModel)comboBoxModel).getFilters().length > 0) {
                        ((Dimension)cloneable).height = -1;
                    } else if (this._comboBox instanceof TableExComboBox && ((TableExComboBox)this._comboBox).getTableModel() instanceof FilterableTableModel && ((FilterableTableModel)((TableExComboBox)this._comboBox).getTableModel()).isFiltersApplied() && ((FilterableTableModel)((TableExComboBox)this._comboBox).getTableModel()).hasFilter()) {
                        ((Dimension)cloneable).height = -1;
                    }
                    this._comboBox.setPreferredPopupSize((Dimension)cloneable);
                }
                this._popup.hidePopup();
            }
            this.repaint();
            if (this._popup != null) {
                this._popup.removePopupMenuListener(this);
                this._popup.removeAllExcludedComponents();
                this._popup.getRootPane().removeAll();
                this._popup = null;
            }
        }
    }

    public boolean isPopupVisible() {
        return this._popup != null && this._popup.isPopupVisible();
    }

    @Override
    public boolean isVisible() {
        return this.isPopupVisible();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.firePopupMenuWillBecomeVisible();
        this._comboBox.delegateKeyStrokes();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.firePopupMenuWillBecomeInvisible();
        this._comboBox.undelegateKeyStrokes();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this._comboBox.popupMenuCanceled(popupMenuEvent);
        this.firePopupMenuCanceled();
    }

    @Override
    protected void startAutoScrolling(int n2) {
        if (this._comboBox != null && this._comboBox.getModel().getSize() >= 0) {
            super.startAutoScrolling(n2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this._popup == null ? super.getPreferredSize() : this._popup.getPreferredSize();
    }

    class A
    extends StandardDialog {
        private Object \u017f;
        private PopupPanel \u017e;
        private Action \u0181;
        private Action \u0180;

        public A(Frame frame, String string, boolean bl, PopupPanel popupPanel, Action action, Action action2) throws HeadlessException {
            super(frame, string, bl);
            this.\u0101(popupPanel, action, action2);
        }

        public A(Dialog dialog, String string, boolean bl, PopupPanel popupPanel, Action action, Action action2) throws HeadlessException {
            super(dialog, string, bl);
            this.\u0101(popupPanel, action, action2);
        }

        private void \u0101(PopupPanel popupPanel, Action action, Action action2) {
            this.\u017e = popupPanel;
            this.\u0181 = action;
            this.\u0180 = action2;
        }

        @Override
        public JComponent createBannerPanel() {
            return null;
        }

        @Override
        public JComponent createContentPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.\u017e);
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            return jPanel;
        }

        @Override
        public ButtonPanel createButtonPanel() {
            if (this.\u017e.needsButtons()) {
                Object object;
                Object object2;
                String string = JideSwingUtilities.getOKString(ExComboBoxPopup.this._comboBox.getLocale());
                String string2 = JideSwingUtilities.getCancelString(ExComboBoxPopup.this._comboBox.getLocale());
                String string3 = UIDefaultsLookup.getString("ColorChooser.resetText");
                ButtonPanel buttonPanel = new ButtonPanel();
                buttonPanel.setBackground(this.\u017e.getBackground());
                final JButton jButton = new JButton(string);
                jButton.setName("OK");
                this.getRootPane().setDefaultButton(jButton);
                jButton.setActionCommand("OK");
                if (this.\u0181 != null) {
                    object2 = this.\u0181.getValue("Name");
                    if (object2 == null || "".equals(object2)) {
                        this.\u0181.putValue("Name", string);
                    }
                    jButton.setAction(this.\u0181);
                }
                buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
                object2 = new JButton(string2);
                ((Component)object2).setName("CANCEL");
                ((AbstractButton)object2).setActionCommand("cancel");
                if (this.\u0180 != null) {
                    object = this.\u0180.getValue("Name");
                    if (object == null || "".equals(object)) {
                        this.\u0180.putValue("Name", string2);
                    }
                    ((AbstractButton)object2).setAction(this.\u0180);
                }
                buttonPanel.addButton((AbstractButton)object2, "CANCEL");
                if (this.\u017e.isResetButtonVisible()) {
                    object = new JButton(string3);
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            A.this.\u0113();
                        }
                    });
                    int n2 = UIDefaultsLookup.getInt("ColorChooser.resetMnemonic");
                    if (n2 != -1) {
                        ((AbstractButton)object).setMnemonic(n2);
                    }
                    buttonPanel.addButton((AbstractButton)object, "ALTERNATIVE");
                }
                buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                this.getRootPane().setDefaultButton(jButton);
                this.setDefaultAction(new AbstractAction(){
                    private static final long \u0103 = 5859027103318009991L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jButton.doClick();
                    }
                });
                this.setDefaultCancelAction(new AbstractAction((JButton)object2){
                    private static final long \u0103 = -1270197865080144061L;
                    final /* synthetic */ JButton \u0101;
                    {
                        this.\u0101 = jButton;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.\u0101.doClick();
                    }
                });
                return buttonPanel;
            }
            if (ExComboBoxPopup.this.\u0103 == null) {
                ExComboBoxPopup.this.\u0103 = new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            if (ExComboBoxPopup.this._dialog != null) {
                                ExComboBoxPopup.this._dialog.setVisible(false);
                            }
                            ExComboBoxPopup.this.comboBox.setSelectedItem(A.this.\u017e.getSelectedObject());
                        }
                    }
                };
            }
            if (this.\u0180 != null) {
                this.setDefaultCancelAction(new AbstractAction("Cancel"){
                    private static final long \u0102 = 4329589269827615427L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        A.this.\u0180.actionPerformed(actionEvent);
                    }
                });
            }
            this.\u017e.addItemListener(ExComboBoxPopup.this.\u0103, 0);
            return null;
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                this.\u017f = this.\u017e.getSelectedObject();
            }
            super.setVisible(bl);
        }

        public void \u0113() {
            this.\u017e.setSelectedObject(this.\u017f);
        }
    }
}

