/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListRowMarginSupport
extends AbstractRowMarginSupport {
    protected JList _list;
    private ListDataListener \u0107;
    private PropertyChangeListener \u0108;

    public ListRowMarginSupport(JList jList, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._list = jList;
    }

    @Override
    public int getRowCount() {
        return this._list.getModel().getSize();
    }

    @Override
    public void scrollTo(int n2, int n3, boolean bl) {
        if (bl) {
            this._list.getSelectionModel().setSelectionInterval(Math.min(n2, n3), Math.max(n2, n3));
        }
        this._list.scrollRectToVisible(this._list.getCellBounds(n3, n3));
    }

    @Override
    public int getRowHeight(int n2) {
        Rectangle rectangle = this._list.getCellBounds(n2, n2);
        return rectangle != null ? rectangle.height : -1;
    }

    @Override
    public int positionToRow(int n2) {
        int n3 = this.getViewPosition();
        return this._list.locationToIndex(new Point(0, n3 + n2));
    }

    @Override
    public int rowToPosition(int n2) {
        Point point = this._list.indexToLocation(n2);
        if (point != null) {
            int n3 = this.getViewPosition();
            return point.y - n3;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        super.installListeners(repaintCallback, modelChangedCallback);
        if (modelChangedCallback != null) {
            if (this.\u0107 == null) {
                this.\u0107 = new ListDataListener(){

                    @Override
                    public void intervalAdded(ListDataEvent listDataEvent) {
                        modelChangedCallback.modelChanged(listDataEvent);
                    }

                    @Override
                    public void intervalRemoved(ListDataEvent listDataEvent) {
                        modelChangedCallback.modelChanged(listDataEvent);
                    }

                    @Override
                    public void contentsChanged(ListDataEvent listDataEvent) {
                        modelChangedCallback.modelChanged(listDataEvent);
                    }
                };
            }
            if (this.\u0108 == null) {
                this.\u0108 = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof ListModel) {
                            ((ListModel)object2).removeListDataListener(ListRowMarginSupport.this.\u0107);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof ListModel) {
                            ((ListModel)object).addListDataListener(ListRowMarginSupport.this.\u0107);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._list.addPropertyChangeListener("model", this.\u0108);
            this._list.getModel().addListDataListener(this.\u0107);
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        if (this.\u0108 != null) {
            this._list.removePropertyChangeListener("model", this.\u0108);
        }
        if (this.\u0107 != null) {
            this._list.getModel().removeListDataListener(this.\u0107);
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

