/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.list.ListModelWrapperUtils;
import java.util.Arrays;
import javax.swing.JList;

public class ListUtils {
    public static int[] saveSelection(JList jList) {
        int[] nArray = jList.getSelectedIndices();
        if (jList.getModel() instanceof ListModelWrapper) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                nArray[i2] = ListModelWrapperUtils.getActualIndexAt(jList.getModel(), n2);
            }
        }
        return nArray;
    }

    public static void loadSelection(JList jList, int[] nArray) {
        if (nArray == null) {
            return;
        }
        jList.getSelectionModel().clearSelection();
        jList.getSelectionModel().setValueIsAdjusting(true);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (jList.getModel() instanceof ListModelWrapper) {
                int n3 = ListModelWrapperUtils.getIndexAt(jList.getModel(), n2);
                if (n3 == -1) continue;
                jList.getSelectionModel().addSelectionInterval(n3, n3);
                continue;
            }
            jList.getSelectionModel().addSelectionInterval(n2, n2);
        }
        jList.getSelectionModel().setValueIsAdjusting(false);
        ListUtils.ensureSelectionVisible(jList);
    }

    public static Object[] saveSelectionByValues(JList jList) {
        return jList.getSelectedValues();
    }

    public static void loadSelectionByValues(JList jList, Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int[] nArray = new int[objectArray.length];
        Arrays.fill(nArray, -1);
        for (int i2 = 0; i2 < jList.getModel().getSize(); ++i2) {
            Object e2 = jList.getModel().getElementAt(i2);
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                if (nArray[i3] != -1) continue;
                Object object = objectArray[i3];
                if (object != null && object.equals(e2)) {
                    nArray[i3] = i2;
                    continue;
                }
                if (object != null || object != e2) continue;
                nArray[i3] = i2;
            }
        }
        jList.getSelectionModel().clearSelection();
        jList.setSelectedIndices(nArray);
        ListUtils.ensureSelectionVisible(jList);
    }

    public static void ensureSelectionVisible(JList jList) {
        int n2 = jList.getMaxSelectionIndex();
        if (n2 != -1) {
            jList.ensureIndexIsVisible(n2);
        }
        int n3 = jList.getMinSelectionIndex();
        if (n2 != -1 && n2 != n3) {
            jList.ensureIndexIsVisible(n3);
        }
    }
}

