/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.CellRendererPaneEx;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableCell;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableCellRenderer;
import com.jidesoft.grid.TreeTableUtils;
import com.jidesoft.jdk.JdkSpecificClass;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TreeExpandablePanel
extends CellRendererPaneEx {
    public static final int TEXT_ICON_GAP = 0;
    public static final int LEFT_MARGIN = 16;
    public static final int CELL_HEIGHT = 16;
    protected ExpandableCell _expandableCell;
    protected Node _node;
    protected JTable _table;
    protected Icon _expandedIcon;
    protected Icon _collapsedIcon;
    protected Color _disabledForeground;
    protected Color _disabledBackground;
    protected boolean _paintLines;
    protected boolean _showRootHandles;
    protected boolean _respectRendererPreferredSize;
    protected boolean _paintLeafNodeLines;
    protected boolean _lineTypeDashed;
    protected Color _lineColor;
    protected int _indent;
    protected boolean _isSelected;
    protected boolean _hasFocus;
    private int \u0102;
    private final int \u0106 = 1;
    private final int \u0103 = 2;
    private final int \u0105 = 4;
    private static final BasicStroke \u0107 = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 1.0f);
    private static final BasicStroke \u0104 = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);

    public TreeExpandablePanel(JTable jTable) {
        this._table = jTable;
        this.initComponents();
    }

    @Deprecated
    public TreeExpandablePanel(JTable jTable, Icon icon, Icon icon2, Color color, Color color2) {
        this._table = jTable;
        this._expandedIcon = icon;
        this._collapsedIcon = icon2;
        this._disabledBackground = color;
        this._disabledForeground = color2;
        this.initComponents();
    }

    protected void initComponents() {
        this._lineTypeDashed = UIDefaultsLookup.getBoolean("Tree.lineTypeDashed");
        this.applyComponentOrientation(this._table.getComponentOrientation());
    }

    @Override
    public void setEnabled(boolean bl) {
        TableCellRenderer tableCellRenderer;
        TableCellRenderer tableCellRenderer2;
        super.setEnabled(bl);
        if (this._table instanceof TreeTable && this._table.getRowCount() > 0 && (tableCellRenderer2 = this._table.getCellRenderer(0, ((TreeTable)this._table).getExpandableColumnViewIndex())) instanceof TreeTableCellRenderer && (tableCellRenderer = ((TreeTableCellRenderer)tableCellRenderer2).getActualCellRenderer()) instanceof JComponent) {
            ((JComponent)((Object)tableCellRenderer)).setEnabled(bl);
        }
    }

    public void setExpandableCell(ExpandableCell expandableCell) {
        this._expandableCell = expandableCell;
        this._node = expandableCell;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    private int \u0101() {
        return this._table instanceof TreeTable ? ((TreeTable)this._table).getLeftMargin() : 16;
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        int n2;
        super.paint(graphics);
        this._lineTypeDashed = UIDefaultsLookup.getBoolean("Tree.lineTypeDashed");
        IExpandableTreeTableModel iExpandableTreeTableModel = null;
        TableModel tableModel = null;
        if (this._table instanceof TreeTable) {
            this._lineColor = ((TreeTable)this._table).getTreeLineColor();
            this._paintLines = ((TreeTable)this._table).isShowTreeLines();
            this._paintLeafNodeLines = ((TreeTable)this._table).isShowLeafNodeTreeLines();
            this._showRootHandles = ((TreeTable)this._table).getShowsRootHandles();
            this._respectRendererPreferredSize = ((TreeTable)this._table).isRespectRenderPreferredHeight();
            n2 = ((TreeTable)this._table).getIndent();
            tableModel = this._table.getModel();
            iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)((TreeTable)this._table).getTreeTableModel());
        } else {
            n2 = this.\u0101();
        }
        boolean bl = this._table.getComponentOrientation().isLeftToRight();
        int n3 = this._node.getLevel() * n2;
        int n4 = -1;
        if (this._table instanceof TreeTable) {
            n4 = ((TreeTable)this._table).getHorizontalLegPosition(this.getHeight());
        }
        if (n4 == -1) {
            n4 = this.getHeight() / 2;
        }
        Rectangle rectangle = null;
        if (this._actualRenderer != null && this._actualRenderer.isOpaque() && Boolean.TRUE.equals(this._table.getClientProperty("TreeTable.doNotPaintCellContentBackground"))) {
            object = (Graphics2D)graphics.create();
            rectangle = this.\u0101((Graphics)object, n2, bl, n3, n4);
            Rectangle rectangle2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            Rectangle rectangle3 = ((Graphics)object).getClipBounds();
            Rectangle rectangle4 = new Rectangle(rectangle3);
            ((Graphics)object).setClip(SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle.y - rectangle2.y, rectangle3));
            this.paintBackground((Graphics)object);
            rectangle3 = (Rectangle)rectangle4.clone();
            ((Graphics)object).setClip(SwingUtilities.computeIntersection(rectangle2.x, rectangle.y + rectangle.height, rectangle2.width, rectangle2.height - rectangle.y - rectangle.height, rectangle3));
            this.paintBackground((Graphics)object);
            rectangle3 = (Rectangle)rectangle4.clone();
            ((Graphics)object).setClip(SwingUtilities.computeIntersection(rectangle2.x, rectangle.y, rectangle.x - rectangle2.x, rectangle.height, rectangle3));
            this.paintBackground((Graphics)object);
            rectangle3 = (Rectangle)rectangle4.clone();
            ((Graphics)object).setClip(SwingUtilities.computeIntersection(rectangle.x + rectangle.width, rectangle.y, rectangle2.width - rectangle.width - rectangle.x, rectangle.height, rectangle3));
            this.paintBackground((Graphics)object);
            ((Graphics)object).dispose();
        } else {
            this.paintBackground(graphics);
            this.\u0101(graphics, n2, bl, n3, n4);
        }
        this.paintFocus(graphics);
        object = this._table.getClientProperty("TreeTable.paintTreeLineOnTreeTable");
        if (!(this._table instanceof TreeTable) || object instanceof Boolean && !((Boolean)object).booleanValue()) {
            this.\u0101(graphics, iExpandableTreeTableModel, tableModel, n2, bl, n3, n4, rectangle);
        }
    }

    private void \u0101(Graphics graphics, IExpandableTreeTableModel iExpandableTreeTableModel, TableModel tableModel, int n2, boolean bl, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6;
        Object object;
        Icon icon = null;
        boolean bl2 = this.isExpandIconVisible(this._table);
        int n7 = 0;
        int n8 = 0;
        if (bl2 && this._node instanceof Expandable && ((Expandable)this._node).hasChildren() && (this._showRootHandles || this._node.getLevel() > 0)) {
            icon = ((Expandable)this._node).isExpanded() && ((Expandable)this._node).getChildrenCount() > 0 ? (this._table instanceof TreeTable && this._node instanceof Row ? ((CategorizedTable)this._table).getExpandedIcon(((TreeTable)this._table).getRowIndex((Row)this._node)) : ((CategorizedTable)this._table).getExpandedIcon()) : (!((Expandable)this._node).isExpanded() ? (this._table instanceof TreeTable && this._node instanceof Row ? ((CategorizedTable)this._table).getCollapsedIcon(((TreeTable)this._table).getRowIndex((Row)this._node)) : ((CategorizedTable)this._table).getCollapsedIcon()) : null);
            if (icon != null) {
                object = this._table.getModel();
                while (object != null && this._node instanceof Row) {
                    if (!((object = TableModelWrapperUtils.getActualTableModel((TableModel)object, FilterableTreeTableModel.class)) instanceof FilterableTreeTableModel)) continue;
                    if (!((FilterableTreeTableModel)object).isKeepAllChildren() && ((FilterableTreeTableModel)object).hasFilter() && ((FilterableTreeTableModel)object).isFiltersApplied()) {
                        if (TreeTableUtils.hasDescendant((TableModel)object, (Row)this._node, false, true)) break;
                        icon = null;
                        break;
                    }
                    object = ((FilterableTreeTableModel)object).getActualModel();
                }
            }
            if (icon != null) {
                n7 = icon.getIconWidth();
                n8 = icon.getIconHeight();
            }
        }
        if (this._paintLines && (this._showRootHandles || this._node.getLevel() > 0)) {
            object = this._node.getParent();
            for (n6 = this._node.getLevel() - 1; n6 >= 0; --n6) {
                if (object.getParent() == null) continue;
                if (this.\u0101((Row)object, iExpandableTreeTableModel, tableModel)) {
                    n5 = this._showRootHandles ? n6 * n2 + this.\u0101() / 2 - 1 : n6 * n2 - this.\u0101() / 2 - 1;
                    this.\u0101(graphics, new Point(bl ? n5 : this.getWidth() - n5, n4 + (rectangle != null ? rectangle.height / 2 : 0)), 3, this.getWidth(), this.getHeight(), n2, bl, 0, 0);
                }
                object = object.getParent();
            }
            if (this._node instanceof Expandable && ((Expandable)this._node).hasChildren() && ((Expandable)this._node).isExpanded()) {
                n6 = this._node.getLevel() + 1;
                n5 = this._showRootHandles ? n6 * n2 + this.\u0101() / 2 - 1 : n6 * n2 - this.\u0101() / 2 - 1;
                this.\u0101(graphics, new Point(bl ? n5 : this.getWidth() - n5, n4 + (rectangle != null ? rectangle.height / 2 : 0)), 2, this.getWidth(), this.getHeight(), n2, bl, n7, n8);
            }
            n6 = 0;
            if (this._node instanceof Expandable || this._paintLeafNodeLines) {
                if (this._node instanceof Expandable && ((Expandable)this._node).hasChildren() || this._paintLeafNodeLines || !this.\u0101((Row)this._node, iExpandableTreeTableModel, tableModel)) {
                    n6 |= 4;
                }
                if (this._node.getParent() != null) {
                    if (this.\u0102((Row)this._node, iExpandableTreeTableModel, tableModel) || !(this._node.getParent() instanceof RootExpandableRow)) {
                        n6 |= 1;
                    }
                    if (this.\u0101((Row)this._node, iExpandableTreeTableModel, tableModel)) {
                        n6 |= 2;
                    }
                }
            }
            n5 = this._showRootHandles ? n3 + this.\u0101() / 2 - 1 : n3 - this.\u0101() / 2 - 1;
            this.\u0101(graphics, new Point(bl ? n5 : this.getWidth() - n5, n4), n6, this.getWidth(), this.getHeight(), this.\u0101(), bl, n7, n8);
        }
        if (icon != null) {
            int n9 = this._showRootHandles ? n3 + (this.\u0101() - icon.getIconWidth()) / 2 : n3 - (icon.getIconWidth() + this.\u0101()) / 2;
            n6 = bl ? n9 : this.getWidth() - n3 - icon.getIconWidth() - (this.\u0101() - icon.getIconWidth()) / 2;
            n5 = -(this.getHeight() + 1) % 2;
            int n10 = n4 - icon.getIconHeight() / 2 + n5;
            if (JdkSpecificClass.isSynthIcon(icon)) {
                JdkSpecificClass.paintTableCellIcon(this._table, icon, graphics, n6, n10);
            } else {
                icon.paintIcon(this, graphics, n6, n10);
            }
        }
    }

    private Rectangle \u0101(Graphics graphics, int n2, boolean bl, int n3, int n4) {
        int n5;
        int n6 = this._showRootHandles ? n3 + this.\u0101() : n3;
        int n7 = this.getWidth() - n6;
        if (this._actualRenderer != null) {
            Rectangle rectangle;
            if (this._table instanceof TreeTable && this._node instanceof Row) {
                int n8 = n2 - ((TreeTable)this._table).getIndent((Row)this._node);
                n6 -= n8;
                n7 += n8;
            }
            this._actualRenderer.applyComponentOrientation(this._table.getComponentOrientation());
            Rectangle rectangle2 = rectangle = bl ? new Rectangle(n6, 0, n7, this.getHeight()) : new Rectangle(0, 0, n7, this.getHeight());
            if (this._respectRendererPreferredSize) {
                int n9 = Math.min(this._actualRenderer.getPreferredSize().height, rectangle.height);
                rectangle.y = Math.max(0, n4 - n9 / 2);
                rectangle.height = n9;
            }
            this.paintComponent(graphics, this._actualRenderer, this._table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            return rectangle;
        }
        graphics.setFont(this._table.getFont());
        if (this.isSelected()) {
            graphics.setColor(this._table.getSelectionForeground());
        } else if (this._expandableCell != null && this._expandableCell.isEditable()) {
            graphics.setColor(this._table.getForeground());
        } else {
            graphics.setColor(((CategorizedTable)this._table).getDisabledForeground());
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n10 = (this.getHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + 1;
        String string = this._expandableCell == null ? "" : this._expandableCell.toString();
        int n11 = SwingUtilities.computeStringWidth(fontMetrics, string);
        if (n11 > n7) {
            int n12;
            String string2 = "...";
            n5 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n12 = 0; n12 < string.length() && (n5 += fontMetrics.charWidth(string.charAt(n12))) <= n7; ++n12) {
            }
            string = string.substring(0, n12) + string2;
            n11 = SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        int n13 = n3 + n2 + 0;
        if (this._table instanceof TreeTable && this._node instanceof Row) {
            n5 = n2 - ((TreeTable)this._table).getIndent((Row)this._node);
            n13 -= n5;
        }
        JideSwingUtilities.drawString(this._table, graphics, string, bl ? n13 : this.getWidth() - n13 - n11, n10);
        return null;
    }

    private boolean \u0101(Row row, IExpandableTreeTableModel iExpandableTreeTableModel, TableModel tableModel) {
        if (tableModel == iExpandableTreeTableModel) {
            return row.getNextSibling() != null;
        }
        boolean bl = true;
        ExpandableRow expandableRow = (ExpandableRow)row.getParent();
        int n2 = expandableRow.getChildrenCount();
        int n3 = iExpandableTreeTableModel.getRowIndex(row);
        int n4 = TableModelWrapperUtils.getRowAt(tableModel, (TableModel)((Object)iExpandableTreeTableModel), n3);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n5;
            int n6;
            Row row2 = (Row)expandableRow.getChildAt(i2);
            if (row2 == row || (n6 = TableModelWrapperUtils.getRowAt(tableModel, (TableModel)((Object)iExpandableTreeTableModel), n5 = iExpandableTreeTableModel.getRowIndex(row2))) < 0 || n6 <= n4) continue;
            bl = false;
            break;
        }
        return !bl;
    }

    private boolean \u0102(Row row, IExpandableTreeTableModel iExpandableTreeTableModel, TableModel tableModel) {
        if (tableModel == iExpandableTreeTableModel) {
            return row.getPreviousSibling() != null;
        }
        boolean bl = true;
        ExpandableRow expandableRow = (ExpandableRow)row.getParent();
        int n2 = expandableRow.getChildrenCount();
        int n3 = iExpandableTreeTableModel.getRowIndex(row);
        int n4 = TableModelWrapperUtils.getRowAt(tableModel, (TableModel)((Object)iExpandableTreeTableModel), n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            int n6;
            Row row2 = (Row)expandableRow.getChildAt(i2);
            if (row2 == row || (n6 = TableModelWrapperUtils.getRowAt(tableModel, (TableModel)((Object)iExpandableTreeTableModel), n5 = iExpandableTreeTableModel.getRowIndex(row2))) < 0 || n6 >= n4) continue;
            bl = false;
            break;
        }
        return !bl;
    }

    protected void paintFocus(Graphics graphics) {
        Color color = super.getBackground();
        if (this.isSelected()) {
            super.setBackground(this._table.getSelectionBackground());
        } else {
            super.setBackground(color);
        }
        if (this.isHasFocus()) {
            Border border = UIDefaultsLookup.getBorder(this.isSelected() ? "Table.focusSelectedCellHighlightBorder" : "Table.focusCellHighlightBorder");
            if (border == null) {
                border = UIDefaultsLookup.getBorder("Table.focusCellHighlightBorder");
            }
            if (border != null) {
                try {
                    border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.setBackground(color);
    }

    protected void paintBackground(Graphics graphics) {
        if (this.isPaintBackground()) {
            if (this._actualRenderer != null && this._actualRenderer.isOpaque() && !(this._actualRenderer.getBackground() instanceof UIResource)) {
                graphics.setColor(this._actualRenderer.getBackground());
            } else {
                graphics.setColor(this.getBackground());
            }
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setSelected(boolean bl) {
        this._isSelected = bl;
    }

    public boolean isHasFocus() {
        return this._hasFocus;
    }

    public void setHasFocus(boolean bl) {
        this._hasFocus = bl;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public int getColumnWidth() {
        return this.\u0102;
    }

    public void setColumnWidth(int n2) {
        this.\u0102 = n2;
    }

    @Override
    public Dimension getPreferredSize() {
        int n2 = (this._node == null ? 0 : this._node.getLevel()) * this.\u0101() + this.\u0101() + 0 + 1;
        if (this._actualRenderer != null) {
            Dimension dimension = this._actualRenderer.getPreferredSize();
            this._actualRenderer.setSize(this.getColumnWidth() - n2, dimension.height);
            dimension = this._actualRenderer.getPreferredSize();
            dimension.width += n2;
            return dimension;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this._table.getFont());
        String string = this._expandableCell.toString();
        int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
        return new Dimension(n3 + n2, fontMetrics.getHeight() + 2);
    }

    void \u0101(Graphics graphics, Point point, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        Color color = graphics.getColor();
        graphics.setColor(this._lineColor);
        Stroke stroke = ((Graphics2D)graphics).getStroke();
        int n8 = -(n4 + 1) % 2;
        if (this._lineTypeDashed) {
            ((Graphics2D)graphics).setStroke(\u0107);
        }
        if ((n2 & 1) != 0) {
            graphics.drawLine(point.x, point.y - n7 / 2 + n8, point.x, 0);
        }
        if ((n2 & 2) != 0) {
            graphics.drawLine(point.x, point.y + n7 / 2, point.x, n4);
        }
        if (this._lineTypeDashed) {
            ((Graphics2D)graphics).setStroke(\u0104);
        }
        if ((n2 & 4) != 0) {
            if (bl) {
                graphics.drawLine(point.x + n6 / 2, point.y + n8, point.x + n5 / 2, point.y + n8);
            } else {
                graphics.drawLine(point.x - n6 / 2 - 1, point.y + n8, point.x - n5 / 2 - 1, point.y + n8);
            }
        }
        if (this._lineTypeDashed) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
        graphics.setColor(color);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this._actualRenderer != null) {
            this._actualRenderer.setFont(font);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._actualRenderer instanceof JComponent) {
            return ((JComponent)this._actualRenderer).getToolTipText(mouseEvent);
        }
        return "";
    }

    public boolean isExpandIconVisible(JTable jTable) {
        return !(jTable instanceof CategorizedTable) || ((CategorizedTable)jTable).isExpandIconVisible();
    }
}

