/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortItemEditor;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TitledSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class TableSortItemEditor
extends AbstractDialogPage {
    private TableModel \u10d5;
    private List<SortItemEditor> \u10d4;

    public TableSortItemEditor(TableModel tableModel) {
        this.\u10d5 = tableModel;
        this.\u10d4 = new ArrayList<SortItemEditor>();
    }

    @Override
    public void lazyInitialize() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new JideBoxLayout(this, 1, 6));
        ResourceBundle resourceBundle = this.getResourceBundle();
        this.add(this.createSortItemEditor(resourceBundle.getString("SortItemEditor.sortBy")));
        this.\u0101(resourceBundle);
        this.add(Box.createGlue(), "vary");
    }

    private void \u0101(final ResourceBundle resourceBundle) {
        JButton jButton = new JButton(new AbstractAction(resourceBundle.getString("SortItemEditor.moreColumns")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TableSortItemEditor.this.\u10d4.size() == 0) {
                    TableSortItemEditor.this.add(TableSortItemEditor.this.createSortItemEditor(resourceBundle.getString("SortItemEditor.sortBy")), 0);
                } else {
                    TableSortItemEditor.this.add(TableSortItemEditor.this.createSortItemEditor(resourceBundle.getString("SortItemEditor.thenSortBy")), TableSortItemEditor.this.\u10d4.size() - 1);
                }
                TableSortItemEditor.this.revalidate();
            }
        });
        jButton.setMnemonic(resourceBundle.getString("SortItemEditor.moreColumns.mnemonic").charAt(0));
        this.add(JideSwingUtilities.createLeftPanel(jButton));
    }

    protected Component createSortItemEditor(String string) {
        final ResourceBundle resourceBundle = this.getResourceBundle();
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 1));
        final SortItemEditor sortItemEditor = new SortItemEditor(this.\u10d5);
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setSelected(true);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    TableSortItemEditor.this.\u10d4.remove(sortItemEditor);
                    if (TableSortItemEditor.this.\u10d4.size() > 0) {
                        SortItemEditor sortItemEditor2 = (SortItemEditor)TableSortItemEditor.this.\u10d4.get(0);
                        Container container = sortItemEditor2.getParent();
                        JideSwingUtilities.setRecursively(container, new JideSwingUtilities.Handler(){

                            @Override
                            public boolean condition(Component component) {
                                return component instanceof JCheckBox;
                            }

                            @Override
                            public void action(Component component) {
                                ((JCheckBox)component).setText(resourceBundle.getString("SortItemEditor.sortBy"));
                            }

                            @Override
                            public void postAction(Component component) {
                            }
                        });
                    }
                    TableSortItemEditor.this.remove(jPanel);
                    TableSortItemEditor.this.revalidate();
                }
            }
        });
        this.\u10d4.add(sortItemEditor);
        jPanel.add(new TitledSeparator(jCheckBox, 10));
        jPanel.add(sortItemEditor);
        return jPanel;
    }

    public ISortableTableModel.SortItem[] getSortItems() {
        ArrayList<ISortableTableModel.SortItem> arrayList = new ArrayList<ISortableTableModel.SortItem>();
        for (SortItemEditor sortItemEditor : this.\u10d4) {
            int n2 = sortItemEditor.getSelectedColumnIndex();
            if (n2 == -1) continue;
            arrayList.add(new ISortableTableModel.SortItem(n2, sortItemEditor.isAscending()));
        }
        return arrayList.toArray(new ISortableTableModel.SortItem[arrayList.size()]);
    }

    public SortableTableModel.ColumnComparatorContextProvider getColumnComparatorContextProvider() {
        final ComparatorContext[] comparatorContextArray = new ComparatorContext[this.\u10d5.getColumnCount()];
        boolean[] blArray = new boolean[this.\u10d5.getColumnCount()];
        for (SortItemEditor sortItemEditor : this.\u10d4) {
            int n2 = sortItemEditor.getSelectedColumnIndex();
            if (n2 == -1 || blArray[n2]) continue;
            comparatorContextArray[n2] = sortItemEditor.getComparatorContext();
            blArray[n2] = true;
        }
        return new SortableTableModel.ColumnComparatorContextProvider(){

            @Override
            public ComparatorContext getColumnComparatorContext(SortableTableModel sortableTableModel, int n2) {
                return comparatorContextArray[n2];
            }
        };
    }

    public void getColumnComparatorContextProvider(SortableTableModel.ColumnComparatorContextProvider columnComparatorContextProvider) {
        for (SortItemEditor sortItemEditor : this.\u10d4) {
            ComparatorContext comparatorContext = columnComparatorContextProvider.getColumnComparatorContext(null, sortItemEditor.getSelectedColumnIndex());
            sortItemEditor.setComparatorContext(comparatorContext);
        }
    }

    public void setSortItems(ISortableTableModel.SortItem[] sortItemArray) {
        ResourceBundle resourceBundle = this.getResourceBundle();
        this.removeAll();
        this.\u10d4.clear();
        for (int i2 = 0; i2 < sortItemArray.length; ++i2) {
            ISortableTableModel.SortItem sortItem = sortItemArray[i2];
            if (i2 == 0) {
                this.add(this.createSortItemEditor(resourceBundle.getString("SortItemEditor.sortBy")));
            } else {
                this.add(this.createSortItemEditor(resourceBundle.getString("SortItemEditor.thenSortBy")));
            }
            this.\u10d4.get(this.\u10d4.size() - 1).setSelectedColumnIndex(sortItem.column);
            this.\u10d4.get(this.\u10d4.size() - 1).setAscending(sortItem.ascending);
        }
        this.\u0101(resourceBundle);
        this.add(Box.createGlue(), "vary");
    }

    protected ResourceBundle getResourceBundle() {
        return GridResource.getResourceBundle(this.getLocale());
    }
}

