/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortListener;
import com.jidesoft.grid.SortableTableHeader;
import com.jidesoft.grid.SortableTableHeaderMouseListener;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortableTable
extends CategorizedTable
implements SortListener {
    private boolean \u11d9;
    private boolean \u11d8 = true;
    private boolean \u11e1 = true;
    public static final String SORTABLE_PROPERTY = "sortable";
    public static final String PROPERTY_SHOW_SORT_ORDER_NUMBER = "showSortOrderNumber";
    public static final String MULTICOLUMN_SORTABLE_PROPERTY = "multicolumn_sortable";
    private Color \u11df;
    private Color \u11dc;
    private boolean \u11e2 = true;
    private SortableTableHeaderMouseListener \u11d7;
    private boolean \u11d4 = true;
    private boolean \u11db = true;
    private Color \u11e0 = null;
    private Icon \u11da = null;
    private Icon \u11d5 = null;
    private Icon \u11de = null;
    private Icon \u11d6 = null;
    private TableModel \u11dd = null;

    public SortableTable() {
        this.\u012d(this.\u11d8);
        this.\u0292();
    }

    public SortableTable(TableModel tableModel) {
        super(tableModel);
        this.\u012d(this.\u11d8);
        this.\u0292();
    }

    public SortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.\u012d(this.\u11d8);
        this.\u0292();
    }

    public SortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.\u012d(this.\u11d8);
        this.\u0292();
    }

    public SortableTable(int n2, int n3) {
        super(n2, n3);
        this.\u012d(this.\u11d8);
        this.\u0292();
    }

    public SortableTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.\u012d(this.\u11d8);
        this.\u0292();
    }

    public SortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.\u012d(this.\u11d8);
        this.\u0292();
    }

    private void \u0292() {
        if (!this.\u11d9) {
            this.\u11d7 = this.createSortableTableHeaderMouseListener();
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("model".equals(propertyChangeEvent.getPropertyName())) {
                        if (propertyChangeEvent.getOldValue() == propertyChangeEvent.getNewValue()) {
                            return;
                        }
                        if (propertyChangeEvent.getOldValue() instanceof SortableTableModel) {
                            ((SortableTableModel)propertyChangeEvent.getOldValue()).removeSortListener(SortableTable.this);
                        }
                        if (propertyChangeEvent.getNewValue() instanceof SortableTableModel) {
                            ((SortableTableModel)propertyChangeEvent.getNewValue()).addSortListener(SortableTable.this);
                        }
                    }
                }
            };
            this.addPropertyChangeListener("model", propertyChangeListener);
            this.\u11d9 = true;
        }
    }

    protected SortableTableHeaderMouseListener createSortableTableHeaderMouseListener() {
        return new SortableTableHeaderMouseListener();
    }

    public SortableTableHeaderMouseListener getSortableHeaderMouseListener() {
        return this.\u11d7;
    }

    public boolean isMultiColumnSortable() {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        return iSortableTableModel == null || iSortableTableModel.isMultiColumnSortable();
    }

    public void setMultiColumnSortable(boolean bl) {
        boolean bl2 = this.isMultiColumnSortable();
        if (bl2 == bl) {
            return;
        }
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (iSortableTableModel != null) {
            iSortableTableModel.setMultiColumnSortable(bl);
            this.firePropertyChange(MULTICOLUMN_SORTABLE_PROPERTY, bl2, this.isMultiColumnSortable());
        }
    }

    public boolean isSortable() {
        return this.\u11d8;
    }

    public void setSortable(boolean bl) {
        boolean bl2 = this.\u11d8;
        if (bl2 == bl) {
            return;
        }
        this.\u012d(bl);
        this.firePropertyChange(SORTABLE_PROPERTY, (Object)bl2, (Object)this.\u11d8);
    }

    public boolean isShowSortOrderNumber() {
        return this.\u11e1;
    }

    public void setShowSortOrderNumber(boolean bl) {
        boolean bl2 = this.\u11e1;
        if (bl2 != bl) {
            this.\u11e1 = bl;
            this.firePropertyChange(PROPERTY_SHOW_SORT_ORDER_NUMBER, bl2, this.\u11e1);
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null) {
                jTableHeader.repaint();
            }
        }
    }

    private void \u012d(boolean bl) {
        this.\u11d8 = bl;
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (this.\u11d8 && iSortableTableModel == null) {
            this.setModel(this.getModel());
        } else if (!this.\u11d8 && iSortableTableModel != null) {
            if (this.getModel() instanceof ISortableTableModel) {
                ((ISortableTableModel)this.getModel()).removeSortListener(this);
                if (this.getModel() instanceof TableModelWrapper) {
                    super.setModel(((TableModelWrapper)((Object)this.getModel())).getActualModel());
                }
            } else {
                ISortableTableModel iSortableTableModel2 = (ISortableTableModel)TableModelWrapperUtils.getActualTableModel(this.getModel(), ISortableTableModel.class);
                if (iSortableTableModel2 != null) {
                    iSortableTableModel2.setSortable(bl);
                }
            }
        } else if (this.\u11d8) {
            iSortableTableModel.addSortListener(this);
        }
    }

    protected ISortableTableModel createSortableTableModel(TableModel tableModel) {
        return new SortableTableModel(tableModel);
    }

    @Override
    public void sortChanging(SortEvent sortEvent) {
    }

    @Override
    public void sortChanged(SortEvent sortEvent) {
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    protected boolean isReusable(ISortableTableModel iSortableTableModel, TableModel tableModel) {
        return true;
    }

    @Override
    public void setModel(TableModel tableModel) {
        ISortableTableModel iSortableTableModel = null;
        if (this.\u11dd != null && (iSortableTableModel = this.getSortableTableModel()) instanceof TableModelWrapperImpl && !TableModelWrapperUtils.\u0101(iSortableTableModel, tableModel) && !TableModelWrapperUtils.\u0101(tableModel, iSortableTableModel)) {
            ((TableModelWrapperImpl)((Object)iSortableTableModel)).\u0101(null, false);
        }
        if (this.isSortable()) {
            ISortableTableModel iSortableTableModel2 = SortableTableModel.getSortableModel(tableModel);
            if (iSortableTableModel2 == null) {
                if (iSortableTableModel instanceof TableModelWrapperImpl && this.isReusable(iSortableTableModel, tableModel)) {
                    ((TableModelWrapperImpl)((Object)iSortableTableModel)).\u0101(tableModel, false);
                } else {
                    this.\u11dd = null;
                    iSortableTableModel2 = this.createSortableTableModel(tableModel);
                    this.\u11dd = iSortableTableModel2;
                    super.setModel(iSortableTableModel2);
                }
            } else {
                super.setModel(tableModel);
            }
            if (iSortableTableModel2 != null) {
                iSortableTableModel2.removeSortListener(this);
                iSortableTableModel2.addSortListener(this);
            }
        } else {
            super.setModel(tableModel);
        }
    }

    public void sortColumn(String string) {
        this.sortColumn(string, true, true);
    }

    public void sortColumn(String string, boolean bl) {
        this.sortColumn(string, bl, true);
    }

    public void sortColumn(String string, boolean bl, boolean bl2) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
                if (!tableModel.getColumnName(i2).equals(string)) continue;
                this.sortColumn(i2, bl, bl2);
                break;
            }
        }
    }

    public void unsort() {
        ISortableTableModel iSortableTableModel;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((iSortableTableModel = this.getSortableTableModel()) != null) {
            iSortableTableModel.reset();
        }
    }

    public void sortColumn(int n2) {
        this.sortColumn(n2, true);
    }

    public void sortColumn(int n2, boolean bl) {
        this.sortColumn(n2, bl, true);
    }

    public void sortColumn(int n2, boolean bl, boolean bl2) {
        ISortableTableModel iSortableTableModel;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((iSortableTableModel = this.getSortableTableModel()) != null) {
            iSortableTableModel.sortColumn(n2, bl, bl2);
        }
    }

    public int getActualRowAt(int n2) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ISortableTableModel) {
            return ((ISortableTableModel)tableModel).getActualRowAt(n2);
        }
        return n2;
    }

    public int getSortedRowAt(int n2) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ISortableTableModel) {
            return ((ISortableTableModel)tableModel).getSortedRowAt(n2);
        }
        return n2;
    }

    protected ISortableTableModel getSortableTableModel() {
        return SortableTableModel.getSortableModel(this.getModel());
    }

    public boolean isOptimized() {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        return iSortableTableModel instanceof SortableTableModel && ((SortableTableModel)iSortableTableModel).isOptimized();
    }

    public void setOptimized(boolean bl) {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (iSortableTableModel instanceof SortableTableModel) {
            ((SortableTableModel)iSortableTableModel).setOptimized(bl);
        }
    }

    public boolean isAutoResort() {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        return iSortableTableModel instanceof SortableTableModel && ((SortableTableModel)iSortableTableModel).isAutoResort();
    }

    public void setAutoResort(boolean bl) {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (iSortableTableModel instanceof SortableTableModel) {
            ((SortableTableModel)iSortableTableModel).setAutoResort(bl);
        }
    }

    public void resort() {
        this.getSortableTableModel().resort();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        if (this.isNestedTableHeader()) {
            return new NestedTableHeader(this);
        }
        return new SortableTableHeader(this.getColumnModel());
    }

    public Color getSortArrowForeground() {
        return this.\u11df;
    }

    public void setSortArrowForeground(Color color) {
        this.\u11df = color;
        if (this.getTableHeader() != null) {
            this.getTableHeader().invalidate();
            this.getTableHeader().repaint();
        }
    }

    public Color getSortOrderForeground() {
        return this.\u11dc;
    }

    public void setSortOrderForeground(Color color) {
        this.\u11dc = color;
        if (this.getTableHeader() != null) {
            this.getTableHeader().invalidate();
            this.getTableHeader().repaint();
        }
    }

    public boolean isSortingEnabled() {
        return this.\u11e2;
    }

    public void setSortingEnabled(boolean bl) {
        this.\u11e2 = bl;
    }

    @Deprecated
    public boolean isPreserveSelectionsAfterSorting() {
        return this.\u11d4;
    }

    @Deprecated
    public void setPreserveSelectionsAfterSorting(boolean bl) {
        this.\u11d4 = bl;
    }

    public Icon createSortIcon(boolean bl) {
        Icon icon = bl ? this.getAscendingIcon() : this.getDescendingIcon();
        if (icon instanceof UIResource) {
            return icon;
        }
        if (this.isEnabled()) {
            Color color;
            Color color2 = color = this.getSortArrowForeground() != null ? this.getSortArrowForeground() : UIDefaultsLookup.getColor("controlDkShadow");
            if (this.\u11e0 != color) {
                this.\u11da = null;
                this.\u11de = null;
            }
            if (bl) {
                if (this.\u11da == null) {
                    this.\u11da = icon.equals(CategorizedTable.DEFAULT_ASCENDING_ICON) ? new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)) : icon;
                    this.\u11e0 = color;
                }
                return this.\u11da;
            }
            if (this.\u11de == null) {
                this.\u11de = icon.equals(CategorizedTable.DEFAULT_DESCENDING_ICON) ? new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)) : icon;
                this.\u11e0 = color;
            }
            return this.\u11de;
        }
        Color color = UIDefaultsLookup.getColor("controlShadow");
        if (bl) {
            if (this.\u11d5 == null) {
                this.\u11d5 = icon.equals(CategorizedTable.DEFAULT_ASCENDING_ICON) ? new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)) : icon;
            }
            return this.\u11d5;
        }
        if (this.\u11d6 == null) {
            this.\u11d6 = icon.equals(CategorizedTable.DEFAULT_DESCENDING_ICON) ? new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)) : icon;
        }
        return this.\u11d6;
    }

    public boolean isEnsureSelectedRowVisibleOnTogglingSort() {
        return this.\u11db;
    }

    public void setEnsureSelectedRowVisibleOnTogglingSort(boolean bl) {
        this.\u11db = bl;
    }
}

