/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterUtils;
import com.jidesoft.grid.CellPainter;
import com.jidesoft.grid.CellRendererPaneEx;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleCustomizer;
import com.jidesoft.grid.CellStyleProvider;
import com.jidesoft.grid.NavigableTable;
import com.jidesoft.grid.RendererWrapper;
import com.jidesoft.grid.RowStripeCellStyleProvider;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableStyleProvider;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SortedList;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CellStyleTable
extends NavigableTable {
    private CellStyleProvider \u11aa;
    private TableStyleProvider \u11b6;
    private List<CellStyleCustomizer> \u11ab;
    private Color \u11a1 = null;
    private Color \u11ad = null;
    private Color \u119d = null;
    private Color \u11a2 = null;
    private Font \u11a9 = null;
    private Border \u11ae = null;
    private Icon \u11b1 = null;
    private int \u11ac = -1;
    private int \u11af = -1;
    private int \u11b5 = -1;
    private int \u119f = -1;
    private String \u11a8 = null;
    private String \u119c = null;
    private boolean \u11b3 = true;
    private boolean \u11b2 = true;
    private Map<String, Font> \u11a0 = new WeakHashMap<String, Font>();
    private CellStyle \u11b4;
    public static final String PROPERTY_FILLS_VIEWPORT_WITH_STRIPE = "fillsViewportWithStripe";
    public static final String PROPERTY_FILLS_SELECTION = "fillsSelection";
    protected final List<CellStyle> _cellStyleList = new SortedList<CellStyle>(new ArrayList(), new Comparator<CellStyle>(){

        public int \u0101(CellStyle cellStyle, CellStyle cellStyle2) {
            int n2;
            if (cellStyle == null) {
                return 1;
            }
            if (cellStyle2 == null) {
                return -1;
            }
            int n3 = cellStyle.getPriority();
            if (n3 < (n2 = cellStyle2.getPriority())) {
                return 1;
            }
            if (n3 > n2) {
                return -1;
            }
            return 0;
        }
    });
    private transient boolean \u119e = false;
    private transient CellStyle \u11b0;

    public CellStyleTable() {
    }

    public CellStyleTable(int n2, int n3) {
        super(n2, n3);
    }

    public CellStyleTable(TableModel tableModel) {
        super(tableModel);
    }

    public CellStyleTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    public CellStyleTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
    }

    public CellStyleTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public CellStyleTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public TableModel getStyleModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof StyleModel) {
            return tableModel;
        }
        return TableModelWrapperUtils.getActualTableModel(tableModel, StyleModel.class);
    }

    public TableModel getNextStyleModel(TableModel tableModel) {
        if (tableModel instanceof TableModelWrapper) {
            return TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel)).getActualModel(), StyleModel.class);
        }
        return null;
    }

    @Override
    public void paintCellUnderlay(Graphics graphics, Component component, int n2, int n3, Rectangle rectangle) {
        CellPainter cellPainter;
        super.paintCellUnderlay(graphics, component, n2, n3, rectangle);
        if (this.\u11b0 != null && (cellPainter = this.\u11b0.getUnderlayCellPainter()) != null) {
            Color color;
            Color color2 = color = this.isCellSelected(n2, n3) ? this.\u11b0.getSelectionBackground() : this.\u11b0.getBackground();
            if (color == null) {
                color = this.isCellSelected(n2, n3) ? this.getSelectionBackground() : this.getBackground();
            }
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            cellPainter.paint(graphics, this, n2, n3, rectangle, this.getValueAt(n2, n3));
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
                this.\u119e = true;
            } else if (component instanceof CellRendererPaneEx) {
                ((CellRendererPaneEx)component).setPaintBackground(false);
                Component component2 = ((CellRendererPaneEx)component).getActualRenderer();
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setOpaque(false);
                }
                this.\u119e = true;
            }
        }
    }

    @Override
    public void releaseRendererComponent(TableCellRenderer tableCellRenderer, int n2, int n3, Component component) {
        super.releaseRendererComponent(tableCellRenderer, n2, n3, component);
        if (this.\u119e) {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(true);
                this.\u119e = false;
            } else if (component instanceof CellRendererPaneEx) {
                ((CellRendererPaneEx)component).setPaintBackground(true);
                Component component2 = ((CellRendererPaneEx)component).getActualRenderer();
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setOpaque(true);
                }
                this.\u119e = false;
            }
        }
        if ("true".equals(this.getClientProperty("workaroundForDefaultTableCellRendererSetBackgroundBug")) && SystemInfo.isJdk6Above() && component.getBackground() instanceof UIResource) {
            component.setBackground(this.getBackground());
        }
        this.\u11b0 = null;
    }

    @Override
    public void paintCellOverlay(Graphics graphics, Component component, int n2, int n3, Rectangle rectangle) {
        super.paintCellOverlay(graphics, component, n2, n3, rectangle);
        if (this.\u11b0 != null) {
            CellPainter cellPainter;
            Border border = this.\u11b0.getOverlayBorder();
            if (border != null) {
                border.paintBorder(this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if ((cellPainter = this.\u11b0.getOverlayCellPainter()) != null) {
                cellPainter.paint(graphics, this, n2, n3, rectangle, this.getValueAt(n2, n3));
            }
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n2, int n3) {
        Component component = super.prepareRenderer(tableCellRenderer, n2, n3);
        return this.configureRendererComponent(n2, n3, component);
    }

    @Override
    Component \u0101(TableCellRenderer tableCellRenderer, int n2, int n3) {
        Component component = super.\u0101(tableCellRenderer, n2, n3);
        CellStyle cellStyle = this.getCellStyleAt(n2, n3);
        if (cellStyle != null) {
            this.\u0101(n2, n3, component, cellStyle, true);
        }
        return component;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n2, int n3) {
        Component component = super.prepareEditor(tableCellEditor, n2, n3);
        if (component != null) {
            return this.configureEditorComponent(n2, n3, component);
        }
        return component;
    }

    @Override
    void \u0101(TableCellRenderer tableCellRenderer, int n2, int n3, Component component, boolean bl) {
        boolean bl2;
        Component component2 = component;
        boolean bl3 = false;
        if (component2 instanceof RendererWrapper) {
            if ((component2 = ((RendererWrapper)((Object)component2)).getActualRenderer()) != null) {
                bl3 = true;
            } else {
                component2 = component;
            }
        }
        boolean bl4 = bl2 = bl || this.isCellSelected(n2, n3);
        if (bl2) {
            if (this.\u119d != null) {
                component2.setBackground(null);
                if (bl3) {
                    component.setBackground(null);
                }
                this.\u119d = null;
            }
            if (this.\u11a2 != null) {
                component2.setForeground(null);
                if (bl3) {
                    component.setForeground(null);
                }
                this.\u11a2 = null;
            }
        } else {
            if (this.\u11a1 != null) {
                component2.setBackground(this.\u11a1 == CellStyle.EMPTY_COLOR ? null : this.\u11a1);
                if (bl3) {
                    component.setBackground(this.\u11a1 == CellStyle.EMPTY_COLOR ? null : this.\u11a1);
                }
                this.\u11a1 = null;
            }
            if (this.\u11ad != null) {
                component2.setForeground(this.\u11ad);
                if (bl3) {
                    component.setForeground(this.\u11ad);
                }
                this.\u11ad = null;
            }
        }
        if (this.\u11a9 != null) {
            component2.setFont(this.\u11a9 == CellStyle.EMPTY_FONT ? null : this.\u11a9);
            if (bl3) {
                component.setFont(this.\u11a9 == CellStyle.EMPTY_FONT ? null : this.\u11a9);
            }
            this.\u11a9 = null;
        }
        if (this.\u11ae != null) {
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setBorder(this.\u11ae == CellStyle.EMPTY_BORDER ? null : this.\u11ae);
            }
            if (bl3 && component instanceof JComponent) {
                ((JComponent)component).setBorder(this.\u11ae == CellStyle.EMPTY_BORDER ? null : this.\u11ae);
            }
            this.\u11ae = null;
        }
        if (component2 instanceof JLabel) {
            if (this.\u11b1 != null) {
                ((JLabel)component2).setIcon(this.\u11b1 == CellStyle.EMPTY_ICON ? null : this.\u11b1);
                this.\u11b1 = null;
            }
            if (this.\u11ac != -1) {
                ((JLabel)component2).setHorizontalAlignment(this.\u11ac);
                this.\u11ac = -1;
            }
            if (this.\u11af != -1) {
                ((JLabel)component2).setVerticalAlignment(this.\u11af);
                this.\u11af = -1;
            }
            if (this.\u11b5 != -1) {
                ((JLabel)component2).setHorizontalTextPosition(this.\u11b5);
                this.\u11b5 = -1;
            }
            if (this.\u119f != -1) {
                ((JLabel)component2).setVerticalTextPosition(this.\u119f);
                this.\u119f = -1;
            }
            if (this.\u11a8 != null) {
                ((JLabel)component2).setText("AN_EMPTY_STRING".equals(this.\u11a8) ? null : this.\u11a8);
                this.\u11a8 = null;
            }
        } else if (component2 instanceof AbstractButton) {
            if (this.\u11b1 != null) {
                ((AbstractButton)component2).setIcon(this.\u11b1 == CellStyle.EMPTY_ICON ? null : this.\u11b1);
                this.\u11b1 = null;
            }
            if (this.\u11ac != -1) {
                ((AbstractButton)component2).setHorizontalAlignment(this.\u11ac);
                this.\u11ac = -1;
            }
            if (this.\u11af != -1) {
                ((AbstractButton)component2).setVerticalAlignment(this.\u11af);
                this.\u11af = -1;
            }
            if (this.\u11b5 != -1) {
                ((AbstractButton)component2).setHorizontalTextPosition(this.\u11b5);
                this.\u11b5 = -1;
            }
            if (this.\u119f != -1) {
                ((AbstractButton)component2).setVerticalTextPosition(this.\u119f);
                this.\u119f = -1;
            }
            if (this.\u11a8 != null) {
                ((AbstractButton)component2).setText("AN_EMPTY_STRING".equals(this.\u11a8) ? null : this.\u11a8);
                this.\u11a8 = null;
            }
        } else if (component2 instanceof JTextField) {
            if (this.\u11ac != -1) {
                ((JTextField)component2).setHorizontalAlignment(this.\u11ac);
                this.\u11ac = -1;
            }
            if (this.\u11a8 != null) {
                ((JTextField)component2).setText("AN_EMPTY_STRING".equals(this.\u11a8) ? null : this.\u11a8);
                this.\u11a8 = null;
            }
        }
        if (this.\u119c != null && component2 instanceof JComponent) {
            ((JComponent)component2).setToolTipText("AN_EMPTY_STRING".equals(this.\u119c) ? null : this.\u119c);
            this.\u119c = null;
        }
        if (this.\u11ab != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this.\u11ab) {
                cellStyleCustomizer.releaseRendererComponent(n2, n3, component);
            }
        }
        super.\u0101(tableCellRenderer, n2, n3, component, bl);
    }

    protected Component configureRendererComponent(int n2, int n3, Component component) {
        this.\u11b0 = this.getCellStyleAt(n2, n3);
        if (this.\u11b0 != null) {
            this.customizeRendererComponent(n2, n3, component, this.\u11b0);
        }
        return component;
    }

    protected CellStyle mergeCellStyles(List<CellStyle> list) {
        CellStyle cellStyle = new CellStyle();
        for (CellStyle cellStyle2 : list) {
            if (cellStyle2 == null) continue;
            this.mergeCellStyle(cellStyle, cellStyle2);
        }
        return cellStyle;
    }

    protected void mergeCellStyle(CellStyle cellStyle, CellStyle cellStyle2) {
        CellStyle.mergeCellStyle(cellStyle, cellStyle2);
    }

    public void addCellStyleCustomizer(CellStyleCustomizer cellStyleCustomizer) {
        if (this.\u11ab == null) {
            this.\u11ab = new ArrayList<CellStyleCustomizer>();
        }
        if (!this.\u11ab.contains(cellStyleCustomizer)) {
            this.\u11ab.add(cellStyleCustomizer);
        }
    }

    public void removeCellStyleCustomizer(CellStyleCustomizer cellStyleCustomizer) {
        if (this.\u11ab != null) {
            this.\u11ab.remove(cellStyleCustomizer);
        }
    }

    public CellStyleCustomizer[] getCellStyleCustomizers() {
        if (this.\u11ab == null) {
            return new CellStyleCustomizer[0];
        }
        return this.\u11ab.toArray(new CellStyleCustomizer[this.\u11ab.size()]);
    }

    public void clearCellStyleCustomizers() {
        if (this.\u11ab != null) {
            this.\u11ab.clear();
            this.\u11ab = null;
        }
    }

    protected void customizeRendererComponent(int n2, int n3, Component component, CellStyle cellStyle) {
        this.\u0101(n2, n3, component, cellStyle, false);
    }

    private void \u0101(int n2, int n3, Component component, CellStyle cellStyle, boolean bl) {
        Color color;
        Color color2;
        boolean bl2;
        Component component2 = component;
        boolean bl3 = false;
        if (component2 instanceof RendererWrapper) {
            if ((component2 = ((RendererWrapper)((Object)component2)).getActualRenderer()) != null) {
                bl3 = true;
            } else {
                component2 = component;
            }
        }
        boolean bl4 = bl2 = bl || this.isCellSelected(n2, n3);
        if (bl2) {
            color2 = cellStyle.getSelectionBackground();
            color = cellStyle.getSelectionForeground();
        } else {
            color2 = cellStyle.getBackground();
            color = cellStyle.getForeground();
        }
        if (!(color2 == null || color2.equals(component2.getBackground()) && color2.equals(component.getBackground()))) {
            if (bl2) {
                if (this.\u119d == null) {
                    this.\u119d = component2.getBackground();
                    if (this.\u119d == null) {
                        this.\u119d = CellStyle.EMPTY_COLOR;
                    }
                }
            } else if (this.\u11a1 == null) {
                this.\u11a1 = component2.getBackground();
                if (this.\u11a1 == null) {
                    this.\u11a1 = CellStyle.EMPTY_COLOR;
                }
            }
            component2.setBackground(color2);
            if (bl3) {
                component.setBackground(color2);
            }
        }
        if (!(color == null || color.equals(component2.getForeground()) && color.equals(component.getForeground()))) {
            if (bl2) {
                if (this.\u11a2 == null) {
                    this.\u11a2 = component2.getForeground();
                }
            } else if (this.\u11ad == null && (this.getForeground() instanceof UIResource || !JideSwingUtilities.equals(this.getForeground(), component2.getForeground()))) {
                this.\u11ad = component2.getForeground();
            }
            component2.setForeground(color);
            if (bl3) {
                component.setForeground(color);
            }
        }
        if (!(cellStyle.getFont() == null || cellStyle.getFont().equals(component2.getFont()) && cellStyle.getFont().equals(component.getFont()))) {
            if (this.\u11a9 == null) {
                this.\u11a9 = component2.getFont();
                if (this.\u11a9 == null) {
                    this.\u11a9 = CellStyle.EMPTY_FONT;
                }
            }
            component2.setFont(cellStyle.getFont());
            if (bl3) {
                component.setFont(cellStyle.getFont());
            }
        } else if (cellStyle.getFontStyle() != -1 && cellStyle.getFontStyle() != (component2.getFont() == null ? 0 : component2.getFont().getStyle())) {
            Object object = null;
            if (this.\u11a9 == null) {
                this.\u11a9 = component2.getFont();
                object = this.\u11a9;
                if (this.\u11a9 == null) {
                    this.\u11a9 = CellStyle.EMPTY_FONT;
                }
            }
            if (object != null) {
                int n4 = cellStyle.getFontStyle();
                Font font = this.\u0101((Font)object, n4);
                component2.setFont(font);
                if (bl3) {
                    component.setFont(font);
                }
            }
        }
        if (cellStyle.getBorder() != null && component2 instanceof JComponent) {
            if (this.\u11ae == null) {
                this.\u11ae = ((JComponent)component2).getBorder();
                if (this.\u11ae == null) {
                    this.\u11ae = CellStyle.EMPTY_BORDER;
                }
            }
            if (!cellStyle.getBorder().equals(((JComponent)component2).getBorder())) {
                ((JComponent)component2).setBorder(cellStyle.getBorder());
            }
            if (bl3 && component instanceof JComponent) {
                ((JComponent)component).setBorder(cellStyle.getBorder());
            }
        }
        if (component2 instanceof JLabel) {
            if (cellStyle.getIcon() != null) {
                if (this.\u11b1 == null) {
                    this.\u11b1 = ((JLabel)component2).getIcon();
                    if (this.\u11b1 == null) {
                        this.\u11b1 = CellStyle.EMPTY_ICON;
                    }
                }
                ((JLabel)component2).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this.\u11ac == -1) {
                    this.\u11ac = ((JLabel)component2).getHorizontalAlignment();
                }
                ((JLabel)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this.\u11af == -1) {
                    this.\u11af = ((JLabel)component2).getVerticalAlignment();
                }
                ((JLabel)component2).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                if (this.\u11b5 == -1) {
                    this.\u11b5 = ((JLabel)component2).getHorizontalTextPosition();
                }
                ((JLabel)component2).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                if (this.\u119f == -1) {
                    this.\u119f = ((JLabel)component2).getVerticalTextPosition();
                }
                ((JLabel)component2).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
            if (cellStyle.getText() != null) {
                this.\u11a8 = ((JLabel)component2).getText();
                if (this.\u11a8 == null) {
                    this.\u11a8 = "AN_EMPTY_STRING";
                }
                ((JLabel)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof AbstractButton) {
            if (cellStyle.getIcon() != null) {
                if (this.\u11b1 == null) {
                    this.\u11b1 = ((AbstractButton)component2).getIcon();
                    if (this.\u11b1 == null) {
                        this.\u11b1 = CellStyle.EMPTY_ICON;
                    }
                }
                ((AbstractButton)component2).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this.\u11ac == -1) {
                    this.\u11ac = ((AbstractButton)component2).getHorizontalAlignment();
                }
                ((AbstractButton)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this.\u11af == -1) {
                    this.\u11af = ((AbstractButton)component2).getVerticalAlignment();
                }
                ((AbstractButton)component2).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                if (this.\u11b5 == -1) {
                    this.\u11b5 = ((AbstractButton)component2).getHorizontalTextPosition();
                }
                ((AbstractButton)component2).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                if (this.\u119f == -1) {
                    this.\u119f = ((AbstractButton)component2).getVerticalTextPosition();
                }
                ((AbstractButton)component2).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
            if (cellStyle.getText() != null) {
                this.\u11a8 = ((AbstractButton)component2).getText();
                if (this.\u11a8 == null) {
                    this.\u11a8 = "AN_EMPTY_STRING";
                }
                ((AbstractButton)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof JTextField) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this.\u11ac == -1) {
                    this.\u11ac = ((JTextField)component2).getHorizontalAlignment();
                }
                ((JTextField)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getText() != null) {
                this.\u11a8 = ((JTextField)component2).getText();
                if (this.\u11a8 == null) {
                    this.\u11a8 = "AN_EMPTY_STRING";
                }
                ((JTextField)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof AlignmentSupport) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this.\u11ac == -1) {
                    this.\u11ac = ((AlignmentSupport)((Object)component2)).getHorizontalAlignment();
                }
                ((AlignmentSupport)((Object)component2)).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this.\u11af == -1) {
                    this.\u11af = ((AlignmentSupport)((Object)component2)).getVerticalAlignment();
                }
                ((AlignmentSupport)((Object)component2)).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        }
        if (cellStyle.getToolTipText() != null && component2 instanceof JComponent) {
            this.\u119c = ((JComponent)component2).getToolTipText();
            if (this.\u119c == null) {
                this.\u119c = "AN_EMPTY_STRING";
            }
            ((JComponent)component2).setToolTipText(cellStyle.getToolTipText());
        }
        if (this.\u11ab != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this.\u11ab) {
                cellStyleCustomizer.customizeRendererComponent(n2, n3, component, cellStyle);
            }
        }
    }

    private Font \u0101(Font font, int n2) {
        String string = font.getFontName() + ";" + font.getSize() + ";" + n2;
        Font font2 = this.\u11a0.get(string);
        if (font2 == null) {
            font2 = font.deriveFont(n2);
            this.\u11a0.put(string, font2);
        }
        return font2;
    }

    protected Component configureEditorComponent(int n2, int n3, Component component) {
        CellStyle cellStyle = this.getCellStyleAt(n2, n3);
        if (cellStyle != null) {
            this.customizeEditorComponent(n2, n3, component, cellStyle);
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellStyle getCellStyleAt(int n2, int n3) {
        List<CellStyle> list = this._cellStyleList;
        synchronized (list) {
            CellStyle cellStyle = null;
            this.collectCellStyles(n2, n3);
            if (this._cellStyleList != null && this._cellStyleList.size() > 0) {
                if (this._cellStyleList.size() == 1) {
                    cellStyle = this._cellStyleList.get(0);
                } else if (this._cellStyleList.size() > 1) {
                    cellStyle = this.mergeCellStyles(this._cellStyleList);
                }
                this._cellStyleList.clear();
            }
            return cellStyle;
        }
    }

    public CellStyle[] getCellStyles(int n2, int n3) {
        CellStyle cellStyle;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TableStyleProvider tableStyleProvider = this.getTableStyleProvider();
        if (tableStyleProvider != null && (object = tableStyleProvider.getCellStyleAt(this, n2, n3)) != null) {
            arrayList.add(object);
        }
        if ((object = this.getCellStyleProvider()) != null && (cellStyle = object.getCellStyleAt(this.getModel(), this.convertRowIndexToModel(n2), this.convertColumnIndexToModel(n3))) != null) {
            arrayList.add(cellStyle);
        }
        int n4 = this.convertColumnIndexToModel(n3);
        Object object2 = this.getStyleModel();
        while (object2 != null) {
            if (object2 instanceof StyleModel && ((StyleModel)object2).isCellStyleOn()) {
                int n5 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, (TableModel)object2);
                int n6 = TableModelWrapperUtils.getActualColumnAt(this.getModel(), n4, (TableModel)object2);
                if (n5 == -1 || n6 == -1) break;
                CellStyle cellStyle2 = ((StyleModel)object2).getCellStyleAt(n5, n6);
                if (cellStyle2 != null) {
                    arrayList.add(cellStyle2);
                }
            }
            object2 = this.getNextStyleModel((TableModel)object2);
        }
        if ((object2 = this.getFocusCellStyle()) != null && this.isCellFocused(n2, n3)) {
            arrayList.add(object2);
        }
        return arrayList.toArray(new CellStyle[arrayList.size()]);
    }

    protected void collectCellStyles(int n2, int n3) {
        CellStyle cellStyle;
        TableStyleProvider tableStyleProvider;
        CellStyle cellStyle2;
        CellStyle cellStyle3 = this.getFocusCellStyle();
        if (cellStyle3 != null && this.isCellFocused(n2, n3)) {
            this._cellStyleList.add(cellStyle3);
        }
        int n4 = this.convertColumnIndexToModel(n3);
        ArrayList<CellStyle> arrayList = new ArrayList<CellStyle>();
        TableModel tableModel = this.getStyleModel();
        while (tableModel != null) {
            if (tableModel instanceof StyleModel && ((StyleModel)((Object)tableModel)).isCellStyleOn()) {
                int n5 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, tableModel);
                int n6 = TableModelWrapperUtils.getActualColumnAt(this.getModel(), n4, tableModel);
                if (n5 == -1 || n6 == -1) break;
                CellStyle cellStyle4 = ((StyleModel)((Object)tableModel)).getCellStyleAt(n5, n6);
                if (cellStyle4 != null) {
                    arrayList.add(cellStyle4);
                }
            }
            tableModel = this.getNextStyleModel(tableModel);
        }
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            this._cellStyleList.add((CellStyle)arrayList.get(i2));
        }
        CellStyleProvider cellStyleProvider = this.getCellStyleProvider();
        if (cellStyleProvider != null && (cellStyle2 = cellStyleProvider.getCellStyleAt(this.getModel(), this.convertRowIndexToModel(n2), this.convertColumnIndexToModel(n3))) != null) {
            this._cellStyleList.add(cellStyle2);
        }
        if ((tableStyleProvider = this.getTableStyleProvider()) != null && (cellStyle = tableStyleProvider.getCellStyleAt(this, n2, n3)) != null) {
            this._cellStyleList.add(cellStyle);
        }
    }

    protected void customizeEditorComponent(int n2, int n3, Component component, CellStyle cellStyle) {
        Object object;
        if (cellStyle.getSelectionBackground() != null) {
            component.setBackground(cellStyle.getSelectionBackground());
        }
        if (cellStyle.getSelectionForeground() != null) {
            component.setForeground(cellStyle.getSelectionForeground());
        }
        if (cellStyle.getFont() != null) {
            component.setFont(cellStyle.getFont());
        } else if (cellStyle.getFontStyle() != -1 && (object = component.getFont()) != null) {
            Font object2 = this.\u0101((Font)object, cellStyle.getFontStyle());
            component.setFont(object2);
        }
        if (cellStyle.getBorder() != null && component instanceof JComponent) {
            ((JComponent)component).setBorder(cellStyle.getBorder());
        }
        if (component instanceof JLabel) {
            if (cellStyle.getIcon() != null) {
                ((JLabel)component).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((JLabel)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((JLabel)component).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        } else if (component instanceof AbstractButton) {
            if (cellStyle.getIcon() != null) {
                ((AbstractButton)component).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((AbstractButton)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((AbstractButton)component).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        } else if (component instanceof JTextField) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((JTextField)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
        } else if (component instanceof AlignmentSupport) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((AlignmentSupport)((Object)component)).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((AlignmentSupport)((Object)component)).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        }
        if (this.\u11ab != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this.\u11ab) {
                cellStyleCustomizer.customizeEditorComponent(n2, n3, component, cellStyle);
            }
        }
    }

    public CellStyleProvider getCellStyleProvider() {
        return this.\u11aa;
    }

    public void setCellStyleProvider(CellStyleProvider cellStyleProvider) {
        this.\u11aa = cellStyleProvider;
        this.repaint();
    }

    public TableStyleProvider getTableStyleProvider() {
        return this.\u11b6;
    }

    public void setTableStyleProvider(TableStyleProvider tableStyleProvider) {
        this.\u11b6 = tableStyleProvider;
        this.repaint();
    }

    public CellStyle getFocusCellStyle() {
        return this.\u11b4;
    }

    public void setFocusCellStyle(CellStyle cellStyle) {
        this.\u11b4 = cellStyle;
    }

    public boolean isFillsViewportWithStripe() {
        return this.\u11b3;
    }

    public void setFillsViewportWithStripe(boolean bl) {
        if (this.\u11b3 != bl) {
            boolean bl2 = this.\u11b3;
            this.\u11b3 = bl;
            this.firePropertyChange(PROPERTY_FILLS_VIEWPORT_WITH_STRIPE, bl2, this.\u11b3);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.needPaintStripedBackground()) {
            Graphics graphics2 = graphics.create();
            this.\u0102(graphics2);
            graphics2.dispose();
        }
    }

    protected boolean needPaintStripedBackground() {
        boolean bl = false;
        if (this.isFillsViewportWithStripe() && (!SystemInfo.isJdk6Above() || this.getFillsViewportHeight())) {
            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), StyleModel.class);
            while (tableModel instanceof StyleModel) {
                if (((StyleModel)((Object)tableModel)).isCellStyleOn()) {
                    bl = true;
                    break;
                }
                if (!(tableModel instanceof TableModelWrapper)) break;
                tableModel = TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel)).getActualModel(), StyleModel.class);
            }
            if (!bl && (this.getCellStyleProvider() instanceof RowStripeCellStyleProvider || this.getTableStyleProvider() instanceof RowStripeTableStyleProvider)) {
                bl = true;
            }
        }
        return bl;
    }

    private void \u0102(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = this.getRowCount();
        int n3 = rectangle.y;
        if (n2 > 0) {
            Rectangle rectangle2 = this.getCellRect(n2 - 1, 0, false);
            n3 = rectangle2.y + rectangle2.height + 1;
        }
        int n4 = this.getRowHeight();
        while (n3 < rectangle.y + rectangle.height) {
            int n5 = n3 + n4;
            graphics.setColor(this.\u013d(n2));
            graphics.fillRect(rectangle.x, n3, rectangle.width, n5 - (this instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0));
            n3 = n5;
            ++n2;
        }
    }

    Color \u013d(int n2) {
        if (n2 >= 0 && n2 < this.getRowCount() || this.isFillsViewportWithStripe()) {
            Color[] colorArray;
            if (this.isFillsSelection() && !this.isNonContiguousCellSelection() && this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() && this.isRowSelected(n2)) {
                return this.getSelectionBackground();
            }
            if (this.getTableStyleProvider() instanceof RowStripeTableStyleProvider && (colorArray = ((RowStripeTableStyleProvider)this.getTableStyleProvider()).getAlternativeBackgroundColors()) != null && colorArray.length >= 1) {
                return colorArray[n2 % colorArray.length];
            }
            if (this.getCellStyleProvider() instanceof RowStripeCellStyleProvider && (colorArray = ((RowStripeCellStyleProvider)this.getCellStyleProvider()).getAlternativeBackgroundColors()) != null && colorArray.length >= 1) {
                return colorArray[n2 % colorArray.length];
            }
            if (this.getModel() instanceof AutoFilterUtils.AutoFilterRowTableModel) {
                return ((AutoFilterUtils.AutoFilterRowTableModel)this.getModel()).getCellStyleAt(0, 0).getBackground();
            }
        }
        return this.getBackground();
    }

    public boolean isFillsSelection() {
        return this.\u11b2;
    }

    public void setFillsSelection(boolean bl) {
        boolean bl2 = this.\u11b2;
        if (bl2 != bl) {
            this.\u11b2 = bl;
            this.firePropertyChange(PROPERTY_FILLS_SELECTION, bl2, this.\u11b2);
        }
    }
}

