/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.PeriodBackgroundPainter;
import com.jidesoft.scale.Period;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;

public abstract class AbstractPeriodBackgroundPainter<T>
implements PeriodBackgroundPainter<T> {
    public static final int OUTLINE_DEFAULT = 0;
    public static final int OUTLINE_START = 1;
    public static final int OUTLINE_END = 2;
    private final Period \u0101;

    protected abstract Paint getBackgroundPaint(T var1, T var2);

    protected abstract Paint getOutlinePaint(T var1, T var2);

    protected abstract Stroke getOutlineStroke(T var1, T var2);

    protected abstract int getOutlineSides(T var1, T var2);

    public AbstractPeriodBackgroundPainter(Period period) {
        this.\u0101 = period;
    }

    @Override
    public Period getPeriod() {
        return this.\u0101;
    }

    @Override
    public void paintPeriodBackground(GanttChart<T, GanttEntry<T>> ganttChart, Graphics2D graphics2D, T t2, T t3, int n2, int n3, int n4, int n5) {
        boolean bl = ganttChart.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics2D.getClipBounds();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        int n6 = 0;
        int n7 = Math.max(n2, rectangle.x);
        int n8 = rectangle.y;
        int n9 = n4 - n7;
        int n10 = Math.min(n9, rectangle.width);
        int n11 = rectangle.height;
        if (n2 >= rectangle.x) {
            n6 |= 1;
        }
        if (n4 <= rectangle.x + rectangle.width) {
            n6 |= 2;
        }
        n6 = this.\u0101(n6, bl);
        Paint paint2 = this.getBackgroundPaint(t2, t3);
        if (paint2 != null) {
            this.paintBackground(graphics2D, paint2, n7, n8, n10, n11);
        }
        Paint paint3 = this.getOutlinePaint(t2, t3);
        Stroke stroke2 = this.getOutlineStroke(t2, t3);
        int n12 = this.getOutlineSides(t2, t3);
        if (paint3 != null) {
            this.\u0101(graphics2D, bl, paint3, stroke2, n12 & n6, n7, n8, n10, n11);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    private int \u0101(int n2, boolean bl) {
        if (!bl) {
            int n3 = 0;
            if ((n2 & 1) == 1) {
                n3 |= 2;
            }
            if ((n2 & 2) == 2) {
                n3 |= 1;
            }
            n2 = n3;
        }
        return n2;
    }

    private void \u0101(Graphics2D graphics2D, boolean bl, Paint paint, Stroke stroke, int n2, int n3, int n4, int n5, int n6) {
        graphics2D.setPaint(paint);
        if (stroke != null) {
            graphics2D.setStroke(this.deriveStroke(stroke, n4));
        }
        boolean bl2 = (n2 & 1) == 1;
        boolean bl3 = (n2 & 2) == 2;
        int n7 = n4 + n6 - 1;
        if (bl2 && bl || bl3 && !bl) {
            graphics2D.drawLine(n3, n4, n3, n7);
        }
        if (bl3 && bl || bl2 && !bl) {
            int n8 = n3 + n5;
            graphics2D.drawLine(n8, n4, n8, n7);
        }
    }

    protected Stroke deriveStroke(Stroke stroke, int n2) {
        BasicStroke basicStroke;
        float[] fArray;
        if (stroke instanceof BasicStroke && (fArray = (basicStroke = (BasicStroke)stroke).getDashArray()).length > 0 && (float)n2 >= 0.0f) {
            return new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), n2);
        }
        return stroke;
    }

    protected void paintBackground(Graphics2D graphics2D, Paint paint, int n2, int n3, int n4, int n5) {
        graphics2D.setPaint(paint);
        graphics2D.fillRect(n2, n3, n4, n5);
    }
}

