/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.marker;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerModel;
import com.jidesoft.range.IntegerRange;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;

public class MarkerStripe
extends com.jidesoft.marker.MarkerStripe {
    private CodeEditor \u0104;
    private static final int \u0103 = 2;

    public MarkerStripe(MarkerArea markerArea) {
        this(null, markerArea);
    }

    public MarkerStripe(CodeEditor codeEditor, MarkerArea markerArea) {
        super(markerArea);
        this.\u0104 = codeEditor;
    }

    public void setCodeEditor(CodeEditor codeEditor) {
        this.\u0104 = codeEditor;
    }

    @Override
    protected List<Marker> getMarkersAt(Point point) {
        Insets insets = this.getInsets();
        int n2 = Math.max(0, this.getHeight() - this.getPainter().getMaxStripeHeight() - insets.top - insets.bottom);
        IntegerRange integerRange = this._markerSupport.pointToIndexRange(new Point(Math.max(0, point.x - 2), Math.max(0, point.y - 2)), n2);
        IntegerRange integerRange2 = this._markerSupport.pointToIndexRange(new Point(point.x + 2, point.y + 2), n2);
        IntegerRange integerRange3 = new IntegerRange(this.\u0104.viewToModelLine(integerRange.getMin()), this.\u0104.viewToModelLine(integerRange2.getMax() + 1) - 1);
        MarkerModel markerModel = this._markerSupport.getMarkerModel();
        return markerModel.getMarkersAt(this.\u0104.modelPositionToOffset(new CaretPosition(integerRange3.getMin(), 0)), this.\u0104.modelPositionToOffset(new CaretPosition(integerRange3.getMax(), this.\u0104.getLineLength(integerRange3.getMax()))));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        List<Marker> list = this.getMarkersAt(mouseEvent.getPoint());
        if (list != null && list.size() > 0) {
            Marker marker = list.get(0);
            int n2 = marker.getStartOffset();
            FoldingSpan[] foldingSpanArray = this.\u0104.getFoldingModel().getFoldingSpans();
            if (foldingSpanArray != null) {
                for (FoldingSpan foldingSpan : foldingSpanArray) {
                    if (foldingSpan == null || foldingSpan.isExpanded() || n2 < foldingSpan.getStartOffset() || n2 > foldingSpan.getEndOffset()) continue;
                    this.\u0104.getFoldingModel().expandFoldingSpan(foldingSpan);
                    break;
                }
            }
            this.\u0104.select(n2, n2);
            int n3 = this.\u0104.getLineNumber(n2);
            int n4 = n3 - this.\u0104.getVisibleLines() / 3;
            this.\u0104.setFirstLine(Math.max(0, n4));
            this.\u0104.requestFocus();
        }
    }
}

