/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter
implements ObjectConverter {
    public static final ConverterContext DATETIME_CONTEXT = new ConverterContext("DateTime");
    public static final ConverterContext TIME_CONTEXT = new ConverterContext("Time");
    public static final ConverterContext DATE_CONTEXT = new ConverterContext("Date");
    private DateFormat \u011d = SimpleDateFormat.getDateInstance(3);
    private DateFormat \u0127 = SimpleDateFormat.getDateInstance(2);
    private DateFormat \u0128 = SimpleDateFormat.getDateInstance(1);
    private DateFormat \u0120 = SimpleDateFormat.getDateInstance(2);
    private DateFormat \u0124 = SimpleDateFormat.getDateTimeInstance(3, 3);
    private DateFormat \u011f = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat \u011e = SimpleDateFormat.getDateTimeInstance(1, 1);
    private DateFormat \u0123 = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat \u0121 = SimpleDateFormat.getTimeInstance(3);
    private DateFormat \u0125 = SimpleDateFormat.getTimeInstance(2);
    private DateFormat \u0122 = SimpleDateFormat.getTimeInstance(1);
    private DateFormat \u0126 = SimpleDateFormat.getTimeInstance(2);

    @Override
    public synchronized String toString(Object object, ConverterContext converterContext) {
        TimeZone timeZone;
        if (object == null) {
            return "";
        }
        if (object instanceof Calendar) {
            timeZone = ((Calendar)object).getTimeZone();
            object = ((Calendar)object).getTime();
        } else if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            timeZone = calendar.getTimeZone();
        } else {
            timeZone = TimeZone.getDefault();
        }
        if (object instanceof Date || object instanceof Number) {
            if (converterContext != null && converterContext.getUserObject() instanceof DateFormat) {
                return ((DateFormat)converterContext.getUserObject()).format(object);
            }
            if (DATETIME_CONTEXT.equals(converterContext)) {
                this.\u0123.setTimeZone(timeZone);
                return this.\u0123.format(object);
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                this.\u0126.setTimeZone(timeZone);
                return this.\u0126.format(object);
            }
            this.\u0120.setTimeZone(timeZone);
            return this.\u0120.format(object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public synchronized Object fromString(String string, ConverterContext converterContext) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            Object object;
            Object object2 = object = converterContext != null ? converterContext.getUserObject() : null;
            if (object instanceof DateFormat) {
                return ((DateFormat)object).parse(string);
            }
            if (DATETIME_CONTEXT.equals(converterContext)) {
                return this.\u0123.parse(string);
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                return this.\u0126.parse(string);
            }
            return this.\u0120.parse(string);
        }
        catch (ParseException parseException) {
            String[] stringArray;
            if (DATETIME_CONTEXT.equals(converterContext)) {
                try {
                    return this.\u0124.parse(string);
                }
                catch (ParseException parseException2) {
                    try {
                        return this.\u011f.parse(string);
                    }
                    catch (ParseException parseException3) {
                        try {
                            return this.\u011e.parse(string);
                        }
                        catch (ParseException parseException4) {
                        }
                    }
                }
            } else {
                if (TIME_CONTEXT.equals(converterContext)) {
                    try {
                        return this.\u0121.parse(string);
                    }
                    catch (ParseException parseException5) {
                        try {
                            return this.\u0125.parse(string);
                        }
                        catch (ParseException parseException6) {
                            try {
                                return this.\u0122.parse(string);
                            }
                            catch (ParseException parseException7) {
                                return string;
                            }
                        }
                    }
                }
                try {
                    return this.\u011d.parse(string);
                }
                catch (ParseException parseException8) {
                    try {
                        return this.\u0127.parse(string);
                    }
                    catch (ParseException parseException9) {
                        try {
                            return this.\u0128.parse(string);
                        }
                        catch (ParseException parseException10) {
                            // empty catch block
                        }
                    }
                }
            }
            for (String string2 : stringArray = new String[]{"yyyy-mm-dd", "yy-mm-dd", "yyyymmdd", "yymmdd", "dd-MMM-yy", "dd-MMM-yyyy"}) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException11) {
                }
            }
            return string;
        }
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this.\u0120;
    }

    public void setDefaultFormat(DateFormat dateFormat) {
        this.\u0120 = dateFormat;
    }

    public DateFormat getDefaultTimeFormat() {
        return this.\u0126;
    }

    public void setDefaultTimeFormat(DateFormat dateFormat) {
        this.\u0126 = dateFormat;
    }

    public DateFormat getDefaultDatetimeFormat() {
        return this.\u0123;
    }

    public void setDefaultDatetimeFormat(DateFormat dateFormat) {
        this.\u0123 = dateFormat;
    }
}

