/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.ChartableND;
import com.jidesoft.chart.render.AbstractPointRenderer;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class RectangularPointRenderer
extends AbstractPointRenderer {
    @Override
    public Shape renderPoint(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        ChartStyle chartStyle = this.getStyle(chart, chartModel, chartable, bl, bl2, bl3);
        if (!chartStyle.isPointsVisible()) {
            return null;
        }
        float f2 = this.getOutlineWidth();
        if (chartable == null || !(chartable instanceof ChartableND)) {
            return null;
        }
        ChartableND chartableND = (ChartableND)chartable;
        double d2 = chartableND.get(0).position();
        double d3 = chartableND.get(1).position();
        double d4 = chartableND.get(2).position();
        double d5 = chartableND.get(3).position();
        Point point = chart.calculatePixelPoint(new Point2D.Double(d2 - d4 / 2.0, d3 + d5 / 2.0));
        Point point2 = chart.calculatePixelPoint(new Point2D.Double(d2 + d4 / 2.0, d3 - d5 / 2.0));
        Rectangle rectangle = new Rectangle(point.x, point.y, 1 + point2.x - point.x, 1 + point2.y - point.y);
        graphics2D.setColor(chartStyle.getPointColor());
        graphics2D.fill(rectangle);
        if (this.isAlwaysShowOutlines() || bl && chart.isSelectionShowsOutline()) {
            graphics2D.setColor(this.isAlwaysShowOutlines() && !bl ? this.getOutlineColor() : this.getSelectionColor());
            graphics2D.setStroke(new BasicStroke(f2));
            graphics2D.draw(rectangle);
        }
        graphics2D.dispose();
        return rectangle;
    }
}

