/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.axis.AxisType;
import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import java.awt.geom.Point2D;
import java.util.Collection;

public class LineFitter
implements CurveFitter {
    private static LineFitter \u0101;

    private LineFitter() {
    }

    public static LineFitter getInstance() {
        if (\u0101 == null) {
            \u0101 = new LineFitter();
        }
        return \u0101;
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n2) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, range, 2);
    }

    @Override
    public AnnotatedChartModel createModel(Polynomial polynomial, Range<?> range, int n2) {
        return this.createModel(null, polynomial, range, n2);
    }

    @Override
    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n2) {
        double d2 = range.minimum();
        double d3 = range.maximum();
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        defaultChartModel.addPoint(d2, polynomial.eval(d2));
        defaultChartModel.addPoint(d3, polynomial.eval(d3));
        return defaultChartModel;
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        for (Double d2 : doubleArray) {
            double d3 = polynomial.eval(d2);
            defaultChartModel.addPoint((double)d2, d3);
        }
        return defaultChartModel;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        double d2 = this.\u0101(AxisType.x, chartModel);
        double d3 = this.\u0101(AxisType.y, chartModel);
        double d4 = this.\u0101(chartModel, d2, d3);
        double d5 = this.\u0101(d2, d3, d4);
        return new Polynomial(d5, d4);
    }

    public Polynomial performRegression(Collection<? extends Point2D> collection) {
        double d2 = this.\u0101(AxisType.x, collection);
        double d3 = this.\u0101(AxisType.y, collection);
        double d4 = this.\u0101(collection, d2, d3);
        double d5 = this.\u0101(d2, d3, d4);
        return new Polynomial(d5, d4);
    }

    private double \u0101(ChartModel chartModel, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        for (Chartable chartable : chartModel) {
            double d6 = chartable.getX().position() - d2;
            double d7 = chartable.getY().position() - d3;
            d4 += d6 * d7;
            d5 += d6 * d6;
        }
        return d4 / d5;
    }

    private double \u0101(Collection<? extends Point2D> collection, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        for (Point2D point2D : collection) {
            double d6 = point2D.getX() - d2;
            double d7 = point2D.getY() - d3;
            d4 += d6 * d7;
            d5 += d6 * d6;
        }
        return d4 / d5;
    }

    private double \u0101(double d2, double d3, double d4) {
        return d3 - d4 * d2;
    }

    private double \u0101(AxisType axisType, ChartModel chartModel) {
        double d2 = 0.0;
        if (axisType == AxisType.x) {
            for (Chartable chartable : chartModel) {
                d2 += chartable.getX().position();
            }
        } else {
            for (Chartable chartable : chartModel) {
                d2 += chartable.getY().position();
            }
        }
        return d2 / (double)chartModel.getPointCount();
    }

    private double \u0101(AxisType axisType, Collection<? extends Point2D> collection) {
        double d2 = 0.0;
        if (axisType == AxisType.x) {
            for (Point2D point2D : collection) {
                d2 += point2D.getX();
            }
        } else {
            for (Point2D point2D : collection) {
                d2 += point2D.getY();
            }
        }
        return d2 / (double)collection.size();
    }
}

