/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.conversions;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.conversions.ISqlConverter;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.support.conv.BinaryConverter;
import com.amazon.support.conv.ConversionResult;
import com.amazon.support.exceptions.ErrorException;

public class SqlBinaryTypeConverter
implements ISqlConverter {
    private final long m_targetColLen;

    public SqlBinaryTypeConverter(IColumn iColumn, IColumn iColumn2) {
        if (!iColumn.getTypeMetadata().isBinaryType() || !iColumn2.getTypeMetadata().isBinaryType()) {
            throw new IllegalArgumentException("Unsupported source to target type conversion: source type: " + iColumn.getTypeMetadata().getTypeName() + " , target type: " + iColumn2.getTypeMetadata().getTypeName());
        }
        this.m_targetColLen = iColumn2.getColumnLength();
    }

    @Override
    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            byte[] byArray = iSqlDataWrapper.getBinary();
            switch (iSqlDataWrapper2.getType()) {
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray2 = BinaryConverter.toBinary(byArray, this.m_targetColLen, conversionResult);
                    iSqlDataWrapper2.setBinary(byArray2);
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString((short)iSqlDataWrapper2.getType()));
                }
            }
        }
        return conversionResult;
    }
}

