/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.exceptions.DefaultParamException;
import com.amazon.dsi.exceptions.ParamAlreadyPushedException;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.ExpectedResult;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PGBatchQueryExecutor
extends PGAbstractQueryExecutor {
    private Map<PGMessagingContext, Integer> m_parameterCountPerQuery = new HashMap<PGMessagingContext, Integer>();
    private List<String> m_queries;
    private String m_query;
    private int m_paramCount;

    public PGBatchQueryExecutor(String string, List<String> list, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n, int n2, boolean bl2) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, list, pGClient);
        this.m_query = string;
        this.m_queries = list;
        this.m_log = iLogger;
        this.m_isDirectExecute = bl;
        this.m_client = pGClient;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        this.m_contexts = new ArrayList();
        this.m_paramCount = n2;
        this.m_rowCountArrayExpected = bl2;
        int n3 = 0;
        while (n3 < list.size()) {
            List<String> list2 = ParseQueryUtils.splitQueries(list.get(n3), true);
            if (1 < list2.size()) {
                list.remove(n3);
                for (String string2 : list2) {
                    list.add(n3++, string2);
                }
                continue;
            }
            ++n3;
        }
        if (!bl) {
            for (int i = 0; i < list.size(); ++i) {
                PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(list.get(i), pGJDBCStatement.getWarningListener(), list.size() > 1);
                pGMessagingContext.addSocketCloseListener(this);
                pGMessagingContext.setFinalCommandInBatch(list.size() - 1 == i);
                this.m_contexts.add(pGMessagingContext);
            }
        }
        this.m_statement.pushContexts(this.m_contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws ErrorException {
        int n;
        int n2;
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        this.m_prepareStage = false;
        if (null != this.m_statement.getExpectedResult() && this.m_statement.getExpectedResult() == ExpectedResult.SingleResult) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_MULTIPLE_COMMAND_EXECUTE_QUERY_ERR.name(), new String[]{this.m_query});
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            n2 = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        try {
            n = this.m_statement.getProperty(2).getInt();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.m_queries.size(); ++i) {
                stringBuilder.append(this.m_queries.get(i));
                if (i >= this.m_queries.size() - 1) continue;
                stringBuilder.append(", ");
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Max rows retrieval failed", stringBuilder.toString()}, (Throwable)exception);
            throw errorException;
        }
        ++this.m_currentExecuteIndex;
        try {
            HashMap<PGMessagingContext, ArrayList<byte[][]>> hashMap = this.buildParameterSets(executionContexts);
            Object object = this.m_statement.getTransactionLock();
            object.lock();
            try {
                PGCoreUtils.TransactionVerb transactionVerb = PGCoreUtils.TransactionVerb.NONE;
                this.checkCancelled();
                this.m_client.executeAtomicStatement(this.m_contexts, this.m_queries, hashMap, executionContexts.getCount(), n, n2, this.m_statement.getWarningListener(), this.getQueryTimeout());
                for (int i = 0; i < this.m_queries.size(); ++i) {
                    PGMessagingContext pGMessagingContext = (PGMessagingContext)this.m_contexts.get(i);
                    transactionVerb = this.m_client.getTransactionVerbOfMessage(pGMessagingContext);
                    if (PGCoreUtils.TransactionVerb.NONE == transactionVerb) continue;
                    ((PGMessagingContext)this.m_contexts.get(i)).closeOperation();
                    this.m_statement.notifyTransaction(transactionVerb);
                }
            }
            finally {
                if (null != object) {
                    object.unlock();
                }
            }
        }
        catch (Exception exception) {
            --this.m_currentExecuteIndex;
            if (!(exception instanceof ErrorException)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
            throw (ErrorException)exception;
        }
        this.m_statement.pushContexts(this.m_contexts);
        for (Object object : this.m_contexts) {
            ((InboundMessagesPipeline)object).addSocketCloseListener(this);
        }
    }

    private HashMap<PGMessagingContext, ArrayList<byte[][]>> buildParameterSets(ExecutionContexts executionContexts) throws ParamAlreadyPushedException, DefaultParamException, ErrorException {
        int n = executionContexts.getMetadata().size();
        if (this.m_statement.isCallableStatement() && this.m_statement.hasReturnQuestionMark()) {
            --n;
        }
        HashMap<PGMessagingContext, ArrayList<byte[][]>> hashMap = new HashMap<PGMessagingContext, ArrayList<byte[][]>>(this.m_contexts.size());
        if (n != 0) {
            Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
            while (iterator.hasNext()) {
                ExecutionContext executionContext = iterator.next();
                int n2 = 0;
                for (Integer n3 : this.m_parameterCountPerQuery.values()) {
                    byte[][] byArrayArray = new byte[n3.intValue()][];
                    PGMessagingContext pGMessagingContext = null;
                    int n4 = 0;
                    while (n4 < n3 && n2 < executionContext.getInputs().size()) {
                        ParameterInputValue parameterInputValue = executionContext.getInputs().get(n2);
                        byArrayArray[n4] = PGDataTypeUtilities.toUTF8ByteArray(parameterInputValue.getData());
                        ++n4;
                        if (null == pGMessagingContext) {
                            pGMessagingContext = ((PGParameterMetadata)parameterInputValue.getMetadata()).getContext();
                        }
                        ++n2;
                    }
                    ArrayList<Object> arrayList = hashMap.get(pGMessagingContext);
                    if (null == arrayList) {
                        arrayList = new ArrayList(executionContexts.getCount());
                    }
                    arrayList.add(byArrayArray);
                    hashMap.put(pGMessagingContext, arrayList);
                }
            }
        }
        return hashMap;
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ArrayList<ParameterMetadata> arrayList = new ArrayList<ParameterMetadata>();
        List<ParameterMetadata> list = null;
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            list = this.getMetadataForParameters(pGMessagingContext);
            this.m_parameterCountPerQuery.put(pGMessagingContext, list.size());
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.m_paramCount;
    }

    @Override
    protected int getParamCountForContext(PGMessagingContext pGMessagingContext) {
        return this.m_parameterCountPerQuery.get(pGMessagingContext);
    }
}

