/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications;

import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.exceptions.MessagesFrameworkMessageKey;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.jdbc.communications.interfaces.SocketCloseObservable;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.channels.AbstractSocketChannel;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class InboundMessagesThread
extends Thread
implements SocketCloseObservable {
    public static final int LOG_COMPONENT_ID = 1001;
    protected static final ExceptionBuilder EXCEPTION_BUILDER = new ExceptionBuilder(1001);
    private static int READ_SELECTOR_TIMEOUT_MS = 500;
    private AbstractSocketChannel m_channel;
    private boolean m_close = false;
    private List<SocketCloseListener> m_closeListeners = new ArrayList<SocketCloseListener>();
    private ILogger m_log;
    private Selector m_selector;
    private AbstractInboundDataHandler m_dataHandler;
    private long m_lastCommunicationTimestampNS;
    private long m_newTCPConnectionKeepAliveThresholdNS;
    private String m_host;
    private int m_port;
    private int m_socketTimeOutMS;
    private int m_timeOutCounter;

    public InboundMessagesThread(Selector selector, AbstractSocketChannel abstractSocketChannel, AbstractInboundDataHandler abstractInboundDataHandler, int n, String string, int n2, int n3, ILogger iLogger) {
        this.setDaemon(true);
        this.m_newTCPConnectionKeepAliveThresholdNS = n > 0 ? BigInteger.valueOf(n).multiply(BigInteger.valueOf(60L)).multiply(BigInteger.valueOf(1000000000L)).longValue() : -1L;
        this.m_lastCommunicationTimestampNS = System.nanoTime();
        this.m_channel = abstractSocketChannel;
        this.m_log = iLogger;
        this.m_selector = selector;
        this.m_dataHandler = abstractInboundDataHandler;
        this.m_host = string;
        this.m_port = n2;
        this.m_socketTimeOutMS = n3;
        this.m_timeOutCounter = this.m_socketTimeOutMS / READ_SELECTOR_TIMEOUT_MS;
    }

    public void close(ErrorException errorException) {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (!this.m_close) {
            this.m_close = true;
            if (null != this.m_dataHandler) {
                try {
                    this.m_dataHandler.addToPipeline(new InboundErrorMessage(DiagState.DIAG_COMM_LINK_FAILURE, 1, JDBCMessageKey.CONNECTION_CLOSED.name()), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fireClose(errorException);
            try {
                this.m_selector.close();
                this.m_selector = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_dataHandler.closeOperation();
            this.m_dataHandler.close(errorException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (this.m_selector.isOpen() && !this.m_selector.keys().isEmpty() && !this.m_close) {
                try {
                    int n = this.m_selector.select(READ_SELECTOR_TIMEOUT_MS);
                    if (n == 0) {
                        if (this.m_socketTimeOutMS != 0 && this.m_dataHandler.isOpenOperation()) {
                            if (this.m_timeOutCounter < 1) {
                                this.close(EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_SOCKET_TIMEOUT.name()));
                            } else {
                                --this.m_timeOutCounter;
                            }
                        }
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logDebug("Select triggered, no keys given.", this.m_log);
                        }
                    }
                    Set<SelectionKey> set = this.m_selector.selectedKeys();
                    Iterator<SelectionKey> iterator = set.iterator();
                    while (!this.m_close && iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        this.m_timeOutCounter = this.m_socketTimeOutMS / READ_SELECTOR_TIMEOUT_MS;
                        try {
                            if ((selectionKey.readyOps() & 1) != 1) continue;
                            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                            try {
                                if (!socketChannel.equals(this.m_channel.getSocketChannel())) continue;
                                this.m_channel.read();
                                this.m_lastCommunicationTimestampNS = System.nanoTime();
                            }
                            catch (ErrorException errorException) {
                                LogUtilities.logFatal(errorException, this.m_log);
                                selectionKey.cancel();
                                this.close(errorException);
                            }
                        }
                        catch (CancelledKeyException cancelledKeyException) {
                            LogUtilities.logFatal(cancelledKeyException, this.m_log);
                            this.close(EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_FAILURE, (Throwable)cancelledKeyException));
                            return;
                        }
                    }
                    set.clear();
                    this.doKeepAlive();
                }
                catch (ClosedSelectorException closedSelectorException) {
                    LogUtilities.logDebug("Select triggered, no keys given.", this.m_log);
                    return;
                }
            }
        }
        catch (IOException iOException) {
            LogUtilities.logFatal("Something is wrong, exiting thread", this.m_log);
            LogUtilities.logFatal(iOException, this.m_log);
            this.close(EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_FAILURE, (Throwable)iOException));
            return;
        }
        catch (Exception exception) {
            LogUtilities.logFatal("Something is wrong, exiting thread", this.m_log);
            LogUtilities.logFatal(exception, this.m_log);
            this.close(EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_FAILURE, (Throwable)exception));
        }
    }

    private void doKeepAlive() throws IOException {
        if (this.m_newTCPConnectionKeepAliveThresholdNS > 0L && System.nanoTime() - this.m_lastCommunicationTimestampNS > this.m_newTCPConnectionKeepAliveThresholdNS) {
            SocketChannel socketChannel = SocketChannel.open(new InetSocketAddress(this.m_host, this.m_port));
            while (socketChannel.isConnectionPending()) {
            }
            if (socketChannel.isConnected()) {
                socketChannel.close();
                this.m_lastCommunicationTimestampNS = System.nanoTime();
                LogUtilities.logDebug("TCP keepalive succesful.", this.m_log);
            } else {
                LogUtilities.logFatal("TCP keepalive failed.", this.m_log);
                this.close(EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_SOCKET_TIMEOUT.name()));
            }
        }
    }

    @Override
    public void addSocketCloseListener(SocketCloseListener socketCloseListener) {
        this.m_closeListeners.add(socketCloseListener);
    }

    @Override
    public void removeSocketCloseListener(SocketCloseListener socketCloseListener) {
        this.m_closeListeners.remove(socketCloseListener);
    }

    private void fireClose(ErrorException errorException) {
        if (null != this.m_log) {
            LogUtilities.logFunctionEntrance(this.m_log, errorException);
        }
        for (SocketCloseListener socketCloseListener : this.m_closeListeners) {
            socketCloseListener.socketClosed(errorException);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close(null);
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }
}

