/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis;

import com.onseven.dbvis.F;
import com.onseven.dbvis.K.B.C;
import com.onseven.dbvis.K.C.B.A.A.V;
import com.onseven.dbvis.K.C.B.A.D;
import com.onseven.dbvis.K.C.B.E;
import com.onseven.dbvis.K.C.B.H;
import com.onseven.dbvis.K.C.C.J;
import com.onseven.dbvis.K.C.C.S;
import com.onseven.dbvis.K.C.R;
import com.onseven.dbvis.b.I;
import com.onseven.dbvis.b.K;
import com.onseven.dbvis.c.A;
import com.onseven.dbvis.c.M;
import com.onseven.dbvis.c.Q;
import com.onseven.dbvis.sql.O;
import com.onseven.dbvis.sql.P;
import com.onseven.dbvis.util.G.G;
import com.onseven.dbvis.util.N;
import com.onseven.dbvis.util.W;
import com.onseven.dbvis.util.Z;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;

public class DbVisualizerCmd
extends F {
    private static DbVisualizerCmd instance;
    private com.onseven.dbvis.db.I.H dbConnection;
    private H executor;
    private PrintWriter outputWriter;
    private static final Logger LOG;
    private static final boolean DO_NOT_CATCH_SYSTEM_STREAMS = true;
    private File currentFile;

    public static void main(String[] stringArray) {
        DbVisualizerCmd dbVisualizerCmd = new DbVisualizerCmd(new com.onseven.dbvis.util.P(stringArray));
        dbVisualizerCmd.runCmd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCmd() {
        com.onseven.dbvis.util.P p2 = (com.onseven.dbvis.util.P)DbVisualizerCmd.getArgumentParser();
        if (p2.\u013d()) {
            int n2 = this.convertDson(p2);
            this.exit(n2);
            return;
        }
        if (p2.\u0129()) {
            int n3 = this.formatDson(p2);
            this.exit(n3);
            return;
        }
        if (p2.\u0143()) {
            int n4 = this.listDson(p2);
            this.exit(n4);
            return;
        }
        try {
            this.initialize();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Initialize Error: " + N.\u010d(throwable.getMessage()));
            this.cleanUpForExit();
            this.exit(2);
        }
        try {
            this.connect();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Connect Error: " + N.\u010d(throwable.getMessage()));
            this.cleanUpForExit();
            this.exit(2);
        }
        int n5 = 0;
        try {
            n5 = this.execute();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - " + throwable);
            this.cleanUpForExit();
            try {
                this.disconnect();
            }
            finally {
                n5 = 2;
                this.exit(2);
            }
        }
        try {
            this.disconnect();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Disconnect Error: " + N.\u010d(throwable.getMessage()));
            n5 = 2;
            this.exit(2);
        }
        this.shutdown(n5);
    }

    public DbVisualizerCmd(Z z2) {
        super(z2, false);
        instance = this;
    }

    public static DbVisualizerCmd getApplication() {
        return instance;
    }

    public void shutdown(int n2) {
        this.cleanUpForExit();
        this.exit(n2);
    }

    @Override
    protected void initialize() {
        com.onseven.dbvis.c.B.A.A.\u0101(false);
        super.initialize();
        if (!Q.\u0102().\u0111().\u0139()) {
            throw new IllegalStateException("The DbVisualizer command line interface is available only in DbVisualizer Pro");
        }
        com.onseven.dbvis.c.C.\u0626();
        Q.\u0102().\u0103().\u0110().\u0101(new B(Q.\u0102().\u0103().\u0110()));
        Q.\u0102().\u0104().\u0101(this);
    }

    @Override
    protected void showEULA() {
    }

    @Override
    protected void initLogging(int n2) {
        com.onseven.dbvis.util.P p2 = (com.onseven.dbvis.util.P)DbVisualizerCmd.getArgumentParser();
        String string = p2.\u013f();
        boolean bl = p2.\u012c();
        boolean bl2 = true;
        if (this.canUseLogFile(string)) {
            bl2 = false;
        }
        String string2 = com.onseven.dbvis.util.G.O.\u0106(com.onseven.dbvis.util.G.O.\u0109);
        if (bl) {
            string2 = com.onseven.dbvis.util.G.O.\u0106(com.onseven.dbvis.util.G.O.\u0104);
        }
        Level level = Level.parse(string2);
        try {
            String string3 = p2.\u012f();
            if (!W.\u0105(string3)) {
                string3 = null;
            }
            G.\u0101().\u0101(level, bl2, string, n2, true, string3);
        }
        catch (com.onseven.dbvis.util.G.R r2) {
            System.err.println("DbVisualizerCmd - Could not initiate logging: " + N.\u010d(r2.getMessage()));
            this.exit(2);
        }
    }

    private boolean canUseLogFile(String string) {
        if (W.\u0105(string)) {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 == null) {
                file2 = new File(System.getProperty("user.dir"));
            }
            return file2.isDirectory();
        }
        return false;
    }

    protected void connect() {
        com.onseven.dbvis.util.P p2 = (com.onseven.dbvis.util.P)DbVisualizerCmd.getArgumentParser();
        if (p2.\u0135()) {
            Iterator<O> iterator = this.getConnections().iterator();
            System.out.println("Connections:\n");
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
            this.exit(0);
            return;
        }
        try {
            this.dbConnection = this.connect(p2);
        }
        catch (P p3) {
            throw new IllegalStateException("Connecting: " + p3.getMessage());
        }
        if (this.dbConnection == null) {
            throw new IllegalStateException("Connecting: The '" + p2.\u012b() + "' connection was not found. Use the -listconnections option to see available connections or specify appropriate options to establish an anonymous connection");
        }
    }

    private int execute() {
        com.onseven.dbvis.b.J j2;
        int n2 = 0;
        com.onseven.dbvis.util.P p2 = (com.onseven.dbvis.util.P)DbVisualizerCmd.getArgumentParser();
        try {
            j2 = this.getScriptSources(p2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Reading the script: " + iOException.getMessage());
        }
        S s2 = null;
        try {
            this.outputWriter = this.createOutPutWriter(p2);
            s2 = this.createExecutionLogHandler(p2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Log file \"" + p2.\u013f() + "\" is not writable");
        }
        String string = this.dbConnection.\u0142().\u0101().\u0104();
        String string2 = p2.\u0140();
        boolean bl = M.\u0109().getBool("SQLCommanderStripComments");
        boolean bl2 = string2 != null ? Boolean.valueOf(string2) : bl;
        com.onseven.dbvis.b.G g2 = new com.onseven.dbvis.b.G(string);
        g2.\u0103(bl2);
        g2.\u0102(j2);
        long l2 = p2.\u0130();
        int n3 = p2.\u0128();
        String string3 = this.getCatalog(p2, this.dbConnection);
        String string4 = p2.\u012e() != null ? p2.\u012e() : this.dbConnection.\u012c();
        H.B b2 = H.B.\u010b;
        String string5 = this.dbConnection.\u0117();
        boolean bl3 = p2.\u0126();
        boolean bl4 = p2.\u0133();
        boolean bl5 = p2.\u012d();
        com.onseven.dbvis.R.H h2 = new com.onseven.dbvis.R.H();
        boolean bl6 = p2.\u0145().equals("result") || p2.\u0145().equals("all");
        A a2 = this.createCallback(l2, n3, bl6);
        this.executor = new H(false, a2, null, s2, 0L);
        this.executor.\u010c(E.A.\u0102);
        this.executor.\u010c(this.dbConnection, string3, string4, g2, b2, string5, false, bl3, bl4, bl5, true, h2, this.currentFile, "Executing Command Line");
        try {
            this.executor.\u011d();
            R r2 = this.executor.\u0c2f();
            if (r2.\u0117()) {
                n2 = 3;
            } else if (r2.\u0114() > 0) {
                n2 = 4;
            }
        }
        catch (com.onseven.dbvis.K.C.P p3) {
            LOG.log(Level.WARNING, "Exception when running script", p3);
            throw new IllegalStateException("Executing script: " + p3.getMessage());
        }
        finally {
            if (s2 != null) {
                try {
                    s2.close();
                    s2 = null;
                }
                catch (IOException iOException) {}
            }
            if (this.outputWriter != null) {
                this.outputWriter.close();
                this.outputWriter = null;
            }
        }
        return n2;
    }

    protected A createCallback(long l2, int n2, boolean bl) {
        return new A(l2, n2, bl);
    }

    protected void exit(int n2) {
        System.exit(n2);
    }

    protected void disconnect() {
        try {
            if (this.dbConnection != null) {
                this.dbConnection.\u0142().\u010b().\u0105(false);
                this.dbConnection = null;
            }
        }
        catch (P p2) {
            throw new IllegalStateException("Disconnecting: " + p2.getMessage());
        }
    }

    private String getCatalog(com.onseven.dbvis.util.P p2, com.onseven.dbvis.db.I.H h2) {
        String string = null;
        string = p2.\u0139() != null ? p2.\u0139() : h2.\u0144();
        return string;
    }

    private List<O> getConnections() {
        return Q.\u0102().\u0103().\u0114().\u0c1d();
    }

    private PrintWriter createOutPutWriter(com.onseven.dbvis.util.P p2) throws IOException {
        if (p2.\u0145().equals("none")) {
            return null;
        }
        PrintWriter printWriter = null;
        if (p2.\u0144() != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(p2.\u0144()));
            printWriter = new PrintWriter(fileOutputStream);
        } else {
            printWriter = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
        }
        return printWriter;
    }

    private S createExecutionLogHandler(com.onseven.dbvis.util.P p2) throws IOException {
        com.onseven.dbvis.K.C.C.Q q2 = new com.onseven.dbvis.K.C.C.Q();
        q2.\u0103(true);
        S s2 = J.\u0102().\u0101("dbviscmd", q2, "");
        if (this.shallLogCommands(p2)) {
            com.onseven.dbvis.K.C.C.B.F f2 = this.initLogTextOptions(p2);
            com.onseven.dbvis.K.C.C.B.B b2 = new com.onseven.dbvis.K.C.C.B.B(this.getLogHandlerPrintWriter(), q2, f2);
            s2.\u0107(b2);
        }
        return s2;
    }

    protected PrintWriter getLogHandlerPrintWriter() throws IOException {
        return this.outputWriter;
    }

    protected com.onseven.dbvis.K.C.C.B.F initLogTextOptions(com.onseven.dbvis.util.P p2) {
        return com.onseven.dbvis.K.C.B.A.A.R.\u0164();
    }

    protected boolean shallLogCommands(com.onseven.dbvis.util.P p2) {
        String string = p2.\u0145();
        return !string.equals("none") && !string.equals("result");
    }

    private com.onseven.dbvis.b.J getScriptSources(com.onseven.dbvis.util.P p2) throws IOException {
        Object object;
        String string;
        com.onseven.dbvis.b.J j2;
        com.onseven.dbvis.b.C c2;
        String string2 = null;
        String string3 = System.getProperty("user.dir");
        String string4 = p2.\u0136();
        if (string4 != null) {
            if (string4.trim().isEmpty()) {
                throw new IllegalStateException("The command for the -sql parameter must not be empty");
            }
            c2 = new K(string4);
            j2 = new com.onseven.dbvis.b.J(string4);
        } else {
            string = p2.\u013a();
            object = new File(string);
            if (!((File)object).exists()) {
                throw new IllegalStateException("The -sqlfile parameter refers '" + string + "' that doesn't exist");
            }
            if (((File)object).length() == 0L) {
                throw new IllegalStateException("The -sqlfile parameter requires a file with content");
            }
            this.currentFile = object;
            string2 = p2.\u0142();
            c2 = new com.onseven.dbvis.b.F((File)object, string2);
            j2 = new com.onseven.dbvis.b.J(c2);
            string3 = ((File)object).getParent();
        }
        string = this.dbConnection.\u0142().\u0101().\u0104();
        object = new com.onseven.dbvis.b.G(string, c2);
        Vector<I> vector = ((com.onseven.dbvis.b.G)object).\u0104();
        if (c2 instanceof com.onseven.dbvis.b.F) {
            ((com.onseven.dbvis.b.F)c2).\u010f();
            if (vector.size() > 50000) {
                System.out.println("\nIf the file you specified with -sqlfile does not contain any @run commands, it will be processed much faster if you use -sql \"@run <fileName>\". Use Ctrl-C to stop and rerun with -sql\n");
            }
        }
        ArrayList<com.onseven.dbvis.b.F> arrayList = null;
        int n2 = 0;
        E e2 = new E();
        Enumeration<I> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            I i2 = enumeration.nextElement();
            String string5 = i2.\u0105();
            com.onseven.dbvis.K.C.B.A.B b2 = D.\u0102();
            com.onseven.dbvis.K.C.B.A.C c3 = b2.\u0101(null, string5, e2);
            com.onseven.dbvis.b.F f2 = null;
            if (c3 != null) {
                if (c3.\u014e().\u0101(com.onseven.dbvis.K.C.B.A.E.\u011c.\u0102())) {
                    string3 = c3.\u014c();
                } else if (c3.\u014e().\u0101(com.onseven.dbvis.K.C.B.A.E.\u0109.\u0102())) {
                    String string6 = M.\u0109().getProperty("VariableIdentifierPrefix");
                    V v2 = (V)c3;
                    f2 = v2.\u010c(string6, string3, string2);
                }
            }
            if (f2 != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<com.onseven.dbvis.b.F>();
                    j2.\u0101(arrayList);
                }
                arrayList.add(f2);
            }
            if (++n2 % 10000 != 0) continue;
            System.out.println("Scanned " + (n2 - 1) + " of " + vector.size() + " statements for @run commands");
        }
        return j2;
    }

    private com.onseven.dbvis.db.I.H connect(com.onseven.dbvis.util.P p2) throws P {
        Object object;
        Object object2;
        com.onseven.dbvis.db.I.H h2 = null;
        if (p2.\u0138()) {
            object2 = this.createTmpAlias();
            object = p2.\u0141();
            String string = p2.\u0137();
            String string2 = p2.\u0127();
            if (object == null && string != null && string2 != null) {
                object = (String)object2 + "-driver";
            }
            h2 = com.onseven.dbvis.db.I.H.\u0101((String)object, string, p2.\u013b(), (String)object2, string2, p2.\u012a(), p2.\u0131(), "jdbc");
        } else {
            h2 = com.onseven.dbvis.db.I.H.\u0101(null, null, null, p2.\u012b(), null, p2.\u012a(), p2.\u0131(), "jdbc");
            if (h2 != null && p2.\u0131() != null && (object2 = h2.\u0142()) != null) {
                ((O)object2).\u0112().setProperty("ConnectionPassword", "ClearAtDisconnect");
            }
        }
        if (h2 != null) {
            h2.\u0104(false);
            object2 = this.getCatalog(p2, h2);
            Object object3 = object = object2 != null ? h2.\u0142().\u0105((String)object2) : h2.\u0142();
            if (!h2.equals(((O)object).\u010b())) {
                ((O)object).\u0101(false);
                h2 = ((O)object).\u010b();
            }
        }
        return h2;
    }

    protected String createTmpAlias() {
        String string = "dbviscommand-" + Q.\u0102().\u0112();
        return string;
    }

    private int listDson(com.onseven.dbvis.util.P p2) {
        final boolean bl = p2.\u0132();
        String string = p2.\u0146();
        File file = new File(string);
        if (!file.isDirectory()) {
            System.out.println("Not an accessible directory " + string);
            return 2;
        }
        final FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        com.onseven.dbvis.util.K.F f2 = new com.onseven.dbvis.util.K.F(){

            @Override
            protected void \u0101(File file, com.onseven.dbvis.util.K.J j2) {
                long l2 = file.lastModified();
                String string = fastDateFormat.format(l2);
                String string2 = bl ? file.getAbsolutePath() : file.getName();
                String string3 = j2.\u0105().name();
                System.out.println(String.format("%-12s %-5s %-7s", string, string3, string2));
            }
        };
        Path path = Paths.get(string, new String[0]);
        try {
            f2.\u0101(path, bl);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Got exception when listing DSON files file", iOException);
        }
        return 0;
    }

    protected int convertDson(com.onseven.dbvis.util.P p2) {
        int n2 = 2;
        PrintWriter printWriter = new PrintWriter(System.out);
        String string = p2.\u013e();
        File file = new File(string);
        if (!file.isFile()) {
            System.out.println("Not an accessible file " + string);
            return n2;
        }
        com.onseven.dbvis.K.C.C.B.F f2 = new com.onseven.dbvis.K.C.C.B.F(null);
        f2.\u0104(true);
        f2.\u0102(true);
        f2.\u0101(false);
        f2.\u0114();
        try {
            J.\u0102().\u0101(file, printWriter, null, f2);
            n2 = 0;
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Got exception when converting Json file", exception);
        }
        return n2;
    }

    protected int formatDson(com.onseven.dbvis.util.P p2) {
        int n2 = 2;
        PrintWriter printWriter = new PrintWriter(System.out);
        String string = p2.\u0125();
        File file = new File(string);
        if (!file.isFile()) {
            System.out.println("Not an accessible file " + string);
            return n2;
        }
        com.onseven.dbvis.util.K.B b2 = new com.onseven.dbvis.util.K.B();
        try {
            b2.\u0101(file.getAbsolutePath(), printWriter);
            printWriter.flush();
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Got exception when formating Json file", iOException);
        }
        return n2;
    }

    static {
        LOG = Logger.getLogger(DbVisualizerCmd.class.getName());
    }

    private static class B
    extends A.A.A {
        protected B(A.A a2) {
            super(a2);
        }

        @Override
        public void \u0101() {
            char[] cArray;
            DbVisualizerCmd.getApplication();
            com.onseven.dbvis.util.P p2 = (com.onseven.dbvis.util.P)DbVisualizerCmd.getArgumentParser();
            String string = p2.\u013c();
            if (string != null) {
                cArray = string.toCharArray();
                if (!this.\u0101(cArray)) {
                    throw new IllegalArgumentException("Invalid Master Password provided with -masterpw");
                }
            } else {
                System.out.println("Please enter the Master Password: ");
                Console console = System.console();
                cArray = console.readPassword();
                while (!this.\u0101(cArray)) {
                    System.out.println("Invalid Master Password. Please try again: ");
                    cArray = console.readPassword();
                }
            }
            this.\u0102.\u0101(cArray);
            Arrays.fill(cArray, ' ');
        }
    }

    protected class A
    implements com.onseven.dbvis.K.C.B {
        private long \u0102 = -1L;
        private int \u0104 = -1;
        private final boolean \u0103;

        public A(long l2, int n2, boolean bl) {
            this.\u0102 = l2;
            this.\u0104 = n2;
            this.\u0103 = bl;
        }

        @Override
        public long \u0101() {
            return this.\u0102;
        }

        @Override
        public int \u0102() {
            return this.\u0104;
        }

        @Override
        public void \u0101(C c2) {
            if (c2 != null && c2.getRowCount() > 0 && DbVisualizerCmd.this.outputWriter != null && this.\u0103) {
                this.\u0101(c2, DbVisualizerCmd.this.outputWriter);
            }
        }

        @Override
        public void \u0101(com.onseven.dbvis.sql.A.A a2) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private void \u0101(C c2, PrintWriter printWriter) {
            com.onseven.dbvis.K.B.I i2 = new com.onseven.dbvis.K.B.I(c2, true);
            while (i2.hasNext()) {
                StringBuffer stringBuffer = i2.\u0105();
                if (stringBuffer == null) continue;
                printWriter.println(stringBuffer);
            }
        }
    }
}

