/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.exe4j.runtime.LauncherEngine;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.update.UpdateScheduleRegistry;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.FirstRun;
import com.install4j.runtime.launcher.integration.LaunchMode;
import com.install4j.runtime.launcher.integration.LaunchSchedule;
import com.install4j.runtime.launcher.integration.UpdateExecutionConfig;
import com.install4j.runtime.launcher.integration.gui.WindowChecker;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.w3c.dom.Element;

public class LauncherIntegration {
    public static final String PROPNAME_LAUNCHER_ID = "install4j.launcherId";
    public static final String FILE_NAME = "launchers.xml";
    public static final String ELEMENT_ROOT = "launcherIntegrations";
    public static final String ELEMENT_LAUNCHER = "launcher";
    public static final String ATTRIBUTE_CHECK_UPDATER = "checkUpdater";
    public static final String ELEMENT_APPLICATION = "application";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_LAUNCH_MODE = "launchMode";
    public static final String ATTRIBUTE_LAUNCH_IN_NEW_PROCESS = "launchInNewProcess";
    public static final String ATTRIBUTE_LAUNCH_SCHEDULE = "launchSchedule";
    public static final String ATTRIBUTE_UPDATE_EXECUTION_MODE = "updateExecutionMode";
    public static final String ATTRIBUTE_UNATTENDED_UPDATE_TITLE = "unattendedUpdateTitle";

    private LauncherIntegration() {
    }

    private static void checkIntegrations(String[] launcherArguments) {
        String launcherId = System.getProperty(PROPNAME_LAUNCHER_ID);
        if (launcherId != null) {
            WindowChecker.initSplashAutoHide();
            File file = InstallerUtil.getInstallerFile(FILE_NAME);
            if (file.exists()) {
                try {
                    LauncherIntegration.processLauncherIntegrations(file, launcherId, launcherArguments);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void processLauncherIntegrations(File file, String launcherId, String[] launcherArguments) throws IOException {
        Element root = XmlHelper.parseFile(file).getDocumentElement();
        for (Element launcherElement : XmlHelper.childElements(root)) {
            String id = XmlHelper.readAttribute(launcherElement, ATTRIBUTE_ID, "");
            if (!Objects.equals(id, launcherId)) continue;
            if (XmlHelper.readAttribute(launcherElement, ATTRIBUTE_CHECK_UPDATER, false)) {
                ExecutionMode executionMode = XmlHelper.readAttribute(launcherElement, ATTRIBUTE_UPDATE_EXECUTION_MODE, ExecutionMode.UNATTENDED);
                String unattendedUpdateTitle = XmlHelper.readAttribute(launcherElement, ATTRIBUTE_UNATTENDED_UPDATE_TITLE, "");
                AutomaticUpdate.checkUpdates(launcherArguments, new UpdateExecutionConfig(executionMode, unattendedUpdateTitle), true, null);
            }
            LauncherIntegration.processLauncherIntegrations(launcherElement);
        }
    }

    private static void processLauncherIntegrations(Element launcherElement) throws IOException {
        boolean hasFirstWindowInProcessRunnables;
        final ArrayList<Runnable> nonBlockingRunnables = new ArrayList<Runnable>();
        final ArrayList<Runnable> firstWindowInProcessRunnables = new ArrayList<Runnable>();
        final ArrayList<Runnable> firstWindowNewProcessRunnables = new ArrayList<Runnable>();
        for (Element applicationElement : XmlHelper.childElements(launcherElement)) {
            if (!Objects.equals(applicationElement.getTagName(), ELEMENT_APPLICATION)) continue;
            LauncherIntegration.processLauncherIntegration(applicationElement, nonBlockingRunnables, firstWindowInProcessRunnables, firstWindowNewProcessRunnables);
        }
        boolean hasNonBlockingRunnables = nonBlockingRunnables.size() > 0;
        final CountDownLatch countDownLatch = new CountDownLatch(hasNonBlockingRunnables ? 1 : 0);
        if (hasNonBlockingRunnables) {
            new Thread("install4j: non-blocking installer apps"){

                @Override
                public void run() {
                    try {
                        for (Runnable runnable : nonBlockingRunnables) {
                            runnable.run();
                        }
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            }.start();
        }
        boolean bl = hasFirstWindowInProcessRunnables = firstWindowInProcessRunnables.size() > 0;
        if (hasFirstWindowInProcessRunnables || firstWindowNewProcessRunnables.size() > 0) {
            WindowChecker.onFirstWindowShown(new Runnable(){

                @Override
                public void run() {
                    for (Runnable runnable : firstWindowNewProcessRunnables) {
                        runnable.run();
                    }
                    if (hasFirstWindowInProcessRunnables) {
                        try {
                            countDownLatch.await();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        for (Runnable runnable : firstWindowInProcessRunnables) {
                            runnable.run();
                        }
                    }
                }
            }, hasFirstWindowInProcessRunnables);
        }
    }

    private static String[] getArguments() {
        if (Launcher.isService()) {
            return new String[]{"-q"};
        }
        if (Boolean.getBoolean("java.awt.headless")) {
            if (System.console() == null) {
                return new String[]{"-q"};
            }
            return new String[]{"-c"};
        }
        return null;
    }

    private static void processLauncherIntegration(Element applicationElement, List<Runnable> nonBlockingRunnables, List<Runnable> firstWindowInProcessRunnables, List<Runnable> firstWindowNewProcessRunnables) throws IOException {
        final String id = XmlHelper.readAttribute(applicationElement, ATTRIBUTE_ID, "");
        LaunchMode launchMode = XmlHelper.readAttribute(applicationElement, ATTRIBUTE_LAUNCH_MODE, LaunchMode.STARTUP_ASNYC);
        final boolean launchInNewProcess = XmlHelper.readAttribute(applicationElement, ATTRIBUTE_LAUNCH_IN_NEW_PROCESS, false);
        LaunchSchedule launchSchedule = XmlHelper.readAttribute(applicationElement, ATTRIBUTE_LAUNCH_SCHEDULE, LaunchSchedule.ALWAYS);
        if (launchSchedule == LaunchSchedule.FIRST_RUN ? !FirstRun.isFirstRun(true) : launchSchedule == LaunchSchedule.UPDATE_SCHEDULE && !UpdateScheduleRegistry.checkAndReset()) {
            return;
        }
        final String[] arguments = LauncherIntegration.getArguments();
        if (launchMode == LaunchMode.FIRST_WINDOW) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (launchInNewProcess) {
                            ApplicationLauncher.launchApplication(id, arguments, false, null);
                        } else {
                            ApplicationLauncher.launchApplicationInProcess(id, arguments, null, ApplicationLauncher.WindowMode.FRAME, null);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            if (launchInNewProcess) {
                firstWindowNewProcessRunnables.add(runnable);
            } else {
                firstWindowInProcessRunnables.add(runnable);
            }
        } else {
            boolean blocking;
            boolean bl = blocking = launchMode == LaunchMode.STARTUP_SYNC;
            if (launchInNewProcess) {
                ApplicationLauncher.launchApplication(id, arguments, blocking, null);
            } else {
                try {
                    if (!GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
                        GUIHelper.setLafUnconditional();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ApplicationLauncher.launchApplicationInProcess(id, arguments, null, ApplicationLauncher.WindowMode.FRAME, null);
                    }
                };
                if (blocking) {
                    runnable.run();
                } else {
                    nonBlockingRunnables.add(runnable);
                }
            }
        }
    }

    public static void init() {
        LauncherEngine.setIntegrationChecker(new LauncherEngine.IntegrationChecker(){

            @Override
            public void checkIntegrations(String[] args) {
                LauncherIntegration.checkIntegrations(args);
            }
        });
    }
}

