/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.context.Context;
import org.jetbrains.annotations.Nullable;

public class CompilerVariableHelper {
    public static final String EXTENSION_VARIABLE_PREFIX = "sys.ext.";

    public static boolean getCompilerExtensionVariable(@Nullable Context context, String name, boolean defaultValue) {
        String variableValue = CompilerVariableHelper.getCompilerExtensionVariable(context, name, null);
        if (variableValue != null) {
            return Boolean.parseBoolean(variableValue);
        }
        return defaultValue;
    }

    public static int getCompilerExtensionVariable(@Nullable Context context, String name, int defaultValue) {
        String variableValue = CompilerVariableHelper.getCompilerExtensionVariable(context, name, null);
        if (variableValue != null) {
            try {
                return Integer.parseInt(variableValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String getCompilerExtensionVariable(@Nullable Context context, String name, String defaultValue) {
        String variableValue;
        if (context != null && (variableValue = context.getCompilerVariable(EXTENSION_VARIABLE_PREFIX + name)) != null) {
            return variableValue;
        }
        return defaultValue;
    }
}

