/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.groups;

import com.install4j.api.beans.Anchor;
import com.install4j.api.beans.ExternalFile;
import com.install4j.runtime.beans.formcomponents.AxisType;
import com.install4j.runtime.beans.formcomponents.BorderSides;
import com.install4j.runtime.beans.groups.FormComponentGroup;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.MaximizedLayeredPane;
import com.install4j.runtime.util.PartialLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;

public abstract class LayoutManagerGroup
extends FormComponentGroup {
    private ExternalFile imageFile = null;
    private Anchor imageAnchor = Anchor.NORTHWEST;
    private AxisType imageEdgeAxisType = AxisType.VERTICAL;
    private Color imageEdgeBackgroundColor = null;
    private Insets imageInsets = new Insets(0, 0, 0, 0);
    private boolean imageOverlap = false;
    private boolean imageEdgeBorder = false;
    private Color imageEdgeBorderColor = null;
    private int imageEdgeBorderWidth = 1;
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private BorderSides borderSides;
    private String borderTitle = "";
    private Color borderColor = null;
    private int borderWidth = 1;
    private int cellSpacing = this.getDefaultCellSpacing();
    private JPanel panel;

    public ExternalFile getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(ExternalFile imageFile) {
        this.imageFile = imageFile;
    }

    public Anchor getImageAnchor() {
        return this.imageAnchor;
    }

    public void setImageAnchor(Anchor imageAnchor) {
        this.imageAnchor = imageAnchor;
    }

    public AxisType getImageEdgeAxisType() {
        return this.imageEdgeAxisType;
    }

    public void setImageEdgeAxisType(AxisType imageEdgeAxisType) {
        this.imageEdgeAxisType = imageEdgeAxisType;
    }

    public Color getImageEdgeBackgroundColor() {
        return this.imageEdgeBackgroundColor;
    }

    public void setImageEdgeBackgroundColor(Color imageEdgeBackgroundColor) {
        this.imageEdgeBackgroundColor = imageEdgeBackgroundColor;
    }

    public Insets getImageInsets() {
        return this.imageInsets;
    }

    public void setImageInsets(Insets imageInsets) {
        this.imageInsets = imageInsets;
    }

    public boolean isImageOverlap() {
        return this.imageOverlap;
    }

    public void setImageOverlap(boolean imageOverlap) {
        this.imageOverlap = imageOverlap;
    }

    public boolean isImageEdgeBorder() {
        return this.imageEdgeBorder;
    }

    public void setImageEdgeBorder(boolean imageEdgeBorder) {
        this.imageEdgeBorder = imageEdgeBorder;
    }

    public Color getImageEdgeBorderColor() {
        return this.imageEdgeBorderColor;
    }

    public void setImageEdgeBorderColor(Color imageEdgeBorderColor) {
        this.imageEdgeBorderColor = imageEdgeBorderColor;
    }

    public int getImageEdgeBorderWidth() {
        return this.imageEdgeBorderWidth;
    }

    public void setImageEdgeBorderWidth(int imageEdgeBorderWidth) {
        this.imageEdgeBorderWidth = imageEdgeBorderWidth;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public BorderSides getBorderSides() {
        return this.borderSides;
    }

    public void setBorderSides(BorderSides borderSides) {
        this.borderSides = borderSides;
    }

    public String getBorderTitle() {
        return LayoutManagerGroup.replaceVariables(this.borderTitle);
    }

    public void setBorderTitle(String borderTitle) {
        this.borderTitle = borderTitle;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    protected LayoutManagerGroup() {
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(int cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    protected abstract int getDefaultCellSpacing();

    @Override
    public JComponent createComponent(JComponent container) {
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        this.panel.setBorder(this.createInsetsBorder(this.getInsets()));
        return this.panel;
    }

    public EmptyBorder createInsetsBorder(Insets insets) {
        return new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.panel != null) {
            this.panel.setVisible(visible);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JComponent wrap(JComponent component) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setOpaque(false);
        wrapper.setBorder(this.createWrapperBorder());
        if (this.backgroundColor != null) {
            wrapper.setBackground(this.getBackgroundColor());
            wrapper.setOpaque(true);
        } else {
            wrapper.setOpaque(false);
        }
        wrapper.add((Component)this.createWrapperContent(component), "Center");
        return wrapper;
    }

    private JComponent createWrapperContent(final JComponent component) {
        ExternalFile imageFile = this.getImageFile();
        if (imageFile == null) {
            return component;
        }
        return GUIHelper.withIcon(imageFile, component, this.getContext(), new GUIHelper.IconConsumer<JComponent>(){

            @Override
            public JComponent call(@NotNull ImageIcon icon) {
                if (LayoutManagerGroup.this.isEffectiveImageOverlap()) {
                    MaximizedLayeredPane layeredPane = new MaximizedLayeredPane();
                    layeredPane.setOpaque(false);
                    layeredPane.add((Component)component, JLayeredPane.PALETTE_LAYER);
                    layeredPane.add((Component)LayoutManagerGroup.this.createImagePanel(new JLabel(icon)), JLayeredPane.DEFAULT_LAYER);
                    return layeredPane;
                }
                JPanel backPanel = new JPanel(new GridBagLayout());
                backPanel.setOpaque(false);
                GridBagConstraints gc = LayoutManagerGroup.this.createImagePanelConstraint();
                boolean imageFirstComponent = LayoutManagerGroup.this.isImageFirstComponent();
                LayoutManagerGroup.this.adjustImagePanelRowOrColumn(gc, imageFirstComponent);
                backPanel.add((Component)LayoutManagerGroup.this.createImagePanel(new JLabel(icon)), gc);
                LayoutManagerGroup.this.adjustImagePanelRowOrColumn(gc, !imageFirstComponent);
                gc.weighty = 1.0;
                gc.weightx = 1.0;
                gc.fill = 1;
                gc.anchor = 10;
                backPanel.add((Component)component, gc);
                return backPanel;
            }
        });
    }

    private boolean isEffectiveImageOverlap() {
        return this.getImageAnchor() == Anchor.CENTER || this.isImageOverlap();
    }

    private void adjustImagePanelRowOrColumn(GridBagConstraints gc, boolean first) {
        int index;
        int n = index = first ? 0 : 1;
        if (this.getImagePanelAxis() == AxisType.HORIZONTAL) {
            gc.gridy = index;
        } else {
            gc.gridx = index;
        }
    }

    private GridBagConstraints createImagePanelConstraint() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = this.getImagePanelConstraintWeight(AxisType.HORIZONTAL);
        gc.weighty = this.getImagePanelConstraintWeight(AxisType.VERTICAL);
        gc.fill = this.getImagePanelFill();
        gc.anchor = this.getImageAnchor().getValue();
        return gc;
    }

    private int getImagePanelFill() {
        Anchor anchor = this.getImageAnchor();
        switch (anchor) {
            case CENTER: {
                return 0;
            }
            case NORTHWEST: 
            case NORTHEAST: 
            case SOUTHWEST: 
            case SOUTHEAST: {
                return this.imageEdgeAxisType == AxisType.HORIZONTAL ? 2 : 3;
            }
            case NORTH: 
            case SOUTH: {
                return 2;
            }
            case WEST: 
            case EAST: {
                return 3;
            }
        }
        throw new IllegalStateException(anchor.name());
    }

    private double getImagePanelConstraintWeight(AxisType gridBagAxisType) {
        Anchor anchor = this.getImageAnchor();
        switch (anchor) {
            case NORTHWEST: 
            case NORTHEAST: 
            case SOUTHWEST: 
            case SOUTHEAST: {
                return this.imageEdgeAxisType == gridBagAxisType ? 1.0 : 0.0;
            }
            case NORTH: 
            case SOUTH: {
                return gridBagAxisType == AxisType.HORIZONTAL ? 1.0 : 0.0;
            }
            case CENTER: {
                return 1.0;
            }
            case WEST: 
            case EAST: {
                return gridBagAxisType == AxisType.VERTICAL ? 1.0 : 0.0;
            }
        }
        throw new IllegalStateException(anchor.name());
    }

    private AxisType getImagePanelAxis() {
        Anchor anchor = this.getImageAnchor();
        switch (anchor) {
            case NORTHWEST: 
            case NORTHEAST: 
            case SOUTHWEST: 
            case SOUTHEAST: {
                return this.imageEdgeAxisType;
            }
            case NORTH: 
            case SOUTH: {
                return AxisType.HORIZONTAL;
            }
            case WEST: 
            case EAST: {
                return AxisType.VERTICAL;
            }
        }
        throw new IllegalStateException(anchor.name());
    }

    private boolean isImageFirstComponent() {
        Anchor anchor = this.getImageAnchor();
        switch (anchor) {
            case NORTHWEST: 
            case NORTH: 
            case WEST: {
                return true;
            }
            case SOUTHEAST: 
            case SOUTH: 
            case EAST: {
                return false;
            }
            case NORTHEAST: {
                return this.imageEdgeAxisType == AxisType.HORIZONTAL;
            }
            case SOUTHWEST: {
                return this.imageEdgeAxisType == AxisType.VERTICAL;
            }
        }
        throw new IllegalStateException(anchor.name());
    }

    private int getImageEdgeBorderFlag() {
        Anchor anchor = this.getImageAnchor();
        switch (anchor) {
            case NORTHWEST: {
                return this.imageEdgeAxisType == AxisType.HORIZONTAL ? 2 : 4;
            }
            case NORTH: {
                return 2;
            }
            case NORTHEAST: {
                return this.imageEdgeAxisType == AxisType.HORIZONTAL ? 2 : 8;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 8;
            }
            case SOUTHWEST: {
                return this.imageEdgeAxisType == AxisType.HORIZONTAL ? 1 : 4;
            }
            case SOUTH: {
                return 1;
            }
            case SOUTHEAST: {
                return this.imageEdgeAxisType == AxisType.HORIZONTAL ? 1 : 8;
            }
        }
        throw new IllegalStateException(anchor.name());
    }

    private JComponent createImagePanel(JLabel label) {
        JPanel edgePanel = new JPanel(new GridBagLayout());
        if (this.imageEdgeBackgroundColor != null) {
            edgePanel.setOpaque(true);
            edgePanel.setBackground(this.imageEdgeBackgroundColor);
        } else {
            edgePanel.setOpaque(false);
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.anchor = this.getImageAnchor().getValue();
        edgePanel.add((Component)label, gc);
        edgePanel.setBorder(this.createImagePanelBorder());
        return edgePanel;
    }

    private Border createImagePanelBorder() {
        EmptyBorder insetsBorder = this.createInsetsBorder(this.imageInsets);
        if (this.imageEdgeBorder && !this.isEffectiveImageOverlap()) {
            Color color = this.imageEdgeBorderColor == null ? GUIHelper.getSeparatorColor() : this.imageEdgeBorderColor;
            PartialLineBorder lineBorder = new PartialLineBorder(color, this.imageEdgeBorderWidth, this.getImageEdgeBorderFlag());
            return BorderFactory.createCompoundBorder(lineBorder, insetsBorder);
        }
        return insetsBorder;
    }

    private Border createWrapperBorder() {
        Color color = this.borderColor == null ? GUIHelper.getSeparatorColor() : this.borderColor;
        int borderSideFlags = this.borderSides == null ? 0 : this.borderSides.getBorderFlags();
        PartialLineBorder border = new PartialLineBorder(color, this.getBorderWidth(), borderSideFlags);
        String title = this.getBorderTitle();
        if (borderSideFlags == 15 && !title.isEmpty()) {
            return new TitledBorder(border, title);
        }
        return border;
    }
}

