/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.runtime.beans.formcomponents.FormattedTextfieldComponent;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.MaskFormatter;

public class MaskTextfieldComponent
extends FormattedTextfieldComponent {
    private String inputMask = "###-##-####";
    private String placeholderCharacter = "0";
    private boolean valueContainsLiteralCharacters = true;
    private String validCharacters = "";
    private String invalidCharacters = "";
    private boolean allowsInvalid = false;

    public String getInputMask() {
        return this.inputMask;
    }

    public void setInputMask(String inputMask) {
        this.inputMask = inputMask;
    }

    public String getPlaceholderCharacter() {
        return this.placeholderCharacter;
    }

    public boolean isValueContainsLiteralCharacters() {
        return this.valueContainsLiteralCharacters;
    }

    public void setValueContainsLiteralCharacters(boolean valueContainsLiteralCharacters) {
        this.valueContainsLiteralCharacters = valueContainsLiteralCharacters;
    }

    public String getValidCharacters() {
        return this.validCharacters;
    }

    public void setValidCharacters(String validCharacters) {
        this.validCharacters = validCharacters;
    }

    public String getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public void setInvalidCharacters(String invalidCharacters) {
        this.invalidCharacters = invalidCharacters;
    }

    public void setPlaceholderCharacter(String placeholderCharacter) {
        this.placeholderCharacter = placeholderCharacter.length() == 0 ? " " : placeholderCharacter.substring(0, 1);
    }

    public boolean isAllowsInvalid() {
        return this.allowsInvalid;
    }

    public void setAllowsInvalid(boolean allowsInvalid) {
        this.allowsInvalid = allowsInvalid;
    }

    @Override
    protected DefaultFormatter createFormatter() {
        try {
            MaskFormatter maskFormatter = new MaskFormatter(this.inputMask);
            maskFormatter.setPlaceholderCharacter(this.placeholderCharacter.charAt(0));
            maskFormatter.setValueContainsLiteralCharacters(this.valueContainsLiteralCharacters);
            if (this.validCharacters.trim().length() > 0) {
                maskFormatter.setValidCharacters(this.validCharacters);
            }
            if (this.invalidCharacters.trim().length() > 0) {
                maskFormatter.setInvalidCharacters(this.invalidCharacters);
            }
            maskFormatter.setAllowsInvalid(this.allowsInvalid);
            return maskFormatter;
        }
        catch (ParseException e) {
            Util.fatalError(e);
            return null;
        }
    }

    @Override
    protected String getFormatDescription() {
        JFormattedTextField textField = (JFormattedTextField)this.getTextComponent();
        return " [" + ((MaskFormatter)textField.getFormatter()).getMask() + "]";
    }
}

