/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.AbstractInstallFilesAction;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.IOException;
import java.util.Objects;

public class DownloadAndInstallComponentAction
extends AbstractInstallFilesAction {
    private String componentId = "";
    private boolean showProgress = true;
    private boolean installInSingleBundle = true;

    public String getComponentId() {
        return DownloadAndInstallComponentAction.replaceVariables(this.componentId);
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isInstallInSingleBundle() {
        return this.installInSingleBundle;
    }

    public void setInstallInSingleBundle(boolean installInSingleBundle) {
        this.installInSingleBundle = installInSingleBundle;
    }

    @Override
    protected ProgressInterface getProgressInterface(InstallerContext context) {
        ProgressInterface progressInterface = super.getProgressInterface(context);
        if (!this.isShowProgress()) {
            progressInterface = new NoPercentageProgressDelegate(progressInterface);
        }
        return progressInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        ProgressInterface progressInterface = this.getProgressInterface(context);
        try {
            FileInstaller.getInstance().setLogDir(context.getDestinationFile(".install4j"));
            FileInstaller.getInstance().resetCurrentRebootRequired();
            String componentId = this.getInternalComponentId();
            try {
                ContentInstaller.getInstance().doComponentInstallation(context, progressInterface, componentId, this.installInSingleBundle, this);
            }
            catch (ReadIOException e) {
                Logger.getInstance().error(this, "content corrupted.");
                Logger.getInstance().log(e.getCause());
                boolean bl = false;
                return bl;
            }
            catch (UserCanceledException e) {
                if (context.isCancelling()) {
                    throw e;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.isTriggerReboot() && this.isDelay() && FileInstaller.getInstance().isCurrentRebootRequired()) {
                    context.triggerReboot(true);
                }
            }
            if (context.isCancelling()) {
                throw new UserCanceledException();
            }
        }
        catch (IOException e) {
            context.handleCriticalException(e);
            return false;
        }
        progressInterface.setDetailMessage("");
        return true;
    }

    private String getInternalComponentId() {
        String componentId = this.getComponentId();
        for (ComponentConfig componentConfig : InstallerConfig.getCurrentInstance().getComponents()) {
            if (!Objects.equals(componentConfig.getCustomizedId(), componentId)) continue;
            return componentConfig.getId();
        }
        return componentId;
    }
}

