/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIUtil;

public class XTICompressor
implements XTIConstants {
    static byte[] compressXTINPage(byte[] byArray, int n) throws XTIException {
        byte[] byArray2 = new byte[4096];
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        if (n == 0) {
            XTICompressor.compressRootPage(byArray, byArray2);
            return byArray2;
        }
        block7: for (int i = 0; i < 4096 && bl; i += 32) {
            n2 = byArray[i] & 0xF;
            switch (n2) {
                case 2: {
                    n3 = XTICompressor.compressAttributeNode(byArray, byArray2, i, n3, n);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 8: {
                    if (n2 == 4) {
                        boolean bl2 = false;
                    }
                    n3 = XTICompressor.compressTextNode(byArray, byArray2, i, n3, n);
                    continue block7;
                }
                case 9: 
                case 11: {
                    n3 = XTICompressor.compressDocumentFragment(byArray, byArray2, i, n3, n);
                    continue block7;
                }
                case 1: {
                    n3 = XTICompressor.compressElementNode(byArray, byArray2, i, n3, n);
                    continue block7;
                }
                case 7: {
                    n3 = XTICompressor.compressPINode(byArray, byArray2, i, n3, n);
                    continue block7;
                }
                default: {
                    bl = false;
                }
            }
        }
        return byArray2;
    }

    static void compressRootPage(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 4096);
    }

    static int compressDocumentFragment(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        byArray2[n2] = byArray[n];
        byte by = XTICompressor.writeXTINAddress(byArray, byArray2, n + 12, n2 + 2, n3);
        byArray2[++n2] = by;
        n2 += XTICompressor.getCount(by);
        return ++n2;
    }

    static int compressAttributeNode(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = n2;
        byArray2[n2] = byArray[n];
        byte by = XTICompressor.writeXTICAddress(byArray, byArray2, n + 4, n2 += 3, n3);
        byte by2 = XTICompressor.writeXTICTextAddress(byArray, byArray2, n + 12, n2 += XTICompressor.getCount(by), n3);
        byte by3 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 20, n2 += XTICompressor.getTextCount(by2), n3);
        byte by4 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 24, n2 += XTICompressor.getCount(by3), n3);
        byte by5 = byArray[n + 29];
        byArray2[n4 + 1] = (byte)(by << 4 | by2 << 2 | by3);
        byArray2[n4 + 2] = (byte)(by4 << 3 | by5);
        return n2 += XTICompressor.getCount(by4);
    }

    static int compressElementNode(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = n2;
        byArray2[n2] = byArray[n];
        byte by = XTICompressor.writeXTICAddress(byArray, byArray2, n + 4, n2 += 3, n3);
        byte by2 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 12, n2 += XTICompressor.getCount(by), n3);
        byte by3 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 16, n2 += XTICompressor.getCount(by2), n3);
        byte by4 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 20, n2 += XTICompressor.getCount(by3), n3);
        byte by5 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 24, n2 += XTICompressor.getCount(by4), n3);
        byte by6 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 28, n2 += XTICompressor.getCount(by5), n3);
        byArray2[n4 + 1] = (byte)(by << 3 | by2);
        byArray2[n4 + 2] = (byte)(by3 << 6 | by4 << 4 | by5 << 2 | by6);
        return n2 += XTICompressor.getCount(by6);
    }

    static int compressPINode(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = n2;
        byArray2[n2] = byArray[n];
        byte by = XTICompressor.writeXTICAddress(byArray, byArray2, n + 4, n2 += 3, n3);
        byte by2 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 16, n2 += XTICompressor.getCount(by), n3);
        byte by3 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 20, n2 += XTICompressor.getCount(by2), n3);
        byte by4 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 24, n2 += XTICompressor.getCount(by3), n3);
        byArray2[n4 + 1] = by;
        byArray2[n4 + 2] = (byte)(by2 << 4 | by3 << 2 | by4);
        return n2 += XTICompressor.getCount(by4);
    }

    static int compressTextNode(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = n2;
        byArray2[n2] = byArray[n];
        byte by = XTICompressor.writeXTICTextAddress(byArray, byArray2, n + 4, n2 += 2, n3);
        byte by2 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 16, n2 += XTICompressor.getTextCount(by), n3);
        byte by3 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 20, n2 += XTICompressor.getCount(by2), n3);
        byte by4 = XTICompressor.writeXTINAddress(byArray, byArray2, n + 24, n2 += XTICompressor.getCount(by3), n3);
        byArray2[n4 + 1] = (byte)(by << 6 | by2 << 4 | by3 << 2 | by4);
        return n2 += XTICompressor.getCount(by4);
    }

    private static int getCount(byte by) {
        switch (by) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 8;
            }
        }
        return 0;
    }

    static byte writeXTINAddress(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = XTIUtil.byteArrayToInt(byArray, n);
        int n5 = (n4 &= Integer.MAX_VALUE) >> 8;
        int n6 = n3 - n5;
        if (n4 == 0) {
            return 0;
        }
        if (n6 == 0) {
            short s = (short)(n4 & 0xFF);
            byte[] byArray3 = XTIUtil.shortToByteArray(s);
            byArray2[n2] = byArray3[0];
            byArray2[n2 + 1] = byArray3[1];
            return 1;
        }
        if (n6 > 0 && n6 <= 128) {
            short s = 0;
            s = n6 >= 1 ? (short)(n6 - 1) : (short)n6;
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            byte[] byArray4 = XTIUtil.shortToByteArray(s);
            byArray2[n2 + 2] = byArray4[0];
            byArray2[n2 + 3] = byArray4[1];
            return 2;
        }
        byArray2[n2] = byArray[n];
        byArray2[n2 + 1] = byArray[n + 1];
        byArray2[n2 + 2] = byArray[n + 2];
        byArray2[n2 + 3] = byArray[n + 3];
        return 3;
    }

    static byte writeXTICAddress(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = XTIUtil.byteArrayToInt(byArray, n + 4);
        int n5 = XTIUtil.byteArrayToInt(byArray, n);
        if (n4 == 0 && n5 <= 255) {
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            return 1;
        }
        if (n4 == 0 && n5 <= 65535) {
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            byArray2[n2 + 2] = byArray[n + 2];
            byArray2[n2 + 3] = byArray[n + 3];
            return 2;
        }
        if (n4 <= 255 && n5 <= 255) {
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            byArray2[n2 + 2] = byArray[n + 4];
            byArray2[n2 + 3] = byArray[n + 5];
            return 3;
        }
        if (n4 <= 255) {
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            byArray2[n2 + 2] = byArray[n + 2];
            byArray2[n2 + 3] = byArray[n + 3];
            byArray2[n2 + 4] = byArray[n + 4];
            byArray2[n2 + 5] = byArray[n + 5];
            return 4;
        }
        if (n5 <= 255) {
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            byArray2[n2 + 2] = byArray[n + 4];
            byArray2[n2 + 3] = byArray[n + 5];
            byArray2[n2 + 4] = byArray[n + 6];
            byArray2[n2 + 5] = byArray[n + 7];
            return 5;
        }
        byArray2[n2] = byArray[n];
        byArray2[n2 + 1] = byArray[n + 1];
        byArray2[n2 + 2] = byArray[n + 2];
        byArray2[n2 + 3] = byArray[n + 3];
        byArray2[n2 + 4] = byArray[n + 4];
        byArray2[n2 + 5] = byArray[n + 5];
        byArray2[n2 + 6] = byArray[n + 6];
        byArray2[n2 + 7] = byArray[n + 7];
        return 6;
    }

    static byte writeXTICTextAddress(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = XTIUtil.byteArrayToInt(byArray, n + 4);
        int n5 = XTIUtil.byteArrayToInt(byArray, n);
        if (n4 == 0 && n5 <= 15) {
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            return 0;
        }
        if (n4 == 0 && n5 <= 255) {
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            byArray2[n2 + 2] = byArray[n + 2];
            byArray2[n2 + 3] = byArray[n + 3];
            return 1;
        }
        if (n4 <= 15 && n5 <= 255) {
            byArray2[n2] = byArray[n];
            byArray2[n2 + 1] = byArray[n + 1];
            byArray2[n2 + 2] = byArray[n + 2];
            byArray2[n2 + 3] = byArray[n + 3];
            byArray2[n2 + 4] = byArray[n + 4];
            byArray2[n2 + 5] = byArray[n + 5];
            return 2;
        }
        byArray2[n2] = byArray[n];
        byArray2[n2 + 1] = byArray[n + 1];
        byArray2[n2 + 2] = byArray[n + 2];
        byArray2[n2 + 3] = byArray[n + 3];
        byArray2[n2 + 4] = byArray[n + 4];
        byArray2[n2 + 5] = byArray[n + 5];
        byArray2[n2 + 6] = byArray[n + 6];
        byArray2[n2 + 7] = byArray[n + 7];
        return 3;
    }

    private static int getTextCount(byte by) {
        switch (by) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 8;
            }
        }
        return 0;
    }
}

