/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.FloatingDialog;
import de.javasoft.swing.jydocking.FloatingFrame;
import de.javasoft.swing.jydocking.FloatingGroup;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IPerspectiveListener;
import de.javasoft.swing.jydocking.IPerspectiveManager;
import de.javasoft.swing.jydocking.PerspectiveEvent;
import de.javasoft.swing.jydocking.PerspectiveManager;
import de.javasoft.swing.jydocking.PerspectiveModel;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Perspective
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6808527338470585077L;
    private String id;
    private String name;
    private PerspectiveModel model;
    private List<IPerspectiveListener> listeners = new ArrayList<IPerspectiveListener>();
    private boolean loading;
    private boolean unloading;

    public Perspective(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("persistentId cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("perspectiveName cannot be null");
        }
        this.id = string;
        this.name = string2;
        this.model = new PerspectiveModel();
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public boolean addPerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        return this.listeners.add(iPerspectiveListener);
    }

    public boolean removePerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        return this.listeners.remove(iPerspectiveListener);
    }

    public List<IPerspectiveListener> getPerspectiveListeners() {
        return this.listeners;
    }

    public PerspectiveModel getModel() {
        return this.model;
    }

    public void setModel(PerspectiveModel perspectiveModel) {
        this.model = perspectiveModel;
    }

    DockingState getDockingState(IDockable iDockable, boolean bl) {
        return this.getModel().getDockingState(iDockable, bl);
    }

    DockingState getDockingState(String string, boolean bl) {
        return this.getModel().getDockingState(string, bl);
    }

    public void add(IDockable iDockable) {
        this.getModel().add(iDockable);
    }

    public void add(IDockable iDockable, IDockable iDockable2, String string, float f) {
        this.getModel().add(iDockable, iDockable2, string, f);
    }

    public void reset(IDockingPort iDockingPort) {
        PerspectiveModel perspectiveModel = this.getModel();
        if (this.getModel() != null) {
            this.apply(iDockingPort);
            perspectiveModel.updateDockingStates();
            PerspectiveManager.dispatchEvent(new PerspectiveEvent(this, 3));
        }
    }

    private void apply(IDockingPort iDockingPort) {
        boolean bl = PerspectiveManager.isDockingStateListening();
        PerspectiveManager.setDockingStateListening(false);
        PerspectiveManager.clear(iDockingPort);
        List<DockingState> list = this.getModel().getDockableSequence();
        int n = list.size();
        IDockable[] iDockableArray = new IDockable[n];
        int n2 = 0;
        while (n2 < n) {
            IDockable iDockable;
            DockingState dockingState = list.get(n2);
            iDockableArray[n2] = iDockable = DockingManager.getDockable(dockingState.getDockableID());
            String string = dockingState.getRegion();
            if (n2 == 0) {
                DockingManager.dock(iDockable, iDockingPort, this, dockingState.getRegion());
            } else {
                IDockable iDockable2 = DockingManager.getDockable(dockingState.getRelativeParentID());
                float f = dockingState.getSplitRatio();
                DockingManager.dockRelative(iDockable, iDockable2, this, string, f);
            }
            ++n2;
        }
        PerspectiveManager.setDockingStateListening(bl);
        PerspectiveManager.updateDockingStates(iDockableArray);
    }

    void load(IDockingPort iDockingPort) {
        PerspectiveModel perspectiveModel = this.getModel();
        if (perspectiveModel.isInitialized()) {
            this.loading = true;
            perspectiveModel.apply(iDockingPort, this);
            PerspectiveManager.dispatchEvent(new PerspectiveEvent(this, 3));
            this.loading = false;
        } else if (iDockingPort != null) {
            this.reset(iDockingPort);
        }
    }

    boolean isLoading() {
        return this.loading;
    }

    boolean isUnloading() {
        return this.unloading;
    }

    void unload() {
        this.unloading = true;
        IDockable[] iDockableArray = this.getModel().getDockables();
        int n = 0;
        while (n < iDockableArray.length) {
            DockingManager.close(iDockableArray[n], this);
            ++n;
        }
        this.unloading = false;
    }

    void updateRestorationLayoutNode(IDockingPort iDockingPort) {
        if (iDockingPort == null) {
            return;
        }
        IDockable iDockable = DockingManager.getDockable(iDockingPort.getDockedComponent());
        boolean bl = iDockable == null ? false : DockingManager.isMaximized(iDockable);
        IPerspectiveManager iPerspectiveManager = DockingManager.getPerspectiveManager();
        if (!bl) {
            this.model.setRestorationLayout(iPerspectiveManager.createLayoutModel(iDockingPort));
        }
        PerspectiveModel perspectiveModel = this.getModel();
        String[] stringArray = perspectiveModel.getFloatingGroupIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            FloatingGroup floatingGroup = perspectiveModel.getFloatingGroup(string);
            Window window = floatingGroup.getFloatingWindow();
            IDockingPort iDockingPort2 = null;
            if (window instanceof FloatingDialog) {
                iDockingPort2 = ((FloatingDialog)window).getDockingPort();
            } else if (window instanceof FloatingFrame) {
                iDockingPort2 = ((FloatingFrame)window).getDockingPort();
            }
            if (iDockingPort2 != null) {
                floatingGroup.setRestorationLayout(iPerspectiveManager.createLayoutModel(iDockingPort2));
            }
            ++n2;
        }
    }

    public Object clone() {
        Perspective perspective = new Perspective(this.id, this.name);
        perspective.model = (PerspectiveModel)this.model.clone();
        return perspective;
    }
}

