/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.PerspectiveManager;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ActiveDockableTracker
implements PropertyChangeListener,
ChangeListener,
AWTEventListener {
    private static final String DOCKABLE_ACTIVATED = "dockableActivated";
    private static final ActiveDockableTracker INSTANCE = new ActiveDockableTracker();
    private WeakReference<IDockable> activeDockable;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    static {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.addPropertyChangeListener(INSTANCE);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(INSTANCE, 16L);
    }

    private ActiveDockableTracker() {
        this.activeDockable = new WeakReference<Object>(null);
    }

    public static ActiveDockableTracker getInstance() {
        return INSTANCE;
    }

    public IDockable getActiveDockable() {
        return (IDockable)this.activeDockable.get();
    }

    public static void requestDockableActivation(Component component, boolean bl) {
        ActiveDockableTracker.requestDockableActivation(component, null, bl);
    }

    public static void requestDockableActivation(Component component, Component component2, boolean bl) {
        IDockable iDockable = DockingUtility.getAncestorDockable(component);
        if (iDockable != null) {
            ActiveDockableTracker.requestDockableActivation(component, component2, iDockable, bl);
        }
    }

    private static void requestDockableActivation(final Component component, final Component component2, final IDockable iDockable, final boolean bl) {
        ActiveDockableTracker.activateWindow(component);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JTabbedPane jTabbedPane;
                int n;
                if ((bl || !iDockable.isActive()) && SyntheticaLookAndFeel.getBoolean("JYDocking.focusFollowsDockable", iDockable.getComponent(), true)) {
                    ActiveDockableTracker.focusDockable(component, component2, iDockable);
                }
                JComponent jComponent = iDockable.getComponent();
                if ((bl || !iDockable.isActive()) && jComponent.getParent() instanceof JTabbedPane && (n = (jTabbedPane = (JTabbedPane)jComponent.getParent()).indexOfComponent(jComponent)) != jTabbedPane.getSelectedIndex()) {
                    jTabbedPane.setSelectedIndex(n);
                }
                if (bl || !iDockable.isActive()) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (!iDockable.isActive()) {
                                INSTANCE.setActive(iDockable, true);
                            }
                        }
                    });
                }
            }
        });
    }

    private static void activateWindow(Component component) {
        RootWindow rootWindow = RootWindow.getRootWindow(component);
        if (rootWindow != null && !rootWindow.isActive()) {
            rootWindow.toFront();
        }
    }

    private static void focusDockable(Component component, Component component2, IDockable iDockable) {
        JComponent jComponent = iDockable.getComponent();
        Component component3 = component2;
        if (component3 == null) {
            Container container = jComponent instanceof Container ? (Container)jComponent : null;
            Component component4 = component3 = container == null ? null : ActiveDockableTracker.getNearestFocusableComponent(component, container);
            if (component3 == null) {
                component3 = jComponent;
            }
        }
        component3.requestFocus();
    }

    private static Component getNearestFocusableComponent(Component component, Container container) {
        Component component2;
        if (component == null) {
            component = container;
        }
        if (component == null) {
            component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        boolean bl = false;
        if (container != null && !(bl = container.isFocusCycleRoot())) {
            container.setFocusCycleRoot(true);
        }
        Component component3 = null;
        component3 = component instanceof Container ? (((Container)(component2 = (Container)component)).isFocusCycleRoot((Container)component2) ? component2 : component2.getFocusCycleRootAncestor()) : component.getFocusCycleRootAncestor();
        component2 = null;
        if (component3 != null) {
            component2 = component;
        }
        if (container != null && !bl) {
            container.setFocusCycleRoot(bl);
        }
        return component2;
    }

    private void handleFocusChange(PropertyChangeEvent propertyChangeEvent, Component component, Component component2, boolean bl) {
        if (!bl) {
            return;
        }
        if (component2 instanceof JTabbedPane) {
            component2 = ((JTabbedPane)component2).getSelectedComponent();
        }
        this.activateComponent(component2, true);
    }

    private void activateComponent(Component component, boolean bl) {
        IDockable iDockable = DockingUtility.getAncestorDockable(component);
        if (iDockable != null) {
            this.setActive(iDockable, bl);
        }
    }

    private void setActive(IDockable iDockable, boolean bl) {
        IDockable iDockable2 = this.getActiveDockable();
        if (iDockable2 != null) {
            iDockable2.setActive(!bl);
        }
        this.activeDockable = new WeakReference<IDockable>(iDockable);
        iDockable.setActive(bl);
        Perspective perspective = DockingManager.getPerspectiveManager().getCurrentPerspective();
        if (!perspective.isLoading()) {
            DockingState dockingState;
            if (iDockable2 != null && (dockingState = perspective.getDockingState(iDockable2, false)) != null && perspective.getModel().contains(iDockable2)) {
                dockingState.setActive(!bl);
            }
            if ((dockingState = perspective.getDockingState(iDockable, false)) != null) {
                dockingState.setActive(bl);
            }
        }
        this.changeSupport.firePropertyChange(DOCKABLE_ACTIVATED, iDockable2, iDockable);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        Container container;
        if (aWTEvent.getID() != 501 || !(aWTEvent instanceof MouseEvent) || !(aWTEvent.getSource() instanceof Component)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        Component component = (Component)mouseEvent.getSource();
        Container container2 = container = component instanceof Container ? (Container)component : null;
        if (container != null && container.getComponentCount() > 1) {
            Point point = mouseEvent.getPoint();
            component = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
        }
        ActiveDockableTracker.requestDockableActivation(component, false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        if (!(propertyChangeEvent.getNewValue() instanceof Component)) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Component component = (Component)propertyChangeEvent.getOldValue();
        Component component2 = (Component)propertyChangeEvent.getNewValue();
        boolean bl2 = bl = component2 != null;
        if ("activeWindow".equals(string)) {
            this.activateComponent(bl ? component2 : component, bl);
        } else if ("permanentFocusOwner".equals(string)) {
            this.handleFocusChange(propertyChangeEvent, component, component2, bl);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)object;
            Component component = jTabbedPane.getSelectedComponent();
            IDockable iDockable = DockingManager.getDockable(component);
            Perspective perspective = PerspectiveManager.getInstance().getCurrentPerspective();
            if (iDockable != null && !perspective.isUnloading()) {
                this.activateComponent(component, true);
            }
        }
    }
}

