/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.filter.ColumnFilter;
import de.javasoft.swing.filter.IRowFilterModel;
import de.javasoft.swing.renderer.ObjectWrapper;
import de.javasoft.swing.sort.Comparators;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jdesktop.swingx.util.Contract;

public class CollectionColumnFilter<M>
extends ColumnFilter<M> {
    private static final Logger LOG = Logger.getLogger(CollectionColumnFilter.class.getName());

    public CollectionColumnFilter(int columnIndex) {
        super(columnIndex);
    }

    public CollectionColumnFilter(int columnIndex, IRowFilterModel<? extends M> filterModel) {
        super(columnIndex, filterModel);
    }

    public void setValues(Collection<?> values) {
        this.setValues(values, null);
    }

    public <T> void setValues(Collection<T> values, Comparator<? super T> comparator) {
        ArrayList<T> localValues;
        block2: {
            Contract.asNotNull(values, (String)"values must not be null");
            HashSet<T> unique = new HashSet<T>(values);
            localValues = new ArrayList<T>(unique);
            try {
                Collections.sort(localValues, comparator);
            }
            catch (ClassCastException e) {
                if (comparator != null) break block2;
                Collections.sort(localValues, Comparators.stringValueComparator());
            }
        }
        this.setValueList(localValues);
    }

    public void setValueList(List<?> list) {
        this.getFilteringComponent().setModel(new ListComboBoxModel(list));
        this.matchValueChanged(null, this.getRowFilterModel().getMatchValue());
    }

    @Override
    public JComboBox getFilteringComponent() {
        return (JComboBox)super.getFilteringComponent();
    }

    @Override
    protected void doRelease() {
        this.uninstallComboBoxListener(this.getFilteringComponent());
    }

    @Override
    protected void matchValueChanged() {
        this.getRowFilterModel().setMatchValue(this.getFilteringComponent().getSelectedItem());
    }

    @Override
    protected void matchValueChanged(Object oldValue, Object newValue) {
        int index = this.findIndexOf(newValue);
        if (this.getFilteringComponent().getSelectedIndex() == index) {
            return;
        }
        if (index < 0 && newValue != null) {
            this.clearSelectionSilently();
        } else {
            this.getFilteringComponent().setSelectedIndex(index);
        }
    }

    private void clearSelectionSilently() {
        Action action = this.getFilteringComponent().getAction();
        this.getFilteringComponent().setAction(null);
        this.getFilteringComponent().getModel().setSelectedItem(null);
        this.getFilteringComponent().setAction(action);
    }

    private int findIndexOf(Object newValue) {
        int index = -1;
        ComboBoxModel model = this.getFilteringComponent().getModel();
        int i = 0;
        while (i < model.getSize()) {
            Object element = model.getElementAt(i);
            if (element instanceof ObjectWrapper) {
                element = ((ObjectWrapper)element).getValue();
            }
            if (this.areEqual(newValue, element)) {
                return i;
            }
            ++i;
        }
        return index;
    }

    @Override
    protected JComboBox createFilteringComponent() {
        JComboBox box = new JComboBox();
        box.setInheritsPopupMenu(true);
        box.setCursor(box.getCursor());
        box.setEditable(false);
        this.installComponentListener(box);
        return box;
    }

    private void installComponentListener(final JComboBox box) {
        box.setAction(this.createMatchValueChangedAction());
        final Action delegate = box.getActionMap().get("hidePopup");
        AbstractActionExt wrapper = new AbstractActionExt(){
            Action clear;
            {
                this.clear = CollectionColumnFilter.this.createClearAction();
            }

            public void actionPerformed(ActionEvent e) {
                if (box.isPopupVisible()) {
                    delegate.actionPerformed(e);
                } else {
                    this.clear.actionPerformed(e);
                }
            }
        };
        box.getActionMap().put("hidePopup", (Action)wrapper);
    }

    private void uninstallComboBoxListener(JComboBox box) {
        box.setAction(null);
        box.getActionMap().remove("hidePopup");
    }
}

