/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.IRotatableComponent;
import de.javasoft.swing.IUIPropertySupport;
import de.javasoft.swing.plaf.UIValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.DefaultsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetUtils {
    private static final String DOUBLE_BUFFER_VALUE = "Synthetica.OriginalDoubleBufferValue";
    private static Cursor dragCursor;
    private static Cursor stopCursor;

    public static Cursor getDragCursor() {
        if (dragCursor == null) {
            ImageIcon imageIcon = new ImageIcon(WidgetUtils.class.getResource("resources/dragCursor.png"));
            dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(0, 0), "DRAG_CURSOR");
        }
        return dragCursor;
    }

    public static Cursor getStopCursor() {
        if (stopCursor == null) {
            ImageIcon imageIcon = new ImageIcon(WidgetUtils.class.getResource("resources/stopCursor.png"));
            stopCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(0, 0), "STOP_CURSOR");
        }
        return stopCursor;
    }

    public static <T> void setUIProperty(JComponent jComponent, String string, UIValue<T> uIValue, T t, T t2, boolean bl, boolean bl2, boolean bl3) {
        if (uIValue == null) {
            return;
        }
        if (bl) {
            t = null;
        }
        if (t == null || !t.equals(t2)) {
            uIValue.set(t2);
            uIValue.setUIResource(bl);
            ((IUIPropertySupport)((Object)jComponent)).firePropertyChange(string, t, t2);
            if (bl2) {
                jComponent.revalidate();
            }
            if (bl3) {
                jComponent.repaint();
            }
        }
    }

    public static boolean shouldUpdateStyle(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("name".equals(string)) {
            return true;
        }
        return "Synthetica.style".equals(string);
    }

    public static Dimension rotateDimension(Dimension dimension, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            int n = dimension.width;
            dimension.width = dimension.height;
            dimension.height = n;
        }
        return dimension;
    }

    public static Rectangle rotateRectangle(Rectangle rectangle, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            int n = rectangle.width;
            rectangle.width = rectangle.height;
            rectangle.height = n;
        }
        return rectangle;
    }

    public static Border createRotatableEmptyBorder(Insets insets, boolean bl) {
        if (bl) {
            return new RotatableEmptyBorderUIResource(insets);
        }
        return new RotatableEmptyBorder(insets);
    }

    public static Insets rotateInsets(Insets insets, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.REVERSED) {
            int n = insets.top;
            insets.top = insets.bottom;
            insets.bottom = n;
        } else if (rotation == IRotatableComponent.Rotation.RIGHT) {
            int n = insets.top;
            insets.top = insets.left;
            int n2 = insets.right;
            insets.right = n;
            n = insets.bottom;
            insets.bottom = n2;
            insets.left = n;
        } else if (rotation == IRotatableComponent.Rotation.LEFT) {
            int n = insets.top;
            insets.top = insets.right;
            int n3 = insets.left;
            insets.left = n;
            n = insets.bottom;
            insets.bottom = n3;
            insets.right = n;
        }
        return insets;
    }

    public static Border createOrientationAwareEmptyBorder(Insets insets, boolean bl) {
        if (bl) {
            return new OrientationAwareEmptyBorderUIResource(insets);
        }
        return new OrientationAwareEmptyBorder(insets);
    }

    public static void addResourceBundleToDefaults(String string, DefaultsList defaultsList) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            String string3 = resourceBundle.getString(string2);
            defaultsList.add((Object)string2, (Object)string3);
        }
    }

    public static Font getDefaultFont() {
        Font font = SyntheticaLookAndFeel.getFont();
        return font == null ? new FontUIResource("Dialog", 0, 12) : new FontUIResource(font);
    }

    public static BufferedImage createPreviewImage(Component component, double d, boolean bl) {
        if (component == null) {
            return null;
        }
        int n = (int)((double)component.getWidth() * d);
        int n2 = (int)((double)component.getHeight() * d);
        return WidgetUtils.createPreviewImage(component, 0, 0, n, n2, bl);
    }

    public static BufferedImage createPreviewImage(Component component, int n, int n2, int n3, int n4, boolean bl) {
        if (component == null || n3 <= 0 || n4 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n5 = component.getWidth();
        int n6 = component.getHeight();
        int n7 = n5;
        int n8 = n6;
        double d = 1.0;
        int n9 = SyntheticaLookAndFeel.getInt("Synthetica.componentPreview.maxSize", component, 2500);
        if (n9 > 0) {
            int n10 = SyntheticaLookAndFeel.getInt("Synthetica.componentPreview.maxFactor", component, 125);
            while (n7 > n9 || n8 > n9) {
                d = (double)n10 / 100.0;
                n7 = (int)((double)n7 / d);
                n8 = (int)((double)n8 / d);
            }
        }
        if (d > 1.0) {
            component.setSize(n7, n8);
        }
        if (n7 > 0 && n8 > 0) {
            double d2;
            if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("Synthetica.previewImageRatio", Float.valueOf(new Float(n7).floatValue() / new Float(n5).floatValue()));
            }
            BufferedImage bufferedImage2 = new BufferedImage(n7, n8, 2);
            component.paint(bufferedImage2.getGraphics());
            if (d > 1.0) {
                component.setSize(n5, n6);
            }
            if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("Synthetica.previewImageRatio", null);
            }
            if ((d2 = Math.min((double)n3 / (double)n7, (double)n4 / (double)n8)) < 1.0) {
                int n11 = (int)(d2 * (double)n7);
                int n12 = (int)(d2 * (double)n8);
                int n13 = n + (bl ? (n3 - n11) / 2 : 0);
                int n14 = n2 + (bl ? (n4 - n12) / 2 : 0);
                graphics2D.drawImage((Image)WidgetUtils.createThumbnail(bufferedImage2, n11), n13, n14, null);
            } else {
                graphics2D.drawImage((Image)bufferedImage2, n, n2, null);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private static BufferedImage createThumbnail(BufferedImage bufferedImage, int n) {
        float f = (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        BufferedImage bufferedImage2 = bufferedImage;
        do {
            if ((n2 /= 2) < n) {
                n2 = n;
            }
            BufferedImage bufferedImage3 = new BufferedImage(n2, (int)((float)n2 / f), 2);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage2, 0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight(), null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        } while (n2 != n);
        return bufferedImage2;
    }

    public static void disableDoubleBuffer(Component component) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            ((JComponent)container).putClientProperty(DOUBLE_BUFFER_VALUE, ((JComponent)container).isDoubleBuffered());
            ((JComponent)container).setDoubleBuffered(false);
        }
        if (component instanceof Container) {
            container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                WidgetUtils.disableDoubleBuffer(container.getComponent(n));
                ++n;
            }
        }
    }

    public static void restoreDoubleBuffer(Component component) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            Boolean bl = (Boolean)((JComponent)container).getClientProperty(DOUBLE_BUFFER_VALUE);
            if (bl != null) {
                ((JComponent)container).setDoubleBuffered(bl);
            } else {
                Container container2 = component.getParent();
                if (container2 instanceof JComponent) {
                    Boolean bl2 = (Boolean)((JComponent)container2).getClientProperty(DOUBLE_BUFFER_VALUE);
                    ((JComponent)container).setDoubleBuffered(bl2 == null ? false : bl2);
                }
            }
        }
        if (component instanceof Container) {
            container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                WidgetUtils.restoreDoubleBuffer(container.getComponent(n));
                ++n;
            }
        }
    }

    public static class OrientationAwareEmptyBorder
    extends EmptyBorder {
        private static final long serialVersionUID = 1197462533056882357L;

        public OrientationAwareEmptyBorder(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public OrientationAwareEmptyBorder(Insets insets) {
            super(insets);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            boolean bl = component.getComponentOrientation().isLeftToRight();
            insets.left = bl ? this.left : this.right;
            insets.top = this.top;
            insets.right = bl ? this.right : this.left;
            insets.bottom = this.bottom;
            return insets;
        }
    }

    public static class OrientationAwareEmptyBorderUIResource
    extends OrientationAwareEmptyBorder
    implements UIResource {
        private static final long serialVersionUID = -2425915691737611974L;

        public OrientationAwareEmptyBorderUIResource(Insets insets) {
            super(insets);
        }
    }

    private static class RotatableEmptyBorder
    extends EmptyBorder {
        private static final long serialVersionUID = -3288482079141574369L;

        public RotatableEmptyBorder(Insets insets) {
            super(insets);
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = super.getBorderInsets(component);
            if (component instanceof AbstractButton) {
                Insets insets2 = ((AbstractButton)component).getMargin();
                insets = new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
            }
            if (component instanceof IRotatableComponent) {
                insets = WidgetUtils.rotateInsets(insets, ((IRotatableComponent)((Object)component)).getRotation());
            }
            return insets;
        }
    }

    private static class RotatableEmptyBorderUIResource
    extends RotatableEmptyBorder
    implements UIResource {
        private static final long serialVersionUID = 1764839983093610630L;

        public RotatableEmptyBorderUIResource(Insets insets) {
            super(insets);
        }
    }
}

